/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.integer;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.integer.ConvertIntegerToOctalPredicate;
import java.math.BigInteger;
import org.jetbrains.annotations.NotNull;

public class ConvertIntegerToOctalIntention
extends Intention {
    private static final BigInteger LONG_BINARY_ONES = new BigInteger("ffffffffffffffff", 16);
    private static final BigInteger INT_BINARY_ONES = new BigInteger("ffffffff", 16);

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ConvertIntegerToOctalPredicate convertIntegerToOctalPredicate = new ConvertIntegerToOctalPredicate();
        if (convertIntegerToOctalPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/integer/ConvertIntegerToOctalIntention.getElementPredicate must not return null");
        }
        return convertIntegerToOctalPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        BigInteger value;
        boolean isLong;
        int textLength;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/integer/ConvertIntegerToOctalIntention.processIntention must not be null");
        }
        PsiExpression expression = (PsiExpression)element;
        String textString = expression.getText();
        char lastChar = textString.charAt((textLength = textString.length()) - 1);
        boolean bl = isLong = lastChar == 'l' || lastChar == 'L';
        if (isLong) {
            textString = textString.substring(0, textLength - 1);
        }
        if (textString.startsWith("0x")) {
            String rawTextString = textString.substring(2);
            value = new BigInteger(rawTextString, 16);
        } else {
            PsiPrefixExpression prefixExpression;
            IElementType tokenType;
            value = new BigInteger(textString, 10);
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiPrefixExpression && JavaTokenType.MINUS == (tokenType = (prefixExpression = (PsiPrefixExpression)parent).getOperationTokenType())) {
                value = isLong ? value.xor(LONG_BINARY_ONES).add(BigInteger.ONE) : value.xor(INT_BINARY_ONES).add(BigInteger.ONE);
                String hexString = '0' + value.toString(8);
                if (isLong) {
                    hexString = hexString + 'L';
                }
                ConvertIntegerToOctalIntention.replaceExpression(hexString, (PsiExpression)prefixExpression);
                return;
            }
        }
        String octString = '0' + value.toString(8);
        if (isLong) {
            octString = octString + 'L';
        }
        ConvertIntegerToOctalIntention.replaceExpression(octString, expression);
    }
}

