/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.conditional;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.conditional.ReplaceConditionalWithIfPredicate;
import com.siyeh.ipp.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceConditionalWithIfIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ReplaceConditionalWithIfPredicate replaceConditionalWithIfPredicate = new ReplaceConditionalWithIfPredicate();
        if (replaceConditionalWithIfPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/conditional/ReplaceConditionalWithIfIntention.getElementPredicate must not return null");
        }
        return replaceConditionalWithIfPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/conditional/ReplaceConditionalWithIfIntention.processIntention must not be null");
        }
        PsiConditionalExpression expression = (PsiConditionalExpression)element;
        ReplaceConditionalWithIfIntention.replaceConditionalWithIf(expression);
    }

    private static void replaceConditionalWithIf(PsiConditionalExpression expression) throws IncorrectOperationException {
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiStatement.class);
        if (statement == null) {
            return;
        }
        PsiVariable variable = statement instanceof PsiDeclarationStatement ? (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiVariable.class) : null;
        PsiExpression thenExpression = expression.getThenExpression();
        PsiExpression elseExpression = expression.getElseExpression();
        PsiExpression condition = expression.getCondition();
        PsiExpression strippedCondition = ParenthesesUtils.stripParentheses(condition);
        StringBuilder newStatement = new StringBuilder();
        newStatement.append("if(");
        if (strippedCondition != null) {
            newStatement.append(strippedCondition.getText());
        }
        newStatement.append(')');
        if (variable != null) {
            String name = variable.getName();
            newStatement.append(name);
            newStatement.append('=');
            PsiExpression initializer = variable.getInitializer();
            if (initializer == null) {
                return;
            }
            ReplaceConditionalWithIfIntention.appendElementTextWithoutParentheses((PsiElement)initializer, (PsiElement)expression, thenExpression, newStatement);
            newStatement.append("; else ");
            newStatement.append(name);
            newStatement.append('=');
            ReplaceConditionalWithIfIntention.appendElementTextWithoutParentheses((PsiElement)initializer, (PsiElement)expression, elseExpression, newStatement);
            newStatement.append(';');
            initializer.delete();
            PsiManager manager = statement.getManager();
            Project project = manager.getProject();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = facade.getElementFactory();
            PsiStatement ifStatement = factory.createStatementFromText(newStatement.toString(), (PsiElement)statement);
            PsiElement parent = statement.getParent();
            PsiElement addedElement = parent.addAfter((PsiElement)ifStatement, (PsiElement)statement);
            CodeStyleManager styleManager = manager.getCodeStyleManager();
            styleManager.reformat(addedElement);
        } else {
            PsiElement expressionParent = expression.getParent();
            boolean addBraces = expressionParent instanceof PsiIfStatement;
            if (addBraces || thenExpression == null) {
                newStatement.append('{');
            }
            ReplaceConditionalWithIfIntention.appendElementTextWithoutParentheses((PsiElement)statement, (PsiElement)expression, thenExpression, newStatement);
            if (addBraces) {
                newStatement.append("} else {");
            } else {
                if (thenExpression == null) {
                    newStatement.append('}');
                }
                newStatement.append(" else ");
                if (elseExpression == null) {
                    newStatement.append('{');
                }
            }
            ReplaceConditionalWithIfIntention.appendElementTextWithoutParentheses((PsiElement)statement, (PsiElement)expression, elseExpression, newStatement);
            if (addBraces || elseExpression == null) {
                newStatement.append('}');
            }
            ReplaceConditionalWithIfIntention.replaceStatement(newStatement.toString(), statement);
        }
    }

    private static void appendElementTextWithoutParentheses(@NotNull PsiElement element, @NotNull PsiElement elementToReplace, @Nullable PsiExpression replacementExpression, @NotNull StringBuilder out) {
        PsiElement grandParent;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/conditional/ReplaceConditionalWithIfIntention.appendElementTextWithoutParentheses must not be null");
        }
        if (elementToReplace == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/conditional/ReplaceConditionalWithIfIntention.appendElementTextWithoutParentheses must not be null");
        }
        if (out == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/siyeh/ipp/conditional/ReplaceConditionalWithIfIntention.appendElementTextWithoutParentheses must not be null");
        }
        PsiElement expressionParent = elementToReplace.getParent();
        if (expressionParent instanceof PsiParenthesizedExpression && !ParenthesesUtils.areParenthesesNeeded(replacementExpression, grandParent = expressionParent.getParent(), true)) {
            ReplaceConditionalWithIfIntention.appendElementText(element, expressionParent, replacementExpression, out);
            return;
        }
        ReplaceConditionalWithIfIntention.appendElementText(element, elementToReplace, replacementExpression, out);
    }

    private static void appendElementText(@NotNull PsiElement element, @NotNull PsiElement elementToReplace, @Nullable PsiExpression replacementExpression, @NotNull StringBuilder out) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/conditional/ReplaceConditionalWithIfIntention.appendElementText must not be null");
        }
        if (elementToReplace == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/conditional/ReplaceConditionalWithIfIntention.appendElementText must not be null");
        }
        if (out == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/siyeh/ipp/conditional/ReplaceConditionalWithIfIntention.appendElementText must not be null");
        }
        if (element.equals(elementToReplace)) {
            String replacementText = replacementExpression == null ? "" : replacementExpression.getText();
            out.append(replacementText);
            return;
        }
        PsiElement[] children = element.getChildren();
        if (children.length == 0) {
            PsiComment comment;
            IElementType tokenType;
            out.append(element.getText());
            if (element instanceof PsiComment && (tokenType = (comment = (PsiComment)element).getTokenType()) == JavaTokenType.END_OF_LINE_COMMENT) {
                out.append('\n');
            }
            return;
        }
        for (PsiElement child : children) {
            ReplaceConditionalWithIfIntention.appendElementText(child, elementToReplace, replacementExpression, out);
        }
    }
}

