/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.concatenation;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.concatenation.AppendChainPredicate;
import com.siyeh.ipp.concatenation.AppendUtil;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class MakeAppendChainIntoAppendSequenceIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        AppendChainPredicate appendChainPredicate = new AppendChainPredicate();
        if (appendChainPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/concatenation/MakeAppendChainIntoAppendSequenceIntention.getElementPredicate must not return null");
        }
        return appendChainPredicate;
    }

    @Override
    public void processIntention(PsiElement element) throws IncorrectOperationException {
        String firstStatement;
        PsiStatement appendStatement;
        String targetText;
        PsiExpression call = (PsiExpression)element;
        ArrayList<String> argumentsList = new ArrayList<String>();
        PsiExpression currentCall = call;
        while (AppendUtil.isAppendCall((PsiElement)currentCall)) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)currentCall;
            PsiExpressionList arguments = methodCallExpression.getArgumentList();
            String argumentsText = arguments.getText();
            argumentsList.add(argumentsText);
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            currentCall = methodExpression.getQualifierExpression();
            if (currentCall != null) continue;
            return;
        }
        PsiElement parent = call.getParent();
        if (parent instanceof PsiExpressionStatement) {
            targetText = currentCall.getText();
            appendStatement = (PsiStatement)parent;
            firstStatement = null;
        } else {
            PsiElement grandParent = parent.getParent();
            appendStatement = (PsiStatement)grandParent;
            if (parent instanceof PsiAssignmentExpression && grandParent instanceof PsiExpressionStatement) {
                PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent;
                PsiExpression lhs = assignment.getLExpression();
                targetText = lhs.getText();
                PsiJavaToken token = assignment.getOperationSign();
                firstStatement = targetText + token.getText() + currentCall.getText() + ';';
            } else {
                PsiDeclarationStatement declaration = (PsiDeclarationStatement)appendStatement;
                PsiVariable variable = (PsiVariable)declaration.getDeclaredElements()[0];
                targetText = variable.getName();
                PsiType variableType = variable.getType();
                firstStatement = variable.hasModifierProperty("final") ? "final " + variableType.getPresentableText() + ' ' + variable.getName() + '=' + currentCall.getText() + ';' : variableType.getPresentableText() + ' ' + variable.getName() + '=' + currentCall.getText() + ';';
            }
        }
        StringBuilder builder = new StringBuilder("{");
        if (firstStatement != null) {
            builder.append(firstStatement);
        }
        Collections.reverse(argumentsList);
        for (String argument : argumentsList) {
            builder.append(targetText);
            builder.append(".append");
            builder.append(argument);
            builder.append(';');
        }
        builder.append('}');
        PsiManager manager = element.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        PsiElement appendStatementParent = appendStatement.getParent();
        CodeStyleManager codeStyleManager = manager.getCodeStyleManager();
        PsiCodeBlock codeBlock = factory.createCodeBlockFromText(builder.toString(), (PsiElement)appendStatement);
        if (appendStatementParent instanceof PsiLoopStatement || appendStatementParent instanceof PsiIfStatement) {
            PsiElement insertedStatement = appendStatement.replace((PsiElement)codeBlock);
            codeStyleManager.reformat(insertedStatement);
        } else {
            PsiStatement[] statements;
            for (PsiStatement statement : statements = codeBlock.getStatements()) {
                PsiElement insertedStatement = appendStatementParent.addBefore((PsiElement)statement, (PsiElement)appendStatement);
                codeStyleManager.reformat(insertedStatement);
            }
            appendStatement.delete();
        }
    }
}

