/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.braces;

import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.braces.RemoveBracesPredicate;
import org.jetbrains.annotations.NotNull;

public class RemoveBracesIntention
extends MutablyNamedIntention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        RemoveBracesPredicate removeBracesPredicate = new RemoveBracesPredicate();
        if (removeBracesPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/braces/RemoveBracesIntention.getElementPredicate must not return null");
        }
        return removeBracesPredicate;
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        String keyword;
        PsiElement parent = element.getParent();
        assert (parent != null);
        if (parent instanceof PsiIfStatement) {
            PsiIfStatement ifStatement = (PsiIfStatement)parent;
            PsiStatement elseBranch = ifStatement.getElseBranch();
            keyword = element.equals(elseBranch) ? "else" : "if";
        } else {
            PsiElement firstChild = parent.getFirstChild();
            assert (firstChild != null);
            keyword = firstChild.getText();
        }
        return IntentionPowerPackBundle.message("remove.braces.intention.name", keyword);
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/braces/RemoveBracesIntention.processIntention must not be null");
        }
        PsiBlockStatement blockStatement = (PsiBlockStatement)element;
        PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
        PsiStatement[] statements = codeBlock.getStatements();
        PsiStatement statement = statements[0];
        PsiElement parent = blockStatement.getParent();
        assert (parent != null);
        PsiElement grandParent = parent.getParent();
        assert (grandParent != null);
        PsiElement sibling = codeBlock.getFirstChild();
        assert (sibling != null);
        for (sibling = sibling.getNextSibling(); sibling != null && !sibling.equals(statement); sibling = sibling.getNextSibling()) {
            if (!(sibling instanceof PsiComment)) continue;
            grandParent.addBefore(sibling, parent);
        }
        PsiElement lastChild = blockStatement.getLastChild();
        if (lastChild instanceof PsiComment) {
            PsiElement nextSibling = parent.getNextSibling();
            grandParent.addAfter(lastChild, nextSibling);
        }
        String text = statement.getText();
        RemoveBracesIntention.replaceStatement(text, (PsiStatement)blockStatement);
    }
}

