/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit4;

import com.intellij.junit4.JUnit45ClassesRequestBuilder;
import com.intellij.junit4.JUnit46ClassesRequestBuilder;
import com.intellij.junit4.JUnit4ClassesRequestBuilder;
import com.intellij.junit4.JUnit4ReflectionUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.requests.ClassRequest;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;

public class JUnit4TestRunnerUtil {
    private static final ResourceBundle ourBundle = ResourceBundle.getBundle("RuntimeBundle");
    static /* synthetic */ Class class$org$junit$runner$RunWith;
    static /* synthetic */ Class class$org$junit$Ignore;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Request buildRequest(String[] suiteClassNames) {
        if (suiteClassNames.length == 0) {
            return null;
        }
        Vector result = new Vector();
        for (int i = 0; i < suiteClassNames.length; ++i) {
            String suiteClassName = suiteClassNames[i];
            if (suiteClassName.charAt(0) == '@') {
                Request request;
                final HashMap<String, HashSet<String>> classMethods = new HashMap<String, HashSet<String>>();
                BufferedReader reader = new BufferedReader(new FileReader(suiteClassName.substring(1)));
                try {
                    Request allClasses;
                    String line;
                    reader.readLine();
                    String packageName = reader.readLine();
                    while ((line = reader.readLine()) != null) {
                        String className = line;
                        int idx = line.indexOf(44);
                        if (idx != -1) {
                            className = line.substring(0, idx);
                            HashSet<String> methodNames = (HashSet<String>)classMethods.get(className);
                            if (methodNames == null) {
                                methodNames = new HashSet<String>();
                                classMethods.put(className, methodNames);
                            }
                            methodNames.add(line.substring(idx + 1));
                        }
                        JUnit4TestRunnerUtil.appendTestClass(result, className);
                    }
                    String suiteName = packageName.length() == 0 ? "<default package>" : packageName;
                    Class[] classes = JUnit4TestRunnerUtil.getArrayOfClasses(result);
                    try {
                        Class.forName("org.junit.runner.Computer");
                        allClasses = JUnit46ClassesRequestBuilder.getClassesRequest(suiteName, classes);
                    }
                    catch (ClassNotFoundException e) {
                        try {
                            Class.forName("org.junit.internal.requests.ClassesRequest");
                            allClasses = JUnit4ClassesRequestBuilder.getClassesRequest(suiteName, classes);
                        }
                        catch (ClassNotFoundException e1) {
                            allClasses = JUnit45ClassesRequestBuilder.getClassesRequest(suiteName, classes);
                        }
                    }
                    request = classMethods.isEmpty() ? allClasses : allClasses.filterWith(new Filter(){

                        public boolean shouldRun(Description description) {
                            if (description.isTest()) {
                                Set methods = (Set)classMethods.get(JUnit4ReflectionUtil.getClassName(description));
                                return methods == null || methods.contains(JUnit4ReflectionUtil.getMethodName(description));
                            }
                            return true;
                        }

                        public String describe() {
                            return "Failed tests";
                        }
                    });
                }
                catch (Throwable throwable) {
                    try {
                        reader.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        System.exit(1);
                    }
                }
                reader.close();
                return request;
                continue;
            }
            int index = suiteClassName.indexOf(44);
            if (index != -1) {
                final Class clazz = JUnit4TestRunnerUtil.loadTestClass(suiteClassName.substring(0, index));
                String methodName = suiteClassName.substring(index + 1);
                if (clazz.getAnnotation(class$org$junit$runner$RunWith == null ? (class$org$junit$runner$RunWith = JUnit4TestRunnerUtil.class$("org.junit.runner.RunWith")) : class$org$junit$runner$RunWith) == null) {
                    try {
                        Class.forName("org.junit.runners.BlockJUnit4ClassRunner");
                        Method method = clazz.getMethod(methodName, null);
                        if (method != null && method.getAnnotation(class$org$junit$Ignore == null ? (class$org$junit$Ignore = JUnit4TestRunnerUtil.class$("org.junit.Ignore")) : class$org$junit$Ignore) != null) {
                            ClassRequest classRequest = new ClassRequest(clazz){

                                public Runner getRunner() {
                                    try {
                                        return new IgnoreIgnoredTestJUnit4ClassRunner(clazz);
                                    }
                                    catch (Exception exception) {
                                        return super.getRunner();
                                    }
                                }
                            };
                            return classRequest.filterWith(Description.createTestDescription((Class)clazz, (String)methodName));
                        }
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
                return Request.method((Class)clazz, (String)methodName);
            }
            JUnit4TestRunnerUtil.appendTestClass(result, suiteClassName);
        }
        return result.size() == 1 ? Request.aClass((Class)((Class)result.get(0))) : Request.classes((Class[])JUnit4TestRunnerUtil.getArrayOfClasses(result));
    }

    private static void appendTestClass(Vector result, String className) {
        Class aClass = JUnit4TestRunnerUtil.loadTestClass(className);
        if (!result.contains(aClass)) {
            result.addElement(aClass);
        }
    }

    private static Class[] getArrayOfClasses(Vector result) {
        Class[] classes = new Class[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            classes[i] = (Class)result.get(i);
        }
        return classes;
    }

    private static Class loadTestClass(String suiteClassName) {
        try {
            return Class.forName(suiteClassName);
        }
        catch (ClassNotFoundException e) {
            String clazz = e.getMessage();
            if (clazz == null) {
                clazz = suiteClassName;
            }
            System.err.print(MessageFormat.format(ourBundle.getString("junit.class.not.found"), clazz));
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println(MessageFormat.format(ourBundle.getString("junit.cannot.instantiate.tests"), e.toString()));
            System.exit(1);
        }
        return null;
    }

    public static String testsFoundInPackageMesage(int testCount, String name) {
        return MessageFormat.format(ourBundle.getString("tests.found.in.package"), new Integer(testCount), name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class IgnoreIgnoredTestJUnit4ClassRunner
    extends BlockJUnit4ClassRunner {
        public IgnoreIgnoredTestJUnit4ClassRunner(Class clazz) throws Exception {
            super(clazz);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runChild(FrameworkMethod method, RunNotifier notifier) {
            Description description = this.describeChild(method);
            EachTestNotifier eachNotifier = new EachTestNotifier(notifier, description);
            eachNotifier.fireTestStarted();
            try {
                this.methodBlock(method).evaluate();
            }
            catch (AssumptionViolatedException e) {
                eachNotifier.addFailedAssumption(e);
            }
            catch (Throwable e) {
                eachNotifier.addFailure(e);
            }
            finally {
                eachNotifier.fireTestFinished();
            }
        }
    }
}

