/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit3;

import com.intellij.junit3.TestRunnerUtil;
import com.intellij.rt.execution.junit.segments.OutputObjectRegistry;
import com.intellij.rt.execution.junit.segments.Packet;
import java.util.Enumeration;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TreeSender {
    private static void sendNode(Test test, Packet packet) {
        Vector testCases = TreeSender.getTestCasesOf(test);
        packet.addObject((Object)test).addLong((long)testCases.size());
        for (int i = 0; i < testCases.size(); ++i) {
            Test nextTest = (Test)testCases.get(i);
            TreeSender.sendNode(nextTest, packet);
        }
    }

    private static Vector getTestCasesOf(Test test) {
        Vector testCases = new Vector();
        if (test instanceof TestRunnerUtil.SuiteMethodWrapper) {
            test = ((TestRunnerUtil.SuiteMethodWrapper)test).getSuite();
        }
        if (test instanceof TestSuite) {
            TestSuite testSuite = (TestSuite)test;
            Enumeration each = testSuite.tests();
            while (each.hasMoreElements()) {
                Object childTest = each.nextElement();
                if (childTest instanceof TestSuite && !((TestSuite)childTest).tests().hasMoreElements()) continue;
                testCases.addElement(childTest);
            }
        }
        return testCases;
    }

    public static void sendSuite(OutputObjectRegistry registry, Test suite) {
        Packet packet = registry.createPacket();
        packet.addString("T");
        TreeSender.sendNode(suite, packet);
        packet.addString("\n");
        packet.send();
    }
}

