/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.LocatableConfigurationType;
import com.intellij.execution.Location;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.TestObject;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnitConfigurationType
implements LocatableConfigurationType {
    private static final Icon ICON = IconLoader.getIcon((String)"/runConfigurations/junit.png");
    private final ConfigurationFactory myFactory = new ConfigurationFactory((ConfigurationType)this){

        public RunConfiguration createTemplateConfiguration(Project project) {
            return new JUnitConfiguration("", project, this);
        }

        public Icon getIcon(@NotNull RunConfiguration configuration) {
            if (configuration == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/junit/JUnitConfigurationType$1.getIcon must not be null");
            }
            return RunConfigurationExtension.getIcon((ModuleBasedConfiguration)((JUnitConfiguration)configuration), (Icon)this.getIcon());
        }
    };

    public String getDisplayName() {
        return ExecutionBundle.message((String)"junit.configuration.display.name", (Object[])new Object[0]);
    }

    public String getConfigurationTypeDescription() {
        return ExecutionBundle.message((String)"junit.configuration.description", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return ICON;
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return new ConfigurationFactory[]{this.myFactory};
    }

    public RunnerAndConfigurationSettings createConfigurationByLocation(Location location) {
        return null;
    }

    public boolean isConfigurationByLocation(RunConfiguration configuration, Location location) {
        JUnitConfiguration unitConfiguration = (JUnitConfiguration)configuration;
        TestObject testobject = unitConfiguration.getTestObject();
        if (testobject == null) {
            return false;
        }
        PsiElement element = location.getPsiElement();
        if (testobject.isConfiguredByElement(unitConfiguration, element)) {
            Module configurationModule = ((JavaRunConfigurationModule)unitConfiguration.getConfigurationModule()).getModule();
            if (Comparing.equal((Object)location.getModule(), (Object)configurationModule)) {
                return true;
            }
            Module predefinedModule = ((JavaRunConfigurationModule)((JUnitConfiguration)((RunManagerImpl)RunManagerEx.getInstanceEx((Project)location.getProject())).getConfigurationTemplate(this.myFactory).getConfiguration()).getConfigurationModule()).getModule();
            return Comparing.equal((Object)predefinedModule, (Object)configurationModule);
        }
        return false;
    }

    @NotNull
    public String getId() {
        if ("JUnit" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/junit/JUnitConfigurationType.getId must not return null");
        }
        return "JUnit";
    }

    @Nullable
    public static JUnitConfigurationType getInstance() {
        return (JUnitConfigurationType)ContainerUtil.findInstance((Object[])Extensions.getExtensions((ExtensionPointName)CONFIGURATION_TYPE_EP), JUnitConfigurationType.class);
    }
}

