/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.export;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.EclipseJDOMUtil;
import org.jetbrains.idea.eclipse.EclipseBundle;
import org.jetbrains.idea.eclipse.conversion.ConversionException;
import org.jetbrains.idea.eclipse.conversion.DotProjectFileHelper;
import org.jetbrains.idea.eclipse.conversion.EclipseClasspathWriter;
import org.jetbrains.idea.eclipse.conversion.EclipseUserLibrariesHelper;
import org.jetbrains.idea.eclipse.conversion.IdeaSpecificSettings;
import org.jetbrains.idea.eclipse.export.ExportEclipseProjectsDialog;

public class ExportEclipseProjectsAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)("#" + ExportEclipseProjectsAction.class.getName()));

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        e.getPresentation().setEnabled(project != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        project.save();
        ArrayList<Module> modules = new ArrayList<Module>();
        ArrayList<Module> incompatibleModules = new ArrayList<Module>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if ("eclipse".equals(ClasspathStorage.getStorageType((Module)module))) continue;
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            try {
                ClasspathStorage.getProvider((String)"eclipse").assertCompatible(model);
                modules.add(module);
            }
            catch (ConfigurationException e1) {
                incompatibleModules.add(module);
            }
            finally {
                model.dispose();
            }
        }
        if (!incompatibleModules.isEmpty()) {
            if (Messages.showOkCancelDialog((Project)project, (String)("<html><body>Eclipse incompatible modules found:<ul><br><li>" + StringUtil.join(incompatibleModules, (Function)new Function<Module, String>(){

                public String fun(Module module) {
                    return module.getName();
                }
            }, (String)"<br><li>") + "</ul><br>Would you like to proceed and possibly lose your configurations?</body></html>"), (String)"Eclipse Incompatible Modules Found", (Icon)Messages.getWarningIcon()) != 0) {
                return;
            }
        } else if (modules.isEmpty()) {
            Messages.showInfoMessage((Project)project, (String)EclipseBundle.message("eclipse.export.nothing.to.do", new Object[0]), (String)EclipseBundle.message("eclipse.export.dialog.title", new Object[0]));
            return;
        }
        modules.addAll(incompatibleModules);
        ExportEclipseProjectsDialog dialog = new ExportEclipseProjectsDialog(project, modules);
        dialog.show();
        if (dialog.isOK()) {
            ModifiableRootModel model;
            if (dialog.isLink()) {
                for (Module module : dialog.getSelectedModules()) {
                    model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                    ClasspathStorage.setStorageType((ModifiableRootModel)model, (String)"eclipse");
                    model.dispose();
                }
            } else {
                for (Module module : dialog.getSelectedModules()) {
                    model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                    VirtualFile[] contentRoots = model.getContentRoots();
                    String storageRoot = contentRoots.length == 1 ? contentRoots[0].getPath() : ClasspathStorage.getStorageRootFromOptions((Module)module);
                    try {
                        Element classpathEleemnt = new Element("classpath");
                        EclipseClasspathWriter classpathWriter = new EclipseClasspathWriter((ModuleRootModel)model);
                        classpathWriter.writeClasspath(classpathEleemnt, null);
                        File classpathFile = new File(storageRoot, ".classpath");
                        if (!FileUtil.createIfDoesntExist((File)classpathFile)) continue;
                        EclipseJDOMUtil.output(new Document(classpathEleemnt), classpathFile, project);
                        Element ideaSpecific = new Element("component");
                        if (IdeaSpecificSettings.writeIDEASpecificClasspath(ideaSpecific, (ModuleRootModel)model)) {
                            File emlFile = new File(storageRoot, module.getName() + ".eml");
                            if (!FileUtil.createIfDoesntExist((File)emlFile)) continue;
                            EclipseJDOMUtil.output(new Document(ideaSpecific), emlFile, project);
                        }
                        DotProjectFileHelper.saveDotProjectFile(module, storageRoot);
                    }
                    catch (ConversionException e1) {
                        LOG.error((Throwable)e1);
                    }
                    catch (IOException e1) {
                        LOG.error((Throwable)e1);
                    }
                    catch (WriteExternalException e1) {
                        LOG.error((Throwable)e1);
                    }
                    finally {
                        model.dispose();
                    }
                }
            }
            try {
                EclipseUserLibrariesHelper.appendProjectLibraries(project, dialog.getUserLibrariesFile());
            }
            catch (IOException e1) {
                LOG.error((Throwable)e1);
            }
            project.save();
        }
    }
}

