/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.config;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.roots.impl.storage.ClasspathStorageProvider;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.eclipse.EclipseBundle;
import org.jetbrains.idea.eclipse.config.CachedXmlDocumentSet;
import org.jetbrains.idea.eclipse.config.EclipseModuleManager;
import org.jetbrains.idea.eclipse.conversion.ConversionException;
import org.jetbrains.idea.eclipse.conversion.DotProjectFileHelper;
import org.jetbrains.idea.eclipse.conversion.EPathUtil;
import org.jetbrains.idea.eclipse.conversion.EclipseClasspathReader;
import org.jetbrains.idea.eclipse.conversion.EclipseClasspathWriter;
import org.jetbrains.idea.eclipse.conversion.IdeaSpecificSettings;

public class EclipseClasspathStorageProvider
implements ClasspathStorageProvider {
    @NonNls
    public static final String ID = "eclipse";
    public static final String DESCR = EclipseBundle.message("eclipse.classpath.storage.description", new Object[0]);

    @NonNls
    public String getID() {
        return ID;
    }

    @Nls
    public String getDescription() {
        return DESCR;
    }

    public void assertCompatible(ModifiableRootModel model) throws ConfigurationException {
        for (OrderEntry entry : model.getOrderEntries()) {
            Library library;
            LibraryOrderEntry libraryEntry;
            if (!(entry instanceof LibraryOrderEntry) || !(libraryEntry = (LibraryOrderEntry)entry).isModuleLevel() || (library = libraryEntry.getLibrary()) != null && libraryEntry.getRootUrls(OrderRootType.CLASSES).length == 1 && !library.isJarDirectory(library.getUrls(OrderRootType.CLASSES)[0])) continue;
            throw new ConfigurationException("Library '" + entry.getPresentableName() + "' is incompatible with eclipse format which supports only one content root");
        }
        if (model.getContentRoots().length == 0) {
            throw new ConfigurationException("Module '" + model.getModule().getName() + "' has no content roots thus is not compatible with eclipse format");
        }
        String output = ((CompilerModuleExtension)model.getModuleExtension(CompilerModuleExtension.class)).getCompilerOutputUrl();
        String contentRoot = this.getContentRoot(model);
        if (output == null || !StringUtil.startsWith((CharSequence)VfsUtil.urlToPath((String)output), (CharSequence)contentRoot)) {
            throw new ConfigurationException("Output path is incompatible with eclipse format which supports output under content root only");
        }
    }

    public void detach(Module module) {
        EclipseModuleManager.getInstance(module).setDocumentSet(null);
    }

    public ClasspathStorageProvider.ClasspathConverter createConverter(Module module) {
        return new EclipseClasspathConverter(module);
    }

    public String getContentRoot(ModifiableRootModel model) {
        VirtualFile contentRoot = EPathUtil.getContentRoot((ModuleRootModel)model);
        if (contentRoot != null) {
            return contentRoot.getPath();
        }
        return model.getContentRoots()[0].getPath();
    }

    public static void registerFiles(CachedXmlDocumentSet fileCache, Module module, String moduleRoot, String storageRoot) {
        fileCache.register(".classpath", storageRoot);
        fileCache.register(".project", storageRoot);
        fileCache.register("plugin.xml", storageRoot);
        fileCache.register(module.getName() + ".eml", moduleRoot);
    }

    static CachedXmlDocumentSet getFileCache(Module module) {
        CachedXmlDocumentSet fileCache = EclipseModuleManager.getInstance(module).getDocumentSet();
        if (fileCache == null) {
            fileCache = new CachedXmlDocumentSet(module.getProject());
            EclipseModuleManager.getInstance(module).setDocumentSet(fileCache);
            EclipseClasspathStorageProvider.registerFiles(fileCache, module, ClasspathStorage.getModuleDir((Module)module), ClasspathStorage.getStorageRootFromOptions((Module)module));
            fileCache.preload();
        }
        return fileCache;
    }

    public void moduleRenamed(Module module, String newName) {
        if (ClasspathStorage.getStorageType((Module)module).equals(ID)) {
            try {
                CachedXmlDocumentSet documentSet = EclipseClasspathStorageProvider.getFileCache(module);
                String oldEmlName = module.getName() + ".eml";
                String root = documentSet.getParent(oldEmlName);
                File source = new File(root, oldEmlName);
                if (source.exists()) {
                    File target = new File(root, newName + ".eml");
                    FileUtil.rename((File)source, (File)target);
                    LocalFileSystem.getInstance().refreshAndFindFileByIoFile(target);
                }
                CachedXmlDocumentSet fileCache = EclipseClasspathStorageProvider.getFileCache(module);
                fileCache.delete(oldEmlName);
                fileCache.register(newName + ".eml", ClasspathStorage.getModuleDir((Module)module));
                fileCache.load(newName + ".eml");
            }
            catch (IOException ignore) {
            }
            catch (JDOMException jDOMException) {
                // empty catch block
            }
        }
    }

    public static class EclipseClasspathConverter
    implements ClasspathStorageProvider.ClasspathConverter {
        private final Module module;

        public EclipseClasspathConverter(Module module) {
            this.module = module;
        }

        public CachedXmlDocumentSet getFileSet() {
            CachedXmlDocumentSet fileCache = EclipseModuleManager.getInstance(this.module).getDocumentSet();
            return fileCache != null ? fileCache : EclipseClasspathStorageProvider.getFileCache(this.module);
        }

        public Set<String> getClasspath(ModifiableRootModel model, Element element) throws IOException, InvalidDataException {
            try {
                HashSet<String> usedVariables = new HashSet<String>();
                CachedXmlDocumentSet documentSet = this.getFileSet();
                VirtualFile vFile = documentSet.getVFile(".project");
                assert (vFile != null);
                VirtualFile parent = vFile.getParent();
                assert (parent != null);
                String path = parent.getPath();
                EclipseClasspathReader classpathReader = new EclipseClasspathReader(path, this.module.getProject(), null);
                classpathReader.init(model);
                if (documentSet.exists(".classpath")) {
                    classpathReader.readClasspath(model, new ArrayList<String>(), new ArrayList<String>(), usedVariables, new HashSet<String>(), null, documentSet.read(".classpath").getRootElement());
                } else {
                    EclipseClasspathReader.setupOutput(model, path + "/bin");
                }
                String eml = model.getModule().getName() + ".eml";
                if (documentSet.exists(eml)) {
                    IdeaSpecificSettings.readIDEASpecific(documentSet.read(eml).getRootElement(), model);
                } else {
                    ((CompilerModuleExtension)model.getModuleExtension(CompilerModuleExtension.class)).setExcludeOutput(false);
                }
                ((RootModelImpl)model).writeExternal(element);
                return usedVariables;
            }
            catch (ConversionException e) {
                throw new InvalidDataException((Throwable)e);
            }
            catch (WriteExternalException e) {
                throw new InvalidDataException((Throwable)e);
            }
            catch (JDOMException e) {
                throw new InvalidDataException((Throwable)e);
            }
        }

        public void setClasspath(ModuleRootModel model) throws IOException, WriteExternalException {
            try {
                Element element;
                Element classpathElement = new Element("classpath");
                EclipseClasspathWriter classpathWriter = new EclipseClasspathWriter(model);
                CachedXmlDocumentSet fileSet = this.getFileSet();
                try {
                    element = fileSet.read(".classpath").getRootElement();
                }
                catch (Exception e) {
                    element = null;
                }
                if (element != null || model.getSourceRoots().length > 0 || model.getOrderEntries().length > 2) {
                    classpathWriter.writeClasspath(classpathElement, element);
                    fileSet.write(new Document(classpathElement), ".classpath");
                }
                try {
                    fileSet.read(".project");
                }
                catch (Exception e) {
                    DotProjectFileHelper.saveDotProjectFile(this.module, fileSet.getParent(".project"));
                }
                Element ideaSpecific = new Element("component");
                String emlFilename = model.getModule().getName() + ".eml";
                if (IdeaSpecificSettings.writeIDEASpecificClasspath(ideaSpecific, model)) {
                    fileSet.write(new Document(ideaSpecific), emlFilename);
                } else {
                    fileSet.delete(emlFilename);
                }
            }
            catch (ConversionException e) {
                throw new WriteExternalException(e.getMessage());
            }
        }
    }
}

