/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.util.Icons;
import java.awt.Color;
import javax.swing.Icon;

public class ResourceBundlePropertyStructureViewElement
implements StructureViewTreeElement {
    private final String myPropertyName;
    private final Project myProject;
    private final ResourceBundle myResourceBundle;
    private String myPresentableName;
    private static final TextAttributesKey INCOMPLETE_PROPERTY_KEY;

    public ResourceBundlePropertyStructureViewElement(Project project, ResourceBundle resourceBundle, String propertyName) {
        this.myProject = project;
        this.myResourceBundle = resourceBundle;
        this.myPropertyName = propertyName;
    }

    public void setPresentableName(String presentableName) {
        this.myPresentableName = presentableName;
    }

    public String getValue() {
        return this.myPropertyName;
    }

    public StructureViewTreeElement[] getChildren() {
        return EMPTY_ARRAY;
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return ResourceBundlePropertyStructureViewElement.this.myPresentableName == null ? ResourceBundlePropertyStructureViewElement.this.myPropertyName : ResourceBundlePropertyStructureViewElement.this.myPresentableName;
            }

            public String getLocationString() {
                return null;
            }

            public Icon getIcon(boolean open) {
                return Icons.PROPERTY_ICON;
            }

            public TextAttributesKey getTextAttributesKey() {
                boolean isComplete = PropertiesUtil.isPropertyComplete(ResourceBundlePropertyStructureViewElement.this.myProject, ResourceBundlePropertyStructureViewElement.this.myResourceBundle, ResourceBundlePropertyStructureViewElement.this.myPropertyName);
                if (isComplete) {
                    return PropertiesHighlighter.PROPERTY_KEY;
                }
                return INCOMPLETE_PROPERTY_KEY;
            }
        };
    }

    public void navigate(boolean requestFocus) {
    }

    public boolean canNavigate() {
        return false;
    }

    public boolean canNavigateToSource() {
        return false;
    }

    static {
        TextAttributes textAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(PropertiesHighlighter.PROPERTY_KEY).clone();
        textAttributes.setForegroundColor(Color.red);
        INCOMPLETE_PROPERTY_KEY = TextAttributesKey.createTextAttributesKey((String)"INCOMPLETE_PROPERTY_KEY", (TextAttributes)textAttributes);
    }
}

