/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.tokenizer;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.spellchecker.inspections.CheckArea;
import com.intellij.spellchecker.inspections.Splitter;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Token<T extends PsiElement> {
    private final String text;
    private final String description;
    private final boolean useRename;
    private int offset;
    private final T element;
    private final Splitter splitter;
    private TextRange range;

    public Token(T element, String text, boolean useRename, Splitter splitter) {
        this.element = element;
        this.text = text;
        this.useRename = useRename;
        this.splitter = splitter;
        this.offset = 0;
        this.description = null;
    }

    public Token(T element, String text, boolean useRename, int offset, Splitter splitter) {
        this(element, text, useRename, splitter);
        this.offset = offset;
    }

    public Token(T element, String text, boolean useRename, int offset, TextRange textRange, Splitter splitter) {
        this(element, text, useRename, offset, splitter);
        this.range = textRange;
    }

    public String getText() {
        return this.text;
    }

    public String getDescription() {
        return this.description;
    }

    public T getElement() {
        return this.element;
    }

    public boolean isUseRename() {
        return this.useRename;
    }

    public int getOffset() {
        return this.offset;
    }

    @NotNull
    public TextRange getRange() {
        if (this.range == null) {
            this.range = new TextRange(0, this.text != null ? this.text.length() : 0);
        }
        TextRange textRange = this.range;
        if (textRange == null) {
            throw new IllegalStateException("@NotNull method com/intellij/spellchecker/tokenizer/Token.getRange must not return null");
        }
        return textRange;
    }

    @Nullable
    public List<CheckArea> getAreas() {
        if (this.splitter == null || this.text == null) {
            return null;
        }
        return this.splitter.split(this.text, this.getRange());
    }
}

