/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.state;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.dictionary.EditableDictionaryLoader;
import com.intellij.spellchecker.state.AggregatedDictionaryState;
import com.intellij.util.Consumer;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class StateLoader
implements EditableDictionaryLoader {
    private Project project;
    private EditableDictionary dictionary;

    public StateLoader(Project project) {
        this.project = project;
    }

    @Override
    public void load(@NotNull Consumer<String> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/state/StateLoader.load must not be null");
        }
        AggregatedDictionaryState state = (AggregatedDictionaryState)ServiceManager.getService((Project)this.project, AggregatedDictionaryState.class);
        state.setProject(this.project);
        state.loadState();
        this.dictionary = state.getDictionary();
        if (this.dictionary == null) {
            return;
        }
        Set<String> storedWords = this.dictionary.getWords();
        if (storedWords != null) {
            for (String word : storedWords) {
                consumer.consume((Object)word);
            }
        }
    }

    @Override
    public EditableDictionary getDictionary() {
        return this.dictionary;
    }

    @Override
    public String getName() {
        return this.dictionary != null ? this.dictionary.getName() : "";
    }
}

