/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.dictionary;

import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.util.Consumer;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UserDictionary
implements EditableDictionary {
    private String name;
    @NotNull
    private final THashSet<String> words = new THashSet();

    public UserDictionary(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean contains(String word) {
        return this.words.contains((Object)word);
    }

    @Override
    public int size() {
        return this.words == null ? 0 : this.words.size();
    }

    @Override
    @Nullable
    public Set<String> getWords() {
        return this.words;
    }

    @Override
    @Nullable
    public Set<String> getEditableWords() {
        return this.words;
    }

    @Override
    public void clear() {
        this.words.clear();
    }

    @Override
    public void addToDictionary(String word) {
        if (word == null) {
            return;
        }
        this.words.add((Object)word);
    }

    @Override
    public void removeFromDictionary(String word) {
        if (word == null) {
            return;
        }
        this.words.remove((Object)word);
    }

    @Override
    public void replaceAll(@Nullable Collection<String> words) {
        this.clear();
        this.addToDictionary(words);
    }

    @Override
    public void addToDictionary(@Nullable Collection<String> words) {
        if (words == null || words.isEmpty()) {
            return;
        }
        for (String word : words) {
            this.addToDictionary(word);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.words.size() == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserDictionary that = (UserDictionary)o;
        return !(this.name == null ? that.name != null : !this.name.equals(that.name));
    }

    @Override
    public void traverse(Consumer<String> consumer) {
        for (String word : this.words) {
            consumer.consume((Object)word);
        }
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String toString() {
        return "UserDictionary{name='" + this.name + '\'' + ", words.count=" + this.words.size() + '}';
    }
}

