/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.actions;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.spellchecker.SpellCheckerManager;
import java.util.ArrayList;
import java.util.List;

public final class CompleteWordFromDictionaryAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        int caretOffset;
        int documentOffset;
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        Editor editor = (Editor)e.getData(PlatformDataKeys.EDITOR);
        PsiFile psiFile = (PsiFile)e.getData(LangDataKeys.PSI_FILE);
        if (project != null && editor != null && psiFile != null && (documentOffset = (caretOffset = editor.getCaretModel().getOffset()) - 1) > 0) {
            char c;
            char c2;
            StringBuilder prefixBuilder = new StringBuilder();
            CharSequence charSequence = editor.getDocument().getCharsSequence();
            while (documentOffset >= 0 && Character.isJavaIdentifierPart(c2 = charSequence.charAt(documentOffset))) {
                prefixBuilder.append(c2);
                --documentOffset;
            }
            StringBuilder suffixBuilder = new StringBuilder();
            for (documentOffset = caretOffset; documentOffset < charSequence.length() && Character.isJavaIdentifierPart(c = charSequence.charAt(documentOffset)); ++documentOffset) {
                suffixBuilder.append(c);
            }
            if (prefixBuilder.length() > 0) {
                String prefix;
                String[] prefixes = NameUtil.nameToWords((String)prefixBuilder.reverse().toString());
                String string = prefix = prefixes.length > 0 ? prefixes[prefixes.length - 1] : "";
                if (prefix.length() > 0) {
                    String suffix;
                    String[] suffixes = NameUtil.nameToWords((String)suffixBuilder.toString());
                    String string2 = suffix = suffixes.length > 0 ? suffixes[0] : "";
                    if (suffix.length() > 0 && Character.isLowerCase(suffix.charAt(0))) {
                        editor.getSelectionModel().setSelection(caretOffset, caretOffset + suffix.length());
                    }
                    List<String> variants = SpellCheckerManager.getInstance(project).getVariants(prefix);
                    ArrayList<LookupElementBuilder> lookupItems = new ArrayList<LookupElementBuilder>();
                    for (String variant : variants) {
                        lookupItems.add(LookupElementBuilder.create((String)variant));
                    }
                    LookupElement[] items = lookupItems.toArray(new LookupElement[lookupItems.size()]);
                    LookupManager.getInstance((Project)project).showLookup(editor, items, prefix);
                }
            }
        }
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Project project = (Project)e.getData(LangDataKeys.PROJECT);
        Editor editor = (Editor)e.getData(LangDataKeys.EDITOR);
        PsiFile psiFile = (PsiFile)e.getData(LangDataKeys.PSI_FILE);
        boolean available = project != null && editor != null && psiFile != null;
        Presentation presentation = e.getPresentation();
        if (presentation.isVisible()) {
            presentation.setVisible(available);
        }
        if (presentation.isEnabled()) {
            presentation.setEnabled(available);
        }
    }
}

