#!/bin/sh
echo 'name: aeson
version: 0.4.0.1
id: aeson-0.4.0.1-d0d7de012144831f5840b3abbfe71a89

license: BSD3
copyright: (c) 2011 Bryan O'\''Sullivan
           (c) 2011 MailRank, Inc.
maintainer: Bryan O'\''Sullivan <bos@serpentine.com>
stability: experimental
homepage: https://github.com/bos/aeson
package-url:
description: A JSON parsing and encoding library optimized for ease of use
             and high performance.
             .
             To get started, see the documentation for the @Data.Aeson@ module
             below.
             .
             For release notes, see
             <https://github.com/bos/aeson/blob/master/release-notes.markdown>
             .
             /Note/: if you use GHCi or Template Haskell, please see the
             @README@ file for important details about building this package,
             and other packages that depend on it:
             <https://github.com/bos/aeson#readme>
             .
             Parsing performance on a late 2010 MacBook Pro (2.66GHz Core i7),
             for mostly-English tweets from Twitter'\''s JSON search API:
             .
             * 0.8 KB, 32-bit GHC 6.12.3: 30538 msg\/sec (24.9 MB\/sec)
             .
             * 0.8 KB, 64-bit GHC 7.0.3: 31204 msg\/sec (25.4 MB\/sec)
             .
             * 6.4 KB, 32-bit GHC 6.12.3: 6731 msg\/sec (42.3 MB\/sec)
             .
             * 6.4 KB, 64-bit GHC 7.0.3: 6627 msg\/sec (41.7 MB\/sec)
             .
             * 11.8 KB, 32-bit GHC 6.12.3: 3751 msg\/sec (43.2 MB\/sec)
             .
             * 11.8 KB, 64-bit GHC 7.0.3: 3381 msg\/sec (38.9 MB\/sec)
             .
             * 31.2 KB, 32-bit GHC 6.12.3: 1306 msg\/sec (39.8 MB\/sec)
             .
             * 31.2 KB, 64-bit GHC 7.0.3: 1132 msg\/sec (34.5 MB\/sec)
             .
             * 61.5 KB, 32-bit GHC 6.12.3: 616 msg\/sec (37.0 MB\/sec)
             .
             * 61.5 KB, 64-bit GHC 7.0.3: 534 msg\/sec (32.1 MB\/sec)
             .
             Handling heavily-escaped text is a little more work.  Here is
             parsing performance with Japanese tweets, where much of the text
             is entirely Unicode-escaped.
             .
             * 14.6 KB, 32-bit GHC 6.12.3: 2315 msg\/sec (33.1 MB\/sec)
             .
             * 14.6 KB, 64-bit GHC 7.0.3: 1986 msg\/sec (28.4 MB\/sec)
             .
             * 44.1 KB, 32-bit GHC 6.12.3: 712 msg\/sec (30.7 MB\/sec)
             .
             * 44.1 KB, 64-bit GHC 7.0.3: 634 msg\/sec (27.3 MB\/sec)
             .
             * 82.9 KB, 32-bit GHC 6.12.3: 377 msg\/sec (30.5 MB\/sec)
             .
             * 82.9 KB, 64-bit GHC 7.0.3: 332 msg\/sec (26.9 MB\/sec)
             .
             Encoding performance on the same machine and data:
             .
             * English, 854 bytes: 43439 msg\/sec (35.4 MB/sec)
             .
             * English, 6.4 KB: 7127 msg\/sec (44.8 MB/sec)
             .
             * Engish, 61.5 KB: 765 msg\/sec (46.0 MB/sec)
             .
             * Japanese, 14.6 KB: 4727 msg\/sec (67.5 MB/sec)
             .
             * Japanese, 44.1 KB: 1505 msg\/sec (64.8 MB/sec)
             .
             (A note on naming: in Greek mythology, Aeson was the father of Jason.)
category: Text, Web, JSON
author: Bryan O'\''Sullivan <bos@serpentine.com>
pkgpath: devel/hs-aeson
exposed: True
exposed-modules: Data.Aeson Data.Aeson.Encode Data.Aeson.Generic
                 Data.Aeson.Parser Data.Aeson.Types Data.Aeson.TH
hidden-modules: Data.Aeson.Functions Data.Aeson.Parser.Internal
                Data.Aeson.Types.Class Data.Aeson.Types.Internal
import-dirs: /usr/local/lib/ghc/aeson-0.4.0.1
library-dirs: /usr/local/lib/ghc/aeson-0.4.0.1
hs-libraries: HSaeson-0.4.0.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: attoparsec-0.8.6.1-6571973e9a458e9ceb9b784270798e62
         base-4.3.1.0-4365831fa9af03083be195ed161cbbc1
         blaze-builder-0.2.1.4-a9a25d33e6d6a838e2cd173ee4fe6a2b
         blaze-textual-0.2.0.6-872610322f4db76fb9709b1ad9167480
         bytestring-0.9.1.10-d11caeadd9605139e1a59850ce083826
         containers-0.4.0.0-b4885363abca642443ccd842502a3b7e
         deepseq-1.1.0.2-0465f803f7d27d264907e7e03e72a71f
         hashable-1.1.2.2-6a4ed2e9867bca45698894dcbd97c792
         mtl-2.0.1.0-5b7a9cce5565d8cc8721ba4f95becf1b
         old-locale-1.0.0.2-161f79060c89cc16ca11576ceb440486
         syb-0.3.3-dd575fa8180bf87dbbe1727117c3b35c
         template-haskell-2.5.0.0-b8491f77d06d290bb99ada53d74aa786
         text-0.11.1.5-24dbc1ca0a1252804bf8bef893d5cf9c
         time-1.2.0.3-3493203919ef238f1a58223fa55b1ceb
         unordered-containers-0.1.4.6-d50348c54534842c443b7c24ef791eba
         vector-0.7.1-8801549ab29457801fbe1eca2f7ad3c5
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-aeson-0.4.0.1/html/aeson.haddock
haddock-html: /usr/local/share/doc/hs-aeson-0.4.0.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
