#!/bin/sh
echo 'name: ListLike
version: 1.0.1
id: ListLike-1.0.1-5372182b2945c216509167b17b4e024e

license: LGPL
copyright: Copyright (c) 2007-2008 John Goerzen
maintainer: John Goerzen <jgoerzen@complete.org>
stability: Stable
homepage: http://software.complete.org/listlike
package-url:
description: Generic support for list-like structures in Haskell.
             .
             The ListLike module provides a common interface to the various Haskell
             types that are list-like.  Predefined interfaces include standard
             Haskell lists, Arrays, ByteStrings, and lazy ByteStrings.  Custom
             types can easily be made ListLike instances as well.
             .
             ListLike also provides for String-like types, such as String and
             ByteString, for types that support input and output, and for types that can handle
             infinite lists.
category: Generics
author: John Goerzen
pkgpath: devel/hs-ListLike
exposed: True
exposed-modules: Data.ListLike Data.ListLike.Base
                 Data.ListLike.FoldableLL Data.ListLike.IO Data.ListLike.Instances
                 Data.ListLike.String Data.ListLike.Utils
hidden-modules:
import-dirs: /usr/local/lib/ghc/ListLike-1.0.1
library-dirs: /usr/local/lib/ghc/ListLike-1.0.1
hs-libraries: HSListLike-1.0.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.3.0.2-143060371bda4ff52c270d1067551fe8
         base-4.3.1.0-4365831fa9af03083be195ed161cbbc1
         bytestring-0.9.1.10-d11caeadd9605139e1a59850ce083826
         containers-0.4.0.0-b4885363abca642443ccd842502a3b7e
         haskell98-1.1.0.1-77a2638462dcb3e7c4b25de628e54ca6
         mtl-2.0.1.0-5b7a9cce5565d8cc8721ba4f95becf1b
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-ListLike-1.0.1/html/ListLike.haddock
haddock-html: /usr/local/share/doc/hs-ListLike-1.0.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
