/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attributes
implements Cloneable,
Map<Object, Object> {
    protected Map<Object, Object> map;

    public Attributes() {
        this.map = new Hashtable<Object, Object>();
    }

    public Attributes(int size) {
        this.map = new Hashtable<Object, Object>(size);
    }

    public Attributes(Attributes attr) {
        this.map = new Hashtable<Object, Object>(attr.map);
    }

    public String getValue(String name) {
        return (String)this.get(new Name(name));
    }

    public String getValue(Name name) {
        return (String)this.get(name);
    }

    public String putValue(String name, String value) {
        return this.putValue(new Name(name), value);
    }

    private String putValue(Name name, String value) {
        return (String)this.put(name, value);
    }

    public Object clone() {
        return new Attributes(this);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object attrName) {
        return this.map.containsKey(attrName);
    }

    @Override
    public boolean containsValue(Object attrValue) {
        return this.map.containsValue(attrValue);
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        try {
            return this.map.equals(((Attributes)o).map);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    @Override
    public Object get(Object attrName) {
        return this.map.get(attrName);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<Object> keySet() {
        return this.map.keySet();
    }

    @Override
    public Object put(Object name, Object value) {
        return this.map.put(name, value);
    }

    @Override
    public void putAll(Map<?, ?> attr) {
        if (!(attr instanceof Attributes)) {
            throw new ClassCastException("Supplied Map is not an instance of Attributes");
        }
        this.map.putAll(attr);
    }

    @Override
    public Object remove(Object name) {
        return this.map.remove(name);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    public static class Name {
        public static final Name MANIFEST_VERSION = new Name("Manifest-Version");
        public static final Name SIGNATURE_VERSION = new Name("Signature-Version");
        public static final Name CLASS_PATH = new Name("Class-Path");
        public static final Name MAIN_CLASS = new Name("Main-Class");
        public static final Name EXTENSION_LIST = new Name("Extension-List");
        public static final Name EXTENSION_NAME;
        public static final Name EXTENSION_INSTALLATION;
        public static final Name IMPLEMENTATION_TITLE;
        public static final Name IMPLEMENTATION_VERSION;
        public static final Name IMPLEMENTATION_VENDOR;
        public static final Name IMPLEMENTATION_VENDOR_ID;
        public static final Name IMPLEMENTATION_URL;
        public static final Name SPECIFICATION_TITLE;
        public static final Name SPECIFICATION_VERSION;
        public static final Name SPECIFICATION_VENDOR;
        public static final Name SEALED;
        public static final Name CONTENT_TYPE;
        private final String name;
        private final String origName;

        static {
            EXTENSION_INSTALLATION = EXTENSION_NAME = new Name("Extension-Name");
            IMPLEMENTATION_TITLE = new Name("Implementation-Title");
            IMPLEMENTATION_VERSION = new Name("Implementation-Version");
            IMPLEMENTATION_VENDOR = new Name("Implementation-Vendor");
            IMPLEMENTATION_VENDOR_ID = new Name("Implementation-Vendor-Id");
            IMPLEMENTATION_URL = new Name("Implementation-URL");
            SPECIFICATION_TITLE = new Name("Specification-Title");
            SPECIFICATION_VERSION = new Name("Specification-Version");
            SPECIFICATION_VENDOR = new Name("Specification-Vendor");
            SEALED = new Name("Sealed");
            CONTENT_TYPE = new Name("Content-Type");
        }

        public Name(String name) throws IllegalArgumentException, NullPointerException {
            char[] chars = name.toCharArray();
            if (chars.length == 0) {
                throw new IllegalArgumentException("There must be at least one character in a name");
            }
            char c = chars[0];
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9')) {
                throw new IllegalArgumentException("First character must be alphanum");
            }
            int i = 1;
            while (i < chars.length) {
                c = chars[i];
                if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_')) {
                    throw new IllegalArgumentException("Characters must be alphanums, '-' or '_'");
                }
                ++i;
            }
            this.origName = name;
            this.name = name.toLowerCase();
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object o) {
            if (this.name == o) {
                return true;
            }
            try {
                String otherName = ((Name)o).name;
                return this.name.equals(otherName);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }

        public String toString() {
            return this.origName;
        }
    }
}

