/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.security.auth.callback;

import gnu.javax.security.auth.callback.AbstractCallbackHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.LanguageCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;

public class ConsoleCallbackHandler
extends AbstractCallbackHandler {
    private final PrintStream out;

    public ConsoleCallbackHandler() {
        this(System.out);
    }

    public ConsoleCallbackHandler(PrintStream out) {
        super("CONSOLE");
        this.out = out;
    }

    protected void handleChoice(ChoiceCallback c) throws IOException {
        String reply;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        this.out.println(c.getPrompt());
        this.out.print('(');
        String[] choices = c.getChoices();
        int i = 0;
        while (i < choices.length) {
            this.out.print(choices[i]);
            if (i != choices.length - 1) {
                this.out.print(", ");
            }
            ++i;
        }
        this.out.print(") ");
        if (c.getDefaultChoice() >= 0 && c.getDefaultChoice() < choices.length) {
            this.out.print('[');
            this.out.print(choices[c.getDefaultChoice()]);
            this.out.print("] ");
        }
        if ((reply = in.readLine()) == null || reply.length() == 0) {
            c.setSelectedIndex(c.getDefaultChoice());
            return;
        }
        if (!c.allowMultipleSelections()) {
            int i2 = 0;
            while (i2 < choices.length) {
                if (reply.trim().equals(choices[i2])) {
                    c.setSelectedIndex(i2);
                    return;
                }
                ++i2;
            }
            c.setSelectedIndex(c.getDefaultChoice());
        } else {
            TreeSet<Integer> indices = new TreeSet<Integer>();
            StringTokenizer tok = new StringTokenizer(reply, ",");
            String[] replies = new String[tok.countTokens()];
            int idx = 0;
            while (tok.hasMoreTokens()) {
                replies[idx++] = tok.nextToken().trim();
            }
            int i3 = 0;
            while (i3 < choices.length) {
                int j = 0;
                while (j < replies.length) {
                    if (choices[i3].equals(replies[j])) {
                        indices.add(i3);
                    }
                    ++i3;
                }
                ++i3;
            }
            if (indices.size() == 0) {
                c.setSelectedIndex(c.getDefaultChoice());
            } else {
                int[] ii = new int[indices.size()];
                int i4 = 0;
                Iterator it = indices.iterator();
                while (it.hasNext()) {
                    ii[i4++] = (Integer)it.next();
                }
                c.setSelectedIndexes(ii);
            }
        }
    }

    protected void handleConfirmation(ConfirmationCallback c) throws IOException {
        int i;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        if (c.getPrompt() != null) {
            this.out.print(c.getPrompt());
        }
        String[] choices = null;
        int[] values = null;
        switch (c.getOptionType()) {
            case 2: {
                this.out.print(this.messages.getString("callback.okCancel"));
                choices = new String[]{this.messages.getString("callback.ok"), this.messages.getString("callback.cancel"), this.messages.getString("callback.shortOk"), this.messages.getString("callback.shortCancel")};
                values = new int[]{3, 2, 3, 2};
                break;
            }
            case 1: {
                this.out.print(this.messages.getString("callback.yesNoCancel"));
                choices = new String[]{this.messages.getString("callback.yes"), this.messages.getString("callback.no"), this.messages.getString("callback.cancel"), this.messages.getString("callback.shortYes"), this.messages.getString("callback.shortNo"), this.messages.getString("callback.shortCancel")};
                int[] nArray = new int[6];
                nArray[1] = 1;
                nArray[2] = 2;
                nArray[4] = 1;
                nArray[5] = 2;
                values = nArray;
                break;
            }
            case 0: {
                this.out.print(this.messages.getString("callback.yesNo"));
                choices = new String[]{this.messages.getString("callback.yes"), this.messages.getString("callback.no"), this.messages.getString("callback.shortYes"), this.messages.getString("callback.shortNo")};
                int[] nArray = new int[4];
                nArray[1] = 1;
                nArray[3] = 1;
                values = nArray;
                int defaultOption = c.getDefaultOption();
                if (defaultOption <= -1 || defaultOption >= choices.length) break;
                this.out.print("[");
                this.out.print(choices[defaultOption]);
                this.out.print("] ");
                break;
            }
            case -1: {
                choices = c.getOptions();
                values = new int[choices.length];
                i = 0;
                while (i < values.length) {
                    values[i] = i;
                    ++i;
                }
                this.out.print('(');
                i = 0;
                while (i < choices.length) {
                    this.out.print(choices[i]);
                    if (i != choices.length - 1) {
                        this.out.print(", ");
                    }
                    ++i;
                }
                this.out.print(") [");
                this.out.print(choices[c.getDefaultOption()]);
                this.out.print("] ");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        String reply = in.readLine();
        if (reply == null) {
            c.setSelectedIndex(c.getDefaultOption());
            return;
        }
        reply = reply.trim();
        i = 0;
        while (i < choices.length) {
            if (reply.equalsIgnoreCase(choices[i])) {
                c.setSelectedIndex(values[i]);
                return;
            }
            ++i;
        }
        c.setSelectedIndex(c.getDefaultOption());
    }

    protected void handleLanguage(LanguageCallback c) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        this.out.print(this.messages.getString("callback.language"));
        String reply = null;
        reply = in.readLine();
        if (reply == null) {
            c.setLocale(Locale.getDefault());
        } else {
            c.setLocale(new Locale(reply.trim()));
        }
    }

    protected void handleName(NameCallback c) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        this.out.print(c.getPrompt());
        String name = in.readLine();
        if (name != null) {
            c.setName(name.trim());
        }
    }

    protected void handlePassword(PasswordCallback c) throws IOException {
        this.out.print(c.getPrompt());
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        String pass = in.readLine();
        c.setPassword(pass.toCharArray());
    }

    protected void handleTextInput(TextInputCallback c) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        this.out.print(c.getPrompt());
        String text = in.readLine();
        if (text != null) {
            c.setText(text);
        }
    }

    protected void handleTextOutput(TextOutputCallback c) {
        this.out.print(c.getMessage());
    }
}

