/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class IdentityHashMap
extends AbstractMap
implements Map,
Serializable,
Cloneable {
    private static final int DEFAULT_CAPACITY = 21;
    static final Object tombstone = new Object();
    static final Object emptyslot = new Object();
    private static final long serialVersionUID = 8188218128353913216L;
    int size;
    transient Object[] table;
    transient int modCount;
    private transient Set entries;
    private transient int threshold;

    public IdentityHashMap() {
        this(21);
    }

    public IdentityHashMap(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n < 2) {
            n = 2;
        }
        this.table = new Object[n << 1];
        Arrays.fill(this.table, emptyslot);
        this.threshold = (n >> 2) * 3;
    }

    public IdentityHashMap(Map map) {
        this(Math.max(map.size() << 1, 21));
        this.putAll(map);
    }

    public void clear() {
        if (this.size != 0) {
            ++this.modCount;
            Arrays.fill(this.table, emptyslot);
            this.size = 0;
        }
    }

    public Object clone() {
        try {
            IdentityHashMap identityHashMap = (IdentityHashMap)super.clone();
            identityHashMap.table = (Object[])this.table.clone();
            identityHashMap.entries = null;
            return identityHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean containsKey(Object object) {
        return object == this.table[this.hash(object)];
    }

    public boolean containsValue(Object object) {
        for (int i = this.table.length - 1; i > 0; i -= 2) {
            if (this.table[i] != object) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractSet(this){
                private /* synthetic */ IdentityHashMap this$0;
                {
                    this.this$0 = identityHashMap;
                }

                public int size() {
                    return this.this$0.size;
                }

                public Iterator iterator() {
                    return new IdentityIterator(this.this$0, 2);
                }

                public void clear() {
                    this.this$0.clear();
                }

                public boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    return entry.getValue() == this.this$0.table[this.this$0.hash(entry.getKey()) + 1];
                }

                public int hashCode() {
                    return this.this$0.hashCode();
                }

                public boolean remove(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Object object2 = ((Map.Entry)object).getKey();
                    int n = this.this$0.hash(object2);
                    if (this.this$0.table[n] == object2) {
                        --this.this$0.size;
                        ++this.this$0.modCount;
                        this.this$0.table[n] = tombstone;
                        this.this$0.table[n + 1] = tombstone;
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.entries;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public Object get(Object object) {
        int n = this.hash(object);
        if (this.table[n] == object) {
            return this.table[n + 1];
        }
        return null;
    }

    public int hashCode() {
        int n = 0;
        for (int i = this.table.length - 2; i >= 0; i -= 2) {
            Object object = this.table[i];
            if (object == emptyslot || object == tombstone) continue;
            n += System.identityHashCode(object) ^ System.identityHashCode(this.table[i + 1]);
        }
        return n;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Set keySet() {
        if (this.keys == null) {
            this.keys = new AbstractSet(this){
                private /* synthetic */ IdentityHashMap this$0;
                {
                    this.this$0 = identityHashMap;
                }

                public int size() {
                    return this.this$0.size;
                }

                public Iterator iterator() {
                    return new IdentityIterator(this.this$0, 0);
                }

                public void clear() {
                    this.this$0.clear();
                }

                public boolean contains(Object object) {
                    return this.this$0.containsKey(object);
                }

                public int hashCode() {
                    int n = 0;
                    for (int i = this.this$0.table.length - 2; i >= 0; i -= 2) {
                        Object object = this.this$0.table[i];
                        if (object == emptyslot || object == tombstone) continue;
                        n += System.identityHashCode(object);
                    }
                    return n;
                }

                public boolean remove(Object object) {
                    int n = this.this$0.hash(object);
                    if (this.this$0.table[n] == object) {
                        --this.this$0.size;
                        ++this.this$0.modCount;
                        this.this$0.table[n] = tombstone;
                        this.this$0.table[n + 1] = tombstone;
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.keys;
    }

    public Object put(Object object, Object object2) {
        int n;
        if (this.size > this.threshold) {
            Object[] objectArray = this.table;
            this.table = new Object[objectArray.length * 2 + 2];
            Arrays.fill(this.table, emptyslot);
            this.size = 0;
            this.threshold = (this.table.length >>> 3) * 3;
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                Object object3 = objectArray[i];
                if (object3 == tombstone || object3 == emptyslot) continue;
                this.put(object3, objectArray[i + 1]);
            }
        }
        if (this.table[n = this.hash(object)] == object) {
            Object object4 = this.table[n + 1];
            this.table[n + 1] = object2;
            return object4;
        }
        ++this.modCount;
        ++this.size;
        this.table[n] = object;
        this.table[n + 1] = object2;
        return null;
    }

    public void putAll(Map map) {
        super.putAll(map);
    }

    public Object remove(Object object) {
        int n = this.hash(object);
        if (this.table[n] == object) {
            ++this.modCount;
            --this.size;
            Object object2 = this.table[n + 1];
            this.table[n] = tombstone;
            this.table[n + 1] = tombstone;
            return object2;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(this){
                private /* synthetic */ IdentityHashMap this$0;
                {
                    this.this$0 = identityHashMap;
                }

                public int size() {
                    return this.this$0.size;
                }

                public Iterator iterator() {
                    return new IdentityIterator(this.this$0, 1);
                }

                public void clear() {
                    this.this$0.clear();
                }

                public boolean remove(Object object) {
                    for (int i = this.this$0.table.length - 1; i > 0; i -= 2) {
                        if (this.this$0.table[i] != object) continue;
                        ++this.this$0.modCount;
                        this.this$0.table[i - 1] = tombstone;
                        this.this$0.table[i] = tombstone;
                        --this.this$0.size;
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.values;
    }

    int hash(Object object) {
        int n = Math.abs(System.identityHashCode(object) % (this.table.length >> 1)) << 1;
        int n2 = -1;
        int n3 = n;
        do {
            if (this.table[n] == object) {
                return n;
            }
            if (this.table[n] == emptyslot) break;
            if (this.table[n] == tombstone && n2 < 0) {
                n2 = n;
            }
            if ((n -= 2) >= 0) continue;
            n = this.table.length - 2;
        } while (n != n3);
        if (n2 < 0) {
            return n;
        }
        return n2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.table = new Object[Math.max(n << 1, 21) << 1];
        while (--n >= 0) {
            this.put(objectInputStream.readObject(), objectInputStream.readObject());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        for (int i = this.table.length - 2; i >= 0; i -= 2) {
            Object object = this.table[i];
            if (object == tombstone || object == emptyslot) continue;
            objectOutputStream.writeObject(object);
            objectOutputStream.writeObject(this.table[i + 1]);
        }
    }

    private final class IdentityEntry
    implements Map.Entry {
        private /* synthetic */ IdentityHashMap this$0;
        final int loc;
        final int knownMod;

        private /* synthetic */ void finit$() {
            this.knownMod = this.this$0.modCount;
        }

        IdentityEntry(IdentityHashMap identityHashMap, int n) {
            this.this$0 = identityHashMap;
            this.finit$();
            this.loc = n;
        }

        public boolean equals(Object object) {
            if (this.knownMod != this.this$0.modCount || this.this$0.table[this.loc] == tombstone) {
                throw new ConcurrentModificationException();
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return this.this$0.table[this.loc] == entry.getKey() && this.this$0.table[this.loc + 1] == entry.getValue();
        }

        public Object getKey() {
            if (this.knownMod != this.this$0.modCount || this.this$0.table[this.loc] == tombstone) {
                throw new ConcurrentModificationException();
            }
            return this.this$0.table[this.loc];
        }

        public Object getValue() {
            if (this.knownMod != this.this$0.modCount || this.this$0.table[this.loc] == tombstone) {
                throw new ConcurrentModificationException();
            }
            return this.this$0.table[this.loc + 1];
        }

        public int hashCode() {
            if (this.knownMod != this.this$0.modCount || this.this$0.table[this.loc] == tombstone) {
                throw new ConcurrentModificationException();
            }
            return System.identityHashCode(this.this$0.table[this.loc]) ^ System.identityHashCode(this.this$0.table[this.loc + 1]);
        }

        public Object setValue(Object object) {
            if (this.knownMod != this.this$0.modCount || this.this$0.table[this.loc] == tombstone) {
                throw new ConcurrentModificationException();
            }
            Object object2 = this.this$0.table[this.loc + 1];
            this.this$0.table[this.loc + 1] = object;
            return object2;
        }

        public String toString() {
            if (this.knownMod != this.this$0.modCount || this.this$0.table[this.loc] == tombstone) {
                throw new ConcurrentModificationException();
            }
            return this.this$0.table[this.loc] + "=" + this.this$0.table[this.loc + 1];
        }
    }

    private class IdentityIterator
    implements Iterator {
        private /* synthetic */ IdentityHashMap this$0;
        final int type;
        int knownMod;
        int count;
        int loc;

        private /* synthetic */ void finit$() {
            this.knownMod = this.this$0.modCount;
            this.count = this.this$0.size;
            this.loc = this.this$0.table.length;
        }

        IdentityIterator(IdentityHashMap identityHashMap, int n) {
            this.this$0 = identityHashMap;
            this.finit$();
            this.type = n;
        }

        public boolean hasNext() {
            return this.count > 0;
        }

        public Object next() {
            Object object;
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.count == 0) {
                throw new NoSuchElementException();
            }
            --this.count;
            do {
                this.loc -= 2;
            } while ((object = this.this$0.table[this.loc]) == emptyslot || object == tombstone);
            if (this.type == 0) {
                return object;
            }
            if (this.type == 1) {
                return this.this$0.table[this.loc + 1];
            }
            return new IdentityEntry(this.this$0, this.loc);
        }

        public void remove() {
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.loc == this.this$0.table.length || this.this$0.table[this.loc] == tombstone) {
                throw new IllegalStateException();
            }
            ++this.this$0.modCount;
            --this.this$0.size;
            this.this$0.table[this.loc] = tombstone;
            this.this$0.table[this.loc + 1] = tombstone;
            ++this.knownMod;
        }
    }
}

