/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.classpath.SystemProperties;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;

public class Throwable
implements Serializable {
    private static final long serialVersionUID = -3042686055658047285L;
    private final String detailMessage;
    private Throwable cause;
    private StackTraceElement[] stackTrace;
    private transient VMThrowable vmState;

    private /* synthetic */ void finit$() {
        this.cause = this;
    }

    public Throwable() {
        this((String)null);
    }

    public Throwable(String string) {
        this.finit$();
        this.fillInStackTrace();
        this.detailMessage = string;
    }

    public Throwable(String string, Throwable throwable) {
        this(string);
        this.cause = throwable;
    }

    public Throwable(Throwable throwable) {
        this(throwable == null ? null : throwable.toString(), throwable);
    }

    public String getMessage() {
        return this.detailMessage;
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public Throwable getCause() {
        if (this.cause == this) {
            return null;
        }
        return this.cause;
    }

    public Throwable initCause(Throwable throwable) {
        if (throwable == this) {
            throw new IllegalArgumentException();
        }
        if (this.cause != this) {
            throw new IllegalStateException();
        }
        this.cause = throwable;
        return this;
    }

    public String toString() {
        String string = this.getLocalizedMessage();
        return this.getClass().getName() + (string == null ? "" : ": " + string);
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream printStream) {
        printStream.print(this.stackTraceString());
    }

    public void printStackTrace(PrintWriter printWriter) {
        printWriter.print(this.stackTraceString());
    }

    private String stackTraceString() {
        StringBuffer stringBuffer = new StringBuffer();
        StackTraceElement[] stackTraceElementArray = this.getStackTrace();
        Throwable.stackTraceStringBuffer(stringBuffer, this.toString(), stackTraceElementArray, 0);
        for (Throwable throwable = this.getCause(); throwable != null; throwable = throwable.getCause()) {
            stringBuffer.append("Caused by: ");
            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
            stackTraceElementArray = throwable.getStackTrace();
            if (stackTraceElementArray2 == null || stackTraceElementArray2.length == 0) {
                Throwable.stackTraceStringBuffer(stringBuffer, throwable.toString(), stackTraceElementArray, 0);
                continue;
            }
            int n = 0;
            int n2 = stackTraceElementArray.length - 1;
            for (int i = stackTraceElementArray2.length - 1; n2 > 0 && i > 0 && stackTraceElementArray[n2].equals(stackTraceElementArray2[i]); --n2, --i) {
                ++n;
            }
            Throwable.stackTraceStringBuffer(stringBuffer, throwable.toString(), stackTraceElementArray, n);
        }
        return stringBuffer.toString();
    }

    private static void stackTraceStringBuffer(StringBuffer stringBuffer, String string, StackTraceElement[] stackTraceElementArray, int n) {
        String string2 = StaticData.nl;
        stringBuffer.append(string);
        stringBuffer.append(string2);
        if (stackTraceElementArray == null || stackTraceElementArray.length == 0) {
            stringBuffer.append("   <<No stacktrace available>>");
            stringBuffer.append(string2);
        } else {
            for (int i = 0; i < stackTraceElementArray.length - n; ++i) {
                stringBuffer.append("   at ");
                stringBuffer.append(stackTraceElementArray[i] == null ? "<<Unknown>>" : stackTraceElementArray[i].toString());
                stringBuffer.append(string2);
            }
            if (n > 0) {
                stringBuffer.append("   ...");
                stringBuffer.append(n);
                stringBuffer.append(" more");
                stringBuffer.append(string2);
            }
        }
    }

    public Throwable fillInStackTrace() {
        this.vmState = VMThrowable.fillInStackTrace(this);
        this.stackTrace = null;
        return this;
    }

    public StackTraceElement[] getStackTrace() {
        if (this.stackTrace == null) {
            if (this.vmState == null) {
                this.stackTrace = new StackTraceElement[0];
            } else {
                this.stackTrace = this.vmState.getStackTrace(this);
                this.vmState = null;
            }
        }
        return this.stackTrace;
    }

    public void setStackTrace(StackTraceElement[] stackTraceElementArray) {
        int n = stackTraceElementArray.length;
        StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[n];
        while (--n >= 0) {
            stackTraceElementArray2[n] = stackTraceElementArray[n];
            if (stackTraceElementArray2[n] != null) continue;
            throw new NullPointerException("Element " + n + " null");
        }
        this.stackTrace = stackTraceElementArray2;
    }

    private static class StaticData {
        static final String nl = SystemProperties.getProperty("line.separator");

        StaticData() {
        }
    }
}

