/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.sasl;

import gnu.javax.crypto.sasl.SaslEncodingException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;

public class InputBuffer {
    protected ByteArrayInputStream in;
    protected int length;

    public InputBuffer(byte[] byArray) throws SaslEncodingException {
        this();
        if (byArray.length < 4) {
            throw new SaslEncodingException("SASL buffer header too short");
        }
        this.length = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        if (this.length > 0x7FFFFFFB || this.length < 0) {
            throw new SaslEncodingException("SASL buffer size limit exceeded");
        }
        this.in = new ByteArrayInputStream(byArray, 4, this.length);
    }

    private InputBuffer() {
    }

    public static InputBuffer getInstance(byte[] byArray) {
        return InputBuffer.getInstance(byArray, 0, byArray.length);
    }

    public static InputBuffer getInstance(byte[] byArray, int n, int n2) {
        InputBuffer inputBuffer = new InputBuffer();
        inputBuffer.in = new ByteArrayInputStream(byArray, n, n2);
        return inputBuffer;
    }

    public static int twoBytesToLength(byte[] byArray) throws SaslEncodingException {
        int n = (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
        if (n > 65535) {
            throw new SaslEncodingException("SASL MPI/Text size limit exceeded");
        }
        return n;
    }

    public boolean hasMoreElements() {
        return this.in.available() > 0;
    }

    public long getScalar(int n) throws IOException {
        if (n < 0 || n > 4) {
            throw new SaslEncodingException("Invalid SASL scalar octet count: " + String.valueOf(n));
        }
        if (!this.hasMoreElements()) {
            throw new SaslEncodingException("Not enough bytes for a scalar in buffer");
        }
        if (this.in.available() < n) {
            throw new SaslEncodingException("Illegal SASL scalar encoding");
        }
        byte[] byArray = new byte[n];
        this.in.read(byArray);
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            l <<= 8;
            l |= (long)byArray[i] & (long)255;
        }
        return l;
    }

    public byte[] getOS() throws IOException {
        if (!this.hasMoreElements()) {
            throw new SaslEncodingException("Not enough bytes for an octet-sequence in buffer");
        }
        int n = this.in.read();
        if (n > 255) {
            throw new SaslEncodingException("SASL octet-sequence size limit exceeded");
        }
        if (this.in.available() < n) {
            throw new SaslEncodingException("Illegal SASL octet-sequence encoding");
        }
        byte[] byArray = new byte[n];
        this.in.read(byArray);
        return byArray;
    }

    public byte[] getEOS() throws IOException {
        if (this.in.available() < 2) {
            throw new SaslEncodingException("Not enough bytes for an extended octet-sequence in buffer");
        }
        byte[] byArray = new byte[2];
        this.in.read(byArray);
        int n = InputBuffer.twoBytesToLength(byArray);
        if (this.in.available() < n) {
            throw new SaslEncodingException("Illegal SASL extended octet-sequence encoding");
        }
        byte[] byArray2 = new byte[n];
        this.in.read(byArray2);
        return byArray2;
    }

    public BigInteger getMPI() throws IOException {
        if (this.in.available() < 2) {
            throw new SaslEncodingException("Not enough bytes for an MPI in buffer");
        }
        byte[] byArray = new byte[2];
        this.in.read(byArray);
        int n = InputBuffer.twoBytesToLength(byArray);
        if (this.in.available() < n) {
            throw new SaslEncodingException("Illegal SASL multi-precision integer encoding");
        }
        byte[] byArray2 = new byte[n];
        this.in.read(byArray2);
        return new BigInteger(1, byArray2);
    }

    public String getText() throws IOException {
        if (this.in.available() < 2) {
            throw new SaslEncodingException("Not enough bytes for a text in buffer");
        }
        byte[] byArray = new byte[2];
        this.in.read(byArray);
        int n = InputBuffer.twoBytesToLength(byArray);
        if (this.in.available() < n) {
            throw new SaslEncodingException("Illegal SASL text encoding");
        }
        byte[] byArray2 = new byte[n];
        this.in.read(byArray2);
        return new String(byArray2, "UTF8");
    }
}

