/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.standalone;

import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.util.List;
import org.eclipse.help.internal.standalone.EclipseController;
import org.eclipse.help.internal.standalone.Options;

public class StandaloneInfocenter
extends EclipseController {
    private static final String INFOCENTER_APPLICATION_ID = "org.eclipse.help.base.infocenterApplication";

    public StandaloneInfocenter(String[] args) {
        super(INFOCENTER_APPLICATION_ID, args);
    }

    public static void main(String[] args) {
        try {
            StandaloneInfocenter infocenter = new StandaloneInfocenter(args);
            List helpCommand = Options.getHelpCommand();
            final String adminId = Options.getAdminId();
            final String adminPassword = Options.getAdminPassword();
            Authenticator.setDefault(new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(adminId, adminPassword.toCharArray());
                }
            });
            HttpURLConnection.setFollowRedirects(true);
            if (infocenter.executeCommand(helpCommand)) {
                return;
            }
            StandaloneInfocenter.printMainUsage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean executeCommand(List helpCommand) throws Exception {
        if (helpCommand.size() <= 0) {
            return false;
        }
        String command = (String)helpCommand.get(0);
        if ("start".equalsIgnoreCase(command)) {
            this.start();
            return true;
        }
        if ("shutdown".equalsIgnoreCase(command)) {
            this.shutdown();
            return true;
        }
        if ("install".equalsIgnoreCase(command) || "enable".equalsIgnoreCase(command) || "disable".equalsIgnoreCase(command) || "uninstall".equalsIgnoreCase(command) || "update".equalsIgnoreCase(command) || "search".equalsIgnoreCase(command) || "listFeatures".equalsIgnoreCase(command) || "addSite".equalsIgnoreCase(command) || "removeSite".equalsIgnoreCase(command) || "apply".equalsIgnoreCase(command)) {
            return this.executeUpdateCommand(command);
        }
        return false;
    }

    private static void printMainUsage() {
        System.out.println("Parameters syntax:");
        System.out.println();
        System.out.println("-command start | shutdown | [update command [update parameters]] [-eclipsehome eclipseInstallPath] [-host helpServerHost] [-port helpServerPort] [-adminId administratorUserId] [-adminPassword administratorPassword] [-trustStoreLocation trustStoreLocation] [-trustStorePassword trustStorePassword][-noexec] [platform options] [-vmargs [Java VM arguments]]");
        System.out.println();
        System.out.println("where:");
        System.out.println(" eclipseInstallPath specifies Eclipse installation directory; this directory is a parent to \"plugins\" directory and eclipse executable;  the option must be provided, when current directory from which infocenter is launched, is not the same as Eclipse installation directory,");
        System.out.println(" helpServerHost specifies host name of the interface that help server will use,");
        System.out.println(" helpServerPort specifies port number that help server will use,");
        System.out.println(" administratorUserId specifies the administrator user id to use when secure access is enabled");
        System.out.println(" administratorPassword specifies the administrator password to use when secure access is enabled");
        System.out.println(" trustStoreLocation specifies the location of the truststore file to use when secure access is enabled");
        System.out.println(" trustStorePassword specifies the password of the truststore file when secure access is enabled");
        System.out.println(" noexec option indicates that Eclipse executable should not be used, ");
        System.out.println(" platform options are other options that are supported by Eclipse Executable,");
        System.out.println(" update command is one of install, update, enable, disable, uninstall, search, listFeatures, addSite, removeSite, or apply,");
        System.out.println(" update parameters are -featureId, -version, -from, -to, -verifyOnly as required by update commands used.");
    }
}

