/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.filters;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentRegistryReader;
import org.eclipse.ui.internal.navigator.filters.CommonFilterDescriptor;
import org.eclipse.ui.navigator.INavigatorContentService;

public class CommonFilterDescriptorManager {
    private static final CommonFilterDescriptorManager INSTANCE = new CommonFilterDescriptorManager();
    private static final CommonFilterDescriptor[] NO_FILTER_DESCRIPTORS = new CommonFilterDescriptor[0];
    private final Set filters = new HashSet();

    public static CommonFilterDescriptorManager getInstance() {
        return INSTANCE;
    }

    private CommonFilterDescriptorManager() {
        new CommonFilterDescriptorRegistry().readRegistry();
    }

    public CommonFilterDescriptor[] findVisibleFilters(INavigatorContentService contentService) {
        ArrayList<CommonFilterDescriptor> visibleFilters = new ArrayList<CommonFilterDescriptor>();
        for (CommonFilterDescriptor descriptor : this.filters) {
            if (!contentService.isVisible(descriptor.getId())) continue;
            visibleFilters.add(descriptor);
        }
        if (visibleFilters.size() == 0) {
            return NO_FILTER_DESCRIPTORS;
        }
        return visibleFilters.toArray(new CommonFilterDescriptor[visibleFilters.size()]);
    }

    private void addCommonFilter(CommonFilterDescriptor aDescriptor) {
        this.filters.add(aDescriptor);
    }

    private class CommonFilterDescriptorRegistry
    extends NavigatorContentRegistryReader {
        private CommonFilterDescriptorRegistry() {
        }

        protected boolean readElement(IConfigurationElement element) {
            if ("commonFilter".equals(element.getName())) {
                CommonFilterDescriptorManager.this.addCommonFilter(new CommonFilterDescriptor(element));
                return true;
            }
            return super.readElement(element);
        }
    }
}

