/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointContainer;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsView;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class BreakpointsDragAdapter
extends DragSourceAdapter
implements TransferDragSourceListener {
    private ISelectionProvider fProvider;
    private BreakpointsView fView;
    private BreakpointContainer[] fContainers;

    public BreakpointsDragAdapter(BreakpointsView view, ISelectionProvider provider) {
        Assert.isNotNull((Object)provider);
        this.fProvider = provider;
        this.fView = view;
    }

    public Transfer getTransfer() {
        return LocalSelectionTransfer.getInstance();
    }

    public void dragStart(DragSourceEvent event) {
        ISelection selection = this.fProvider.getSelection();
        LocalSelectionTransfer.getInstance().setSelection(selection);
        LocalSelectionTransfer.getInstance().setSelectionSetTime((long)event.time & 0xFFFFFFFFL);
        event.doit = this.isDragable(selection);
    }

    protected boolean isDragable(ISelection selection) {
        if (this.fView.canMove(selection)) {
            this.fContainers = this.fView.getMovedFromContainers(selection);
            return true;
        }
        return false;
    }

    public void dragSetData(DragSourceEvent event) {
        event.data = LocalSelectionTransfer.getInstance().getSelection();
    }

    public void dragFinished(DragSourceEvent event) {
        if (event.detail == 2) {
            this.fView.performRemove(this.fContainers, LocalSelectionTransfer.getInstance().getSelection());
        }
        LocalSelectionTransfer.getInstance().setSelection(null);
        LocalSelectionTransfer.getInstance().setSelectionSetTime(0L);
    }
}

