/*******************************************************************************
 * Copyright (c) 2000, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.sqleditor.internal.sql;

import org.eclipse.jface.text.formatter.IFormattingStrategy;

/**
 * This class provides the formatting strategy for SQL.  The simple strategy implemented
 * is to transforms SQL keywords to upper case.
 */
public class SQLUpperCaseFormattingStrategy implements IFormattingStrategy {

    /**
     * Informs the strategy about the start of a formatting process in which it will
     * participate.
     * 
     * @see org.eclipse.jface.text.formatter.IFormattingStrategy#formatterStarts(String)
     */
    public void formatterStarts( String initialIndentation ) {
    }

    /**
     * Formats the given string.  During the formatting process this strategy must update
     * the given character positions according to the changes applied to the given string.
     * 
     * @see org.eclipse.jface.text.formatter.IFormattingStrategy#format(String, boolean, String, int[])
     */
    public String format( String content, boolean isLineStart, String indentation, int[] positions ) {
        return allToUpper( content );
    }

    private String allToUpper( String content ) {
        String newContent = content.toUpperCase();
        return newContent;
    }
    
//    /**
//     * Converts SQL keywords contained in the given string to uppercase.
//     * 
//     * @param content the string to convert
//     * @return the converted string
//     */
//    private String keyWordsToUpper( String content ) {
//        StringTokenizer st = new StringTokenizer( content, " \n", true );
//        String token = "";
//        String newContent = "";
//        boolean done;
//        while (st.hasMoreTokens()) {
//            token = st.nextToken();
//            done = false;
//            Object[] allWords = SQLCodeScanner.getSQLAllWords();
//            for (int i = 0; i < allWords.length; i++) {
//                String[] sqlWords = (String[]) allWords[i];
//                for (int j = 0; j < sqlWords.length; j++) {
//                    if (token.equals(" ") || token.equals("\n"))
//                        break;
//                    if (token.toLowerCase().equals( sqlWords[ j ] )) {
//                        token = token.toUpperCase();
//                        done = true;
//                        break;
//                    }
//                }
//                if (done == true)
//                    break;
//            }
//            newContent = newContent + token;
//        }
//        return newContent;
//    } 
    
    /**
     * Informs the strategy that the formatting process in which it has participated
     * has been finished.
     * 
     * @see org.eclipse.jface.text.formatter.IFormattingStrategy#formatterStops()
     */
    public void formatterStops() {
    }

} // end class
