/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.core.internal.ui.explorer.helpers;

import java.text.MessageFormat; 

import org.eclipse.wst.rdb.core.internal.ui.util.resources.ResourceLoader;
import org.eclipse.wst.rdb.internal.models.sql.constraints.Index;

/**
 * @author ljulien
 */
public class IndexHelper
{
    public static final IndexHelper INSTANCE = new IndexHelper ();

    private static final String FORMAT = " [{0}]"; //$NON-NLS-1$
    private static final String BLANK = ""; //$NON-NLS-1$
    
    private static final ResourceLoader resource = ResourceLoader.getResourceLoader();
    private static final String UNIQUE = resource.queryString("DATATOOLS.CORE.UI.INDEX_UNIQUE.DECORATION"); //$NON-NLS-1$
 
    private IndexHelper () 
    {
    }
    
    public String getDecoration (Index index)
    {
        if (index.isUnique())
        {
            return MessageFormat.format(FORMAT, new String [] {UNIQUE});
        }
        return BLANK;
    }
}
