/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.core.internal.ui;
import java.net.URL;

import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * @author ljulien
 */
public class RDBCoreUIPlugin extends AbstractUIPlugin
{
	private static RDBCoreUIPlugin plugin;

	/**
	 * @param descriptor
	 */
    public RDBCoreUIPlugin()
    {
        super ();
        plugin = this;
    }
	/**
	 * @return The core.ui plugin
	 */
	public static RDBCoreUIPlugin getDefault() 
	{
		return plugin;
	}
	
	/**
	 * @return Will return the plugin ID
	 */
	public static String getPluginId ()
	{
		return getDefault().getBundle().getSymbolicName();
	}
	
	/**
	 * @return
	 */
	public static URL getInstallURL ()
	{
	   return getDefault().getBundle().getEntry("/");  //$NON-NLS-1$
	}
	
	/**
	 * 
	 */
	public void start(BundleContext ctx) throws Exception
	{
        try
        {
            super.start(ctx);
        }
        catch (Throwable e)
        {
        }
	}
	
	/**
	 * 
	 */
	public void stop(BundleContext ctx) throws Exception
	{
        try
        {
            super.stop(ctx);
        }
        catch (Throwable e)
        {
        }
	}

}
