/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.correction;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.sse.ui.internal.correction.IQuickAssistProcessor;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.correction.InsertRequiredAttrsQuickAssistProposal;
import org.eclipse.wst.xml.ui.internal.correction.RenameInFileQuickAssistProposal;
import org.eclipse.wst.xml.ui.internal.correction.SurroundWithNewElementQuickAssistProposal;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class QuickAssistProcessorXML
implements IQuickAssistProcessor {
    public boolean canAssist(StructuredTextViewer viewer, int offset) {
        return true;
    }

    protected void getInsertRequiredAttrs(ArrayList proposals, StructuredTextViewer viewer, int offset) {
        IDOMNode cursorNode;
        List requiredAttrs;
        IStructuredDocumentRegion startStructuredDocumentRegion;
        IDOMNode node = (IDOMNode)ContentAssistUtils.getNodeAt((StructuredTextViewer)viewer, (int)offset);
        if (node != null && node.getNodeType() == 1 && (startStructuredDocumentRegion = node.getStartStructuredDocumentRegion()) != null && startStructuredDocumentRegion.containsOffset(offset) && (requiredAttrs = this.getRequiredAttrs((Node)(cursorNode = (IDOMNode)ContentAssistUtils.getNodeAt((StructuredTextViewer)viewer, (int)offset)))).size() > 0) {
            NamedNodeMap currentAttrs = node.getAttributes();
            ArrayList insertAttrs = new ArrayList();
            if (currentAttrs.getLength() == 0) {
                insertAttrs.addAll(requiredAttrs);
            } else {
                int i = 0;
                while (i < requiredAttrs.size()) {
                    String requiredAttrName = ((CMAttributeDeclaration)requiredAttrs.get(i)).getAttrName();
                    boolean found = false;
                    int j = 0;
                    while (j < currentAttrs.getLength()) {
                        String currentAttrName = currentAttrs.item(j).getNodeName();
                        if (requiredAttrName.compareToIgnoreCase(currentAttrName) == 0) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        insertAttrs.add(requiredAttrs.get(i));
                    }
                    ++i;
                }
            }
            if (insertAttrs.size() > 0) {
                proposals.add(new InsertRequiredAttrsQuickAssistProposal(insertAttrs));
            }
        }
    }

    protected void getLocalRenameQuickAssistProposal(ArrayList proposals, StructuredTextViewer viewer, int offset) {
        IDOMNode node = (IDOMNode)ContentAssistUtils.getNodeAt((StructuredTextViewer)viewer, (int)offset);
        IStructuredDocumentRegion startStructuredDocumentRegion = node == null ? null : node.getStartStructuredDocumentRegion();
        IStructuredDocumentRegion endStructuredDocumentRegion = node == null ? null : node.getEndStructuredDocumentRegion();
        ITextRegion region = null;
        int regionTextEndOffset = 0;
        if (startStructuredDocumentRegion != null && startStructuredDocumentRegion.containsOffset(offset)) {
            region = startStructuredDocumentRegion.getRegionAtCharacterOffset(offset);
            regionTextEndOffset = startStructuredDocumentRegion.getTextEndOffset(region);
        } else if (endStructuredDocumentRegion != null && endStructuredDocumentRegion.containsOffset(offset)) {
            region = endStructuredDocumentRegion.getRegionAtCharacterOffset(offset);
            regionTextEndOffset = endStructuredDocumentRegion.getTextEndOffset(region);
        }
        if (region != null && (region.getType() == "XML_TAG_NAME" || region.getType() == "XML_TAG_ATTRIBUTE_NAME") && offset <= regionTextEndOffset) {
            proposals.add(new RenameInFileQuickAssistProposal());
        }
    }

    protected ModelQuery getModelQuery(Node node) {
        if (node.getNodeType() == 9) {
            return ModelQueryUtil.getModelQuery((Document)((Document)node));
        }
        return ModelQueryUtil.getModelQuery((Document)node.getOwnerDocument());
    }

    public ICompletionProposal[] getProposals(StructuredTextViewer viewer, int offset) throws CoreException {
        ArrayList proposals = new ArrayList();
        this.getLocalRenameQuickAssistProposal(proposals, viewer, offset);
        this.getSurroundWithNewElementQuickAssistProposal(proposals, viewer, offset);
        this.getInsertRequiredAttrs(proposals, viewer, offset);
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    protected List getRequiredAttrs(Node node) {
        CMElementDeclaration elementDecl;
        ArrayList<CMAttributeDeclaration> result = new ArrayList<CMAttributeDeclaration>();
        ModelQuery modelQuery = this.getModelQuery(node);
        if (modelQuery != null && (elementDecl = modelQuery.getCMElementDeclaration((Element)node)) != null) {
            CMNamedNodeMap attrMap = elementDecl.getAttributes();
            Iterator it = attrMap.iterator();
            CMAttributeDeclaration attr = null;
            while (it.hasNext()) {
                attr = (CMAttributeDeclaration)it.next();
                if (attr.getUsage() != 2) continue;
                result.add(attr);
            }
        }
        return result;
    }

    protected void getSurroundWithNewElementQuickAssistProposal(ArrayList proposals, StructuredTextViewer viewer, int offset) {
        IDOMNode node = (IDOMNode)ContentAssistUtils.getNodeAt((StructuredTextViewer)viewer, (int)offset);
        if (node != null) {
            proposals.add(new SurroundWithNewElementQuickAssistProposal());
        }
    }
}

