/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.derby.internal.ui.connection.dialogs;

import java.io.File;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.rdb.connection.internal.ui.factories.RSCCoreUIWidgetFactory;
import org.eclipse.wst.rdb.connection.internal.ui.providers.IServerConnectionInformation;
import org.eclipse.wst.rdb.connection.internal.ui.providers.IServerConnectionUIProvider;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.NewConnectionWizard;
import org.eclipse.wst.rdb.derby.internal.ui.util.ResourceLoader;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;

public class DerbyNewConnectionProvider
implements IServerConnectionUIProvider,
Listener {
    protected static final RSCCoreUIWidgetFactory factory = RSCCoreUIWidgetFactory.INSTANCE;
    protected static final ResourceLoader resource = ResourceLoader.INSTANCE;
    protected static final String CUI_NEWCW_DBLOCATION_LBL_UI_ = resource.queryString("CUI_NEWCW_DBLOCATION_LBL_UI_");
    protected static final String CUI_NEWCW_DBBROWSE_BTN_UI_ = resource.queryString("CUI_NEWCW_DBBROWSE_BTN_UI_");
    protected static final String CUI_NEWCW_CREATEDB_BTN_UI_ = resource.queryString("CUI_NEWCW_CREATEDB_BTN_UI_");
    protected static final String CUI_NEWCW_UPGRADEDB_BTN_UI_ = resource.queryString("CUI_NEWCW_UPGRADEDB_BTN_UI_");
    protected static final String CUI_NEWCW_JDBCDRIVERCLS_LBL_UI_ = resource.queryString("CUI_NEWCW_JDBCDRIVERCLS_LBL_UI_");
    protected static final String CUI_NEWCW_JDBCCLSLOCATION_LBL_UI_ = resource.queryString("CUI_NEWCW_JDBCCLSLOCATION_LBL_UI_");
    protected static final String CUI_NEWCW_JARBROWSE_BTN_UI_ = resource.queryString("CUI_NEWCW_JARBROWSE_BTN_UI_");
    protected static final String CUI_NEWCW_CONNECTIONURL_LBL_UI_ = resource.queryString("CUI_NEWCW_CONNECTIONURL_LBL_UI_");
    protected static final String CUI_NEWCW_DBLOCATION_CLOUDSCAPE_UI_ = resource.queryString("CUI_NEWCW_DBLOCATION_CLOUDSCAPE_UI_");
    protected static final String CUI_NEWCW_DEFDBNAME_VAL_UI_ = resource.queryString("CUI_NEWCW_DEFDBNAME_VAL_UI_");
    protected static final String CREATE_EQUALS_TRUE_TEXT = "create=true";
    protected static final String UPGRADE_EQUALS_TRUE_TEXT = "upgrade=true";
    protected static final String DRIVER_CLASS_NAME = "org.apache.derby.jdbc.EmbeddedDriver";
    protected Composite parentComposite;
    protected Label databaseLabel;
    protected Combo databaseCombo;
    protected Button browseDBLocation;
    protected Button createCheck;
    protected boolean displayUpgrade = false;
    protected Button upgradeCheck;
    protected Label driverLabel;
    protected Combo driverCombo;
    protected Text driverDisplay;
    protected Label locationLabel;
    protected Combo locationCombo;
    protected Button browseLocation;
    protected Label urlLabel;
    protected Text urlDisplay;
    protected WizardPage parentPage;
    protected IServerConnectionInformation connectionInformation;
    protected DatabaseDefinition definition;
    protected String databaseName;

    protected void refresh() {
        this.databaseName = null;
    }

    public boolean determinePageCompletion() {
        return this.validateControl();
    }

    protected void setConnectionInformation() {
        this.connectionInformation.setDriverClassName(DRIVER_CLASS_NAME);
        this.connectionInformation.setDatabaseName(this.databaseName);
        this.connectionInformation.setLoadingPath(this.locationCombo.getText());
        if (this.determinePageCompletion()) {
            this.connectionInformation.setInformationComplete(true);
        }
    }

    protected boolean validateControl() {
        if (this.databaseCombo.getText() == null || this.databaseCombo.getText().equals("")) {
            this.parentPage.setErrorMessage(NewConnectionWizard.getResourceString((String)"CUI_NEWCW_VALIDATE_DBLOCATION_REQ_UI_"));
            return false;
        }
        if (this.locationCombo != null && this.locationCombo.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(NewConnectionWizard.getResourceString((String)"CUI_NEWCW_VALIDATE_CLASSLOCATION_REQ_UI_"));
            return false;
        }
        return true;
    }

    protected void initialize() {
        this.driverDisplay.setText(DRIVER_CLASS_NAME);
        this.connectionInformation.setDriverClassName(DRIVER_CLASS_NAME);
        this.updateURL();
        this.addListeners();
        this.determinePageCompletion();
    }

    protected void updateURL() {
        String url = "jdbc:derby:" + this.databaseCombo.getText();
        url = String.valueOf(url) + (!this.createCheck.getSelection() ? "" : ";create=true");
        if (this.displayUpgrade) {
            url = String.valueOf(url) + (!this.upgradeCheck.getSelection() ? "" : ";upgrade=true");
        }
        this.urlDisplay.setText(url);
        this.connectionInformation.setURL(url);
    }

    protected String getDirectory(String message) {
        DirectoryDialog dialog = new DirectoryDialog(this.parentPage.getWizard().getContainer().getShell(), 4);
        dialog.setMessage(message);
        dialog.setFilterPath(this.databaseCombo.getText().trim());
        return dialog.open();
    }

    public void addListeners() {
        this.locationCombo.addListener(24, (Listener)this);
        this.browseLocation.addListener(13, (Listener)this);
        this.databaseCombo.addListener(24, (Listener)this);
        this.browseDBLocation.addListener(13, (Listener)this);
        this.createCheck.addListener(13, (Listener)this);
        if (this.displayUpgrade) {
            this.upgradeCheck.addListener(13, (Listener)this);
        }
        this.urlDisplay.addListener(13, (Listener)this);
    }

    protected void removeListeners() {
        this.locationCombo.removeListener(24, (Listener)this);
        this.browseLocation.removeListener(13, (Listener)this);
        this.databaseCombo.removeListener(24, (Listener)this);
        this.browseDBLocation.removeListener(13, (Listener)this);
        this.createCheck.removeListener(13, (Listener)this);
        if (this.displayUpgrade) {
            this.upgradeCheck.removeListener(13, (Listener)this);
        }
        this.urlDisplay.removeListener(13, (Listener)this);
    }

    public Composite getServerConnectionUI(Composite parent) {
        if (this.parentComposite == null || this.parentComposite.isDisposed()) {
            this.refresh();
            this.parentComposite = this.createServerConnectionUI(parent);
        }
        return this.parentComposite;
    }

    protected Composite createServerConnectionUI(Composite parent) {
        this.parentComposite = factory.createComposite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        this.parentComposite.setLayout((Layout)layout);
        this.databaseLabel = factory.createLabel(this.parentComposite, 0);
        this.databaseLabel.setText(CUI_NEWCW_DBLOCATION_LBL_UI_);
        this.databaseCombo = factory.createCombo(this.parentComposite, 2052);
        GridData gd = new GridData(768);
        this.databaseCombo.setLayoutData((Object)gd);
        this.browseDBLocation = factory.createButton(this.parentComposite, 8);
        this.browseDBLocation.setText(CUI_NEWCW_DBBROWSE_BTN_UI_);
        this.createCheck = factory.createButton(this.parentComposite, 32);
        this.createCheck.setText(CUI_NEWCW_CREATEDB_BTN_UI_);
        this.createCheck.setSelection(true);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.createCheck.setLayoutData((Object)gd);
        if (this.displayUpgrade) {
            this.upgradeCheck = factory.createButton(this.parentComposite, 32);
            this.upgradeCheck.setText(CUI_NEWCW_UPGRADEDB_BTN_UI_);
            this.upgradeCheck.setSelection(false);
            gd = new GridData();
            gd.horizontalSpan = 3;
            this.upgradeCheck.setLayoutData((Object)gd);
        }
        this.driverLabel = factory.createLabel(this.parentComposite, 0);
        this.driverLabel.setText(CUI_NEWCW_JDBCDRIVERCLS_LBL_UI_);
        this.driverDisplay = factory.createText(this.parentComposite, 2060);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.driverDisplay.setLayoutData((Object)gd);
        this.locationLabel = factory.createLabel(this.parentComposite, 0);
        this.locationLabel.setText(CUI_NEWCW_JDBCCLSLOCATION_LBL_UI_);
        this.locationCombo = factory.createCombo(this.parentComposite, 2052);
        gd = new GridData(256);
        this.locationCombo.setLayoutData((Object)gd);
        this.browseLocation = factory.createButton(this.parentComposite, 8);
        this.browseLocation.setText(CUI_NEWCW_JARBROWSE_BTN_UI_);
        this.urlLabel = factory.createLabel(this.parentComposite, 0);
        this.urlLabel.setText(CUI_NEWCW_CONNECTIONURL_LBL_UI_);
        this.urlDisplay = factory.createText(this.parentComposite, 2060);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.urlDisplay.setLayoutData((Object)gd);
        this.initialize();
        return this.parentComposite;
    }

    public void setServerConnectionInformation(IServerConnectionInformation connectionInformation) {
        this.connectionInformation = connectionInformation;
    }

    public void setWizardPage(WizardPage parentPage) {
        this.parentPage = parentPage;
    }

    public void setDatabaseDefinition(DatabaseDefinition definition) {
        this.definition = definition;
    }

    protected void updateDatabaseName() {
        if (this.databaseCombo.getText() != null && !this.databaseCombo.getText().equals("")) {
            this.databaseName = this.databaseCombo.getText().substring(this.databaseCombo.getText().lastIndexOf(File.separator) + 1);
        }
    }

    public void handleEvent(Event event) {
        String file;
        Widget source = event.widget;
        if (source == this.databaseCombo || source == this.createCheck || source == this.upgradeCheck) {
            this.updateDatabaseName();
            this.updateURL();
        } else if (source == this.browseDBLocation) {
            String directory = this.getDirectory(CUI_NEWCW_DBLOCATION_CLOUDSCAPE_UI_);
            if (directory != null && directory.length() > 0) {
                this.databaseCombo.setText(directory);
                this.databaseName = directory.substring(directory.lastIndexOf(File.separator) + 1);
            }
        } else if (source != this.locationCombo && source == this.browseLocation && (file = NewConnectionWizard.getFile((Wizard)((Wizard)this.parentPage.getWizard()), (String[])NewConnectionWizard.fExtensions)) != null && file.length() > 0) {
            this.locationCombo.removeListener(24, (Listener)this);
            this.locationCombo.setText(file);
            this.locationCombo.addListener(24, (Listener)this);
            this.connectionInformation.setLoadingPath(file);
        }
        this.setConnectionInformation();
    }

    public void loadProperties() {
        this.removeListeners();
        GenericJDBCURL url = new GenericJDBCURL(this.connectionInformation.getURL());
        this.locationCombo.setText(this.connectionInformation.getLoadingPath());
        this.databaseCombo.setText(url.getNode());
        this.updateDatabaseName();
        if (url.getProperties().indexOf(CREATE_EQUALS_TRUE_TEXT) <= -1) {
            this.createCheck.setSelection(false);
        }
        if (this.displayUpgrade && url.getProperties().indexOf(CREATE_EQUALS_TRUE_TEXT) > -1) {
            this.upgradeCheck.setSelection(true);
        }
        this.updateURL();
        this.addListeners();
        this.setConnectionInformation();
    }

    protected class GenericJDBCURL {
        protected String subprotocol = "";
        protected String node = "";
        protected String properties = "";

        public GenericJDBCURL(String url) {
            this.parseURL(url);
        }

        public String getNode() {
            return this.node;
        }

        public String getSubprotocol() {
            return this.subprotocol;
        }

        protected void parseURL(String url) {
            try {
                String remainingURL = url.substring(url.indexOf(58) + 1);
                this.subprotocol = remainingURL.substring(0, remainingURL.indexOf(58));
                remainingURL = remainingURL.substring(remainingURL.indexOf(58) + 1);
                if (remainingURL.indexOf(59) > -1) {
                    this.node = remainingURL.substring(0, remainingURL.indexOf(59));
                    this.properties = remainingURL = remainingURL.substring(remainingURL.indexOf(59) + 1);
                } else {
                    this.node = remainingURL;
                }
            }
            catch (Exception exception) {}
        }

        public String getProperties() {
            return this.properties;
        }
    }
}

