/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.javascript.ui.internal.common;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wst.javascript.ui.internal.editor.JSEditorPlugin;
import org.eclipse.wst.sse.ui.internal.preferences.ui.ColorHelper;
import org.eclipse.wst.sse.ui.internal.util.EditorUtility;

public class JavaScriptColorPreferences {
    private static final Color defaultForeground = null;
    private static final Color defaultBackground = null;
    public static TextAttribute taDefault;
    public static TextAttribute taKeyword;
    public static TextAttribute taComment;
    public static TextAttribute taStringLit;
    public static TextAttribute taUnfComment;
    private PropertyChangeListener fPreferenceListener = new PropertyChangeListener();
    private static final JavaScriptColorPreferences global;

    static {
        global = new JavaScriptColorPreferences();
    }

    private JavaScriptColorPreferences() {
        IPreferenceStore pref = this.getColorPreferences();
        if (pref != null) {
            pref.addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        }
        this.loadColors();
    }

    protected TextAttribute createTextAttribute(String colorKey) {
        TextAttribute ta = null;
        String prefString = this.getColorPreferences().getString(colorKey);
        String[] stylePrefs = ColorHelper.unpackStylePreferences((String)prefString);
        if (stylePrefs != null) {
            RGB foreground = ColorHelper.toRGB((String)stylePrefs[0]);
            RGB background = ColorHelper.toRGB((String)stylePrefs[1]);
            boolean bold = Boolean.valueOf(stylePrefs[2]);
            ta = JavaScriptColorPreferences.createTextAttribute(foreground, background, bold);
        }
        return ta;
    }

    protected void loadColors() {
        JavaScriptColorPreferences.clearColors();
        TextAttribute ta = this.createTextAttribute("DEFAULT");
        if (ta != null) {
            taDefault = ta;
        }
        if ((ta = this.createTextAttribute("KEYWORD")) != null) {
            taKeyword = ta;
        }
        if ((ta = this.createTextAttribute("LITERAL")) != null) {
            taStringLit = ta;
        }
        if ((ta = this.createTextAttribute("COMMENT")) != null) {
            taComment = ta;
        }
        if ((ta = this.createTextAttribute("UNFINISHED_COMMENT")) != null) {
            taUnfComment = ta;
        }
    }

    protected static void clearColors() {
        taComment = taUnfComment = JavaScriptColorPreferences.createTextAttribute(null, null, false);
        taStringLit = taUnfComment;
        taKeyword = taUnfComment;
        taDefault = taUnfComment;
    }

    protected static TextAttribute createTextAttribute(RGB foreground, RGB background, boolean bold) {
        return new TextAttribute(foreground != null ? EditorUtility.getColor((RGB)foreground) : defaultForeground, background != null ? EditorUtility.getColor((RGB)background) : defaultBackground, bold ? 1 : 0);
    }

    public static void addPropertyChangeListener(IPropertyChangeListener pcl) {
        global.getColorPreferences().addPropertyChangeListener(pcl);
    }

    public static void removePropertyChangeListener(IPropertyChangeListener pcl) {
        global.getColorPreferences().removePropertyChangeListener(pcl);
    }

    protected IPreferenceStore getColorPreferences() {
        return JSEditorPlugin.getDefault().getPreferenceStore();
    }

    protected void handlePropertyChange(PropertyChangeEvent event) {
        if (event != null) {
            String prefKey = event.getProperty();
            if ("DEFAULT".equals(prefKey)) {
                taDefault = this.createTextAttribute("DEFAULT");
            } else if ("KEYWORD".equals(prefKey)) {
                taKeyword = this.createTextAttribute("KEYWORD");
            } else if ("LITERAL".equals(prefKey)) {
                taStringLit = this.createTextAttribute("LITERAL");
            } else if ("COMMENT".equals(prefKey)) {
                taComment = this.createTextAttribute("COMMENT");
            } else if ("UNFINISHED_COMMENT".equals(prefKey)) {
                taUnfComment = this.createTextAttribute("UNFINISHED_COMMENT");
            }
        }
    }

    public static boolean isJavaScriptColorPreference(String prefKey) {
        boolean isPreference = false;
        if ("DEFAULT".equals(prefKey) || "KEYWORD".equals(prefKey) || "LITERAL".equals(prefKey) || "COMMENT".equals(prefKey) || "UNFINISHED_COMMENT".equals(prefKey)) {
            isPreference = true;
        }
        return isPreference;
    }

    private class PropertyChangeListener
    implements IPropertyChangeListener {
        private PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            JavaScriptColorPreferences.this.handlePropertyChange(event);
        }
    }
}

