/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.provisional.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.provisional.registry.AdapterFactoryProvider;
import org.eclipse.wst.sse.ui.internal.provisional.registry.AdapterFactoryRegistry;
import org.eclipse.wst.sse.ui.internal.provisional.registry.AdapterFactoryRegistryExtension;
import org.eclipse.wst.sse.ui.internal.provisional.registry.AdapterFactoryRegistryReader;

public class AdapterFactoryRegistryImpl
implements AdapterFactoryRegistry,
AdapterFactoryRegistryExtension {
    protected static final String ATT_CLASS = "class";
    private static AdapterFactoryRegistry instance = null;
    private HashMap adapterProviders = null;
    private boolean DEBUG = false;
    private HashMap hashMap = new HashMap();
    private HashSet unassociatedProviders = new HashSet();

    public static synchronized AdapterFactoryRegistry getInstance() {
        if (instance == null) {
            instance = new AdapterFactoryRegistryImpl();
        }
        return instance;
    }

    private AdapterFactoryRegistryImpl() {
        this.adapterProviders = new HashMap();
        AdapterFactoryRegistryReader.readRegistry(this.hashMap);
    }

    void add(AdapterFactoryProvider adapterFactoryProvider) {
        this.unassociatedProviders.add(adapterFactoryProvider);
    }

    public Iterator getAdapterFactories() {
        if (this.DEBUG) {
            System.out.println("====================================================================================");
            System.out.println("GETTING ALL ADAPTER FACTORIES");
        }
        ArrayList results = new ArrayList();
        results.addAll(this.unassociatedProviders);
        Iterator it = this.hashMap.keySet().iterator();
        String contentTypeId = null;
        while (it.hasNext()) {
            contentTypeId = (String)it.next();
            if (this.DEBUG) {
                System.out.println(" + for: " + contentTypeId);
            }
            results.addAll(this.getAdapterFactoriesAsList(contentTypeId));
        }
        if (this.DEBUG) {
            System.out.println("====================================================================================");
        }
        return results.iterator();
    }

    public Iterator getAdapterFactories(String contentTypeID) {
        if (this.DEBUG) {
            System.out.println("====================================================================================");
            System.out.println("GETTING ADAPTER FACTORIES for: " + contentTypeID);
        }
        ArrayList results = new ArrayList();
        results.addAll(this.unassociatedProviders);
        results.addAll(this.getAdapterFactoriesAsList("unknown"));
        results.addAll(this.getAdapterFactoriesAsList(Platform.getContentTypeManager().getContentType(contentTypeID)));
        if (this.DEBUG) {
            System.out.println("====================================================================================");
        }
        return results.iterator();
    }

    public List getAdapterFactoriesAsList(IContentType contentType) {
        IContentType type = contentType;
        ArrayList results = new ArrayList();
        while (type != null && !type.getId().equals("org.eclipse.core.runtime.text")) {
            results.addAll(this.getAdapterFactoriesAsList(type.getId()));
            type = type.getBaseType();
        }
        return results;
    }

    public List getAdapterFactoriesAsList(String contentTypeID) {
        ArrayList<Object> results = new ArrayList<Object>();
        Object o = this.hashMap.get(contentTypeID);
        if (o != null) {
            Map element2Provider = (Map)o;
            Iterator it = element2Provider.keySet().iterator();
            IConfigurationElement element = null;
            String classname = null;
            Object existing = null;
            AdapterFactoryProvider p = null;
            while (it.hasNext()) {
                element = (IConfigurationElement)it.next();
                o = element2Provider.get(element);
                if (o != null) {
                    if (this.DEBUG) {
                        System.out.println("already created: " + element.getAttribute(ATT_CLASS));
                    }
                    results.add(o);
                    continue;
                }
                try {
                    classname = element.getAttribute(ATT_CLASS);
                    if (this.DEBUG) {
                        System.out.println("about to create: " + classname);
                    }
                    if ((existing = this.adapterProviders.get(classname)) == null) {
                        p = (AdapterFactoryProvider)element.createExecutableExtension(ATT_CLASS);
                        this.adapterProviders.put(classname, p);
                    } else {
                        p = existing;
                    }
                    element2Provider.put(element, p);
                    results.add(p);
                }
                catch (CoreException e) {
                    Logger.logException(e);
                }
            }
        }
        return results;
    }
}

