/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.document;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.eclipse.wst.css.core.internal.document.CSSModelUtil;
import org.eclipse.wst.css.core.internal.document.CSSNodeImpl;
import org.eclipse.wst.css.core.internal.document.CSSNodeListImpl;
import org.eclipse.wst.css.core.internal.document.CSSStructuredDocumentRegionContainer;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.util.CSSUtil;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegionList;

class CSSModelDeletionContext {
    private int fOldStart = -1;
    private int fOldLength = 0;
    private int fNewStart = -1;
    private int fNewLength = 0;
    private int fLengthDifference = 0;
    private IStructuredDocumentRegionList fOldStructuredDocumentRegions = null;
    private int fRemovedRangeBegin = -1;
    private int fRemovedRangeEnd = -1;
    private CSSNodeListImpl fNodesToBeRemoved = new CSSNodeListImpl();

    CSSModelDeletionContext(ICSSNode rootNode) {
    }

    boolean addNodeToBeRemoved(ICSSNode node) {
        int nNodes = this.fNodesToBeRemoved.getLength();
        int i = 0;
        while (i < nNodes) {
            ICSSNode parent = this.fNodesToBeRemoved.item(i);
            if (CSSModelUtil.isParentOf(parent, node)) {
                return false;
            }
            ++i;
        }
        this.fNodesToBeRemoved.appendNode(node);
        return true;
    }

    void expandRemovedRangeBegin(IStructuredDocumentRegion flatNode) {
        if (flatNode == null) {
            return;
        }
        int newBegin = flatNode.getStart();
        if (this.fRemovedRangeBegin < 0 || newBegin < this.fRemovedRangeBegin) {
            this.fRemovedRangeBegin = newBegin;
        }
    }

    void expandRemovedRangeEnd(IStructuredDocumentRegion flatNode) {
        if (flatNode == null) {
            return;
        }
        int newEnd = flatNode.getEnd() + (this.isOldNode(flatNode) ? this.fLengthDifference : 0);
        if (this.fRemovedRangeEnd < 0 || this.fRemovedRangeEnd < newEnd) {
            this.fRemovedRangeEnd = newEnd;
        }
    }

    private CSSStructuredDocumentRegionContainer findContainer(CSSNodeImpl parent, IStructuredDocumentRegion flatNode) {
        if (parent instanceof CSSStructuredDocumentRegionContainer) {
            IStructuredDocumentRegion firstNode = ((CSSStructuredDocumentRegionContainer)parent).getFirstStructuredDocumentRegion();
            IStructuredDocumentRegion lastNode = ((CSSStructuredDocumentRegionContainer)parent).getLastStructuredDocumentRegion();
            int firstStart = this.getOriginalOffset(firstNode);
            int lastStart = this.getOriginalOffset(lastNode);
            int start = flatNode.getStart();
            if (firstStart <= start && start <= lastStart) {
                ICSSNode node = parent.getFirstChild();
                while (node != null) {
                    CSSStructuredDocumentRegionContainer container;
                    if (node instanceof CSSNodeImpl && (container = this.findContainer((CSSNodeImpl)node, flatNode)) != null) {
                        return container;
                    }
                    node = node.getNextSibling();
                }
                return (CSSStructuredDocumentRegionContainer)parent;
            }
        }
        return null;
    }

    CSSStructuredDocumentRegionContainer findDeletionTarget(CSSNodeImpl parent, IStructuredDocumentRegion flatNode) {
        CSSStructuredDocumentRegionContainer target = this.findContainer(parent, flatNode);
        if (target == null) {
            return null;
        }
        ICSSNode child = target.getFirstChild();
        while (child != null && !(child instanceof CSSStructuredDocumentRegionContainer)) {
            child = child.getNextSibling();
        }
        if (child == null) {
            return target;
        }
        IStructuredDocumentRegion firstNode = ((CSSStructuredDocumentRegionContainer)child).getFirstStructuredDocumentRegion();
        if (flatNode.getStart() < this.getOriginalOffset(firstNode)) {
            return target;
        }
        child = target.getLastChild();
        while (child != null && !(child instanceof CSSStructuredDocumentRegionContainer)) {
            child = child.getPreviousSibling();
        }
        if (child == null) {
            return target;
        }
        firstNode = ((CSSStructuredDocumentRegionContainer)child).getFirstStructuredDocumentRegion();
        if (this.getOriginalOffset(firstNode) < flatNode.getStart()) {
            return target;
        }
        return null;
    }

    Iterator getNodesToBeRemoved() {
        ArrayList<ICSSNode> nodes = new ArrayList<ICSSNode>();
        int nNodes = this.fNodesToBeRemoved.getLength();
        int i = 0;
        while (i < nNodes) {
            nodes.add(this.fNodesToBeRemoved.item(i));
            ++i;
        }
        return nodes.iterator();
    }

    private int getOriginalOffset(IStructuredDocumentRegion flatNode) {
        int offset = 0;
        if (flatNode != null) {
            offset = flatNode.getStart();
            if (this.fLengthDifference >= 0) {
                if (this.fNewStart + this.fNewLength < offset) {
                    offset -= this.fLengthDifference;
                }
            } else if (this.fOldStart + this.fOldLength <= offset || this.fNewStart < 0 && this.fOldStart <= offset && !this.isOldNode(flatNode) || this.fNewStart >= 0 && this.fNewStart + this.fNewLength <= offset && !this.isOldNode(flatNode)) {
                offset -= this.fLengthDifference;
            }
        }
        return offset;
    }

    int getRemovedRangeBegin() {
        return this.fRemovedRangeBegin;
    }

    int getRemovedRangeEnd() {
        return this.fRemovedRangeEnd;
    }

    private boolean isOldNode(IStructuredDocumentRegion flatNode) {
        if (this.fOldStructuredDocumentRegions != null) {
            Enumeration e = this.fOldStructuredDocumentRegions.elements();
            while (e.hasMoreElements()) {
                if (e.nextElement() != flatNode) continue;
                return true;
            }
        }
        return false;
    }

    void setupContext(IStructuredDocumentRegionList newStructuredDocumentRegions, IStructuredDocumentRegionList oldStructuredDocumentRegions) {
        IStructuredDocumentRegion flatNode = null;
        this.fOldLength = CSSUtil.getTextLength(oldStructuredDocumentRegions);
        this.fOldStart = oldStructuredDocumentRegions != null && oldStructuredDocumentRegions.getLength() > 0 && (flatNode = oldStructuredDocumentRegions.item(0)) != null ? flatNode.getStart() : -1;
        this.fNewLength = CSSUtil.getTextLength(newStructuredDocumentRegions);
        if (newStructuredDocumentRegions != null && newStructuredDocumentRegions.getLength() > 0 && (flatNode = newStructuredDocumentRegions.item(0)) != null) {
            this.fRemovedRangeBegin = this.fNewStart = flatNode.getStart();
            this.fRemovedRangeEnd = this.fNewStart + this.fNewLength;
        } else {
            this.fNewStart = -1;
            this.fRemovedRangeEnd = -1;
            this.fRemovedRangeBegin = -1;
        }
        this.fLengthDifference = this.fNewLength - this.fOldLength;
        this.fOldStructuredDocumentRegions = oldStructuredDocumentRegions;
        while (this.fNodesToBeRemoved.getLength() > 0) {
            this.fNodesToBeRemoved.removeNode(0);
        }
    }
}

