/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.EditorManager;

public class CommonEditorUtility {
    public static final Class IRESOURCE_CLASS;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IRESOURCE_CLASS = clazz;
    }

    private CommonEditorUtility() {
    }

    public static IEditorPart[] getDirtyEditors() {
        return CommonEditorUtility.getDirtyEditors(null);
    }

    public static IEditorPart[] getDirtyEditors(List projects) {
        HashSet<IEditorInput> inputs = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = J2EEUIPlugin.getPluginWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorPart[] editors = pages[x].getDirtyEditors();
                int z = 0;
                while (z < editors.length) {
                    IEditorPart ep = editors[z];
                    IEditorInput input = ep.getEditorInput();
                    if (!inputs.contains(input) && (projects == null || CommonEditorUtility.inputInProjects(input, projects))) {
                        inputs.add(input);
                        result.add(ep);
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result.toArray(new IEditorPart[result.size()]);
    }

    public static boolean inputInProjects(IEditorInput input, List projects) {
        IProject project;
        IResource res = (IResource)input.getAdapter(IRESOURCE_CLASS);
        IProject iProject = project = res == null ? null : res.getProject();
        if (project == null) {
            return false;
        }
        int i = 0;
        while (i < projects.size()) {
            if (project.equals(projects.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean promptToSaveAllDirtyEditors() {
        return CommonEditorUtility.promptToSaveDirtyEditors(Arrays.asList(CommonEditorUtility.getDirtyEditors()));
    }

    public static boolean promptToSaveDirtyEditors(List dirtyEditors) {
        if (dirtyEditors.isEmpty()) {
            return true;
        }
        return EditorManager.saveAll((List)dirtyEditors, (boolean)true, (boolean)true, (boolean)false, (IWorkbenchWindow)J2EEUIPlugin.getActiveWorkbenchWindow());
    }

    public static boolean promptToSaveDirtyEditorsInProjects(List projects) {
        return CommonEditorUtility.promptToSaveDirtyEditors(Arrays.asList(CommonEditorUtility.getDirtyEditors(projects)));
    }
}

