/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.subscriber;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizeModelAction;
import org.eclipse.team.ui.synchronize.SynchronizeModelOperation;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.commands.GetStatusCommand;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.subscriber.OverrideAndUpdateSynchronizeOperation;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.utils.SVNStatusUtils;

public class OverrideAndUpdateSynchronizeAction
extends SynchronizeModelAction {
    public OverrideAndUpdateSynchronizeAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    protected FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter(){

            public boolean select(SyncInfo info) {
                FastSyncInfoFilter.SyncInfoDirectionFilter filter = new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{4, 12});
                if (!filter.select(info)) {
                    return false;
                }
                IStructuredSelection selection = OverrideAndUpdateSynchronizeAction.this.getStructuredSelection();
                boolean removeUnAdded = SVNUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_remove_unadded_resources_on_replace");
                Iterator iter = selection.iterator();
                while (iter.hasNext()) {
                    ISVNLocalResource svnResource;
                    block6: {
                        ISynchronizeModelElement element = (ISynchronizeModelElement)iter.next();
                        IResource resource = element.getResource();
                        if (resource == null || !resource.exists()) {
                            return false;
                        }
                        svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
                        try {
                            if (!svnResource.isAdded()) break block6;
                            return false;
                        }
                        catch (SVNException sVNException) {
                            return false;
                        }
                    }
                    if (removeUnAdded || svnResource.isManaged()) continue;
                    return false;
                }
                return true;
            }
        };
    }

    protected SynchronizeModelOperation getSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        IStructuredSelection selection = this.getStructuredSelection();
        ArrayList<IResource> selectedElements = new ArrayList<IResource>();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            ISynchronizeModelElement synchronizeModelElement = (ISynchronizeModelElement)iter.next();
            IResource resource = synchronizeModelElement.getResource();
            selectedElements.add(resource);
        }
        IResource[] resources = new IResource[selectedElements.size()];
        selectedElements.toArray(resources);
        IResource[] modifiedResources = null;
        try {
            modifiedResources = this.getModifiedResources(resources, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (SVNException sVNException) {}
        return new OverrideAndUpdateSynchronizeOperation(configuration, elements, modifiedResources, resources);
    }

    private IResource[] getModifiedResources(IResource[] resources, IProgressMonitor iProgressMonitor) throws SVNException {
        ArrayList<IResource> modified = new ArrayList<IResource>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
            GetStatusCommand command = new GetStatusCommand(svnResource, true, false);
            command.run(iProgressMonitor);
            ISVNStatus[] statuses = command.getStatuses();
            int j = 0;
            while (j < statuses.length) {
                IResource currentResource;
                if ((SVNStatusUtils.isReadyForRevert((ISVNStatus)statuses[j]) || !SVNStatusUtils.isManaged((ISVNStatus)statuses[j])) && (currentResource = SVNWorkspaceRoot.getResourceFor((ISVNStatus)statuses[j])) != null) {
                    modified.add(currentResource);
                }
                ++j;
            }
            ++i;
        }
        return modified.toArray(new IResource[modified.size()]);
    }
}

