/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.dialogs;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.dialogs.DateSelectionDialog;

public class HistorySearchDialog
extends TrayDialog {
    private ISVNRemoteResource remoteResource;
    private final int SELECTED_RESOURCE_WIDTH_HINT = 300;
    private Text selectedResourceText;
    private Text userText;
    private Combo commentCombo;
    private Text startDateText;
    private Text endDateText;
    private Button regExpButton;
    private Button searchAllButton;
    private Button fetchButton;
    private String user;
    private String comment;
    private Date startDate;
    private Date endDate;
    private boolean searchAll = true;
    private boolean regExp;
    private boolean autoFetchLogs;
    private List previousComments;

    public HistorySearchDialog(Shell shell, ISVNRemoteResource remoteResource) {
        super(shell);
        this.remoteResource = remoteResource;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Policy.bind("HistorySearchDialog.title"));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.search_history_dialog_context");
        Composite top = new Composite(composite, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        top.setLayout((Layout)topLayout);
        top.setLayoutData((Object)new GridData(1808));
        Label resourceLabel = new Label(top, 0);
        resourceLabel.setText(Policy.bind("HistorySearchDialog.resource"));
        this.selectedResourceText = new Text(top, 2048);
        this.selectedResourceText.setText(this.remoteResource.getUrl().toString());
        this.selectedResourceText.setEditable(false);
        GridData gdSelectedResourceText = new GridData(768);
        gdSelectedResourceText.widthHint = 300;
        this.selectedResourceText.setLayoutData((Object)gdSelectedResourceText);
        this.regExpButton = new Button(top, 32);
        this.regExpButton.setText(Policy.bind("HistorySearchDialog.regExp"));
        GridData gdRegExpButton = new GridData(768);
        gdRegExpButton.horizontalSpan = 2;
        this.regExpButton.setLayoutData((Object)gdRegExpButton);
        this.regExpButton.setSelection(this.regExp);
        Group search = new Group(composite, 0);
        search.setText(Policy.bind("HistorySearchDialog.searchTitle"));
        GridLayout searchLayout = new GridLayout();
        searchLayout.numColumns = 2;
        search.setLayout((Layout)searchLayout);
        search.setLayoutData((Object)new GridData(768));
        Label userLabel = new Label((Composite)search, 0);
        userLabel.setText(Policy.bind("HistorySearchDialog.user"));
        this.userText = new Text((Composite)search, 2048);
        this.userText.setLayoutData((Object)new GridData(768));
        if (this.user != null) {
            this.userText.setText(this.user);
        }
        Label commentLabel = new Label((Composite)search, 0);
        commentLabel.setText(Policy.bind("HistorySearchDialog.comment"));
        this.commentCombo = new Combo((Composite)search, 4);
        this.commentCombo.setLayoutData((Object)new GridData(768));
        this.fillCommentCombo(this.commentCombo);
        this.fetchButton = new Button((Composite)search, 32);
        GridData gdFetchButton = new GridData(768);
        gdFetchButton.horizontalSpan = 2;
        this.fetchButton.setLayoutData((Object)gdFetchButton);
        this.fetchButton.setText(Policy.bind("HistorySearchDialog.fetchLogIfNeeded"));
        this.fetchButton.setSelection(this.autoFetchLogs);
        this.searchAllButton = new Button((Composite)search, 32);
        GridData gdSearchAllButton = new GridData(768);
        gdSearchAllButton.horizontalSpan = 2;
        this.searchAllButton.setLayoutData((Object)gdSearchAllButton);
        this.searchAllButton.setText(Policy.bind("HistorySearchDialog.searchAllLogs"));
        this.searchAllButton.setSelection(this.searchAll);
        final Label dateLabel = new Label((Composite)search, 0);
        dateLabel.setText(Policy.bind("HistorySearchDialog.date"));
        dateLabel.setEnabled(!this.searchAll);
        Composite dateComp = new Composite((Composite)search, 0);
        GridLayout dateCompLayout = new GridLayout();
        dateCompLayout.numColumns = 5;
        dateCompLayout.marginHeight = 0;
        dateCompLayout.marginWidth = 0;
        dateComp.setLayout((Layout)dateCompLayout);
        dateComp.setLayoutData((Object)new GridData(768));
        this.startDateText = new Text(dateComp, 2048);
        this.startDateText.setLayoutData((Object)new GridData(768));
        if (this.startDate == null) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(2, -1);
            this.startDate = calendar.getTime();
        }
        this.startDateText.setText(this.formatDate(this.startDate));
        this.startDateText.setData((Object)this.startDate);
        this.startDateText.setEnabled(!this.searchAll);
        final Button selectStartDateButton = new Button(dateComp, 0);
        selectStartDateButton.setText(Policy.bind("HistorySearchDialog.startDateButton"));
        selectStartDateButton.setEnabled(!this.searchAll);
        final Label midDataLabel = new Label(dateComp, 0);
        midDataLabel.setText(Policy.bind("HistorySearchDialog.midDate"));
        midDataLabel.setEnabled(!this.searchAll);
        this.endDateText = new Text(dateComp, 2048);
        this.endDateText.setLayoutData((Object)new GridData(768));
        if (this.endDate == null) {
            this.endDate = Calendar.getInstance().getTime();
        }
        this.endDateText.setText(this.formatDate(this.endDate));
        this.endDateText.setData((Object)this.endDate);
        this.endDateText.setEnabled(!this.searchAll);
        final Button selectEndDateButton = new Button(dateComp, 0);
        selectEndDateButton.setText(Policy.bind("HistorySearchDialog.endDateButton"));
        selectEndDateButton.setEnabled(!this.searchAll);
        this.searchAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (HistorySearchDialog.this.searchAllButton.getSelection()) {
                    dateLabel.setEnabled(false);
                    midDataLabel.setEnabled(false);
                    selectStartDateButton.setEnabled(false);
                    selectEndDateButton.setEnabled(false);
                    HistorySearchDialog.this.startDateText.setEnabled(false);
                    HistorySearchDialog.this.endDateText.setEnabled(false);
                } else {
                    dateLabel.setEnabled(true);
                    midDataLabel.setEnabled(true);
                    selectStartDateButton.setEnabled(true);
                    selectEndDateButton.setEnabled(true);
                    HistorySearchDialog.this.startDateText.setEnabled(true);
                    HistorySearchDialog.this.endDateText.setEnabled(true);
                }
            }
        });
        selectStartDateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (HistorySearchDialog.this.parseDate(HistorySearchDialog.this.startDateText.getText()) == null) {
                    return;
                }
                DateSelectionDialog dsd = new DateSelectionDialog(HistorySearchDialog.this.getShell(), HistorySearchDialog.this.startDateText.getText());
                if (dsd.open() == 0) {
                    Date startDate = dsd.getDate();
                    HistorySearchDialog.this.startDateText.setText(HistorySearchDialog.this.formatDate(startDate));
                    HistorySearchDialog.this.startDateText.setData((Object)startDate);
                    Date endDate = (Date)HistorySearchDialog.this.endDateText.getData();
                    if (!startDate.before(endDate)) {
                        HistorySearchDialog.this.endDateText.setText(HistorySearchDialog.this.formatDate(startDate));
                        HistorySearchDialog.this.endDateText.setData((Object)startDate);
                    }
                }
            }
        });
        selectEndDateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (HistorySearchDialog.this.parseDate(HistorySearchDialog.this.endDateText.getText()) == null) {
                    return;
                }
                DateSelectionDialog dsd = new DateSelectionDialog(HistorySearchDialog.this.getShell(), HistorySearchDialog.this.endDateText.getText());
                if (dsd.open() == 0) {
                    Date endDate = dsd.getDate();
                    HistorySearchDialog.this.endDateText.setText(HistorySearchDialog.this.formatDate(endDate));
                    HistorySearchDialog.this.endDateText.setData((Object)endDate);
                    Date startDate = (Date)HistorySearchDialog.this.startDateText.getData();
                    if (!endDate.after(startDate)) {
                        HistorySearchDialog.this.startDateText.setText(HistorySearchDialog.this.formatDate(endDate));
                        HistorySearchDialog.this.startDateText.setData((Object)endDate);
                    }
                }
            }
        });
        this.userText.setFocus();
        this.userText.setSelection(0, this.userText.getText().length());
        return composite;
    }

    public void setRemoteResource(ISVNRemoteResource remoteResource) {
        this.remoteResource = remoteResource;
    }

    public String getUser() {
        return this.user;
    }

    public String getComment() {
        return this.comment;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public boolean getRegExp() {
        return this.regExp;
    }

    public boolean getAutoFetchLogs() {
        return this.autoFetchLogs;
    }

    public boolean getSearchAllLogs() {
        return this.searchAll;
    }

    protected void okPressed() {
        if (this.searchAllButton.getSelection()) {
            this.startDate = null;
            this.endDate = null;
        } else {
            Date tempStartDate = this.parseDate(this.startDateText.getText());
            Date tempEndDate = this.parseDate(this.endDateText.getText());
            if (tempStartDate == null || tempEndDate == null) {
                return;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(tempEndDate);
            calendar.set(11, calendar.getActualMaximum(11));
            calendar.set(12, calendar.getActualMaximum(12));
            calendar.set(13, calendar.getActualMaximum(13));
            tempEndDate = calendar.getTime();
            if (!tempEndDate.after(tempStartDate)) {
                MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("HistorySearchDialog.dateSequenceErrorTitle"), (String)Policy.bind("HistorySearchDialog.dateSequenceErrorMessage"));
                return;
            }
            this.endDate = tempEndDate;
            this.startDate = tempStartDate;
        }
        this.user = this.userText.getText();
        this.comment = this.commentCombo.getText();
        this.autoFetchLogs = this.fetchButton.getSelection();
        this.searchAll = this.searchAllButton.getSelection();
        this.regExp = this.regExpButton.getSelection();
        if (this.comment.trim().length() > 0) {
            this.previousComments.add(this.comment);
        }
        super.okPressed();
    }

    private String formatDate(Date date) {
        return DateFormat.getDateInstance(3).format(date);
    }

    private Date parseDate(String date) {
        try {
            return DateFormat.getDateInstance(3).parse(date);
        }
        catch (ParseException parseException) {
            MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("HistorySearchDialog.dateParseErrorTitle"), (String)Policy.bind("HistorySearchDialog.dateParseErrorMessage"));
            return null;
        }
    }

    private void fillCommentCombo(Combo combo) {
        if (this.previousComments == null) {
            this.previousComments = new ArrayList();
        }
        int i = this.previousComments.size() - 1;
        while (i >= 0) {
            combo.add((String)this.previousComments.get(i));
            --i;
        }
        combo.select(0);
    }
}

