/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.actions.WorkspaceAction;
import org.tigris.subversion.subclipse.ui.operations.ShowAnnotationOperation;

public class ShowAnnotationAction
extends WorkspaceAction {
    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        ISVNRemoteFile cvsResource = this.getSingleSelectedSVNRemoteFile();
        this.execute(cvsResource);
    }

    public void execute(ISVNRemoteFile svnResource) throws InvocationTargetException, InterruptedException {
        if (svnResource == null) {
            return;
        }
        new ShowAnnotationOperation(this.getTargetPart(), svnResource).run();
    }

    protected boolean isEnabled() throws TeamException {
        ISVNRemoteFile resource = this.getSingleSelectedSVNRemoteFile();
        return resource != null;
    }

    protected ISVNRemoteFile getSingleSelectedSVNRemoteFile() {
        ISVNRemoteFile[] svnResources = this.getSelectedRemoteFiles();
        if (svnResources.length == 1) {
            return svnResources[0];
        }
        IResource[] resources = this.getSelectedResources();
        if (resources.length == 1) {
            try {
                return (ISVNRemoteFile)SVNWorkspaceRoot.getBaseResourceFor((IResource)resources[0]);
            }
            catch (SVNException sVNException) {
                return null;
            }
        }
        return null;
    }

    protected String getImageId() {
        return "Menu Annotate";
    }
}

