/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.viewsupport;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.rubypeople.rdt.internal.ui.viewsupport.RubyUILabelProvider;
import org.rubypeople.rdt.ui.PreferenceConstants;

public class AppearanceAwareLabelProvider
extends RubyUILabelProvider
implements IPropertyChangeListener {
    public static final long DEFAULT_TEXTFLAGS = 0x210000000002L;
    public static final int DEFAULT_IMAGEFLAGS = 1;
    private long fTextFlagMask;
    private int fImageFlagMask;

    public AppearanceAwareLabelProvider(long l, int n) {
        super(l, n);
        this.initMasks();
        PreferenceConstants.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public AppearanceAwareLabelProvider() {
        this(0x210000000002L, 1);
    }

    private void initMasks() {
        IPreferenceStore iPreferenceStore = PreferenceConstants.getPreferenceStore();
        this.fTextFlagMask = -1L;
        if (!iPreferenceStore.getBoolean("org.rubypeople.rdt.ui.compresspackagenames")) {
            this.fTextFlagMask ^= 0x2000000000L;
        }
        this.fImageFlagMask = -1;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if (string.equals("PackagesView.pkgNamePatternForPackagesView") || string.equals("org.rubypeople.rdt.ui.compresspackagenames")) {
            this.initMasks();
            LabelProviderChangedEvent labelProviderChangedEvent = new LabelProviderChangedEvent((IBaseLabelProvider)this, null);
            this.fireLabelProviderChanged(labelProviderChangedEvent);
        }
    }

    public void dispose() {
        PreferenceConstants.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    protected int evaluateImageFlags(Object object) {
        return this.getImageFlags() & this.fImageFlagMask;
    }

    protected long evaluateTextFlags(Object object) {
        return this.getTextFlags() & this.fTextFlagMask;
    }
}

