/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.browsing;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.rubypeople.rdt.core.IImportContainer;
import org.rubypeople.rdt.core.IImportDeclaration;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.actions.LexicalSortingAction;
import org.rubypeople.rdt.internal.ui.browsing.RubyBrowsingPart;
import org.rubypeople.rdt.internal.ui.preferences.MembersOrderPreferenceCache;
import org.rubypeople.rdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.rubypeople.rdt.internal.ui.viewsupport.RubyUILabelProvider;
import org.rubypeople.rdt.ui.RubyUI;
import org.rubypeople.rdt.ui.actions.MemberFilterActionGroup;

public class MembersView
extends RubyBrowsingPart
implements IPropertyChangeListener {
    private MemberFilterActionGroup fMemberFilterActionGroup;

    public MembersView() {
        this.setHasCustomSetFilter(true);
        RubyPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected RubyUILabelProvider createLabelProvider() {
        return new AppearanceAwareLabelProvider(0x210000000002L, 1);
    }

    protected String getLinkToEditorKey() {
        return "org.rubypeople.rdt.ui.browsing.memberstoeditor";
    }

    protected boolean isValidInput(Object object) {
        if (object instanceof IType) {
            IType iType = (IType)object;
            return iType.getDeclaringType() == null;
        }
        return false;
    }

    protected boolean isValidElement(Object object) {
        IRubyScript iRubyScript;
        Object object2;
        if (object instanceof IMember) {
            return super.isValidElement(((IMember)object).getDeclaringType());
        }
        if (object instanceof IImportDeclaration) {
            return this.isValidElement(((IRubyElement)object).getParent());
        }
        if (object instanceof IImportContainer && (object2 = this.getViewer().getInput()) instanceof IRubyElement && (iRubyScript = (IRubyScript)((IRubyElement)object2).getAncestor(2)) != null) {
            IRubyScript iRubyScript2 = (IRubyScript)((IRubyElement)object).getAncestor(2);
            return iRubyScript.equals(iRubyScript2);
        }
        return false;
    }

    protected void hookViewerListeners() {
        super.hookViewerListeners();
        this.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                Object object;
                TreeViewer treeViewer = (TreeViewer)MembersView.this.getViewer();
                if (treeViewer.isExpandable(object = ((IStructuredSelection)doubleClickEvent.getSelection()).getFirstElement())) {
                    treeViewer.setExpandedState(object, !treeViewer.getExpandedState(object));
                }
            }
        });
    }

    protected IRubyElement findElementToSelect(IRubyElement iRubyElement) {
        if (iRubyElement == null) {
            return null;
        }
        switch (iRubyElement.getElementType()) {
            case 3: {
                if (((IType)iRubyElement).getDeclaringType() == null) {
                    return null;
                }
            }
            case 4: 
            case 13: 
            case 14: {
                return this.getSuitableRubyElement(iRubyElement);
            }
            case 6: {
                iRubyElement = this.getSuitableRubyElement(iRubyElement);
                if (iRubyElement == null) break;
                IRubyScript iRubyScript = (IRubyScript)iRubyElement.getParent().getParent();
                try {
                    Object object;
                    if (iRubyScript.getImports()[0].equals(iRubyElement) && (object = this.getSingleElementFromSelection(this.getViewer().getSelection())) instanceof IImportContainer) {
                        return (IImportContainer)object;
                    }
                }
                catch (RubyModelException rubyModelException) {}
                return iRubyElement;
            }
        }
        return null;
    }

    protected IRubyElement findInputForRubyElement(IRubyElement iRubyElement) {
        if (iRubyElement == null || !iRubyElement.exists()) {
            return null;
        }
        switch (iRubyElement.getElementType()) {
            case 3: {
                IType iType = ((IType)iRubyElement).getDeclaringType();
                if (iType == null) {
                    return iRubyElement;
                }
                return this.findInputForRubyElement((IRubyElement)iType);
            }
            case 2: {
                return this.getTypeForRubyScript((IRubyScript)iRubyElement);
            }
            case 6: {
                return this.findInputForRubyElement(iRubyElement.getParent());
            }
            case 14: {
                IRubyElement iRubyElement2 = iRubyElement.getParent();
                if (!(iRubyElement2 instanceof IRubyScript)) break;
                return this.getTypeForRubyScript((IRubyScript)iRubyElement2);
            }
        }
        if (iRubyElement instanceof IMember) {
            return this.findInputForRubyElement((IRubyElement)((IMember)iRubyElement).getDeclaringType());
        }
        return null;
    }

    boolean isInputAWorkingCopy() {
        IRubyScript iRubyScript;
        Object object = this.getViewer().getInput();
        if (object instanceof IRubyElement && (iRubyScript = (IRubyScript)((IRubyElement)object).getAncestor(2)) != null) {
            return iRubyScript.isWorkingCopy();
        }
        return false;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (MembersOrderPreferenceCache.isMemberOrderProperty(propertyChangeEvent.getProperty())) {
            this.getViewer().refresh();
        }
    }

    public void dispose() {
        if (this.fMemberFilterActionGroup != null) {
            this.fMemberFilterActionGroup.dispose();
            this.fMemberFilterActionGroup = null;
        }
        super.dispose();
        RubyPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    protected StructuredViewer createViewer(Composite composite) {
        StructuredViewer structuredViewer = super.createViewer(composite);
        this.fMemberFilterActionGroup = new MemberFilterActionGroup(structuredViewer, RubyUI.ID_MEMBERS_VIEW);
        return structuredViewer;
    }

    protected void fillToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)new LexicalSortingAction(this.getViewer(), RubyUI.ID_MEMBERS_VIEW));
        this.fMemberFilterActionGroup.contributeToToolBar(iToolBarManager);
        super.fillToolBar(iToolBarManager);
    }
}

