# vim:set et sts=4 sw=4:
# -*- coding: utf-8 -*-
KZIK_RULE = {
    u'a': (None, (u'ア', u'あ')),
    u'ba': (None, (u'バ', u'ば')),
    u'be': (None, (u'ベ', u'べ')),
    u'bi': (None, (u'ビ', u'び')),
    u'bo': (None, (u'ボ', u'ぼ')),
    u'bu': (None, (u'ブ', u'ぶ')),
    u'bya': (None, (u'ビャ', u'びゃ')),
    u'bye': (None, (u'ビェ', u'びぇ')),
    u'byi': (None, (u'ビィ', u'びぃ')),
    u'byo': (None, (u'ビョ', u'びょ')),
    u'byu': (None, (u'ビュ', u'びゅ')),
    u'cya': (None, (u'チャ', u'ちゃ')),
    u'cye': (None, (u'チェ', u'ちぇ')),
    u'cyi': (None, (u'チィ', u'ちぃ')),
    u'cyo': (None, (u'チョ', u'ちょ')),
    u'cyu': (None, (u'チュ', u'ちゅ')),
    u'da': (None, (u'ダ', u'だ')),
    u'de': (None, (u'デ', u'で')),
    u'df': (None, (u'デ', u'で')),
    u'di': (None, (u'ヂ', u'ぢ')),
    u'do': (None, (u'ド', u'ど')),
    u'du': (None, (u'ヅ', u'づ')),
    u'e': (None, (u'エ', u'え')),
    u'fa': (None, (u'ファ', u'ふぁ')),
    u'fe': (None, (u'フェ', u'ふぇ')),
    u'fi': (None, (u'フィ', u'ふぃ')),
    u'fo': (None, (u'フォ', u'ふぉ')),
    u'fu': (None, (u'フ', u'ふ')),
    u'fya': (None, (u'フャ', u'ふゃ')),
    u'fye': (None, (u'フェ', u'ふぇ')),
    u'fyi': (None, (u'フィ', u'ふぃ')),
    u'fyo': (None, (u'フョ', u'ふょ')),
    u'fyu': (None, (u'フュ', u'ふゅ')),
    u'ga': (None, (u'ガ', u'が')),
    u'ge': (None, (u'ゲ', u'げ')),
    u'gi': (None, (u'ギ', u'ぎ')),
    u'go': (None, (u'ゴ', u'ご')),
    u'gu': (None, (u'グ', u'ぐ')),
    u'gya': (None, (u'ギャ', u'ぎゃ')),
    u'gye': (None, (u'ギェ', u'ぎぇ')),
    u'gyi': (None, (u'ギィ', u'ぎぃ')),
    u'gyo': (None, (u'ギョ', u'ぎょ')),
    u'gyu': (None, (u'ギュ', u'ぎゅ')),
    u'ha': (None, (u'ハ', u'は')),
    u'he': (None, (u'ヘ', u'へ')),
    u'hi': (None, (u'ヒ', u'ひ')),
    u'ho': (None, (u'ホ', u'ほ')),
    u'hu': (None, (u'フ', u'ふ')),
    u'hya': (None, (u'ヒャ', u'ひゃ')),
    u'hye': (None, (u'ヒェ', u'ひぇ')),
    u'hyi': (None, (u'ヒィ', u'ひぃ')),
    u'hyo': (None, (u'ヒョ', u'ひょ')),
    u'hyu': (None, (u'ヒュ', u'ひゅ')),
    u'i': (None, (u'イ', u'い')),
    u'ja': (None, (u'ジャ', u'じゃ')),
    u'je': (None, (u'ジェ', u'じぇ')),
    u'ji': (None, (u'ジ', u'じ')),
    u'jo': (None, (u'ジョ', u'じょ')),
    u'ju': (None, (u'ジュ', u'じゅ')),
    u'jya': (None, (u'ジャ', u'じゃ')),
    u'jye': (None, (u'ジェ', u'じぇ')),
    u'jyi': (None, (u'ジィ', u'じぃ')),
    u'jyo': (None, (u'ジョ', u'じょ')),
    u'jyu': (None, (u'ジュ', u'じゅ')),
    u'ka': (None, (u'カ', u'か')),
    u'ke': (None, (u'ケ', u'け')),
    u'ki': (None, (u'キ', u'き')),
    u'kf': (None, (u'キ', u'き')),
    u'ko': (None, (u'コ', u'こ')),
    u'ku': (None, (u'ク', u'く')),
    u'kya': (None, (u'キャ', u'きゃ')),
    u'kye': (None, (u'キェ', u'きぇ')),
    u'kyi': (None, (u'キィ', u'きぃ')),
    u'kyo': (None, (u'キョ', u'きょ')),
    u'kyu': (None, (u'キュ', u'きゅ')),
    u'ma': (None, (u'マ', u'ま')),
    u'me': (None, (u'メ', u'め')),
    u'mi': (None, (u'ミ', u'み')),
    u'mo': (None, (u'モ', u'も')),
    u'mu': (None, (u'ム', u'む')),
    u'mf': (None, (u'ム', u'む')),
    u'mya': (None, (u'ミャ', u'みゃ')),
    u'mye': (None, (u'ミェ', u'みぇ')),
    u'myi': (None, (u'ミィ', u'みぃ')),
    u'myo': (None, (u'ミョ', u'みょ')),
    u'myu': (None, (u'ミュ', u'みゅ')),
    u'n\'': (None, (u'ン', u'ん')),
    u'na': (None, (u'ナ', u'な')),
    u'ne': (None, (u'ネ', u'ね')),
    u'ni': (None, (u'ニ', u'に')),
    u'nn': (None, (u'ン', u'ん')),
    u'no': (None, (u'ノ', u'の')),
    u'nu': (None, (u'ヌ', u'ぬ')),
    u'nf': (None, (u'ヌ', u'ぬ')),
    u'nya': (None, (u'ニャ', u'にゃ')),
    u'nye': (None, (u'ニェ', u'にぇ')),
    u'nyi': (None, (u'ニィ', u'にぃ')),
    u'nyo': (None, (u'ニョ', u'にょ')),
    u'nyu': (None, (u'ニュ', u'にゅ')),
    u'o': (None, (u'オ', u'お')),
    u'pa': (None, (u'パ', u'ぱ')),
    u'pe': (None, (u'ペ', u'ぺ')),
    u'pi': (None, (u'ピ', u'ぴ')),
    u'po': (None, (u'ポ', u'ぽ')),
    u'pu': (None, (u'プ', u'ぷ')),
    u'pya': (None, (u'ピャ', u'ぴゃ')),
    u'pye': (None, (u'ピェ', u'ぴぇ')),
    u'pyi': (None, (u'ピィ', u'ぴぃ')),
    u'pyo': (None, (u'ピョ', u'ぴょ')),
    u'pyu': (None, (u'ピュ', u'ぴゅ')),
    u'ra': (None, (u'ラ', u'ら')),
    u're': (None, (u'レ', u'れ')),
    u'ri': (None, (u'リ', u'り')),
    u'ro': (None, (u'ロ', u'ろ')),
    u'ru': (None, (u'ル', u'る')),
    u'rya': (None, (u'リャ', u'りゃ')),
    u'rye': (None, (u'リェ', u'りぇ')),
    u'ryi': (None, (u'リィ', u'りぃ')),
    u'ryo': (None, (u'リョ', u'りょ')),
    u'ryu': (None, (u'リュ', u'りゅ')),
    u'sa': (None, (u'サ', u'さ')),
    u'se': (None, (u'セ', u'せ')),
    u'si': (None, (u'シ', u'し')),
    u'so': (None, (u'ソ', u'そ')),
    u'su': (None, (u'ス', u'す')),
    u'sya': (None, (u'シャ', u'しゃ')),
    u'sye': (None, (u'シェ', u'しぇ')),
    u'syi': (None, (u'シィ', u'しぃ')),
    u'syo': (None, (u'ショ', u'しょ')),
    u'syu': (None, (u'シュ', u'しゅ')),
    u'ta': (None, (u'タ', u'た')),
    u'te': (None, (u'テ', u'て')),
    u'ti': (None, (u'チ', u'ち')),
    u'to': (None, (u'ト', u'と')),
    u'tu': (None, (u'ツ', u'つ')),
    u'u': (None, (u'ウ', u'う')),
    u'va': (None, (u'ヴァ', u'う゛ぁ')),
    u've': (None, (u'ヴェ', u'う゛ぇ')),
    u'vi': (None, (u'ヴィ', u'う゛ぃ')),
    u'vo': (None, (u'ヴォ', u'う゛ぉ')),
    u'vu': (None, (u'ヴ', u'う゛')),
    u'wa': (None, (u'ワ', u'わ')),
    u'we': (None, (u'ウェ', u'うぇ')),
    u'wi': (None, (u'ウィ', u'うぃ')),
    u'wo': (None, (u'ヲ', u'を')),
    u'wu': (None, (u'ウ', u'う')),
    u'xxa': (None, (u'ァ', u'ぁ')),
    u'xxe': (None, (u'ェ', u'ぇ')),
    u'xxi': (None, (u'ィ', u'ぃ')),
    u'xka': (None, (u'ヵ', u'か')),
    u'xke': (None, (u'ヶ', u'け')),
    u'xxo': (None, (u'ォ', u'ぉ')),
    u'xxu': (None, (u'ゥ', u'ぅ')),
    u'xxwa': (None, (u'ヮ', u'ゎ')),
    u'xxwe': (None, (u'ヱ', u'ゑ')),
    u'xxwi': (None, (u'ヰ', u'ゐ')),
    u'xya': (None, (u'ャ', u'ゃ')),
    u'xyo': (None, (u'ョ', u'ょ')),
    u'xyu': (None, (u'ュ', u'ゅ')),
    u'ya': (None, (u'ヤ', u'や')),
    u'ye': (None, (u'イェ', u'いぇ')),
    u'yo': (None, (u'ヨ', u'よ')),
    u'yu': (None, (u'ユ', u'ゆ')),
    u'z,': (None, u'‥'),
    u'z-': (None, u'〜'),
    u'z.': (None, u'…'),
    u'z/': (None, u'・'),
    u'z[': (None, u'『'),
    u'z]': (None, u'』'),
    u'za': (None, (u'ザ', u'ざ')),
    u'ze': (None, (u'ゼ', u'ぜ')),
    u'xxh': (None, u'←'),
    u'zi': (None, (u'ジ', u'じ')),
    u'xxj': (None, u'↓'),
    u'xxk': (None, u'↑'),
    u'xxl': (None, u'→'),
    u'zo': (None, (u'ゾ', u'ぞ')),
    u'zu': (None, (u'ズ', u'ず')),
    u'ff': (u'f', (u'ッ', u'っ')),
    u'tt': (u't', (u'ッ', u'っ')),
    u'-': (None, u'ー'),
    u':': (u'b', (u'ッ', u'っ')),
    u';': (None, (u'ッ', u'っ')),
    u'?': (None, u'？'),
    u'[': (None, u'「'),
    u']': (None, u'」'),
    u'bga': (None, (u'ビャ', u'びゃ')),
    u'bgd': (None, (u'ビェン', u'びぇん')),
    u'bge': (None, (u'ビェ', u'びぇ')),
    u'bgo': (None, (u'ビョ', u'びょ')),
    u'bgu': (None, (u'ビュ', u'びゅ')),
    u'dci': (None, (u'ディ', u'でぃ')),
    u'dcu': (None, (u'ドゥ', u'どぅ')),
    u'gga': (None, (u'ギャ', u'ぎゃ')),
    u'ggu': (None, (u'ギュ', u'ぎゅ')),
    u'gge': (None, (u'ギェ', u'ぎぇ')),
    u'ggo': (None, (u'ギョ', u'ぎょ')),
    u'hgo': (None, (u'ヒョ', u'ひょ')),
    u'hga': (None, (u'ヒャ', u'ひゃ')),
    u'hge': (None, (u'ヒェ', u'ひぇ')),
    u'hgu': (None, (u'ヒュ', u'ひゅ')),
    u'bgh': (None, (u'ビュウ', u'びゅう')),
    u'bgj': (None, (u'ビュン', u'びゅん')),
    u'bgl': (None, (u'ビョン', u'びょん')),
    u'bgn': (None, (u'ビャン', u'びゃん')),
    u'bgp': (None, (u'ビョウ', u'びょう')),
    u'bgq': (None, (u'ビャイ', u'びゃい')),
    u'bgw': (None, (u'ビェイ', u'びぇい')),
    u'bgz': (None, (u'ビャン', u'びゃん')),
    u'byd': (None, (u'ビェン', u'びぇん')),
    u'byh': (None, (u'ビュウ', u'びゅう')),
    u'byj': (None, (u'ビュン', u'びゅん')),
    u'byl': (None, (u'ビョン', u'びょん')),
    u'byn': (None, (u'ビャン', u'びゃん')),
    u'byp': (None, (u'ビョウ', u'びょう')),
    u'byq': (None, (u'ビャイ', u'びゃい')),
    u'byw': (None, (u'ビェイ', u'びぇい')),
    u'byz': (None, (u'ビャン', u'びゃん')),
    u'ggz': (None, (u'ギャン', u'ぎゃん')),
    u'ggn': (None, (u'ギャン', u'ぎゃん')),
    u'ggj': (None, (u'ギュン', u'ぎゅん')),
    u'ggd': (None, (u'ギェン', u'ぎぇん')),
    u'ggl': (None, (u'ギョン', u'ぎょん')),
    u'ggq': (None, (u'ギャイ', u'ぎゃい')),
    u'ggh': (None, (u'ギュウ', u'ぎゅう')),
    u'ggw': (None, (u'ギェイ', u'ぎぇい')),
    u'ggp': (None, (u'ギョウ', u'ぎょう')),
    u'gyd': (None, (u'ギェン', u'ぎぇん')),
    u'gyh': (None, (u'ギュウ', u'ぎゅう')),
    u'gyj': (None, (u'ギュン', u'ぎゅん')),
    u'gyl': (None, (u'ギョン', u'ぎょん')),
    u'gyn': (None, (u'ギャン', u'ぎゃん')),
    u'gyp': (None, (u'ギョウ', u'ぎょう')),
    u'gyq': (None, (u'ギャイ', u'ぎゃい')),
    u'gyw': (None, (u'ギェイ', u'ぎぇい')),
    u'gyz': (None, (u'ギャン', u'ぎゃん')),
    u'hgd': (None, (u'ヒェン', u'ひぇん')),
    u'hgh': (None, (u'ヒュウ', u'ひゅう')),
    u'hgj': (None, (u'ヒュン', u'ひゅん')),
    u'hgl': (None, (u'ヒョン', u'ひょん')),
    u'hgn': (None, (u'ヒャン', u'ひゃん')),
    u'hgp': (None, (u'ヒョウ', u'ひょう')),
    u'hgq': (None, (u'ヒャイ', u'ひゃい')),
    u'hgw': (None, (u'ヒェイ', u'ひぇい')),
    u'hgz': (None, (u'ヒャン', u'ひゃん')),
    u'hyd': (None, (u'ヒェン', u'ひぇん')),
    u'hyh': (None, (u'ヒュウ', u'ひゅう')),
    u'hyj': (None, (u'ヒュン', u'ひゅん')),
    u'hyl': (None, (u'ヒョン', u'ひょん')),
    u'hyn': (None, (u'ヒャン', u'ひゃん')),
    u'hyp': (None, (u'ヒョウ', u'ひょう')),
    u'hyq': (None, (u'ヒャイ', u'ひゃい')),
    u'hyw': (None, (u'ヒェイ', u'ひぇい')),
    u'hyz': (None, (u'ヒャン', u'ひゃん')),
    u'kgd': (None, (u'キェン', u'きぇん')),
    u'kgh': (None, (u'キュウ', u'きゅう')),
    u'kgj': (None, (u'キュン', u'きゅん')),
    u'kgl': (None, (u'キョン', u'きょん')),
    u'kgn': (None, (u'キャン', u'きゃん')),
    u'kgp': (None, (u'キョウ', u'きょう')),
    u'kgq': (None, (u'キャイ', u'きゃい')),
    u'kgw': (None, (u'キェイ', u'きぇい')),
    u'kgz': (None, (u'キャン', u'きゃん')),
    u'kyd': (None, (u'キェン', u'きぇん')),
    u'kyh': (None, (u'キュウ', u'きゅう')),
    u'kyj': (None, (u'キュン', u'きゅん')),
    u'kyl': (None, (u'キョン', u'きょん')),
    u'kyn': (None, (u'キャン', u'きゃん')),
    u'kyp': (None, (u'キョウ', u'きょう')),
    u'kyq': (None, (u'キャイ', u'きゃい')),
    u'kyw': (None, (u'キェイ', u'きぇい')),
    u'kyz': (None, (u'キャン', u'きゃん')),
    u'mgd': (None, (u'ミェン', u'みぇん')),
    u'mgh': (None, (u'ミュウ', u'みゅう')),
    u'mgj': (None, (u'ミュン', u'みゅん')),
    u'mgl': (None, (u'ミョン', u'みょん')),
    u'mgn': (None, (u'ミャン', u'みゃん')),
    u'mgp': (None, (u'ミョウ', u'みょう')),
    u'mgq': (None, (u'ミャイ', u'みゃい')),
    u'mgw': (None, (u'ミェイ', u'みぇい')),
    u'mgz': (None, (u'ミャン', u'みゃん')),
    u'myd': (None, (u'ミェン', u'みぇん')),
    u'myh': (None, (u'ミュウ', u'みゅう')),
    u'myj': (None, (u'ミュン', u'みゅん')),
    u'myl': (None, (u'ミョン', u'みょん')),
    u'myn': (None, (u'ミャン', u'みゃん')),
    u'myp': (None, (u'ミョウ', u'みょう')),
    u'myq': (None, (u'ミャイ', u'みゃい')),
    u'myw': (None, (u'ミェイ', u'みぇい')),
    u'myz': (None, (u'ミャン', u'みゃん')),
    u'jya': (None, (u'ジャ', u'じゃ')),
    u'jye': (None, (u'ジェ', u'じぇ')),
    u'jyi': (None, (u'ジィ', u'じぃ')),
    u'jyo': (None, (u'ジョ', u'じょ')),
    u'jyu': (None, (u'ジュ', u'じゅ')),
    u'kga': (None, (u'キャ', u'きゃ')),
    u'kge': (None, (u'キェ', u'きぇ')),
    u'kgo': (None, (u'キョ', u'きょ')),
    u'kgu': (None, (u'キュ', u'きゅ')),
    u'mga': (None, (u'ミャ', u'みゃ')),
    u'mge': (None, (u'ミェ', u'みぇ')),
    u'mgo': (None, (u'ミョ', u'みょ')),
    u'mgu': (None, (u'ミュ', u'みゅ')),
    u'nga': (None, (u'ニャ', u'にゃ')),
    u'nge': (None, (u'ニェ', u'にぇ')),
    u'ngo': (None, (u'ニョ', u'にょ')),
    u'ngu': (None, (u'ニュ', u'にゅ')),
    u'pga': (None, (u'ピャ', u'ぴゃ')),
    u'pge': (None, (u'ピェ', u'ぴぇ')),
    u'pgo': (None, (u'ピョ', u'ぴょ')),
    u'pgu': (None, (u'ピュ', u'ぴゅ')),
    u'rga': (None, (u'リャ', u'りゃ')),
    u'rge': (None, (u'リェ', u'りぇ')),
    u'rgo': (None, (u'リョ', u'りょ')),
    u'rgu': (None, (u'リュ', u'りゅ')),
    u'bd': (None, (u'ベン', u'べん')),
    u'bh': (None, (u'ブウ', u'ぶう')),
    u'bj': (None, (u'ブン', u'ぶん')),
    u'bk': (None, (u'ビン', u'びん')),
    u'bl': (None, (u'ボン', u'ぼん')),
    u'bn': (None, (u'バン', u'ばん')),
    u'bp': (None, (u'ボウ', u'ぼう')),
    u'bq': (None, (u'バイ', u'ばい')),
    u'bt': (None, (u'ビト', u'びと')),
    u'bw': (None, (u'ベイ', u'べい')),
    u'bz': (None, (u'バン', u'ばん')),
    u'ca': (None, (u'チャ', u'ちゃ')),
    u'ce': (None, (u'チェ', u'ちぇ')),
    u'co': (None, (u'チョ', u'ちょ')),
    u'cu': (None, (u'チュ', u'ちゅ')),
    u'dd': (None, (u'デン', u'でん')),
    u'dh': (None, (u'ヅウ', u'づう')),
    u'dj': (None, (u'ヅン', u'づん')),
    u'dk': (None, (u'ヂン', u'ぢん')),
    u'dl': (None, (u'ドン', u'どん')),
    u'dm': (None, (u'デモ', u'でも')),
    u'dn': (None, (u'ダン', u'だん')),
    u'dp': (None, (u'ドウ', u'どう')),
    u'dq': (None, (u'ダイ', u'だい')),
    u'ds': (None, (u'デス', u'です')),
    u'dt': (None, (u'ダチ', u'だち')),
    u'dw': (None, (u'デイ', u'でい')),
    u'dz': (None, (u'ダン', u'だん')),
    u'fh': (None, (u'フウ', u'ふう')),
    u'fj': (None, (u'フン', u'ふん')),
    u'gd': (None, (u'ゲン', u'げん')),
    u'gh': (None, (u'グウ', u'ぐう')),
    u'gj': (None, (u'グン', u'ぐん')),
    u'gk': (None, (u'ギン', u'ぎん')),
    u'gl': (None, (u'ゴン', u'ごん')),
    u'gn': (None, (u'ガン', u'がん')),
    u'gp': (None, (u'ゴウ', u'ごう')),
    u'gq': (None, (u'ガイ', u'がい')),
    u'gr': (None, (u'ガラ', u'がら')),
    u'gt': (None, (u'ゴト', u'ごと')),
    u'gw': (None, (u'ゲイ', u'げい')),
    u'gz': (None, (u'ガン', u'がん')),
    u'hd': (None, (u'ヘン', u'へん')),
    u'hh': (None, (u'フウ', u'ふう')),
    u'hj': (None, (u'フン', u'ふん')),
    u'hk': (None, (u'ヒン', u'ひん')),
    u'hl': (None, (u'ホン', u'ほん')),
    u'hn': (None, (u'ハン', u'はん')),
    u'hp': (None, (u'ホウ', u'ほう')),
    u'hq': (None, (u'ハイ', u'はい')),
    u'ht': (None, (u'ヒト', u'ひと')),
    u'hw': (None, (u'ヘイ', u'へい')),
    u'hz': (None, (u'ハン', u'はん')),
    u'jf': (None, (u'ジュ', u'じゅ')),
    u'jk': (None, (u'ジン', u'じん')),
    u'kd': (None, (u'ケン', u'けん')),
    u'kh': (None, (u'クウ', u'くう')),
    u'kj': (None, (u'クン', u'くん')),
    u'kk': (None, (u'キン', u'きん')),
    u'kl': (None, (u'コン', u'こん')),
    u'km': (None, (u'カモ', u'かも')),
    u'kn': (None, (u'カン', u'かん')),
    u'kp': (None, (u'コウ', u'こう')),
    u'kq': (None, (u'カイ', u'かい')),
    u'kr': (None, (u'カラ', u'から')),
    u'kt': (None, (u'コト', u'こと')),
    u'kw': (None, (u'ケイ', u'けい')),
    u'kz': (None, (u'カン', u'かん')),
    u'md': (None, (u'メン', u'めん')),
    u'mh': (None, (u'ムウ', u'むう')),
    u'mj': (None, (u'ムン', u'むん')),
    u'mk': (None, (u'ミン', u'みん')),
    u'ml': (None, (u'モン', u'もん')),
    u'mn': (None, (u'モノ', u'もの')),
    u'mp': (None, (u'モウ', u'もう')),
    u'mq': (None, (u'マイ', u'まい')),
    u'ms': (None, (u'マス', u'ます')),
    u'mt': (None, (u'マタ', u'また')),
    u'mw': (None, (u'メイ', u'めい')),
    u'mz': (None, (u'マン', u'まん')),
    u'nb': (None, (u'ネバ', u'ねば')),
    u'nd': (None, (u'ネン', u'ねん')),
    u'nh': (None, (u'ヌウ', u'ぬう')),
    u'nj': (None, (u'ヌン', u'ぬん')),
    u'nk': (None, (u'ニン', u'にん')),
    u'nl': (None, (u'ノン', u'のん')),
    u'np': (None, (u'ノウ', u'のう')),
    u'nq': (None, (u'ナイ', u'ない')),
    u'nr': (None, (u'ナル', u'なる')),
    u'nt': (None, (u'ニチ', u'にち')),
    u'nw': (None, (u'ネイ', u'ねい')),
    u'nz': (None, (u'ナン', u'なん')),
    u'pd': (None, (u'ペン', u'ぺん')),
    u'ph': (None, (u'プウ', u'ぷう')),
    u'pj': (None, (u'プン', u'ぷん')),
    u'pk': (None, (u'ピン', u'ぴん')),
    u'pl': (None, (u'ポン', u'ぽん')),
    u'pn': (None, (u'パン', u'ぱん')),
    u'pp': (None, (u'ポウ', u'ぽう')),
    u'pq': (None, (u'パイ', u'ぱい')),
    u'pw': (None, (u'ペイ', u'ぺい')),
    u'pz': (None, (u'パン', u'ぱん')),
    u'rd': (None, (u'レン', u'れん')),
    u'rh': (None, (u'ルウ', u'るう')),
    u'rj': (None, (u'ルン', u'るん')),
    u'rk': (None, (u'リン', u'りん')),
    u'rl': (None, (u'ロン', u'ろん')),
    u'rn': (None, (u'ラン', u'らん')),
    u'rp': (None, (u'ロウ', u'ろう')),
    u'rq': (None, (u'ライ', u'らい')),
    u'rr': (None, (u'ラレ', u'られ')),
    u'rw': (None, (u'レイ', u'れい')),
    u'rz': (None, (u'ラン', u'らん')),
    u'sd': (None, (u'セン', u'せん')),
    u'sf': (None, (u'サイ', u'さい')),
    u'sh': (None, (u'スウ', u'すう')),
    u'sj': (None, (u'スン', u'すん')),
    u'sk': (None, (u'シン', u'しん')),
    u'sl': (None, (u'ソン', u'そん')),
    u'sn': (None, (u'サン', u'さん')),
    u'sp': (None, (u'ソウ', u'そう')),
    u'sq': (None, (u'サイ', u'さい')),
    u'sr': (None, (u'スル', u'する')),
    u'ss': (None, (u'セイ', u'せい')),
    u'st': (None, (u'シタ', u'した')),
    u'sw': (None, (u'セイ', u'せい')),
    u'sz': (None, (u'サン', u'さん')),
    u'tb': (None, (u'タビ', u'たび')),
    u'td': (None, (u'テン', u'てん')),
    u'th': (None, (u'ツウ', u'つう')),
    u'tj': (None, (u'ツン', u'つん')),
    u'tk': (None, (u'チン', u'ちん')),
    u'tl': (None, (u'トン', u'とん')),
    u'tm': (None, (u'タメ', u'ため')),
    u'tn': (None, (u'タン', u'たん')),
    u'tp': (None, (u'トウ', u'とう')),
    u'tq': (None, (u'タイ', u'たい')),
    u'tr': (None, (u'タラ', u'たら')),
    u'tw': (None, (u'テイ', u'てい')),
    u'tz': (None, (u'タン', u'たん')),
    u'wn': (None, (u'ワン', u'わん')),
    u'wq': (None, (u'ワイ', u'わい')),
    u'wr': (None, (u'ワレ', u'われ')),
    u'wt': (None, (u'ワタ', u'わた')),
    u'wz': (None, (u'ワン', u'わん')),
    u'xa': (None, (u'シャ', u'しゃ')),
    u'xe': (None, (u'シェ', u'しぇ')),
    u'xo': (None, (u'ショ', u'しょ')),
    u'xu': (None, (u'シュ', u'しゅ')),
    u'ye': (None, (u'イェ', u'いぇ')),
    u'yh': (None, (u'ユウ', u'ゆう')),
    u'yj': (None, (u'ユン', u'ゆん')),
    u'yl': (None, (u'ヨン', u'よん')),
    u'yn': (None, (u'ヤン', u'やん')),
    u'yp': (None, (u'ヨウ', u'よう')),
    u'yq': (None, (u'ヤイ', u'やい')),
    u'yr': (None, (u'ヨル', u'よる')),
    u'yz': (None, (u'ヤン', u'やん')),
    u'zd': (None, (u'ゼン', u'ぜん')),
    u'zh': (None, (u'ズウ', u'ずう')),
    u'zj': (None, (u'ズン', u'ずん')),
    u'zk': (None, (u'ジン', u'じん')),
    u'zl': (None, (u'ゾン', u'ぞん')),
    u'zn': (None, (u'ザン', u'ざん')),
    u'zp': (None, (u'ゾウ', u'ぞう')),
    u'zq': (None, (u'ザイ', u'ざい')),
    u'zr': (None, (u'ザル', u'ざる')),
    u'zv': (None, (u'ザイ', u'ざい')),
    u'zw': (None, (u'ゼイ', u'ぜい')),
    u'zx': (None, (u'ゼイ', u'ぜい')),
    u'zz': (None, (u'ザン', u'ざん')),
    u'ngd': (None, (u'ニェン', u'にぇん')),
    u'ngh': (None, (u'ニュウ', u'にゅう')),
    u'ngj': (None, (u'ニュン', u'にゅん')),
    u'ngl': (None, (u'ニョン', u'にょん')),
    u'ngn': (None, (u'ニャン', u'にゃん')),
    u'ngp': (None, (u'ニョウ', u'にょう')),
    u'ngq': (None, (u'ニャイ', u'にゃい')),
    u'ngw': (None, (u'ニェイ', u'にぇい')),
    u'ngz': (None, (u'ニャン', u'にゃん')),
    u'nyd': (None, (u'ニェン', u'にぇん')),
    u'nyh': (None, (u'ニュウ', u'にゅう')),
    u'nyj': (None, (u'ニュン', u'にゅん')),
    u'nyl': (None, (u'ニョン', u'にょん')),
    u'nyn': (None, (u'ニャン', u'にゃん')),
    u'nyp': (None, (u'ニョウ', u'にょう')),
    u'nyq': (None, (u'ニャイ', u'にゃい')),
    u'nyw': (None, (u'ニェイ', u'にぇい')),
    u'nyz': (None, (u'ニャン', u'にゃん')),
    u'pgd': (None, (u'ピェン', u'ぴぇん')),
    u'pgh': (None, (u'ピュウ', u'ぴゅう')),
    u'pgj': (None, (u'ピュン', u'ぴゅん')),
    u'pgl': (None, (u'ピョン', u'ぴょん')),
    u'pgn': (None, (u'ピャン', u'ぴゃん')),
    u'pgp': (None, (u'ピョウ', u'ぴょう')),
    u'pgq': (None, (u'ピャイ', u'ぴゃい')),
    u'pgw': (None, (u'ピェイ', u'ぴぇい')),
    u'pgz': (None, (u'ピャン', u'ぴゃん')),
    u'pyd': (None, (u'ピェン', u'ぴぇん')),
    u'pyh': (None, (u'ピュウ', u'ぴゅう')),
    u'pyj': (None, (u'ピュン', u'ぴゅん')),
    u'pyl': (None, (u'ピョン', u'ぴょん')),
    u'pyn': (None, (u'ピャン', u'ぴゃん')),
    u'pyp': (None, (u'ピョウ', u'ぴょう')),
    u'pyq': (None, (u'ピャイ', u'ぴゃい')),
    u'pyw': (None, (u'ピェイ', u'ぴぇい')),
    u'pyz': (None, (u'ピャン', u'ぴゃん')),
    u'rgd': (None, (u'リェン', u'りぇん')),
    u'rgh': (None, (u'リュウ', u'りゅう')),
    u'rgj': (None, (u'リュン', u'りゅん')),
    u'rgl': (None, (u'リョン', u'りょん')),
    u'rgn': (None, (u'リャン', u'りゃん')),
    u'rgp': (None, (u'リョウ', u'りょう')),
    u'rgq': (None, (u'リャイ', u'りゃい')),
    u'rgw': (None, (u'リェイ', u'りぇい')),
    u'rgz': (None, (u'リャン', u'りゃん')),
    u'ryd': (None, (u'リェン', u'りぇん')),
    u'ryh': (None, (u'リュウ', u'りゅう')),
    u'ryj': (None, (u'リュン', u'りゅん')),
    u'ryl': (None, (u'リョン', u'りょん')),
    u'ryn': (None, (u'リャン', u'りゃん')),
    u'ryp': (None, (u'リョウ', u'りょう')),
    u'ryq': (None, (u'リャイ', u'りゃい')),
    u'ryw': (None, (u'リェイ', u'りぇい')),
    u'ryz': (None, (u'リャン', u'りゃん')),
    u'syd': (None, (u'シェン', u'しぇん')),
    u'syh': (None, (u'シュウ', u'しゅう')),
    u'syj': (None, (u'シュン', u'しゅん')),
    u'syl': (None, (u'ション', u'しょん')),
    u'syn': (None, (u'シャン', u'しゃん')),
    u'syp': (None, (u'ショウ', u'しょう')),
    u'syq': (None, (u'シャイ', u'しゃい')),
    u'syw': (None, (u'シェイ', u'しぇい')),
    u'syz': (None, (u'シャン', u'しゃん')),
    u'tgi': (None, (u'ティ', u'てぃ')),
    u'tgu': (None, (u'トゥ', u'とぅ')),
    u'tsa': (None, (u'ツァ', u'つぁ')),
    u'tse': (None, (u'ツェ', u'つぇ')),
    u'tsi': (None, (u'ツィ', u'つぃ')),
    u'tso': (None, (u'ツォ', u'つぉ')),
    u'wso': (None, (u'ウォ', u'うぉ')),
    u'zga': (None, (u'ジャ', u'じゃ')),
    u'zge': (None, (u'ジェ', u'じぇ')),
    u'zgo': (None, (u'ジョ', u'じょ')),
    u'zgu': (None, (u'ジュ', u'じゅ')),
    u'cd': (None, (u'チェン', u'ちぇん')),
    u'ch': (None, (u'チュウ', u'ちゅう')),
    u'cj': (None, (u'チュン', u'ちゅん')),
    u'cl': (None, (u'チョン', u'ちょん')),
    u'cn': (None, (u'チャン', u'ちゃん')),
    u'cp': (None, (u'チョウ', u'ちょう')),
    u'cq': (None, (u'チャイ', u'ちゃい')),
    u'cw': (None, (u'チェイ', u'ちぇい')),
    u'cz': (None, (u'チャン', u'ちゃん')),
    u'fd': (None, (u'フェン', u'ふぇん')),
    u'fk': (None, (u'フィン', u'ふぃん')),
    u'fl': (None, (u'フォン', u'ふぉん')),
    u'fn': (None, (u'ファン', u'ふぁん')),
    u'fp': (None, (u'フォー', u'ふぉー')),
    u'fq': (None, (u'ファイ', u'ふぁい')),
    u'fw': (None, (u'フェイ', u'ふぇい')),
    u'fz': (None, (u'ファン', u'ふぁん')),
    u'jd': (None, (u'ジェン', u'じぇん')),
    u'jh': (None, (u'ジュウ', u'じゅう')),
    u'jj': (None, (u'ジュン', u'じゅん')),
    u'jl': (None, (u'ジョン', u'じょん')),
    u'jn': (None, (u'ジャン', u'じゃん')),
    u'jp': (None, (u'ジョウ', u'じょう')),
    u'jq': (None, (u'ジャイ', u'じゃい')),
    u'jw': (None, (u'ジェイ', u'じぇい')),
    u'jz': (None, (u'ジャン', u'じゃん')),
    u'wd': (None, (u'ウェン', u'うぇん')),
    u'wk': (None, (u'ウィン', u'うぃん')),
    u'wl': (None, (u'ウォン', u'うぉん')),
    u'wp': (None, (u'ウォー', u'うぉー')),
    u'xd': (None, (u'シェン', u'しぇん')),
    u'xh': (None, (u'シュウ', u'しゅう')),
    u'xj': (None, (u'シュン', u'しゅん')),
    u'xl': (None, (u'ション', u'しょん')),
    u'xn': (None, (u'シャン', u'しゃん')),
    u'xp': (None, (u'ショウ', u'しょう')),
    u'xq': (None, (u'シャイ', u'しゃい')),
    u'xw': (None, (u'シェイ', u'しぇい')),
    u'xz': (None, (u'シャン', u'しゃん')),
    u'yw': (None, (u'イェイ', u'いぇい')),
    u'tyd': (None, (u'チェン', u'ちぇん')),
    u'tyh': (None, (u'チュウ', u'ちゅう')),
    u'tyj': (None, (u'チュン', u'ちゅん')),
    u'tyl': (None, (u'チョン', u'ちょん')),
    u'tyn': (None, (u'チャン', u'ちゃん')),
    u'typ': (None, (u'チョウ', u'ちょう')),
    u'tyq': (None, (u'チャイ', u'ちゃい')),
    u'tyw': (None, (u'チェイ', u'ちぇい')),
    u'tyz': (None, (u'チャン', u'ちゃん')),
    u'zgd': (None, (u'ジェン', u'じぇん')),
    u'zgh': (None, (u'ジュウ', u'じゅう')),
    u'zgj': (None, (u'ジュン', u'じゅん')),
    u'zgl': (None, (u'ジョン', u'じょん')),
    u'zgn': (None, (u'ジャン', u'じゃん')),
    u'zgp': (None, (u'ジョウ', u'じょう')),
    u'zgq': (None, (u'ジャイ', u'じゃい')),
    u'zgw': (None, (u'ジェイ', u'じぇい')),
    u'zgz': (None, (u'ジャン', u'じゃん')),
    u'zyd': (None, (u'ジェン', u'じぇん')),
    u'zyh': (None, (u'ジュウ', u'じゅう')),
    u'zyj': (None, (u'ジュン', u'じゅん')),
    u'zyl': (None, (u'ジョン', u'じょん')),
    u'zyn': (None, (u'ジャン', u'じゃん')),
    u'zyp': (None, (u'ジョウ', u'じょう')),
    u'zyq': (None, (u'ジャイ', u'じゃい')),
    u'zyw': (None, (u'ジェイ', u'じぇい')),
    u'zyz': (None, (u'ジャン', u'じゃん')),
    u'x-': (None, u'-'),
    u'x;': (None, u';'),
    u'x:': (None, u':'),
    u'x_': (None, u'　'),
    u'x,': (None, u','),
    u'x.': (None, u'.'),
    u'x[': (None, u'['),
    u'x]': (None, u']'),
    u'x~': (None, u'~'),
    u'yf': (None, (u'ユ', u'ゆ')),
    u'zc': (None, (u'ザ', u'ざ')),
    u'zf': (None, (u'ゼ', u'ぜ')),
    u'sg': (None, u'思'),
    u'sx': (None, u'着'),
    u'sc': (None, u'送'),
    u'sv': (None, u'空'),
    u'sb': (None, u'分'),
    u'sm': (None, u'見'),
    u'dr': (None, u'対'),
    u'dg': (None, u'大'),
    u'dx': (None, u'代'),
    u'dv': (None, u'遅'),
    u'db': (None, u'書'),
    u'fr': (None, u'件'),
    u'ft': (None, u'仕'),
    u'fs': (None, u'会'),
    u'fg': (None, u'以'),
    u'fx': (None, u'点'),
    u'fc': (None, u'押'),
    u'fv': (None, u'換'),
    u'fb': (None, u'付'),
    u'gs': (None, u'行'),
    u'gf': (None, u'試'),
    u'gx': (None, u'欠'),
    u'gc': (None, u'要'),
    u'gv': (None, u'用'),
    u'gb': (None, u'様'),
    u'hr': (None, u'合'),
    u'hs': (None, u'方'),
    u'hf': (None, u'法'),
    u'hx': (None, u'機'),
    u'hc': (None, u'移'),
    u'hv': (None, u'信'),
    u'hb': (None, u'買'),
    u'jr': (None, u'重'),
    u'jt': (None, u'使'),
    u'jg': (None, u'聞'),
    u'jx': (None, u'生'),
    u'jc': (None, u'身'),
    u'jv': (None, u'地'),
    u'jb': (None, u'自'),
    u'kx': (None, u'変'),
    u'kc': (None, u'開'),
    u'kv': (None, u'気'),
    u'kb': (None, u'効'),
    u'rt': (None, u'力'),
    u'tf': (None, u'強'),
    u'vf': (None, u'返'),
    u'vz': (None, u'帰'),
    }
