require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_IXGBE_H_)) {
    eval 'sub _IXGBE_H_ () {1;}' unless defined(&_IXGBE_H_);
    require './dev/pci/bpfilter.ph';
    require './dev/pci/vlan.ph';
    require 'sys/param.ph';
    require 'sys/systm.ph';
    require 'sys/sockio.ph';
    require 'sys/mbuf.ph';
    require 'sys/malloc.ph';
    require 'sys/kernel.ph';
    require 'sys/device.ph';
    require 'sys/socket.ph';
    require 'sys/timeout.ph';
    require 'sys/pool.ph';
    require 'sys/rwlock.ph';
    require 'sys/workq.ph';
    require 'net/if.ph';
    require 'net/if_arp.ph';
    require 'net/bpf.ph';
    require 'net/if_dl.ph';
    require 'net/if_media.ph';
    require 'netinet/in_systm.ph';
    require 'netinet/in.ph';
    require 'netinet/if_ether.ph';
    require 'netinet/ip.ph';
    require 'netinet/ip6.ph';
    require 'netinet/tcp.ph';
    require 'netinet/udp.ph';
    if((defined(&NBPFILTER) ? &NBPFILTER : undef) > 0) {
	require 'net/bpf.ph';
    }
    if((defined(&NVLAN) ? &NVLAN : undef) > 0) {
	require 'net/if_types.ph';
	require 'net/if_vlan_var.ph';
    }
    require 'uvm/uvm_extern.ph';
    require 'dev/rndvar.ph';
    require 'dev/pci/pcireg.ph';
    require 'dev/pci/pcivar.ph';
    require 'dev/pci/pcidevs.ph';
    require 'dev/pci/ixgbe_type.ph';
    eval 'sub DBG () {0;}' unless defined(&DBG);
    eval 'sub MSGOUT {
        my($S, $A, $B) = @_;
	    eval q( &printf($S \\"\\\\n\\", $A, $B));
    }' unless defined(&MSGOUT);
    eval 'sub DEBUGFUNC {
        my($F) = @_;
	    eval q( &DEBUGOUT($F););
    }' unless defined(&DEBUGFUNC);
    if((defined(&DBG) ? &DBG : undef)) {
	eval 'sub DEBUGOUT {
	    my($S) = @_;
    	    eval q( &printf($S));
	}' unless defined(&DEBUGOUT);
	eval 'sub DEBUGOUT1 {
	    my($S,$A) = @_;
    	    eval q( &printf($S,$A));
	}' unless defined(&DEBUGOUT1);
	eval 'sub DEBUGOUT2 {
	    my($S,$A,$B) = @_;
    	    eval q( &printf($S,$A,$B));
	}' unless defined(&DEBUGOUT2);
	eval 'sub DEBUGOUT3 {
	    my($S,$A,$B,$C) = @_;
    	    eval q( &printf($S,$A,$B,$C));
	}' unless defined(&DEBUGOUT3);
	eval 'sub DEBUGOUT6 {
	    my($S,$A,$B,$C,$D,$E,$F) = @_;
    	    eval q( &printf($S,$A,$B,$C,$D,$E,$F));
	}' unless defined(&DEBUGOUT6);
	eval 'sub DEBUGOUT7 {
	    my($S,$A,$B,$C,$D,$E,$F,$G) = @_;
    	    eval q( &printf($S,$A,$B,$C,$D,$E,$F,$G));
	}' unless defined(&DEBUGOUT7);
    } else {
	eval 'sub DEBUGOUT {
	    my($S) = @_;
    	    eval q();
	}' unless defined(&DEBUGOUT);
	eval 'sub DEBUGOUT1 {
	    my($S,$A) = @_;
    	    eval q();
	}' unless defined(&DEBUGOUT1);
	eval 'sub DEBUGOUT2 {
	    my($S,$A,$B) = @_;
    	    eval q();
	}' unless defined(&DEBUGOUT2);
	eval 'sub DEBUGOUT3 {
	    my($S,$A,$B,$C) = @_;
    	    eval q();
	}' unless defined(&DEBUGOUT3);
	eval 'sub DEBUGOUT6 {
	    my($S,$A,$B,$C,$D,$E,$F) = @_;
    	    eval q();
	}' unless defined(&DEBUGOUT6);
	eval 'sub DEBUGOUT7 {
	    my($S,$A,$B,$C,$D,$E,$F,$G) = @_;
    	    eval q();
	}' unless defined(&DEBUGOUT7);
    }
    eval 'sub FALSE () {0;}' unless defined(&FALSE);
    eval 'sub TRUE () {1;}' unless defined(&TRUE);
    eval 'sub CMD_MEM_WRT_INVALIDATE () {0x10;}' unless defined(&CMD_MEM_WRT_INVALIDATE);
    eval 'sub PCI_COMMAND_REGISTER () { &PCIR_COMMAND;}' unless defined(&PCI_COMMAND_REGISTER);
    eval 'sub PCIR_BAR {
        my($_x) = @_;
	    eval q((0x10 + ($_x) * 4));
    }' unless defined(&PCIR_BAR);
    eval 'sub roundup2 {
        my($size, $unit) = @_;
	    eval q(((($size) + ($unit) - 1) & ~(($unit) - 1)));
    }' unless defined(&roundup2);
    eval 'sub usec_delay {
        my($x) = @_;
	    eval q( &delay($x));
    }' unless defined(&usec_delay);
    eval 'sub msec_delay {
        my($x) = @_;
	    eval q( &delay(1000* ($x)));
    }' unless defined(&msec_delay);
    eval 'sub IXGBE_READ_PCIE_WORD () { &ixgbe_read_pci_cfg;}' unless defined(&IXGBE_READ_PCIE_WORD);
    eval 'sub IXGBE_WRITE_PCIE_WORD () { &ixgbe_write_pci_cfg;}' unless defined(&IXGBE_WRITE_PCIE_WORD);
    eval 'sub IXGBE_WRITE_FLUSH {
        my($a) = @_;
	    eval q( &IXGBE_READ_REG($a,  &IXGBE_STATUS));
    }' unless defined(&IXGBE_WRITE_FLUSH);
    eval 'sub IXGBE_READ_REG {
        my($a, $reg) = @_;
	    eval q( &bus_space_read_4((($a)-> &back)-> &os_memt, (($a)-> &back)-> &os_memh, $reg));
    }' unless defined(&IXGBE_READ_REG);
    eval 'sub IXGBE_WRITE_REG {
        my($a, $reg, $value) = @_;
	    eval q( &bus_space_write_4((($a)-> &back)-> &os_memt, (($a)-> &back)-> &os_memh, $reg, $value));
    }' unless defined(&IXGBE_WRITE_REG);
    eval 'sub IXGBE_READ_REG_ARRAY {
        my($a, $reg, $offset) = @_;
	    eval q( &bus_space_read_4((($a)-> &back)-> &os_memt, (($a)-> &back)-> &os_memh, ($reg + (($offset) << 2))));
    }' unless defined(&IXGBE_READ_REG_ARRAY);
    eval 'sub IXGBE_WRITE_REG_ARRAY {
        my($a, $reg, $offset, $value) = @_;
	    eval q( &bus_space_write_4((($a)-> &back)-> &os_memt, (($a)-> &back)-> &os_memh, ($reg + (($offset) << 2)), $value));
    }' unless defined(&IXGBE_WRITE_REG_ARRAY);
    eval 'sub IXGBE_WRITE_REG64 {
        my($hw, $reg, $value) = @_;
	    eval q( &do {  &IXGBE_WRITE_REG($hw, $reg, ( &uint32_t) $value);  &IXGBE_WRITE_REG($hw, $reg + 4, ( &uint32_t) ($value >> 32)); }  &while (0));
    }' unless defined(&IXGBE_WRITE_REG64);
}
1;
