require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_POWERPC_CPU_H_)) {
    eval 'sub _POWERPC_CPU_H_ () {1;}' unless defined(&_POWERPC_CPU_H_);
    require 'machine/frame.ph';
    require 'sys/device.ph';
    require 'sys/lock.ph';
    require 'sys/sched.ph';
    eval 'sub CI_IACTIVE_PROCESSING_SOFT () {1;}' unless defined(&CI_IACTIVE_PROCESSING_SOFT);
    eval 'sub CI_IACTIVE_PROCESSING_HARD () {2;}' unless defined(&CI_IACTIVE_PROCESSING_HARD);
    eval 'sub CPUSAVE_LEN () {8;}' unless defined(&CPUSAVE_LEN);
    eval 'sub DISISAVE_LEN () {4;}' unless defined(&DISISAVE_LEN);
    eval 'sub CI_DDB_RUNNING () {0;}' unless defined(&CI_DDB_RUNNING);
    eval 'sub CI_DDB_SHOULDSTOP () {1;}' unless defined(&CI_DDB_SHOULDSTOP);
    eval 'sub CI_DDB_STOPPED () {2;}' unless defined(&CI_DDB_STOPPED);
    eval 'sub CI_DDB_ENTERDDB () {3;}' unless defined(&CI_DDB_ENTERDDB);
    eval 'sub CI_DDB_INDDB () {4;}' unless defined(&CI_DDB_INDDB);
    if(defined(&DIAGNOSTIC)) {
    }
    eval 'sub curcpu {
        my($void) = @_;
	    eval q({ \'struct cpu_info\' * &ci;  &__asm  &volatile (\\"mfsprg %0,0\\" : \\"=r\\"( &ci));  &ci; });
    }' unless defined(&curcpu);
    eval 'sub curpcb () {( &curcpu()-> &ci_curpcb);}' unless defined(&curpcb);
    eval 'sub curpm () {( &curcpu()-> &ci_curpm);}' unless defined(&curpm);
    eval 'sub CPU_INFO_UNIT {
        my($ci) = @_;
	    eval q((($ci)-> &ci_dev ? ($ci)-> ($ci_dev->{dv_unit}) : 0));
    }' unless defined(&CPU_INFO_UNIT);
    if(defined(&MULTIPROCESSOR)) {
	eval 'sub PPC_MAXPROCS () {4;}' unless defined(&PPC_MAXPROCS);
	eval 'sub cpu_number {
	    my($void) = @_;
    	    eval q({ \'int\'  &pir;  &pir =  &curcpu()-> &ci_cpuid;  &pir; });
	}' unless defined(&cpu_number);
	eval 'sub CPU_IS_PRIMARY {
	    my($ci) = @_;
    	    eval q((($ci)-> &ci_cpuid == 0));
	}' unless defined(&CPU_IS_PRIMARY);
	eval 'sub CPU_INFO_ITERATOR () {\'int\';}' unless defined(&CPU_INFO_ITERATOR);
	eval 'sub CPU_INFO_FOREACH {
	    my($cii, $ci) = @_;
    	    eval q( &for ($cii = 0, $ci =  $cpu_info[0]; $cii <  &ncpus; $cii++, $ci++));
	}' unless defined(&CPU_INFO_FOREACH);
    } else {
	eval 'sub PPC_MAXPROCS () {1;}' unless defined(&PPC_MAXPROCS);
	eval 'sub cpu_number () {
	    eval q(0);
	}' unless defined(&cpu_number);
	eval 'sub CPU_IS_PRIMARY {
	    my($ci) = @_;
    	    eval q(1);
	}' unless defined(&CPU_IS_PRIMARY);
	eval 'sub CPU_INFO_ITERATOR () {\'int\';}' unless defined(&CPU_INFO_ITERATOR);
	eval 'sub CPU_INFO_FOREACH {
	    my($cii, $ci) = @_;
    	    eval q( &for ($cii = 0, $ci =  &curcpu(); $ci !=  &NULL; $ci =  &NULL));
	}' unless defined(&CPU_INFO_FOREACH);
	eval 'sub cpu_unidle {
	    my($ci) = @_;
    	    eval q();
	}' unless defined(&cpu_unidle);
    }
    eval 'sub MAXCPUS () { &PPC_MAXPROCS;}' unless defined(&MAXCPUS);
    eval 'sub CLKF_USERMODE {
        my($frame) = @_;
	    eval q(((($frame)-> &srr1 &  &PSL_PR) != 0));
    }' unless defined(&CLKF_USERMODE);
    eval 'sub CLKF_PC {
        my($frame) = @_;
	    eval q((($frame)-> &srr0));
    }' unless defined(&CLKF_PC);
    eval 'sub CLKF_INTR {
        my($frame) = @_;
	    eval q((($frame)-> &depth != 0));
    }' unless defined(&CLKF_INTR);
    eval 'sub PROC_PC {
        my($p) = @_;
	    eval q(( &trapframe($p)-> &srr0));
    }' unless defined(&PROC_PC);
    eval 'sub DELAY {
        my($n) = @_;
	    eval q( &delay($n));
    }' unless defined(&DELAY);
    eval 'sub aston {
        my($p) = @_;
	    eval q((($p)-> ($p_md->{md_astpending}) = 1));
    }' unless defined(&aston);
    eval 'sub need_resched {
        my($ci) = @_;
	    eval q( &do {  ($ci->{ci_want_resched}) = 1;  &if ( ($ci->{ci_curproc}) !=  &NULL)  &aston( ($ci->{ci_curproc})); }  &while (0));
    }' unless defined(&need_resched);
    eval 'sub clear_resched {
        my($ci) = @_;
	    eval q(($ci)-> &ci_want_resched = 0);
    }' unless defined(&clear_resched);
    eval 'sub need_proftick {
        my($p) = @_;
	    eval q( &aston($p));
    }' unless defined(&need_proftick);
    unless(defined(&CACHELINESIZE)) {
	eval 'sub CACHELINESIZE () {32;}' unless defined(&CACHELINESIZE);
    }
    eval 'sub syncicache {
        my($from,$len) = @_;
	    eval q({ \'int\'  &l; \'char\' * &p = $from; $len = $len + ((( &u_int32_t) $from) & ( &CACHELINESIZE - 1));  &l = $len;  &do {  &__asm  &__volatile (\\"dcbst 0,%0\\" :: \\"r\\"( &p));  &p +=  &CACHELINESIZE; }  &while (( &l -=  &CACHELINESIZE) > 0);  &__asm  &__volatile (\\"sync\\");  &p = $from;  &l = $len;  &do {  &__asm  &__volatile (\\"icbi 0,%0\\" :: \\"r\\"( &p));  &p +=  &CACHELINESIZE; }  &while (( &l -=  &CACHELINESIZE) > 0);  &__asm  &__volatile (\\"isync\\"); });
    }' unless defined(&syncicache);
    eval 'sub invdcache {
        my($from,$len) = @_;
	    eval q({ \'int\'  &l; \'char\' * &p = $from; $len = $len + ((( &u_int32_t) $from) & ( &CACHELINESIZE - 1));  &l = $len;  &do {  &__asm  &__volatile (\\"dcbi 0,%0\\" :: \\"r\\"( &p));  &p +=  &CACHELINESIZE; }  &while (( &l -=  &CACHELINESIZE) > 0);  &__asm  &__volatile (\\"sync\\"); });
    }' unless defined(&invdcache);
    eval 'sub FUNC_SPR {
        my($n, $name) = @_;
	    eval q( &static  &__inline  &u_int32_t  &ppc_mf  $name ( &void) {  &u_int32_t  &ret;  &__asm  &__volatile (\\"mfspr %0,\\"  $n : \\"=r\\" ( &ret));  &return  &ret; }  &static  &__inline  &void  &ppc_mt  $name ( &u_int32_t  &val) {  &__asm  &__volatile (\\"mtspr \\" $n \\",%0\\" :: \\"r\\" ( &val)); });
    }' unless defined(&FUNC_SPR);
    eval 'sub ppc_mftbl {
        my($void) = @_;
	    eval q({ \'int\'  &ret;  &__asm  &__volatile (\\"mftb %0\\" : \\"=r\\" ( &ret));  &ret; });
    }' unless defined(&ppc_mftbl);
    eval 'sub ppc_mftb {
        my($void) = @_;
	    eval q({ my $scratch;  &u_int64_t  &tb;  &__asm  &__volatile (\\"1: mftbu %0; mftb %0+1; mftbu %1;\\" \\" cmpw 0,%0,%1; bne 1b\\" : \\"=r\\"( &tb), \\"=r\\"( $scratch));  &tb; });
    }' unless defined(&ppc_mftb);
    eval 'sub ppc_mfmsr {
        my($void) = @_;
	    eval q({ \'int\'  &ret;  &__asm  &__volatile (\\"mfmsr %0\\" : \\"=r\\" ( &ret));  &ret; });
    }' unless defined(&ppc_mfmsr);
    eval 'sub ppc_mtmsr {
        my($val) = @_;
	    eval q({  &__asm  &__volatile (\\"mtmsr %0\\" :: \\"r\\" ($val)); });
    }' unless defined(&ppc_mtmsr);
    eval 'sub ppc_mtsrin {
        my($val,$sn_shifted) = @_;
	    eval q({  &__asm  &__volatile (\\"mtsrin %0,%1\\" :: \\"r\\"($val), \\"r\\"($sn_shifted)); });
    }' unless defined(&ppc_mtsrin);
    require 'machine/psl.ph';
    eval 'sub ppc_intr_disable {
        my($void) = @_;
	    eval q({  &u_int32_t  &emsr,  &dmsr;  &emsr =  &ppc_mfmsr();  &dmsr =  &emsr & ~ &PSL_EE;  &ppc_mtmsr( &dmsr); ( &emsr &  &PSL_EE); });
    }' unless defined(&ppc_intr_disable);
    eval 'sub PPC_CPU_MPC601 () {1;}' unless defined(&PPC_CPU_MPC601);
    eval 'sub PPC_CPU_MPC603 () {3;}' unless defined(&PPC_CPU_MPC603);
    eval 'sub PPC_CPU_MPC604 () {4;}' unless defined(&PPC_CPU_MPC604);
    eval 'sub PPC_CPU_MPC603e () {6;}' unless defined(&PPC_CPU_MPC603e);
    eval 'sub PPC_CPU_MPC603ev () {7;}' unless defined(&PPC_CPU_MPC603ev);
    eval 'sub PPC_CPU_MPC750 () {8;}' unless defined(&PPC_CPU_MPC750);
    eval 'sub PPC_CPU_MPC604ev () {9;}' unless defined(&PPC_CPU_MPC604ev);
    eval 'sub PPC_CPU_MPC7400 () {12;}' unless defined(&PPC_CPU_MPC7400);
    eval 'sub PPC_CPU_IBM970FX () {0x3c;}' unless defined(&PPC_CPU_IBM970FX);
    eval 'sub PPC_CPU_IBM970MP () {0x44;}' unless defined(&PPC_CPU_IBM970MP);
    eval 'sub PPC_CPU_IBM750FX () {0x7000;}' unless defined(&PPC_CPU_IBM750FX);
    eval 'sub PPC_CPU_MPC7410 () {0x800c;}' unless defined(&PPC_CPU_MPC7410);
    eval 'sub PPC_CPU_MPC7447A () {0x8003;}' unless defined(&PPC_CPU_MPC7447A);
    eval 'sub PPC_CPU_MPC7448 () {0x8004;}' unless defined(&PPC_CPU_MPC7448);
    eval 'sub PPC_CPU_MPC7450 () {0x8000;}' unless defined(&PPC_CPU_MPC7450);
    eval 'sub PPC_CPU_MPC7455 () {0x8001;}' unless defined(&PPC_CPU_MPC7455);
    eval 'sub PPC_CPU_MPC7457 () {0x8002;}' unless defined(&PPC_CPU_MPC7457);
    if(defined(&MULTIPROCESSOR)  && defined(&_KERNEL)) {
	require 'sys/mplock.ph';
    }
}
1;
