require '_h2ph_pre.ph';

no warnings qw(redefine misc);

if(defined(&__OpenBSD__)) {
    eval 'sub Static () {1;}' unless defined(&Static);
} else {
    eval 'sub Static () { &static;}' unless defined(&Static);
}
unless(defined(&PIPEX_PPTP)) {
    sub PIPEX_PPTP () {	1;}
}
unless(defined(&PIPEX_L2TP)) {
    sub PIPEX_L2TP () {	1;}
}
unless(defined(&PIPEX_PPPOE)) {
    sub PIPEX_PPPOE () {	1;}
}
unless(defined(&PIPEX_MPPE)) {
    sub PIPEX_MPPE () {	1;}
}
unless(defined(&PIPEX_REWIND_LIMIT)) {
    sub PIPEX_REWIND_LIMIT () {	64;}
}
unless(defined(&PIPEX_ENABLED)) {
    sub PIPEX_ENABLED () {	0x1;}
}
unless(defined(&LOG_PPPAC)) {
    eval 'sub LOG_PPPAC () { &LOG_KERN;}' unless defined(&LOG_PPPAC);
}
unless(defined(&PIPEX_MAX_SESSION)) {
    eval 'sub PIPEX_MAX_SESSION () {512;}' unless defined(&PIPEX_MAX_SESSION);
}
unless(defined(&PIPEX_HASH_DIV)) {
    sub PIPEX_HASH_DIV () {	8;}
}
unless(defined(&PIPEX_HASH_SIZE)) {
    sub PIPEX_HASH_SIZE () {	( &PIPEX_MAX_SESSION/ &PIPEX_HASH_DIV);}
}
unless(defined(&PIPEX_HASH_MASK)) {
    sub PIPEX_HASH_MASK () {	( &PIPEX_HASH_SIZE-1);}
}
unless(defined(&PIPEX_CLOSE_TIMEOUT)) {
    sub PIPEX_CLOSE_TIMEOUT () {	30;}
}
unless(defined(&PIPEX_DEQUEUE_LIMIT)) {
    sub PIPEX_DEQUEUE_LIMIT () {	( &IFQ_MAXLEN >> 1);}
}
unless(defined(&PIPEX_PPPMINLEN)) {
    sub PIPEX_PPPMINLEN () {	5;}
}
unless(defined(&NNBY)) {
    eval 'sub NNBY () {8;}' unless defined(&NNBY);
}
unless(defined(&PIPEX_MPPE_NOLDKEY)) {
    sub PIPEX_MPPE_NOLDKEY () {	64;}
}
unless(defined(&PIPEX_MPPE_OLDKEYMASK)) {
    sub PIPEX_MPPE_OLDKEYMASK () {	( &PIPEX_MPPE_NOLDKEY - 1);}
}
if(defined(&PIPEX_MPPE)) {
}
if(defined(&PIPEX_PPPOE)) {
}
if(defined(&PIPEX_PPTP)) {
}
if(defined(&PIPEX_L2TP)) {
}
unless(defined(&PIPEX_STATE_INITIAL)) {
    sub PIPEX_STATE_INITIAL () {	0x;}
}
unless(defined(&PIPEX_STATE_OPENED)) {
    sub PIPEX_STATE_OPENED () {	0x1;}
}
unless(defined(&PIPEX_STATE_CLOSE_WAIT)) {
    sub PIPEX_STATE_CLOSE_WAIT () {	0x2;}
}
unless(defined(&PIPEX_STATE_CLOSED)) {
    sub PIPEX_STATE_CLOSED () {	0x3;}
}
if(defined(&PIPEX_MPPE)) {
}
if(defined(&PIPEX_PPPOE)) {
}
if(defined(&PIPEX_PPTP)) {
}
if(defined(&PIPEX_L2TP)) {
}
unless(defined(&PIPEX_GRE_KFLAG)) {
    sub PIPEX_GRE_KFLAG () {	0x2000;}
}
unless(defined(&PIPEX_GRE_SFLAG)) {
    sub PIPEX_GRE_SFLAG () {	0x1000;}
}
unless(defined(&PIPEX_GRE_AFLAG)) {
    sub PIPEX_GRE_AFLAG () {	0x80;}
}
unless(defined(&PIPEX_GRE_VER)) {
    sub PIPEX_GRE_VER () {	0x1;}
}
unless(defined(&PIPEX_GRE_VERMASK)) {
    sub PIPEX_GRE_VERMASK () {	0x3;}
}
unless(defined(&PIPEX_GRE_PROTO_PPP)) {
    sub PIPEX_GRE_PROTO_PPP () {	0x880b;}
}
unless(defined(&PIPEX_PPPOE_VERTYPE)) {
    sub PIPEX_PPPOE_VERTYPE () {	0x11;}
}
unless(defined(&PIPEX_PPPOE_CODE_SESSION)) {
    sub PIPEX_PPPOE_CODE_SESSION () {	0x;}
}
unless(defined(&PIPEX_L2TP_FLAG_MASK)) {
    sub PIPEX_L2TP_FLAG_MASK () {	0xfff0;}
}
unless(defined(&PIPEX_L2TP_FLAG_TYPE)) {
    sub PIPEX_L2TP_FLAG_TYPE () {	0x8000;}
}
unless(defined(&PIPEX_L2TP_FLAG_LENGTH)) {
    sub PIPEX_L2TP_FLAG_LENGTH () {	0x4000;}
}
unless(defined(&PIPEX_L2TP_FLAG_SEQUENCE)) {
    sub PIPEX_L2TP_FLAG_SEQUENCE () {	0x800;}
}
unless(defined(&PIPEX_L2TP_FLAG_OFFSET)) {
    sub PIPEX_L2TP_FLAG_OFFSET () {	0x200;}
}
unless(defined(&PIPEX_L2TP_FLAG_PRIORITY)) {
    sub PIPEX_L2TP_FLAG_PRIORITY () {	0x100;}
}
unless(defined(&PIPEX_L2TP_VER_MASK)) {
    sub PIPEX_L2TP_VER_MASK () {	0xf;}
}
unless(defined(&PIPEX_L2TP_VER)) {
    sub PIPEX_L2TP_VER () {	2;}
}
if(defined(&PIPEX_DEBUG)) {
    eval 'sub PIPEX_DBG {
        my($a) = @_;
	    eval q( &if ( &pipex_debug & 1)  &pipex_session_log $a);
    }' unless defined(&PIPEX_DBG);
    eval 'sub PIPEX_MPPE_DBG {
        my($a) = @_;
	    eval q();
    }' unless defined(&PIPEX_MPPE_DBG);
} else {
    eval 'sub PIPEX_DBG {
        my($a) = @_;
	    eval q();
    }' unless defined(&PIPEX_DBG);
    eval 'sub PIPEX_MPPE_DBG {
        my($a) = @_;
	    eval q();
    }' unless defined(&PIPEX_MPPE_DBG);
}
unless(defined(&PIPEX_ID_HASHTABLE)) {
    sub PIPEX_ID_HASHTABLE {
	my($key) = @_;
	eval q(( $pipex_id_hashtable[($key) &  &PIPEX_HASH_MASK]));
    }
}
unless(defined(&PIPEX_PEER_ADDR_HASHTABLE)) {
    sub PIPEX_PEER_ADDR_HASHTABLE {
	my($key) = @_;
	eval q(( $pipex_peer_addr_hashtable[($key) &  &PIPEX_HASH_MASK]));
    }
}
unless(defined(&GETCHAR)) {
    sub GETCHAR {
	my($c, $cp) = @_;
	eval q( &do { ($c) = *($cp)++; }  &while (0));
    }
}
unless(defined(&PUTCHAR)) {
    sub PUTCHAR {
	my($s, $cp) = @_;
	eval q( &do { *++ = ($s); }  &while (0));
    }
}
unless(defined(&GETSHORT)) {
    sub GETSHORT {
	my($s, $cp) = @_;
	eval q( &do { ($s) = *($cp)++ << 8; ($s) |= *($cp)++; }  &while (0));
    }
}
unless(defined(&PUTSHORT)) {
    sub PUTSHORT {
	my($s, $cp) = @_;
	eval q( &do { *++ = ( >> 8); *++ = ($s); }  &while (0));
    }
}
unless(defined(&GETLONG)) {
    sub GETLONG {
	my($l, $cp) = @_;
	eval q( &do { ($l) = *($cp)++ << 8; ($l) |= *($cp)++; ($l) <<= 8; ($l) |= *($cp)++; ($l) <<= 8; ($l) |= *($cp)++; }  &while (0));
    }
}
unless(defined(&PUTLONG)) {
    sub PUTLONG {
	my($l, $cp) = @_;
	eval q( &do { *++ = ( >> 24); *++ = ( >> 16); *++ = ( >> 8); *++ = ($l); }  &while (0));
    }
}
unless(defined(&PIPEX_PULLUP)) {
    sub PIPEX_PULLUP {
	my($m0, $l) = @_;
	eval q( &if (($m0)-> &m_len < ($l)) {  &if (($m0)-> ($m_pkthdr->{len}) < ($l)) {  &PIPEX_DBG(( &NULL,  &LOG_DEBUG, \"<%s> received packet is too short.\",  &__func__));  &m_freem($m0); ($m0) =  &NULL; }  &else { ($m0) =  &m_pullup(($m0), ($l));  &KASSERT(($m0) !=  &NULL); } });
    }
}
unless(defined(&PIPEX_SEEK_NEXTHDR)) {
    sub PIPEX_SEEK_NEXTHDR {
	my($ptr, $len, $t) = @_;
	eval q((($t) (($ptr) + $len)));
    }
}
unless(defined(&SEQ32_LT)) {
    sub SEQ32_LT {
	my($a,$b) = @_;
	eval q(((($a) - ($b)) < 0));
    }
}
unless(defined(&SEQ32_LE)) {
    sub SEQ32_LE {
	my($a,$b) = @_;
	eval q(((($a) - ($b)) <= 0));
    }
}
unless(defined(&SEQ32_GT)) {
    sub SEQ32_GT {
	my($a,$b) = @_;
	eval q(((($a) - ($b)) > 0));
    }
}
unless(defined(&SEQ32_GE)) {
    sub SEQ32_GE {
	my($a,$b) = @_;
	eval q(((($a) - ($b)) >= 0));
    }
}
unless(defined(&SEQ32_SUB)) {
    sub SEQ32_SUB {
	my($a,$b) = @_;
	eval q((( &int32_t)(($a) - ($b))));
    }
}
unless(defined(&SEQ16_LT)) {
    sub SEQ16_LT {
	my($a,$b) = @_;
	eval q(((($a) - ($b)) < 0));
    }
}
unless(defined(&SEQ16_LE)) {
    sub SEQ16_LE {
	my($a,$b) = @_;
	eval q(((($a) - ($b)) <= 0));
    }
}
unless(defined(&SEQ16_GT)) {
    sub SEQ16_GT {
	my($a,$b) = @_;
	eval q(((($a) - ($b)) > 0));
    }
}
unless(defined(&SEQ16_GE)) {
    sub SEQ16_GE {
	my($a,$b) = @_;
	eval q(((($a) - ($b)) >= 0));
    }
}
unless(defined(&SEQ16_SUB)) {
    sub SEQ16_SUB {
	my($a,$b) = @_;
	eval q((( &int16_t)(($a) - ($b))));
    }
}
unless(defined(&RUPDIV)) {
    sub RUPDIV {
	my($n,$d) = @_;
	eval q(((($n) + ($d) - (($n) % ($d))) / ($d)));
    }
}
unless(defined(&pipex_session_is_acfc_accepted)) {
    sub pipex_session_is_acfc_accepted {
	my($s) = @_;
	eval q(((($s)-> &ppp_flags &  &PIPEX_PPP_ACFC_ACCEPTED)? 1: 0));
    }
}
unless(defined(&pipex_session_is_pfc_accepted)) {
    sub pipex_session_is_pfc_accepted {
	my($s) = @_;
	eval q(((($s)-> &ppp_flags &  &PIPEX_PPP_PFC_ACCEPTED)? 1: 0));
    }
}
unless(defined(&pipex_session_is_acfc_enabled)) {
    sub pipex_session_is_acfc_enabled {
	my($s) = @_;
	eval q(((($s)-> &ppp_flags &  &PIPEX_PPP_ACFC_ENABLED)? 1: 0));
    }
}
unless(defined(&pipex_session_is_pfc_enabled)) {
    sub pipex_session_is_pfc_enabled {
	my($s) = @_;
	eval q(((($s)-> &ppp_flags &  &PIPEX_PPP_PFC_ENABLED)? 1: 0));
    }
}
unless(defined(&pipex_session_has_acf)) {
    sub pipex_session_has_acf {
	my($s) = @_;
	eval q(((($s)-> &ppp_flags &  &PIPEX_PPP_HAS_ACF)? 1: 0));
    }
}
unless(defined(&pipex_session_is_mppe_accepted)) {
    sub pipex_session_is_mppe_accepted {
	my($s) = @_;
	eval q(((($s)-> &ppp_flags &  &PIPEX_PPP_MPPE_ACCEPTED)? 1: 0));
    }
}
unless(defined(&pipex_session_is_mppe_enabled)) {
    sub pipex_session_is_mppe_enabled {
	my($s) = @_;
	eval q(((($s)-> &ppp_flags &  &PIPEX_PPP_MPPE_ENABLED)? 1: 0));
    }
}
unless(defined(&pipex_session_is_mppe_required)) {
    sub pipex_session_is_mppe_required {
	my($s) = @_;
	eval q(((($s)-> &ppp_flags &  &PIPEX_PPP_MPPE_REQUIRED)? 1: 0));
    }
}
unless(defined(&pipex_mppe_rc4_keybits)) {
    sub pipex_mppe_rc4_keybits {
	my($r) = @_;
	eval q((($r)-> &keylen << 3));
    }
}
unless(defined(&pipex_session_is_l2tp_data_sequencing_on)) {
    sub pipex_session_is_l2tp_data_sequencing_on {
	my($s) = @_;
	eval q(((($s)-> ($proto->{l2tp}->{option_flags}) &  &PIPEX_L2TP_USE_SEQUENCING) ? 1: 0));
    }
}
unless(defined(&PIPEX_IPGRE_HDRLEN)) {
    sub PIPEX_IPGRE_HDRLEN () {	($sizeof{'struct ip'} + $sizeof{'struct pipex_gre_header'});}
}
unless(defined(&PIPEX_TCP_OPTLEN)) {
    sub PIPEX_TCP_OPTLEN () {	40;}
}
unless(defined(&PIPEX_L2TP_MINLEN)) {
    sub PIPEX_L2TP_MINLEN () {	8;}
}
if(defined(&INET6)) {
}
if(defined(&PIPEX_PPPOE)) {
}
if(defined(&PIPEX_PPTP)) {
}
if(defined(&PIPEX_L2TP)) {
}
if(defined(&PIPEX_MPPE)) {
}
1;
