/*	$OpenBSD: omron12x20.h,v 1.3 2009/06/21 20:30:35 jsg Exp $ */
/*	$NetBSD$	*/
/*
 * Copyright (c) 1992 OMRON Corporation.
 * Copyright (c) 1992, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * OMRON Corporation.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)font.c	8.1 (Berkeley) 6/10/93
 */

/*
 * omron12x20.h
 *
 *	This file is generated from sys/luna68k/font/font.c in 4.4BSD-Lite2.
 */

static u_char omron12x20_data[];

struct wsdisplay_font omron12x20 = {
	"omron12x20",			/* typeface name */
	0,				/* index */
	' ',				/* firstchar */
	'~' - ' ' + 1,			/* numchars */
	WSDISPLAY_FONTENC_ISO,		/* encoding */
	12,				/* width */
	20,				/* height */
	2,				/* stride */
	WSDISPLAY_FONTORDER_L2R,	/* bit order */
	WSDISPLAY_FONTORDER_L2R,	/* byte order */
	NULL,				/* cookie */
	omron12x20_data			/* data */
};

static u_char omron12x20_data[] = {

			/* 0x20   (' ') */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x21   ('!') */
	0x0c, 0x00,	/* ....**...... */
	0x1e, 0x00,	/* ...****..... */
	0x1e, 0x00,	/* ...****..... */
	0x1e, 0x00,	/* ...****..... */
	0x1e, 0x00,	/* ...****..... */
	0x1e, 0x00,	/* ...****..... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0c, 0x00,	/* ....**...... */
	0x1e, 0x00,	/* ...****..... */
	0x0c, 0x00,	/* ....**...... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x22   ('"') */
	0x10, 0x80,	/* ...*....*... */
	0x39, 0xc0,	/* ..***..***.. */
	0x39, 0xc0,	/* ..***..***.. */
	0x18, 0xc0,	/* ...**...**.. */
	0x10, 0x80,	/* ...*....*... */
	0x21, 0x00,	/* ..*....*.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x23   ('#') */
	0x04, 0x80,	/* .....*..*... */
	0x04, 0x80,	/* .....*..*... */
	0x04, 0x80,	/* .....*..*... */
	0x04, 0x80,	/* .....*..*... */
	0x3f, 0xe0,	/* ..*********. */
	0x3f, 0xe0,	/* ..*********. */
	0x09, 0x00,	/* ....*..*.... */
	0x09, 0x00,	/* ....*..*.... */
	0x09, 0x00,	/* ....*..*.... */
	0x09, 0x00,	/* ....*..*.... */
	0x7f, 0xc0,	/* .*********.. */
	0x7f, 0xc0,	/* .*********.. */
	0x12, 0x00,	/* ...*..*..... */
	0x12, 0x00,	/* ...*..*..... */
	0x12, 0x00,	/* ...*..*..... */
	0x12, 0x00,	/* ...*..*..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x24   ('$') */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x1f, 0x80,	/* ...******... */
	0x34, 0xc0,	/* ..**.*..**.. */
	0x64, 0x60,	/* .**..*...**. */
	0x64, 0xe0,	/* .**..*..***. */
	0x34, 0x40,	/* ..**.*...*.. */
	0x3f, 0x00,	/* ..******.... */
	0x0f, 0xc0,	/* ....******.. */
	0x24, 0xc0,	/* ..*..*..**.. */
	0x74, 0x60,	/* .***.*...**. */
	0x64, 0x60,	/* .**..*...**. */
	0x34, 0xc0,	/* ..**.*..**.. */
	0x1f, 0x80,	/* ...******... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x25   ('%') */
	0x00, 0x00,	/* ............ */
	0x38, 0x60,	/* ..***....**. */
	0x6c, 0xc0,	/* .**.**..**.. */
	0x44, 0xc0,	/* .*...*..**.. */
	0x6d, 0x80,	/* .**.**.**... */
	0x39, 0x80,	/* ..***..**... */
	0x03, 0x00,	/* ......**.... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x0c, 0x00,	/* ....**...... */
	0x19, 0xc0,	/* ...**..***.. */
	0x1b, 0x60,	/* ...**.**.**. */
	0x32, 0x20,	/* ..**..*...*. */
	0x33, 0x60,	/* ..**..**.**. */
	0x61, 0xc0,	/* .**....***.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x26   ('&') */
	0x1c, 0x00,	/* ...***...... */
	0x36, 0x00,	/* ..**.**..... */
	0x63, 0x00,	/* .**...**.... */
	0x63, 0x00,	/* .**...**.... */
	0x66, 0x00,	/* .**..**..... */
	0x36, 0x00,	/* ..**.**..... */
	0x3c, 0x00,	/* ..****...... */
	0x3d, 0xc0,	/* ..****.***.. */
	0x6c, 0x80,	/* .**.**..*... */
	0x66, 0x80,	/* .**..**.*... */
	0xc6, 0x80,	/* **...**.*... */
	0xc3, 0x80,	/* **....***... */
	0xc1, 0x80,	/* **.....**... */
	0xc3, 0xa0,	/* **....***.*. */
	0x66, 0xe0,	/* .**..**.***. */
	0x3c, 0x40,	/* ..****...*.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x27   (''') */
	0x18, 0x00,	/* ...**....... */
	0x3c, 0x00,	/* ..****...... */
	0x1c, 0x00,	/* ...***...... */
	0x08, 0x00,	/* ....*....... */
	0x10, 0x00,	/* ...*........ */
	0x20, 0x00,	/* ..*......... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x28   ('(') */
	0x00, 0x40,	/* .........*.. */
	0x00, 0x80,	/* ........*... */
	0x01, 0x80,	/* .......**... */
	0x03, 0x00,	/* ......**.... */
	0x03, 0x00,	/* ......**.... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x03, 0x00,	/* ......**.... */
	0x03, 0x00,	/* ......**.... */
	0x01, 0x80,	/* .......**... */
	0x00, 0x80,	/* ........*... */
	0x00, 0x40,	/* .........*.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x29   (')') */
	0x20, 0x00,	/* ..*......... */
	0x10, 0x00,	/* ...*........ */
	0x18, 0x00,	/* ...**....... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x18, 0x00,	/* ...**....... */
	0x10, 0x00,	/* ...*........ */
	0x20, 0x00,	/* ..*......... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x2A   ('*') */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x04, 0x00,	/* .....*...... */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x64, 0xc0,	/* .**..*..**.. */
	0x64, 0xc0,	/* .**..*..**.. */
	0x35, 0x80,	/* ..**.*.**... */
	0x0e, 0x00,	/* ....***..... */
	0x15, 0x00,	/* ...*.*.*.... */
	0x75, 0xc0,	/* .***.*.***.. */
	0x64, 0xc0,	/* .**..*..**.. */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x04, 0x00,	/* .....*...... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x2B   ('+') */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x7f, 0xe0,	/* .**********. */
	0x7f, 0xe0,	/* .**********. */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x2C   (',') */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0c, 0x00,	/* ....**...... */
	0x1e, 0x00,	/* ...****..... */
	0x0e, 0x00,	/* ....***..... */
	0x04, 0x00,	/* .....*...... */
	0x08, 0x00,	/* ....*....... */
	0x10, 0x00,	/* ...*........ */

			/* 0x2D   ('-') */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x7f, 0xc0,	/* .*********.. */
	0x7f, 0xc0,	/* .*********.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x2E   ('.') */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x04, 0x00,	/* .....*...... */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x04, 0x00,	/* .....*...... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x2F   ('/') */
	0x00, 0x20,	/* ..........*. */
	0x00, 0x60,	/* .........**. */
	0x00, 0x40,	/* .........*.. */
	0x00, 0xc0,	/* ........**.. */
	0x01, 0x80,	/* .......**... */
	0x03, 0x00,	/* ......**.... */
	0x02, 0x00,	/* ......*..... */
	0x06, 0x00,	/* .....**..... */
	0x0c, 0x00,	/* ....**...... */
	0x08, 0x00,	/* ....*....... */
	0x18, 0x00,	/* ...**....... */
	0x30, 0x00,	/* ..**........ */
	0x60, 0x00,	/* .**......... */
	0x40, 0x00,	/* .*.......... */
	0xc0, 0x00,	/* **.......... */
	0x80, 0x00,	/* *........... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x30   ('0') */
	0x0f, 0x00,	/* ....****.... */
	0x30, 0xc0,	/* ..**....**.. */
	0x20, 0x40,	/* ..*......*.. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x20, 0x40,	/* ..*......*.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x0f, 0x00,	/* ....****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x31   ('1') */
	0x02, 0x00,	/* ......*..... */
	0x06, 0x00,	/* .....**..... */
	0x1e, 0x00,	/* ...****..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x1f, 0x80,	/* ...******... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x32   ('2') */
	0x0f, 0x80,	/* ....*****... */
	0x38, 0xc0,	/* ..***...**.. */
	0x30, 0x60,	/* ..**.....**. */
	0x60, 0x60,	/* .**......**. */
	0x70, 0x60,	/* .***.....**. */
	0x70, 0xc0,	/* .***....**.. */
	0x21, 0x80,	/* ..*....**... */
	0x03, 0x00,	/* ......**.... */
	0x06, 0x00,	/* .....**..... */
	0x0c, 0x00,	/* ....**...... */
	0x18, 0x00,	/* ...**....... */
	0x30, 0x00,	/* ..**........ */
	0x60, 0x20,	/* .**.......*. */
	0x60, 0x60,	/* .**......**. */
	0x7f, 0xc0,	/* .*********.. */
	0x7f, 0xc0,	/* .*********.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x33   ('3') */
	0x1f, 0x00,	/* ...*****.... */
	0x31, 0xc0,	/* ..**...***.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0x60,	/* .**......**. */
	0x70, 0x60,	/* .***.....**. */
	0x20, 0x40,	/* ..*......*.. */
	0x00, 0xc0,	/* ........**.. */
	0x0f, 0x80,	/* ....*****... */
	0x00, 0xc0,	/* ........**.. */
	0x00, 0x60,	/* .........**. */
	0x20, 0x60,	/* ..*......**. */
	0x70, 0x60,	/* .***.....**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0xc0,	/* .**.....**.. */
	0x39, 0xc0,	/* ..***..***.. */
	0x1f, 0x00,	/* ...*****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x34   ('4') */
	0x01, 0x80,	/* .......**... */
	0x03, 0x80,	/* ......***... */
	0x03, 0x80,	/* ......***... */
	0x05, 0x80,	/* .....*.**... */
	0x05, 0x80,	/* .....*.**... */
	0x09, 0x80,	/* ....*..**... */
	0x09, 0x80,	/* ....*..**... */
	0x11, 0x80,	/* ...*...**... */
	0x11, 0x80,	/* ...*...**... */
	0x21, 0x80,	/* ..*....**... */
	0x21, 0x80,	/* ..*....**... */
	0x7f, 0xe0,	/* .**********. */
	0x7f, 0xe0,	/* .**********. */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x07, 0xe0,	/* .....******. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x35   ('5') */
	0x3f, 0xe0,	/* ..*********. */
	0x3f, 0xc0,	/* ..********.. */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x37, 0x00,	/* ..**.***.... */
	0x38, 0xc0,	/* ..***...**.. */
	0x30, 0x40,	/* ..**.....*.. */
	0x30, 0x60,	/* ..**.....**. */
	0x00, 0x60,	/* .........**. */
	0x00, 0x60,	/* .........**. */
	0x20, 0x60,	/* ..*......**. */
	0x70, 0x60,	/* .***.....**. */
	0x70, 0x40,	/* .***.....*.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x30, 0x80,	/* ..**....*... */
	0x0f, 0x00,	/* ....****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x36   ('6') */
	0x0f, 0x00,	/* ....****.... */
	0x30, 0xc0,	/* ..**....**.. */
	0x20, 0x40,	/* ..*......*.. */
	0x60, 0xe0,	/* .**.....***. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x6f, 0x00,	/* .**.****.... */
	0x70, 0xc0,	/* .***....**.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x20, 0x40,	/* ..*......*.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x0f, 0x00,	/* ....****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x37   ('7') */
	0x3f, 0xe0,	/* ..*********. */
	0x3f, 0xe0,	/* ..*********. */
	0x30, 0x40,	/* ..**.....*.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x40, 0x80,	/* .*......*... */
	0x01, 0x80,	/* .......**... */
	0x03, 0x00,	/* ......**.... */
	0x03, 0x00,	/* ......**.... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x38   ('8') */
	0x0f, 0x00,	/* ....****.... */
	0x30, 0xc0,	/* ..**....**.. */
	0x20, 0x40,	/* ..*......*.. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x40,	/* .**......*.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x3f, 0x80,	/* ..*******... */
	0x1f, 0x80,	/* ...******... */
	0x31, 0xc0,	/* ..**...***.. */
	0x20, 0xc0,	/* ..*.....**.. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x40,	/* .**......*.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x0f, 0x00,	/* ....****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x39   ('9') */
	0x0f, 0x00,	/* ....****.... */
	0x30, 0xc0,	/* ..**....**.. */
	0x20, 0x40,	/* ..*......*.. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x20, 0x60,	/* ..*......**. */
	0x30, 0xe0,	/* ..**....***. */
	0x0f, 0x60,	/* ....****.**. */
	0x00, 0x60,	/* .........**. */
	0x00, 0x60,	/* .........**. */
	0x20, 0x60,	/* ..*......**. */
	0x70, 0x60,	/* .***.....**. */
	0x60, 0x40,	/* .**......*.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x0f, 0x00,	/* ....****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x3A   (':') */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x06, 0x00,	/* .....**..... */
	0x0f, 0x00,	/* ....****.... */
	0x06, 0x00,	/* .....**..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x06, 0x00,	/* .....**..... */
	0x0f, 0x00,	/* ....****.... */
	0x06, 0x00,	/* .....**..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x3B   (';') */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x06, 0x00,	/* .....**..... */
	0x0f, 0x00,	/* ....****.... */
	0x06, 0x00,	/* .....**..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x06, 0x00,	/* .....**..... */
	0x0f, 0x00,	/* ....****.... */
	0x07, 0x00,	/* .....***.... */
	0x02, 0x00,	/* ......*..... */
	0x04, 0x00,	/* .....*...... */
	0x08, 0x00,	/* ....*....... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x3C   ('<') */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0xc0,	/* ........**.. */
	0x03, 0xc0,	/* ......****.. */
	0x0f, 0x00,	/* ....****.... */
	0x3c, 0x00,	/* ..****...... */
	0x70, 0x00,	/* .***........ */
	0x3c, 0x00,	/* ..****...... */
	0x0f, 0x00,	/* ....****.... */
	0x03, 0xc0,	/* ......****.. */
	0x00, 0xc0,	/* ........**.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x3D   ('=') */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x7f, 0xe0,	/* .**********. */
	0x7f, 0xe0,	/* .**********. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x7f, 0xe0,	/* .**********. */
	0x7f, 0xe0,	/* .**********. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x3E   ('>') */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x30, 0x00,	/* ..**........ */
	0x3c, 0x00,	/* ..****...... */
	0x0f, 0x00,	/* ....****.... */
	0x03, 0xc0,	/* ......****.. */
	0x00, 0xe0,	/* ........***. */
	0x03, 0xc0,	/* ......****.. */
	0x0f, 0x00,	/* ....****.... */
	0x3c, 0x00,	/* ..****...... */
	0x30, 0x00,	/* ..**........ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x3F   ('?') */
	0x0e, 0x00,	/* ....***..... */
	0x3f, 0x80,	/* ..*******... */
	0x31, 0x80,	/* ..**...**... */
	0x78, 0xc0,	/* .****...**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x01, 0x80,	/* .......**... */
	0x03, 0x00,	/* ......**.... */
	0x02, 0x00,	/* ......*..... */
	0x06, 0x00,	/* .....**..... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x04, 0x00,	/* .....*...... */
	0x0e, 0x00,	/* ....***..... */
	0x04, 0x00,	/* .....*...... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x40   ('@') */
	0x00, 0x00,	/* ............ */
	0x0e, 0x00,	/* ....***..... */
	0x3f, 0x80,	/* ..*******... */
	0x60, 0xc0,	/* .**.....**.. */
	0xc0, 0x60,	/* **.......**. */
	0xc7, 0x20,	/* **...***..*. */
	0xcf, 0xa0,	/* **..*****.*. */
	0xd9, 0xa0,	/* **.**..**.*. */
	0xd9, 0xa0,	/* **.**..**.*. */
	0xd9, 0xa0,	/* **.**..**.*. */
	0xdf, 0xe0,	/* **.********. */
	0xcf, 0x40,	/* **..****.*.. */
	0x60, 0x00,	/* .**......... */
	0x70, 0x60,	/* .***.....**. */
	0x3f, 0xc0,	/* ..********.. */
	0x0f, 0x00,	/* ....****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x41   ('A') */
	0x00, 0x00,	/* ............ */
	0x04, 0x00,	/* .....*...... */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x0a, 0x00,	/* ....*.*..... */
	0x13, 0x00,	/* ...*..**.... */
	0x13, 0x00,	/* ...*..**.... */
	0x13, 0x00,	/* ...*..**.... */
	0x21, 0x80,	/* ..*....**... */
	0x21, 0x80,	/* ..*....**... */
	0x3f, 0x80,	/* ..*******... */
	0x21, 0x80,	/* ..*....**... */
	0x40, 0xc0,	/* .*......**.. */
	0x40, 0xc0,	/* .*......**.. */
	0x40, 0xc0,	/* .*......**.. */
	0xe1, 0xe0,	/* ***....****. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x42   ('B') */
	0x00, 0x00,	/* ............ */
	0xff, 0x00,	/* ********.... */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0x40,	/* ..**.....*.. */
	0x30, 0x60,	/* ..**.....**. */
	0x30, 0x40,	/* ..**.....*.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x3f, 0x80,	/* ..*******... */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0x40,	/* ..**.....*.. */
	0x30, 0x60,	/* ..**.....**. */
	0x30, 0x60,	/* ..**.....**. */
	0x30, 0x60,	/* ..**.....**. */
	0x30, 0x40,	/* ..**.....*.. */
	0x30, 0xc0,	/* ..**....**.. */
	0xff, 0x00,	/* ********.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x43   ('C') */
	0x00, 0x00,	/* ............ */
	0x0f, 0x20,	/* ....****..*. */
	0x30, 0xe0,	/* ..**....***. */
	0x20, 0x60,	/* ..*......**. */
	0x60, 0x20,	/* .**.......*. */
	0x60, 0x20,	/* .**.......*. */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x20,	/* .**.......*. */
	0x60, 0x20,	/* .**.......*. */
	0x20, 0x40,	/* ..*......*.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x0f, 0x00,	/* ....****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x44   ('D') */
	0x00, 0x00,	/* ............ */
	0xfe, 0x00,	/* *******..... */
	0x31, 0x80,	/* ..**...**... */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0x40,	/* ..**.....*.. */
	0x30, 0x60,	/* ..**.....**. */
	0x30, 0x60,	/* ..**.....**. */
	0x30, 0x60,	/* ..**.....**. */
	0x30, 0x60,	/* ..**.....**. */
	0x30, 0x60,	/* ..**.....**. */
	0x30, 0x60,	/* ..**.....**. */
	0x30, 0x60,	/* ..**.....**. */
	0x30, 0x40,	/* ..**.....*.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x31, 0x80,	/* ..**...**... */
	0xfe, 0x00,	/* *******..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x45   ('E') */
	0x00, 0x00,	/* ............ */
	0xff, 0xc0,	/* **********.. */
	0x30, 0x40,	/* ..**.....*.. */
	0x30, 0x40,	/* ..**.....*.. */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x80,	/* ..**....*... */
	0x30, 0x80,	/* ..**....*... */
	0x3f, 0x80,	/* ..*******... */
	0x30, 0x80,	/* ..**....*... */
	0x30, 0x80,	/* ..**....*... */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x20,	/* ..**......*. */
	0x30, 0x20,	/* ..**......*. */
	0x30, 0x20,	/* ..**......*. */
	0xff, 0xe0,	/* ***********. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x46   ('F') */
	0x00, 0x00,	/* ............ */
	0xff, 0xe0,	/* ***********. */
	0x30, 0x20,	/* ..**......*. */
	0x30, 0x20,	/* ..**......*. */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x80,	/* ..**....*... */
	0x30, 0x80,	/* ..**....*... */
	0x3f, 0x80,	/* ..*******... */
	0x30, 0x80,	/* ..**....*... */
	0x30, 0x80,	/* ..**....*... */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0xfc, 0x00,	/* ******...... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x47   ('G') */
	0x00, 0x00,	/* ............ */
	0x0f, 0x20,	/* ....****..*. */
	0x30, 0xe0,	/* ..**....***. */
	0x20, 0x60,	/* ..*......**. */
	0x60, 0x20,	/* .**.......*. */
	0x60, 0x20,	/* .**.......*. */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x61, 0xf0,	/* .**....***** */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x20, 0xe0,	/* ..*.....***. */
	0x31, 0x60,	/* ..**...*.**. */
	0x0e, 0x20,	/* ....***...*. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x48   ('H') */
	0x00, 0x00,	/* ............ */
	0xf0, 0xf0,	/* ****....**** */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x7f, 0xe0,	/* .**********. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0xf0, 0xf0,	/* ****....**** */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x49   ('I') */
	0x00, 0x00,	/* ............ */
	0x1f, 0x80,	/* ...******... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x1f, 0x80,	/* ...******... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x4A   ('J') */
	0x00, 0x00,	/* ............ */
	0x07, 0xe0,	/* .....******. */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x41, 0x80,	/* .*.....**... */
	0xe1, 0x80,	/* ***....**... */
	0xc1, 0x80,	/* **.....**... */
	0x41, 0x00,	/* .*.....*.... */
	0x63, 0x00,	/* .**...**.... */
	0x1c, 0x00,	/* ...***...... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x4B   ('K') */
	0x00, 0x00,	/* ............ */
	0xf1, 0xc0,	/* ****...***.. */
	0x60, 0x80,	/* .**.....*... */
	0x61, 0x00,	/* .**....*.... */
	0x62, 0x00,	/* .**...*..... */
	0x64, 0x00,	/* .**..*...... */
	0x6c, 0x00,	/* .**.**...... */
	0x7c, 0x00,	/* .*****...... */
	0x76, 0x00,	/* .***.**..... */
	0x66, 0x00,	/* .**..**..... */
	0x63, 0x00,	/* .**...**.... */
	0x63, 0x00,	/* .**...**.... */
	0x61, 0x80,	/* .**....**... */
	0x61, 0x80,	/* .**....**... */
	0x60, 0xc0,	/* .**.....**.. */
	0xf1, 0xe0,	/* ****...****. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x4C   ('L') */
	0x00, 0x00,	/* ............ */
	0x78, 0x00,	/* .****....... */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x20,	/* ..**......*. */
	0x30, 0x20,	/* ..**......*. */
	0x30, 0x20,	/* ..**......*. */
	0xff, 0xe0,	/* ***********. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x4D   ('M') */
	0x00, 0x00,	/* ............ */
	0xe0, 0x70,	/* ***......*** */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0xe0,	/* .**.....***. */
	0x70, 0xe0,	/* .***....***. */
	0x70, 0xe0,	/* .***....***. */
	0x59, 0xe0,	/* .*.**..****. */
	0x59, 0x60,	/* .*.**..*.**. */
	0x59, 0x60,	/* .*.**..*.**. */
	0x4a, 0x60,	/* .*..*.*..**. */
	0x4e, 0x60,	/* .*..***..**. */
	0x4e, 0x60,	/* .*..***..**. */
	0x44, 0x60,	/* .*...*...**. */
	0x44, 0x60,	/* .*...*...**. */
	0xe4, 0xf0,	/* ***..*..**** */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x4E   ('N') */
	0x00, 0x00,	/* ............ */
	0x71, 0xf0,	/* .***...***** */
	0x30, 0x40,	/* ..**.....*.. */
	0x30, 0x40,	/* ..**.....*.. */
	0x38, 0x40,	/* ..***....*.. */
	0x38, 0x40,	/* ..***....*.. */
	0x2c, 0x40,	/* ..*.**...*.. */
	0x2c, 0x40,	/* ..*.**...*.. */
	0x26, 0x40,	/* ..*..**..*.. */
	0x26, 0x40,	/* ..*..**..*.. */
	0x23, 0x40,	/* ..*...**.*.. */
	0x23, 0x40,	/* ..*...**.*.. */
	0x21, 0xc0,	/* ..*....***.. */
	0x21, 0xc0,	/* ..*....***.. */
	0x20, 0xc0,	/* ..*.....**.. */
	0xf8, 0xc0,	/* *****...**.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x4F   ('O') */
	0x00, 0x00,	/* ............ */
	0x0f, 0x00,	/* ....****.... */
	0x39, 0xc0,	/* ..***..***.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x30, 0xc0,	/* ..**....**.. */
	0x39, 0xc0,	/* ..***..***.. */
	0x0f, 0x00,	/* ....****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x50   ('P') */
	0x00, 0x00,	/* ............ */
	0xff, 0x00,	/* ********.... */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0x40,	/* ..**.....*.. */
	0x30, 0x60,	/* ..**.....**. */
	0x30, 0x60,	/* ..**.....**. */
	0x30, 0x40,	/* ..**.....*.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x3f, 0x00,	/* ..******.... */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0xfc, 0x00,	/* ******...... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x51   ('Q') */
	0x00, 0x00,	/* ............ */
	0x0f, 0x00,	/* ....****.... */
	0x30, 0xc0,	/* ..**....**.. */
	0x20, 0x40,	/* ..*......*.. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x62, 0x60,	/* .**...*..**. */
	0x6f, 0x40,	/* .**.****.*.. */
	0x29, 0xc0,	/* ..*.*..***.. */
	0x31, 0x90,	/* ..**...**..* */
	0x0f, 0x90,	/* ....*****..* */
	0x00, 0xe0,	/* ........***. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x52   ('R') */
	0x00, 0x00,	/* ............ */
	0xff, 0x00,	/* ********.... */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0x40,	/* ..**.....*.. */
	0x30, 0x60,	/* ..**.....**. */
	0x30, 0x40,	/* ..**.....*.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x3f, 0x00,	/* ..******.... */
	0x31, 0x80,	/* ..**...**... */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0xfc, 0x70,	/* ******...*** */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x53   ('S') */
	0x00, 0x00,	/* ............ */
	0x0f, 0x20,	/* ....****..*. */
	0x31, 0xe0,	/* ..**...****. */
	0x20, 0x60,	/* ..*......**. */
	0x60, 0x20,	/* .**.......*. */
	0x60, 0x00,	/* .**......... */
	0x30, 0x00,	/* ..**........ */
	0x38, 0x00,	/* ..***....... */
	0x0f, 0x00,	/* ....****.... */
	0x01, 0xc0,	/* .......***.. */
	0x40, 0xc0,	/* .*......**.. */
	0x40, 0x60,	/* .*.......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x40,	/* .**......*.. */
	0x70, 0xc0,	/* .***....**.. */
	0x4f, 0x00,	/* .*..****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x54   ('T') */
	0x00, 0x00,	/* ............ */
	0x7f, 0xe0,	/* .**********. */
	0x46, 0x20,	/* .*...**...*. */
	0x46, 0x20,	/* .*...**...*. */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x1f, 0x80,	/* ...******... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x55   ('U') */
	0x00, 0x00,	/* ............ */
	0xf0, 0xf0,	/* ****....**** */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x20, 0x40,	/* ..*......*.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x0f, 0x00,	/* ....****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x56   ('V') */
	0x00, 0x00,	/* ............ */
	0xf0, 0xe0,	/* ****....***. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x30, 0x80,	/* ..**....*... */
	0x30, 0x80,	/* ..**....*... */
	0x30, 0x80,	/* ..**....*... */
	0x31, 0x00,	/* ..**...*.... */
	0x19, 0x00,	/* ...**..*.... */
	0x19, 0x00,	/* ...**..*.... */
	0x19, 0x00,	/* ...**..*.... */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x57   ('W') */
	0x00, 0x00,	/* ............ */
	0xf7, 0x70,	/* ****.***.*** */
	0x62, 0x20,	/* .**...*...*. */
	0x62, 0x20,	/* .**...*...*. */
	0x62, 0x20,	/* .**...*...*. */
	0x63, 0x20,	/* .**...**..*. */
	0x37, 0x40,	/* ..**.***.*.. */
	0x37, 0x40,	/* ..**.***.*.. */
	0x37, 0x40,	/* ..**.***.*.. */
	0x35, 0x40,	/* ..**.*.*.*.. */
	0x35, 0xc0,	/* ..**.*.***.. */
	0x35, 0xc0,	/* ..**.*.***.. */
	0x19, 0x80,	/* ...**..**... */
	0x19, 0x80,	/* ...**..**... */
	0x18, 0x80,	/* ...**...*... */
	0x18, 0x80,	/* ...**...*... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x58   ('X') */
	0x00, 0x00,	/* ............ */
	0xf0, 0x70,	/* ****.....*** */
	0x60, 0x20,	/* .**.......*. */
	0x30, 0x40,	/* ..**.....*.. */
	0x30, 0x80,	/* ..**....*... */
	0x18, 0x80,	/* ...**...*... */
	0x0d, 0x00,	/* ....**.*.... */
	0x0e, 0x00,	/* ....***..... */
	0x06, 0x00,	/* .....**..... */
	0x07, 0x00,	/* .....***.... */
	0x0b, 0x00,	/* ....*.**.... */
	0x11, 0x80,	/* ...*...**... */
	0x20, 0xc0,	/* ..*.....**.. */
	0x20, 0xc0,	/* ..*.....**.. */
	0x40, 0x60,	/* .*.......**. */
	0xe0, 0xf0,	/* ***.....**** */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x59   ('Y') */
	0x00, 0x00,	/* ............ */
	0xf0, 0x70,	/* ****.....*** */
	0x60, 0x20,	/* .**.......*. */
	0x30, 0x40,	/* ..**.....*.. */
	0x30, 0x40,	/* ..**.....*.. */
	0x18, 0x80,	/* ...**...*... */
	0x19, 0x00,	/* ...**..*.... */
	0x0d, 0x00,	/* ....**.*.... */
	0x0e, 0x00,	/* ....***..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x1f, 0x80,	/* ...******... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x5A   ('Z') */
	0x00, 0x00,	/* ............ */
	0x7f, 0xe0,	/* .**********. */
	0x40, 0x60,	/* .*.......**. */
	0x40, 0xc0,	/* .*......**.. */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x03, 0x00,	/* ......**.... */
	0x06, 0x00,	/* .....**..... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x18, 0x00,	/* ...**....... */
	0x30, 0x00,	/* ..**........ */
	0x60, 0x20,	/* .**.......*. */
	0x60, 0x20,	/* .**.......*. */
	0xc0, 0x20,	/* **........*. */
	0xff, 0xe0,	/* ***********. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x5B   ('[') */
	0x07, 0xe0,	/* .....******. */
	0x07, 0xe0,	/* .....******. */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x07, 0xe0,	/* .....******. */
	0x07, 0xe0,	/* .....******. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x5C   ('\') */
	0x40, 0x00,	/* .*.......... */
	0x60, 0x00,	/* .**......... */
	0x20, 0x00,	/* ..*......... */
	0x30, 0x00,	/* ..**........ */
	0x10, 0x00,	/* ...*........ */
	0x18, 0x00,	/* ...**....... */
	0x0c, 0x00,	/* ....**...... */
	0x04, 0x00,	/* .....*...... */
	0x06, 0x00,	/* .....**..... */
	0x02, 0x00,	/* ......*..... */
	0x03, 0x00,	/* ......**.... */
	0x01, 0x80,	/* .......**... */
	0x00, 0x80,	/* ........*... */
	0x00, 0xc0,	/* ........**.. */
	0x00, 0x40,	/* .........*.. */
	0x00, 0x60,	/* .........**. */
	0x00, 0x20,	/* ..........*. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x5D   (']') */
	0x7e, 0x00,	/* .******..... */
	0x7e, 0x00,	/* .******..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x7e, 0x00,	/* .******..... */
	0x7e, 0x00,	/* .******..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x5E   ('^') */
	0x04, 0x00,	/* .....*...... */
	0x0e, 0x00,	/* ....***..... */
	0x1b, 0x00,	/* ...**.**.... */
	0x31, 0x80,	/* ..**...**... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x5F   ('_') */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xff, 0xf0,	/* ************ */
	0xff, 0xf0,	/* ************ */

			/* 0x60   ('`') */
	0x04, 0x00,	/* .....*...... */
	0x0c, 0x00,	/* ....**...... */
	0x06, 0x00,	/* .....**..... */
	0x02, 0x00,	/* ......*..... */
	0x01, 0x00,	/* .......*.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x61   ('a') */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0e, 0x00,	/* ....***..... */
	0x33, 0x00,	/* ..**..**.... */
	0x71, 0x80,	/* .***...**... */
	0x01, 0x80,	/* .......**... */
	0x0f, 0x80,	/* ....*****... */
	0x31, 0x80,	/* ..**...**... */
	0x61, 0x80,	/* .**....**... */
	0x61, 0x80,	/* .**....**... */
	0x61, 0x80,	/* .**....**... */
	0x33, 0x90,	/* ..**..***..* */
	0x1c, 0xe0,	/* ...***..***. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x62   ('b') */
	0x00, 0x00,	/* ............ */
	0x78, 0x00,	/* .****....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x1b, 0x00,	/* ...**.**.... */
	0x1c, 0xc0,	/* ...***..**.. */
	0x18, 0x40,	/* ...**....*.. */
	0x18, 0x60,	/* ...**....**. */
	0x18, 0x60,	/* ...**....**. */
	0x18, 0x60,	/* ...**....**. */
	0x18, 0x60,	/* ...**....**. */
	0x18, 0x40,	/* ...**....*.. */
	0x1c, 0xc0,	/* ...***..**.. */
	0x13, 0x00,	/* ...*..**.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x63   ('c') */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x06, 0x00,	/* .....**..... */
	0x19, 0x80,	/* ...**..**... */
	0x10, 0x80,	/* ...*....*... */
	0x31, 0xc0,	/* ..**...***.. */
	0x30, 0x80,	/* ..**....*... */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x40,	/* ..**.....*.. */
	0x10, 0x80,	/* ...*....*... */
	0x19, 0x80,	/* ...**..**... */
	0x06, 0x00,	/* .....**..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x64   ('d') */
	0x00, 0x00,	/* ............ */
	0x07, 0x80,	/* .....****... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x0d, 0x80,	/* ....**.**... */
	0x33, 0x80,	/* ..**..***... */
	0x21, 0x80,	/* ..*....**... */
	0x61, 0x80,	/* .**....**... */
	0x61, 0x80,	/* .**....**... */
	0x61, 0x80,	/* .**....**... */
	0x61, 0x80,	/* .**....**... */
	0x21, 0x80,	/* ..*....**... */
	0x33, 0x80,	/* ..**..***... */
	0x0d, 0xe0,	/* ....**.****. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x65   ('e') */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x06, 0x00,	/* .....**..... */
	0x19, 0x80,	/* ...**..**... */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x3f, 0xc0,	/* ..********.. */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x40,	/* ..**.....*.. */
	0x18, 0x80,	/* ...**...*... */
	0x07, 0x00,	/* .....***.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x66   ('f') */
	0x00, 0x00,	/* ............ */
	0x03, 0x80,	/* ......***... */
	0x06, 0x40,	/* .....**..*.. */
	0x06, 0x60,	/* .....**..**. */
	0x06, 0x40,	/* .....**..*.. */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x3f, 0xc0,	/* ..********.. */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x1f, 0x80,	/* ...******... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x67   ('g') */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x60,	/* .........**. */
	0x00, 0xe0,	/* ........***. */
	0x0f, 0x80,	/* ....*****... */
	0x19, 0x80,	/* ...**..**... */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x39, 0x80,	/* ..***..**... */
	0x1f, 0x00,	/* ...*****.... */
	0x30, 0x00,	/* ..**........ */
	0x20, 0x00,	/* ..*......... */
	0x3f, 0x00,	/* ..******.... */
	0x3f, 0xc0,	/* ..********.. */
	0x60, 0xe0,	/* .**.....***. */
	0x60, 0x60,	/* .**......**. */
	0x30, 0xc0,	/* ..**....**.. */
	0x1f, 0x80,	/* ...******... */

			/* 0x68   ('h') */
	0x00, 0x00,	/* ............ */
	0x70, 0x00,	/* .***........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x36, 0x00,	/* ..**.**..... */
	0x39, 0x80,	/* ..***..**... */
	0x30, 0x80,	/* ..**....*... */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x79, 0xe0,	/* .****..****. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x69   ('i') */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0e, 0x00,	/* ....***..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x0f, 0x00,	/* ....****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x6A   ('j') */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x03, 0x00,	/* ......**.... */
	0x03, 0x00,	/* ......**.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x07, 0x00,	/* .....***.... */
	0x03, 0x00,	/* ......**.... */
	0x03, 0x00,	/* ......**.... */
	0x03, 0x00,	/* ......**.... */
	0x03, 0x00,	/* ......**.... */
	0x03, 0x00,	/* ......**.... */
	0x03, 0x00,	/* ......**.... */
	0x03, 0x00,	/* ......**.... */
	0x23, 0x00,	/* ..*...**.... */
	0x73, 0x00,	/* .***..**.... */
	0x63, 0x00,	/* .**...**.... */
	0x36, 0x00,	/* ..**.**..... */
	0x1c, 0x00,	/* ...***...... */
	0x00, 0x00,	/* ............ */

			/* 0x6B   ('k') */
	0x00, 0x00,	/* ............ */
	0xf0, 0x00,	/* ****........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x31, 0xe0,	/* ..**...****. */
	0x30, 0x80,	/* ..**....*... */
	0x31, 0x00,	/* ..**...*.... */
	0x36, 0x00,	/* ..**.**..... */
	0x3c, 0x00,	/* ..****...... */
	0x3e, 0x00,	/* ..*****..... */
	0x33, 0x00,	/* ..**..**.... */
	0x33, 0x00,	/* ..**..**.... */
	0x31, 0x80,	/* ..**...**... */
	0x30, 0xc0,	/* ..**....**.. */
	0x79, 0xf0,	/* .****..***** */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x6C   ('l') */
	0x00, 0x00,	/* ............ */
	0x1e, 0x00,	/* ...****..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x1f, 0x80,	/* ...******... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x6D   ('m') */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xec, 0xc0,	/* ***.**..**.. */
	0x77, 0x60,	/* .***.***.**. */
	0x66, 0x60,	/* .**..**..**. */
	0x66, 0x60,	/* .**..**..**. */
	0x66, 0x60,	/* .**..**..**. */
	0x66, 0x60,	/* .**..**..**. */
	0x66, 0x60,	/* .**..**..**. */
	0x66, 0x60,	/* .**..**..**. */
	0x66, 0x60,	/* .**..**..**. */
	0x66, 0x60,	/* .**..**..**. */
	0xff, 0xf0,	/* ************ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x6E   ('n') */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x66, 0x00,	/* .**..**..... */
	0x39, 0x80,	/* ..***..**... */
	0x30, 0x80,	/* ..**....*... */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x79, 0xe0,	/* .****..****. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x6F   ('o') */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x06, 0x00,	/* .....**..... */
	0x19, 0x80,	/* ...**..**... */
	0x10, 0x80,	/* ...*....*... */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x10, 0x80,	/* ...*....*... */
	0x19, 0x80,	/* ...**..**... */
	0x06, 0x00,	/* .....**..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x70   ('p') */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x7b, 0x00,	/* .****.**.... */
	0x1c, 0xc0,	/* ...***..**.. */
	0x18, 0x40,	/* ...**....*.. */
	0x18, 0x60,	/* ...**....**. */
	0x18, 0x60,	/* ...**....**. */
	0x18, 0x60,	/* ...**....**. */
	0x18, 0x60,	/* ...**....**. */
	0x18, 0x40,	/* ...**....*.. */
	0x1c, 0xc0,	/* ...***..**.. */
	0x1b, 0x00,	/* ...**.**.... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x7e, 0x00,	/* .******..... */

			/* 0x71   ('q') */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0c, 0x80,	/* ....**..*... */
	0x33, 0x80,	/* ..**..***... */
	0x21, 0x80,	/* ..*....**... */
	0x61, 0x80,	/* .**....**... */
	0x61, 0x80,	/* .**....**... */
	0x61, 0x80,	/* .**....**... */
	0x61, 0x80,	/* .**....**... */
	0x21, 0x80,	/* ..*....**... */
	0x33, 0x80,	/* ..**..***... */
	0x0d, 0x80,	/* ....**.**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x07, 0xe0,	/* .....******. */

			/* 0x72   ('r') */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x79, 0x80,	/* .****..**... */
	0x1a, 0x40,	/* ...**.*..*.. */
	0x1a, 0x40,	/* ...**.*..*.. */
	0x1c, 0xe0,	/* ...***..***. */
	0x1c, 0x40,	/* ...***...*.. */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x7e, 0x00,	/* .******..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x73   ('s') */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x1e, 0x40,	/* ...****..*.. */
	0x31, 0xc0,	/* ..**...***.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x70, 0x40,	/* .***.....*.. */
	0x3c, 0x00,	/* ..****...... */
	0x1f, 0x00,	/* ...*****.... */
	0x47, 0x80,	/* .*...****... */
	0x41, 0xc0,	/* .*.....***.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x71, 0x80,	/* .***...**... */
	0x4f, 0x00,	/* .*..****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x74   ('t') */
	0x00, 0x00,	/* ............ */
	0x04, 0x00,	/* .....*...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x1c, 0x00,	/* ...***...... */
	0x7f, 0x80,	/* .********... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x80,	/* ....**..*... */
	0x0c, 0x80,	/* ....**..*... */
	0x0c, 0x80,	/* ....**..*... */
	0x07, 0x00,	/* .....***.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x75   ('u') */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xf3, 0xc0,	/* ****..****.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x10, 0xc0,	/* ...*....**.. */
	0x19, 0xc0,	/* ...**..***.. */
	0x06, 0xf0,	/* .....**.**** */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x76   ('v') */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xf9, 0xe0,	/* *****..****. */
	0x30, 0x80,	/* ..**....*... */
	0x30, 0x80,	/* ..**....*... */
	0x19, 0x00,	/* ...**..*.... */
	0x19, 0x00,	/* ...**..*.... */
	0x19, 0x00,	/* ...**..*.... */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x77   ('w') */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xff, 0xf0,	/* ************ */
	0x66, 0x60,	/* .**..**..**. */
	0x66, 0x60,	/* .**..**..**. */
	0x26, 0x40,	/* ..*..**..*.. */
	0x3f, 0xc0,	/* ..********.. */
	0x39, 0xc0,	/* ..***..***.. */
	0x39, 0xc0,	/* ..***..***.. */
	0x39, 0xc0,	/* ..***..***.. */
	0x19, 0x80,	/* ...**..**... */
	0x10, 0x80,	/* ...*....*... */
	0x10, 0x80,	/* ...*....*... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x78   ('x') */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x70, 0xf0,	/* .***....**** */
	0x20, 0x60,	/* ..*......**. */
	0x10, 0xc0,	/* ...*....**.. */
	0x09, 0x80,	/* ....*..**... */
	0x07, 0x00,	/* .....***.... */
	0x06, 0x00,	/* .....**..... */
	0x0d, 0x00,	/* ....**.*.... */
	0x18, 0x80,	/* ...**...*... */
	0x30, 0x40,	/* ..**.....*.. */
	0x60, 0x20,	/* .**.......*. */
	0xf0, 0x70,	/* ****.....*** */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x79   ('y') */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x78, 0x70,	/* .****....*** */
	0x30, 0x20,	/* ..**......*. */
	0x18, 0x20,	/* ...**.....*. */
	0x18, 0x40,	/* ...**....*.. */
	0x18, 0x40,	/* ...**....*.. */
	0x0c, 0x40,	/* ....**...*.. */
	0x0c, 0x80,	/* ....**..*... */
	0x06, 0x80,	/* .....**.*... */
	0x07, 0x80,	/* .....****... */
	0x07, 0x00,	/* .....***.... */
	0x07, 0x00,	/* .....***.... */
	0x46, 0x00,	/* .*...**..... */
	0xe6, 0x00,	/* ***..**..... */
	0x4c, 0x00,	/* .*..**...... */
	0x38, 0x00,	/* ..***....... */

			/* 0x7A   ('z') */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x3f, 0xc0,	/* ..********.. */
	0x20, 0xc0,	/* ..*.....**.. */
	0x21, 0x80,	/* ..*....**... */
	0x03, 0x00,	/* ......**.... */
	0x03, 0x00,	/* ......**.... */
	0x06, 0x00,	/* .....**..... */
	0x0c, 0x00,	/* ....**...... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x40,	/* ...**....*.. */
	0x30, 0x40,	/* ..**.....*.. */
	0x7f, 0xc0,	/* .*********.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x7B   ('{') */
	0x00, 0xe0,	/* ........***. */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x03, 0x00,	/* ......**.... */
	0x04, 0x00,	/* .....*...... */
	0x03, 0x00,	/* ......**.... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x00, 0xe0,	/* ........***. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x7C   ('|') */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */

			/* 0x7D   ('}') */
	0x70, 0x00,	/* .***........ */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x0c, 0x00,	/* ....**...... */
	0x02, 0x00,	/* ......*..... */
	0x0c, 0x00,	/* ....**...... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x70, 0x00,	/* .***........ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

			/* 0x7E   ('~') */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x18, 0x10,	/* ...**......* */
	0x3e, 0x60,	/* ..*****..**. */
	0x67, 0xc0,	/* .**..*****.. */
	0x83, 0x00,	/* *.....**.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
};
