require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&HEADER_E_OS_H)) {
    eval 'sub HEADER_E_OS_H () {1;}' unless defined(&HEADER_E_OS_H);
    require 'openssl/opensslconf.ph';
    require 'openssl/e_os2.ph';
    if(defined(&__cplusplus)) {
    }
    if(defined(&REF_PRINT)) {
	undef(&REF_PRINT) if defined(&REF_PRINT);
	eval 'sub REF_PRINT {
	    my($a,$b) = @_;
    	    eval q( &fprintf( &stderr,\\"%08X:%4d:%s\\\\n\\",$b, ($b->{references}),$a));
	}' unless defined(&REF_PRINT);
    }
    unless(defined(&DEVRANDOM)) {
	eval 'sub DEVRANDOM () {"/dev/urandom","/dev/random","/dev/srandom";}' unless defined(&DEVRANDOM);
    }
    unless(defined(&DEVRANDOM_EGD)) {
	eval 'sub DEVRANDOM_EGD () {"/var/run/egd-pool","/dev/egd-pool","/etc/egd-pool","/etc/entropy";}' unless defined(&DEVRANDOM_EGD);
    }
    if(defined(&OPENSSL_SYS_VXWORKS)) {
	eval 'sub NO_SYS_PARAM_H () {1;}' unless defined(&NO_SYS_PARAM_H);
	eval 'sub NO_CHMOD () {1;}' unless defined(&NO_CHMOD);
	eval 'sub NO_SYSLOG () {1;}' unless defined(&NO_SYSLOG);
    }
    if(defined(&OPENSSL_SYS_MACINTOSH_CLASSIC)) {
	if((defined(&macintosh) ? &macintosh : undef)==1) {
	    unless(defined(&MAC_OS_GUSI_SOURCE)) {
		eval 'sub MAC_OS_pre_X () {1;}' unless defined(&MAC_OS_pre_X);
		eval 'sub NO_SYS_TYPES_H () {1;}' unless defined(&NO_SYS_TYPES_H);
	    }
	    eval 'sub NO_SYS_PARAM_H () {1;}' unless defined(&NO_SYS_PARAM_H);
	    eval 'sub NO_CHMOD () {1;}' unless defined(&NO_CHMOD);
	    eval 'sub NO_SYSLOG () {1;}' unless defined(&NO_SYSLOG);
	    undef(&DEVRANDOM) if defined(&DEVRANDOM);
	    eval 'sub GETPID_IS_MEANINGLESS () {1;}' unless defined(&GETPID_IS_MEANINGLESS);
	}
    }
    if(defined(&OPENSSL_SYS_MSDOS)  && !defined(&OPENSSL_SYSNAME_WIN32)) {
	eval 'sub MS_STATIC () { &static;}' unless defined(&MS_STATIC);
    } else {
	eval 'sub MS_STATIC () {1;}' unless defined(&MS_STATIC);
    }
    if(defined(&OPENSSL_SYS_WIN32)  && !defined(&WIN32)) {
	eval 'sub WIN32 () {1;}' unless defined(&WIN32);
    }
    if(defined(&OPENSSL_SYS_WINDOWS)  && !defined(&WINDOWS)) {
	eval 'sub WINDOWS () {1;}' unless defined(&WINDOWS);
    }
    if(defined(&OPENSSL_SYS_MSDOS)  && !defined(&MSDOS)) {
	eval 'sub MSDOS () {1;}' unless defined(&MSDOS);
    }
    if(defined(&MSDOS)  && !defined(&GETPID_IS_MEANINGLESS)) {
	eval 'sub GETPID_IS_MEANINGLESS () {1;}' unless defined(&GETPID_IS_MEANINGLESS);
    }
    if(defined(&WIN32)) {
	eval 'sub get_last_sys_error () {
	    eval q( &GetLastError());
	}' unless defined(&get_last_sys_error);
	eval 'sub clear_sys_error () {
	    eval q( &SetLastError(0));
	}' unless defined(&clear_sys_error);
	if(!defined(&WINNT)) {
	    eval 'sub WIN_CONSOLE_BUG () {1;}' unless defined(&WIN_CONSOLE_BUG);
	}
    } else {
	eval 'sub get_last_sys_error () {
	    eval q( &errno);
	}' unless defined(&get_last_sys_error);
	eval 'sub clear_sys_error () {
	    eval q( &errno=0);
	}' unless defined(&clear_sys_error);
    }
    if(defined(&WINDOWS)) {
	eval 'sub get_last_socket_error () {
	    eval q( &WSAGetLastError());
	}' unless defined(&get_last_socket_error);
	eval 'sub clear_socket_error () {
	    eval q( &WSASetLastError(0));
	}' unless defined(&clear_socket_error);
	eval 'sub readsocket {
	    my($s,$b,$n) = @_;
    	    eval q( &recv(($s),($b),($n),0));
	}' unless defined(&readsocket);
	eval 'sub writesocket {
	    my($s,$b,$n) = @_;
    	    eval q( &send(($s),($b),($n),0));
	}' unless defined(&writesocket);
    }
 elsif(defined(&__DJGPP__)) {
	eval 'sub WATT32 () {1;}' unless defined(&WATT32);
	eval 'sub get_last_socket_error () {
	    eval q( &errno);
	}' unless defined(&get_last_socket_error);
	eval 'sub clear_socket_error () {
	    eval q( &errno=0);
	}' unless defined(&clear_socket_error);
	eval 'sub closesocket {
	    my($s) = @_;
    	    eval q( &close_s($s));
	}' unless defined(&closesocket);
	eval 'sub readsocket {
	    my($s,$b,$n) = @_;
    	    eval q( &read_s($s,$b,$n));
	}' unless defined(&readsocket);
	eval 'sub writesocket {
	    my($s,$b,$n) = @_;
    	    eval q( &send($s,$b,$n,0));
	}' unless defined(&writesocket);
    }
 elsif(defined(&MAC_OS_pre_X)) {
	eval 'sub get_last_socket_error () {
	    eval q( &errno);
	}' unless defined(&get_last_socket_error);
	eval 'sub clear_socket_error () {
	    eval q( &errno=0);
	}' unless defined(&clear_socket_error);
	eval 'sub closesocket {
	    my($s) = @_;
    	    eval q( &MacSocket_close($s));
	}' unless defined(&closesocket);
	eval 'sub readsocket {
	    my($s,$b,$n) = @_;
    	    eval q( &MacSocket_recv(($s),($b),($n), &true));
	}' unless defined(&readsocket);
	eval 'sub writesocket {
	    my($s,$b,$n) = @_;
    	    eval q( &MacSocket_send(($s),($b),($n)));
	}' unless defined(&writesocket);
    }
 elsif(defined(&OPENSSL_SYS_VMS)) {
	eval 'sub get_last_socket_error () {
	    eval q( &errno);
	}' unless defined(&get_last_socket_error);
	eval 'sub clear_socket_error () {
	    eval q( &errno=0);
	}' unless defined(&clear_socket_error);
	eval 'sub ioctlsocket {
	    my($a,$b,$c) = @_;
    	    eval q( &ioctl($a,$b,$c));
	}' unless defined(&ioctlsocket);
	eval 'sub closesocket {
	    my($s) = @_;
    	    eval q( &close($s));
	}' unless defined(&closesocket);
	eval 'sub readsocket {
	    my($s,$b,$n) = @_;
    	    eval q( &recv(($s),($b),($n),0));
	}' unless defined(&readsocket);
	eval 'sub writesocket {
	    my($s,$b,$n) = @_;
    	    eval q( &send(($s),($b),($n),0));
	}' unless defined(&writesocket);
    }
 elsif(defined(&OPENSSL_SYS_VXWORKS)) {
	eval 'sub get_last_socket_error () {
	    eval q( &errno);
	}' unless defined(&get_last_socket_error);
	eval 'sub clear_socket_error () {
	    eval q( &errno=0);
	}' unless defined(&clear_socket_error);
	eval 'sub ioctlsocket {
	    my($a,$b,$c) = @_;
    	    eval q( &ioctl(,,($c)));
	}' unless defined(&ioctlsocket);
	eval 'sub closesocket {
	    my($s) = @_;
    	    eval q( &close($s));
	}' unless defined(&closesocket);
	eval 'sub readsocket {
	    my($s,$b,$n) = @_;
    	    eval q( &read(($s),($b),($n)));
	}' unless defined(&readsocket);
	eval 'sub writesocket {
	    my($s,$b,$n) = @_;
    	    eval q( &write(,($b),($n)));
	}' unless defined(&writesocket);
    }
 elsif(defined(&OPENSSL_SYS_BEOS_R5)) {
	eval 'sub get_last_socket_error () {
	    eval q( &errno);
	}' unless defined(&get_last_socket_error);
	eval 'sub clear_socket_error () {
	    eval q( &errno=0);
	}' unless defined(&clear_socket_error);
	eval 'sub FIONBIO () { &SO_NONBLOCK;}' unless defined(&FIONBIO);
	eval 'sub ioctlsocket {
	    my($a,$b,$c) = @_;
    	    eval q( &setsockopt(($a), &SOL_SOCKET,($b),($c),$sizeof{($c)}));
	}' unless defined(&ioctlsocket);
	eval 'sub readsocket {
	    my($s,$b,$n) = @_;
    	    eval q( &recv(($s),($b),($n),0));
	}' unless defined(&readsocket);
	eval 'sub writesocket {
	    my($s,$b,$n) = @_;
    	    eval q( &send(($s),($b),($n),0));
	}' unless defined(&writesocket);
    }
 elsif(defined(&OPENSSL_SYS_NETWARE)) {
	if(defined(&NETWARE_BSDSOCK)) {
	    eval 'sub get_last_socket_error () {
	        eval q( &errno);
	    }' unless defined(&get_last_socket_error);
	    eval 'sub clear_socket_error () {
	        eval q( &errno=0);
	    }' unless defined(&clear_socket_error);
	    eval 'sub closesocket {
	        my($s) = @_;
    		eval q( &close($s));
	    }' unless defined(&closesocket);
	    eval 'sub ioctlsocket {
	        my($a,$b,$c) = @_;
    		eval q( &ioctl($a,$b,$c));
	    }' unless defined(&ioctlsocket);
	    if(defined(&NETWARE_LIBC)) {
		eval 'sub readsocket {
		    my($s,$b,$n) = @_;
    		    eval q( &recv(($s),($b),($n),0));
		}' unless defined(&readsocket);
		eval 'sub writesocket {
		    my($s,$b,$n) = @_;
    		    eval q( &send(($s),($b),($n),0));
		}' unless defined(&writesocket);
	    } else {
		eval 'sub readsocket {
		    my($s,$b,$n) = @_;
    		    eval q( &recv(,($b),($n),0));
		}' unless defined(&readsocket);
		eval 'sub writesocket {
		    my($s,$b,$n) = @_;
    		    eval q( &send(,($b),($n),0));
		}' unless defined(&writesocket);
	    }
	} else {
	    eval 'sub get_last_socket_error () {
	        eval q( &WSAGetLastError());
	    }' unless defined(&get_last_socket_error);
	    eval 'sub clear_socket_error () {
	        eval q( &WSASetLastError(0));
	    }' unless defined(&clear_socket_error);
	    eval 'sub readsocket {
	        my($s,$b,$n) = @_;
    		eval q( &recv(($s),($b),($n),0));
	    }' unless defined(&readsocket);
	    eval 'sub writesocket {
	        my($s,$b,$n) = @_;
    		eval q( &send(($s),($b),($n),0));
	    }' unless defined(&writesocket);
	}
    } else {
	eval 'sub get_last_socket_error () {
	    eval q( &errno);
	}' unless defined(&get_last_socket_error);
	eval 'sub clear_socket_error () {
	    eval q( &errno=0);
	}' unless defined(&clear_socket_error);
	eval 'sub ioctlsocket {
	    my($a,$b,$c) = @_;
    	    eval q( &ioctl($a,$b,$c));
	}' unless defined(&ioctlsocket);
	eval 'sub closesocket {
	    my($s) = @_;
    	    eval q( &close($s));
	}' unless defined(&closesocket);
	eval 'sub readsocket {
	    my($s,$b,$n) = @_;
    	    eval q( &read(($s),($b),($n)));
	}' unless defined(&readsocket);
	eval 'sub writesocket {
	    my($s,$b,$n) = @_;
    	    eval q( &write(($s),($b),($n)));
	}' unless defined(&writesocket);
    }
    if(defined(&WIN16)) {
	eval 'sub MS_CALLBACK () { &_far  &_loadds;}' unless defined(&MS_CALLBACK);
	eval 'sub MS_FAR () { &_far;}' unless defined(&MS_FAR);
    } else {
	eval 'sub MS_CALLBACK () {1;}' unless defined(&MS_CALLBACK);
	eval 'sub MS_FAR () {1;}' unless defined(&MS_FAR);
    }
    if(defined(&OPENSSL_NO_STDIO)) {
	undef(&OPENSSL_NO_FP_API) if defined(&OPENSSL_NO_FP_API);
	eval 'sub OPENSSL_NO_FP_API () {1;}' unless defined(&OPENSSL_NO_FP_API);
    }
    if((defined(&WINDOWS) || defined(&MSDOS))) {
	if(defined(&__DJGPP__)) {
	    require 'unistd.ph';
	    require 'sys/stat.ph';
	    require 'sys/socket.ph';
	    require 'tcp.ph';
	    require 'netdb.ph';
	    eval 'sub _setmode () { &setmode;}' unless defined(&_setmode);
	    eval 'sub _O_TEXT () { &O_TEXT;}' unless defined(&_O_TEXT);
	    eval 'sub _O_BINARY () { &O_BINARY;}' unless defined(&_O_BINARY);
	    undef(&DEVRANDOM) if defined(&DEVRANDOM);
	    eval 'sub DEVRANDOM () {"/dev/urandom\\x24";}' unless defined(&DEVRANDOM);
	}
	unless(defined(&S_IFDIR)) {
	    eval 'sub S_IFDIR () { &_S_IFDIR;}' unless defined(&S_IFDIR);
	}
	unless(defined(&S_IFMT)) {
	    eval 'sub S_IFMT () { &_S_IFMT;}' unless defined(&S_IFMT);
	}
	if(!defined(&WINNT)  && !defined(&__DJGPP__)) {
	    eval 'sub NO_SYSLOG () {1;}' unless defined(&NO_SYSLOG);
	}
	eval 'sub NO_DIRENT () {1;}' unless defined(&NO_DIRENT);
	if(defined(&WINDOWS)) {
	    if(!defined(&_WIN32_WCE)  && !defined(&_WIN32_WINNT)) {
		eval 'sub _WIN32_WINNT () {0x400;}' unless defined(&_WIN32_WINNT);
	    }
	    if(!defined(&OPENSSL_NO_SOCK)  && defined(&_WIN32_WINNT)) {
		require 'winsock2.ph';
		require 'ws2tcpip.ph';
	    }
	    require 'windows.ph';
	    require 'stdio.ph';
	    require 'stddef.ph';
	    require 'errno.ph';
	    require 'string.ph';
	    if(defined(&_WIN64)) {
		eval 'sub strlen {
		    my($s) = @_;
    		    eval q( &_strlen31($s));
		}' unless defined(&strlen);
	    }
	    require 'malloc.ph';
	    if(defined(&_MSC_VER)  && (defined(&_MSC_VER) ? &_MSC_VER : undef)<=1200 && defined(&_MT)  && defined(&isspace)) {
		undef(&isspace) if defined(&isspace);
		undef(&isdigit) if defined(&isdigit);
		undef(&isalnum) if defined(&isalnum);
		undef(&isupper) if defined(&isupper);
		undef(&isxdigit) if defined(&isxdigit);
	    }
	    if(defined(&_MSC_VER)  && !defined(&_DLL)  && defined(&stdin)) {
		if((defined(&_MSC_VER) ? &_MSC_VER : undef)>=1300) {
		    undef(&stdin) if defined(&stdin);
		    undef(&stdout) if defined(&stdout);
		    undef(&stderr) if defined(&stderr);
		    eval 'sub stdin () {(& &__iob_func()[0]);}' unless defined(&stdin);
		    eval 'sub stdout () {(& &__iob_func()[1]);}' unless defined(&stdout);
		    eval 'sub stderr () {(& &__iob_func()[2]);}' unless defined(&stderr);
		}
 elsif(defined(&I_CAN_LIVE_WITH_LNK4049)) {
		    undef(&stdin) if defined(&stdin);
		    undef(&stdout) if defined(&stdout);
		    undef(&stderr) if defined(&stderr);
		    eval 'sub stdin () {(& $_imp___iob[0]);}' unless defined(&stdin);
		    eval 'sub stdout () {(& $_imp___iob[1]);}' unless defined(&stdout);
		    eval 'sub stderr () {(& $_imp___iob[2]);}' unless defined(&stderr);
		}
	    }
	}
	require 'io.ph';
	require 'fcntl.ph';
	if(defined(&OPENSSL_SYS_WINCE)) {
	    eval 'sub OPENSSL_NO_POSIX_IO () {1;}' unless defined(&OPENSSL_NO_POSIX_IO);
	}
	eval 'sub ssize_t () {\'long\';}' unless defined(&ssize_t);
	if(defined (&__BORLANDC__)) {
	    eval 'sub _setmode () { &setmode;}' unless defined(&_setmode);
	    eval 'sub _O_TEXT () { &O_TEXT;}' unless defined(&_O_TEXT);
	    eval 'sub _O_BINARY () { &O_BINARY;}' unless defined(&_O_BINARY);
	    eval 'sub _int64 () { &__int64;}' unless defined(&_int64);
	    eval 'sub _kbhit () { &kbhit;}' unless defined(&_kbhit);
	}
	eval 'sub EXIT {
	    my($n) = @_;
    	    eval q( &exit($n));
	}' unless defined(&EXIT);
	eval 'sub LIST_SEPARATOR_CHAR () {ord(\';\');}' unless defined(&LIST_SEPARATOR_CHAR);
	unless(defined(&X_OK)) {
	    eval 'sub X_OK () {0;}' unless defined(&X_OK);
	}
	unless(defined(&W_OK)) {
	    eval 'sub W_OK () {2;}' unless defined(&W_OK);
	}
	unless(defined(&R_OK)) {
	    eval 'sub R_OK () {4;}' unless defined(&R_OK);
	}
	eval 'sub OPENSSL_CONF () {"openssl.cnf";}' unless defined(&OPENSSL_CONF);
	eval 'sub SSLEAY_CONF () { &OPENSSL_CONF;}' unless defined(&SSLEAY_CONF);
	eval 'sub NUL_DEV () {"nul";}' unless defined(&NUL_DEV);
	eval 'sub RFILE () {".rnd";}' unless defined(&RFILE);
	if(defined(&OPENSSL_SYS_WINCE)) {
	    eval 'sub DEFAULT_HOME () {"";}' unless defined(&DEFAULT_HOME);
	} else {
	    eval 'sub DEFAULT_HOME () {"C:";}' unless defined(&DEFAULT_HOME);
	}
    } else {
	if(defined(&OPENSSL_SYS_VMS)) {
	    eval 'sub VMS () {1;}' unless defined(&VMS);
	    require 'stdlib.ph';
	    if(defined(&__DECC)) {
		require 'unistd.ph';
	    } else {
		require 'unixlib.ph';
	    }
	    eval 'sub OPENSSL_CONF () {"openssl.cnf";}' unless defined(&OPENSSL_CONF);
	    eval 'sub SSLEAY_CONF () { &OPENSSL_CONF;}' unless defined(&SSLEAY_CONF);
	    eval 'sub RFILE () {".rnd";}' unless defined(&RFILE);
	    eval 'sub LIST_SEPARATOR_CHAR () {ord(\',\');}' unless defined(&LIST_SEPARATOR_CHAR);
	    eval 'sub NUL_DEV () {"NLA0:";}' unless defined(&NUL_DEV);
	    undef(&DEVRANDOM) if defined(&DEVRANDOM);
	    eval 'sub EXIT {
	        my($n) = @_;
    		eval q( &do { \'int\'  &__VMS_EXIT = $n;  &if ( &__VMS_EXIT == 0)  &__VMS_EXIT = 1;  &else  &__VMS_EXIT = ($n << 3) | 2;  &__VMS_EXIT |= 0x10000000;  &exit( &__VMS_EXIT); }  &while(0));
	    }' unless defined(&EXIT);
	    eval 'sub NO_SYS_PARAM_H () {1;}' unless defined(&NO_SYS_PARAM_H);
	}
 elsif(defined(&OPENSSL_SYS_NETWARE)) {
	    require 'fcntl.ph';
	    require 'unistd.ph';
	    eval 'sub NO_SYS_TYPES_H () {1;}' unless defined(&NO_SYS_TYPES_H);
	    undef(&DEVRANDOM) if defined(&DEVRANDOM);
	    if(defined(&NETWARE_CLIB)) {
		eval 'sub getpid () { &GetThreadID;}' unless defined(&getpid);
	    } else {
		require 'screen.ph';
	    }
	    eval 'sub NO_SYSLOG () {1;}' unless defined(&NO_SYSLOG);
	    eval 'sub _setmode () { &setmode;}' unless defined(&_setmode);
	    eval 'sub _kbhit () { &kbhit;}' unless defined(&_kbhit);
	    eval 'sub _O_TEXT () { &O_TEXT;}' unless defined(&_O_TEXT);
	    eval 'sub _O_BINARY () { &O_BINARY;}' unless defined(&_O_BINARY);
	    eval 'sub OPENSSL_CONF () {"openssl.cnf";}' unless defined(&OPENSSL_CONF);
	    eval 'sub SSLEAY_CONF () { &OPENSSL_CONF;}' unless defined(&SSLEAY_CONF);
	    eval 'sub RFILE () {".rnd";}' unless defined(&RFILE);
	    eval 'sub LIST_SEPARATOR_CHAR () {ord(\';\');}' unless defined(&LIST_SEPARATOR_CHAR);
	    eval 'sub EXIT {
	        my($n) = @_;
    		eval q({  &if ($n)  &printf(\\"ERROR: %d\\\\n\\", $n);  &exit($n); });
	    }' unless defined(&EXIT);
	} else {
	    if(defined(&OPENSSL_SYS_MPE)) {
		eval 'sub NO_SYS_PARAM_H () {1;}' unless defined(&NO_SYS_PARAM_H);
	    }
	    if(defined(&OPENSSL_UNISTD)) {
	    } else {
		require 'unistd.ph';
	    }
	    unless(defined(&NO_SYS_TYPES_H)) {
		require 'sys/types.ph';
	    }
	    if(defined(&NeXT) || defined(&OPENSSL_SYS_NEWS4)) {
		eval 'sub pid_t () {\'int\';}' unless defined(&pid_t);
	    }
	    if(defined(&NeXT) || defined(&OPENSSL_SYS_NEWS4) || defined(&OPENSSL_SYS_SUNOS)) {
		eval 'sub ssize_t () {\'int\';}' unless defined(&ssize_t);
	    }
	    if(defined(&OPENSSL_SYS_NEWS4)) {
		eval 'sub setvbuf {
		    my($a, $b, $c, $d) = @_;
    		    eval q( &setbuffer(($a), ($b), ($d)));
		}' unless defined(&setvbuf);
	    }
	    if(defined(&OPENSSL_SYS_WIN32_CYGWIN)) {
		require 'io.ph';
		require 'fcntl.ph';
	    }
	    eval 'sub OPENSSL_CONF () {"openssl.cnf";}' unless defined(&OPENSSL_CONF);
	    eval 'sub SSLEAY_CONF () { &OPENSSL_CONF;}' unless defined(&SSLEAY_CONF);
	    eval 'sub RFILE () {".rnd";}' unless defined(&RFILE);
	    eval 'sub LIST_SEPARATOR_CHAR () {ord(\':\');}' unless defined(&LIST_SEPARATOR_CHAR);
	    eval 'sub NUL_DEV () {"/dev/null";}' unless defined(&NUL_DEV);
	    eval 'sub EXIT {
	        my($n) = @_;
    		eval q( &exit($n));
	    }' unless defined(&EXIT);
	}
	eval 'sub SSLeay_getpid () {
	    eval q( &getpid());
	}' unless defined(&SSLeay_getpid);
    }
    if(defined(&USE_SOCKETS)) {
	if(defined(&WINDOWS) || defined(&MSDOS)) {
	    if(defined(&OPENSSL_NO_SOCK)) {
		eval 'sub SSLeay_Write {
		    my($a,$b,$c) = @_;
    		    eval q((-1));
		}' unless defined(&SSLeay_Write);
		eval 'sub SSLeay_Read {
		    my($a,$b,$c) = @_;
    		    eval q((-1));
		}' unless defined(&SSLeay_Read);
		eval 'sub SHUTDOWN {
		    my($fd) = @_;
    		    eval q( &close($fd));
		}' unless defined(&SHUTDOWN);
		eval 'sub SHUTDOWN2 {
		    my($fd) = @_;
    		    eval q( &close($fd));
		}' unless defined(&SHUTDOWN2);
	    }
 elsif(!defined(&__DJGPP__)) {
		if(defined(&_WIN32_WCE)  && (defined(&_WIN32_WCE) ? &_WIN32_WCE : undef)<410) {
		    eval 'sub getservbyname () { &_masked_declaration_getservbyname;}' unless defined(&getservbyname);
		}
		if(!defined(&IPPROTO_IP)) {
		    require 'winsock.ph';
		}
		if(defined(&getservbyname)) {
		    undef(&getservbyname) if defined(&getservbyname);
		}
		if(defined(&_WIN64)) {
		    eval 'sub socket {
		        my($d,$t,$p) = @_;
    			eval q(( &socket($d,$t,$p)));
		    }' unless defined(&socket);
		    eval 'sub accept {
		        my($s,$f,$l) = @_;
    			eval q(( &accept($s,$f,$l)));
		    }' unless defined(&accept);
		}
		eval 'sub SSLeay_Write {
		    my($a,$b,$c) = @_;
    		    eval q( &send(($a),($b),($c),0));
		}' unless defined(&SSLeay_Write);
		eval 'sub SSLeay_Read {
		    my($a,$b,$c) = @_;
    		    eval q( &recv(($a),($b),($c),0));
		}' unless defined(&SSLeay_Read);
		eval 'sub SHUTDOWN {
		    my($fd) = @_;
    		    eval q({  &shutdown(($fd),0);  &closesocket($fd); });
		}' unless defined(&SHUTDOWN);
		eval 'sub SHUTDOWN2 {
		    my($fd) = @_;
    		    eval q({  &shutdown(($fd),2);  &closesocket($fd); });
		}' unless defined(&SHUTDOWN2);
	    } else {
		eval 'sub SSLeay_Write {
		    my($a,$b,$c) = @_;
    		    eval q( &write_s($a,$b,$c,0));
		}' unless defined(&SSLeay_Write);
		eval 'sub SSLeay_Read {
		    my($a,$b,$c) = @_;
    		    eval q( &read_s($a,$b,$c));
		}' unless defined(&SSLeay_Read);
		eval 'sub SHUTDOWN {
		    my($fd) = @_;
    		    eval q( &close_s($fd));
		}' unless defined(&SHUTDOWN);
		eval 'sub SHUTDOWN2 {
		    my($fd) = @_;
    		    eval q( &close_s($fd));
		}' unless defined(&SHUTDOWN2);
	    }
	}
 elsif(defined(&MAC_OS_pre_X)) {
	    require './openssl/MacSocket.ph';
	    eval 'sub SSLeay_Write {
	        my($a,$b,$c) = @_;
    		eval q( &MacSocket_send(($a),($b),($c)));
	    }' unless defined(&SSLeay_Write);
	    eval 'sub SSLeay_Read {
	        my($a,$b,$c) = @_;
    		eval q( &MacSocket_recv(($a),($b),($c), &true));
	    }' unless defined(&SSLeay_Read);
	    eval 'sub SHUTDOWN {
	        my($fd) = @_;
    		eval q( &MacSocket_close($fd));
	    }' unless defined(&SHUTDOWN);
	    eval 'sub SHUTDOWN2 {
	        my($fd) = @_;
    		eval q( &MacSocket_close($fd));
	    }' unless defined(&SHUTDOWN2);
	}
 elsif(defined(&OPENSSL_SYS_NETWARE)) {
	    if(defined(&NETWARE_BSDSOCK)) {
		require 'sys/socket.ph';
		require 'netinet/in.ph';
		require 'sys/time.ph';
		if(defined(&NETWARE_CLIB)) {
		    require 'sys/bsdskt.ph';
		} else {
		    require 'sys/select.ph';
		}
		eval 'sub INVALID_SOCKET () {(~0);}' unless defined(&INVALID_SOCKET);
	    } else {
		require 'novsock2.ph';
	    }
	    eval 'sub SSLeay_Write {
	        my($a,$b,$c) = @_;
    		eval q( &send(($a),($b),($c),0));
	    }' unless defined(&SSLeay_Write);
	    eval 'sub SSLeay_Read {
	        my($a,$b,$c) = @_;
    		eval q( &recv(($a),($b),($c),0));
	    }' unless defined(&SSLeay_Read);
	    eval 'sub SHUTDOWN {
	        my($fd) = @_;
    		eval q({  &shutdown(($fd),0);  &closesocket($fd); });
	    }' unless defined(&SHUTDOWN);
	    eval 'sub SHUTDOWN2 {
	        my($fd) = @_;
    		eval q({  &shutdown(($fd),2);  &closesocket($fd); });
	    }' unless defined(&SHUTDOWN2);
	} else {
	    unless(defined(&NO_SYS_PARAM_H)) {
		require 'sys/param.ph';
	    }
	    if(defined(&OPENSSL_SYS_VXWORKS)) {
		require 'time.ph';
	    }
 elsif(!defined(&OPENSSL_SYS_MPE)) {
		require 'sys/time.ph';
	    }
	    require 'netdb.ph';
	    if(defined(&OPENSSL_SYS_VMS_NODECC)) {
		require 'socket.ph';
		require 'in.ph';
		require 'inet.ph';
	    } else {
		require 'sys/socket.ph';
		if(defined(&FILIO_H)) {
		    require 'sys/filio.ph';
		}
		require 'netinet/in.ph';
		if(!defined(&OPENSSL_SYS_BEOS_R5)) {
		    require 'arpa/inet.ph';
		}
	    }
	    if(defined(&NeXT) || defined(&_NEXT_SOURCE)) {
		require 'sys/fcntl.ph';
		require 'sys/types.ph';
	    }
	    if(defined(&OPENSSL_SYS_AIX)) {
		require 'sys/select.ph';
	    }
	    if(defined(&__QNX__)) {
		require 'sys/select.ph';
	    }
	    if(defined(&sun)) {
		require 'sys/filio.ph';
	    } else {
		unless(defined(&VMS)) {
		    require 'sys/ioctl.ph';
		} else {
		    if(!defined(&TCPIP_TYPE_SOCKETSHR)  && defined(&__VMS_VER)  && ((defined(&__VMS_VER) ? &__VMS_VER : undef) > 70000000)) {
			require 'sys/ioctl.ph';
		    }
		}
	    }
	    if(defined(&VMS)) {
		require 'unixio.ph';
		if(defined(&TCPIP_TYPE_SOCKETSHR)) {
		    require 'socketshr.ph';
		}
	    }
	    eval 'sub SSLeay_Read {
	        my($a,$b,$c) = @_;
    		eval q( &read(($a),($b),($c)));
	    }' unless defined(&SSLeay_Read);
	    eval 'sub SSLeay_Write {
	        my($a,$b,$c) = @_;
    		eval q( &write(($a),($b),($c)));
	    }' unless defined(&SSLeay_Write);
	    eval 'sub SHUTDOWN {
	        my($fd) = @_;
    		eval q({  &shutdown(($fd),0);  &closesocket(($fd)); });
	    }' unless defined(&SHUTDOWN);
	    eval 'sub SHUTDOWN2 {
	        my($fd) = @_;
    		eval q({  &shutdown(($fd),2);  &closesocket(($fd)); });
	    }' unless defined(&SHUTDOWN2);
	    unless(defined(&INVALID_SOCKET)) {
		eval 'sub INVALID_SOCKET () {(-1);}' unless defined(&INVALID_SOCKET);
	    }
	}
	if(!defined(&OPENSSL_USE_IPV6)) {
	    if(defined(&AF_INET6)  && !defined(&OPENSSL_SYS_BEOS_BONE)  && !defined(&NETWARE_CLIB)) {
		eval 'sub OPENSSL_USE_IPV6 () {1;}' unless defined(&OPENSSL_USE_IPV6);
	    } else {
		eval 'sub OPENSSL_USE_IPV6 () {0;}' unless defined(&OPENSSL_USE_IPV6);
	    }
	}
    }
    if(defined(&__ultrix)) {
	unless(defined(&ssize_t)) {
	    eval 'sub ssize_t () {\'int\';}' unless defined(&ssize_t);
	}
    }
    if(defined(&sun)  && !defined(&__svr4__)  && !defined(&__SVR4)) {
	require 'stdlib.ph';
	require 'string.ph';
	eval 'sub memmove {
	    my($s1,$s2,$n) = @_;
    	    eval q( &bcopy(($s2),($s1),($n)));
	}' unless defined(&memmove);
	eval 'sub strtoul {
	    my($s,$e,$b) = @_;
    	    eval q(( &strtol(($s),($e),($b))));
	}' unless defined(&strtoul);
	eval 'sub strerror {
	    my($errnum) = @_;
    	    eval q(((($errnum)<0|| ($errnum)>= &sys_nerr) ?  &NULL :  $sys_errlist[$errnum]));
	}' unless defined(&strerror);
	require 'crypto/o_str.ph';
	eval 'sub memcmp () { &OPENSSL_memcmp;}' unless defined(&memcmp);
    }
    unless(defined(&OPENSSL_EXIT)) {
	if(defined(&MONOLITH)  && !defined(&OPENSSL_C)) {
	    eval 'sub OPENSSL_EXIT {
	        my($n) = @_;
    		eval q( &return($n));
	    }' unless defined(&OPENSSL_EXIT);
	} else {
	    eval 'sub OPENSSL_EXIT {
	        my($n) = @_;
    		eval q( &do {  &EXIT($n);  &return($n); }  &while(0));
	    }' unless defined(&OPENSSL_EXIT);
	}
    }
    eval 'sub DG_GCC_BUG () {1;}' unless defined(&DG_GCC_BUG);
    if(defined(&sgi)) {
	eval 'sub IRIX_CC_BUG () {1;}' unless defined(&IRIX_CC_BUG);
    }
    if(defined(&OPENSSL_SYS_SNI)) {
	eval 'sub IRIX_CC_BUG () {1;}' unless defined(&IRIX_CC_BUG);
    }
    if(defined(&OPENSSL_SYS_WINDOWS)) {
	eval 'sub strcasecmp () { &_stricmp;}' unless defined(&strcasecmp);
	eval 'sub strncasecmp () { &_strnicmp;}' unless defined(&strncasecmp);
    }
 elsif(defined(&OPENSSL_SYS_VMS)) {
	require './openssl/o_str.ph';
	eval 'sub strcasecmp () { &OPENSSL_strcasecmp;}' unless defined(&strcasecmp);
	eval 'sub strncasecmp () { &OPENSSL_strncasecmp;}' unless defined(&strncasecmp);
	eval 'sub OPENSSL_IMPLEMENTS_strncasecmp () {1;}' unless defined(&OPENSSL_IMPLEMENTS_strncasecmp);
    }
 elsif(defined(&OPENSSL_SYS_OS2)  && defined(&__EMX__)) {
	eval 'sub strcasecmp () { &stricmp;}' unless defined(&strcasecmp);
	eval 'sub strncasecmp () { &strnicmp;}' unless defined(&strncasecmp);
    }
 elsif(defined(&OPENSSL_SYS_NETWARE)) {
	require 'string.ph';
	if(defined(&NETWARE_CLIB)) {
	    eval 'sub strcasecmp () { &stricmp;}' unless defined(&strcasecmp);
	    eval 'sub strncasecmp () { &strnicmp;}' unless defined(&strncasecmp);
	}
    }
    if(defined(&OPENSSL_SYS_OS2)  && defined(&__EMX__)) {
	require 'io.ph';
	require 'fcntl.ph';
	eval 'sub NO_SYSLOG () {1;}' unless defined(&NO_SYSLOG);
    }
    if(defined(&OPENSSL_SYS_VXWORKS)) {
	require 'ioLib.ph';
	require 'tickLib.ph';
	require 'sysLib.ph';
	eval 'sub TTY_STRUCT () {\'int\';}' unless defined(&TTY_STRUCT);
	eval 'sub sleep {
	    my($a) = @_;
    	    eval q( &taskDelay(($a) *  &sysClkRateGet()));
	}' unless defined(&sleep);
	require 'vxWorks.ph';
	require 'sockLib.ph';
	require 'taskLib.ph';
	eval 'sub getpid () { &taskIdSelf;}' unless defined(&getpid);
    }
    if(defined(&OPENSSL_SYS_BEOS_R5)) {
	eval 'sub SO_ERROR () {0;}' unless defined(&SO_ERROR);
	eval 'sub NO_SYS_UN () {1;}' unless defined(&NO_SYS_UN);
	eval 'sub IPPROTO_IP () {0;}' unless defined(&IPPROTO_IP);
	require 'OS.ph';
    }
    if(defined(&__cplusplus)) {
    }
}
1;
