require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&R92S_MAX_EP)) {
    sub R92S_MAX_EP () {	11;}
}
unless(defined(&R92S_REQ_REGS)) {
    sub R92S_REQ_REGS () {	0x5;}
}
unless(defined(&R92S_SYSCFG)) {
    sub R92S_SYSCFG () {	0x;}
}
unless(defined(&R92S_SYS_ISO_CTRL)) {
    sub R92S_SYS_ISO_CTRL () {	( &R92S_SYSCFG + 0x);}
}
unless(defined(&R92S_SYS_FUNC_EN)) {
    sub R92S_SYS_FUNC_EN () {	( &R92S_SYSCFG + 0x2);}
}
unless(defined(&R92S_PMC_FSM)) {
    sub R92S_PMC_FSM () {	( &R92S_SYSCFG + 0x4);}
}
unless(defined(&R92S_SYS_CLKR)) {
    sub R92S_SYS_CLKR () {	( &R92S_SYSCFG + 0x8);}
}
unless(defined(&R92S_EE_9346CR)) {
    sub R92S_EE_9346CR () {	( &R92S_SYSCFG + 0xa);}
}
unless(defined(&R92S_AFE_MISC)) {
    sub R92S_AFE_MISC () {	( &R92S_SYSCFG + 0x10);}
}
unless(defined(&R92S_SPS0_CTRL)) {
    sub R92S_SPS0_CTRL () {	( &R92S_SYSCFG + 0x11);}
}
unless(defined(&R92S_SPS1_CTRL)) {
    sub R92S_SPS1_CTRL () {	( &R92S_SYSCFG + 0x18);}
}
unless(defined(&R92S_RF_CTRL)) {
    sub R92S_RF_CTRL () {	( &R92S_SYSCFG + 0x1f);}
}
unless(defined(&R92S_LDOA15_CTRL)) {
    sub R92S_LDOA15_CTRL () {	( &R92S_SYSCFG + 0x20);}
}
unless(defined(&R92S_LDOV12D_CTRL)) {
    sub R92S_LDOV12D_CTRL () {	( &R92S_SYSCFG + 0x21);}
}
unless(defined(&R92S_AFE_XTAL_CTRL)) {
    sub R92S_AFE_XTAL_CTRL () {	( &R92S_SYSCFG + 0x26);}
}
unless(defined(&R92S_AFE_PLL_CTRL)) {
    sub R92S_AFE_PLL_CTRL () {	( &R92S_SYSCFG + 0x28);}
}
unless(defined(&R92S_EFUSE_CTRL)) {
    sub R92S_EFUSE_CTRL () {	( &R92S_SYSCFG + 0x30);}
}
unless(defined(&R92S_EFUSE_TEST)) {
    sub R92S_EFUSE_TEST () {	( &R92S_SYSCFG + 0x34);}
}
unless(defined(&R92S_EFUSE_CLK_CTRL)) {
    sub R92S_EFUSE_CLK_CTRL () {	( &R92S_SYSCFG + 0x2f8);}
}
unless(defined(&R92S_CMDCTRL)) {
    sub R92S_CMDCTRL () {	0x40;}
}
unless(defined(&R92S_CR)) {
    sub R92S_CR () {	( &R92S_CMDCTRL + 0x);}
}
unless(defined(&R92S_TCR)) {
    sub R92S_TCR () {	( &R92S_CMDCTRL + 0x4);}
}
unless(defined(&R92S_RCR)) {
    sub R92S_RCR () {	( &R92S_CMDCTRL + 0x8);}
}
unless(defined(&R92S_MACIDSETTING)) {
    sub R92S_MACIDSETTING () {	0x50;}
}
unless(defined(&R92S_MACID)) {
    sub R92S_MACID () {	( &R92S_MACIDSETTING + 0x);}
}
unless(defined(&R92S_GP)) {
    sub R92S_GP () {	0x1e0;}
}
unless(defined(&R92S_GPIO_CTRL)) {
    sub R92S_GPIO_CTRL () {	( &R92S_GP + 0xc);}
}
unless(defined(&R92S_GPIO_IO_SEL)) {
    sub R92S_GPIO_IO_SEL () {	( &R92S_GP + 0xe);}
}
unless(defined(&R92S_MAC_PINMUX_CTRL)) {
    sub R92S_MAC_PINMUX_CTRL () {	( &R92S_GP + 0x11);}
}
unless(defined(&R92S_IOCMD_CTRL)) {
    sub R92S_IOCMD_CTRL () {	0x370;}
}
unless(defined(&R92S_IOCMD_DATA)) {
    sub R92S_IOCMD_DATA () {	0x374;}
}
unless(defined(&R92S_USB_HRPWM)) {
    sub R92S_USB_HRPWM () {	0xfe58;}
}
unless(defined(&R92S_FEN_CPUEN)) {
    sub R92S_FEN_CPUEN () {	0x400;}
}
unless(defined(&R92S_PMC_FSM_CUT_M)) {
    sub R92S_PMC_FSM_CUT_M () {	0xf8000;}
}
unless(defined(&R92S_PMC_FSM_CUT_S)) {
    sub R92S_PMC_FSM_CUT_S () {	15;}
}
unless(defined(&R92S_SYS_CLKSEL)) {
    sub R92S_SYS_CLKSEL () {	0x1;}
}
unless(defined(&R92S_SYS_PS_CLKSEL)) {
    sub R92S_SYS_PS_CLKSEL () {	0x2;}
}
unless(defined(&R92S_SYS_CPU_CLKSEL)) {
    sub R92S_SYS_CPU_CLKSEL () {	0x4;}
}
unless(defined(&R92S_MAC_CLK_EN)) {
    sub R92S_MAC_CLK_EN () {	0x800;}
}
unless(defined(&R92S_SYS_CLK_EN)) {
    sub R92S_SYS_CLK_EN () {	0x1000;}
}
unless(defined(&R92S_SWHW_SEL)) {
    sub R92S_SWHW_SEL () {	0x4000;}
}
unless(defined(&R92S_FWHW_SEL)) {
    sub R92S_FWHW_SEL () {	0x8000;}
}
unless(defined(&R92S_9356SEL)) {
    sub R92S_9356SEL () {	0x10;}
}
unless(defined(&R92S_EEPROM_EN)) {
    sub R92S_EEPROM_EN () {	0x20;}
}
unless(defined(&R92S_AFE_MISC_BGEN)) {
    sub R92S_AFE_MISC_BGEN () {	0x1;}
}
unless(defined(&R92S_AFE_MISC_MBEN)) {
    sub R92S_AFE_MISC_MBEN () {	0x2;}
}
unless(defined(&R92S_AFE_MISC_I32_EN)) {
    sub R92S_AFE_MISC_I32_EN () {	0x8;}
}
unless(defined(&R92S_SPS1_LDEN)) {
    sub R92S_SPS1_LDEN () {	0x1;}
}
unless(defined(&R92S_SPS1_SWEN)) {
    sub R92S_SPS1_SWEN () {	0x2;}
}
unless(defined(&R92S_LDA15_EN)) {
    sub R92S_LDA15_EN () {	0x1;}
}
unless(defined(&R92S_LDV12_EN)) {
    sub R92S_LDV12_EN () {	0x1;}
}
unless(defined(&R92S_EFUSE_CTRL_DATA_M)) {
    sub R92S_EFUSE_CTRL_DATA_M () {	0xff;}
}
unless(defined(&R92S_EFUSE_CTRL_DATA_S)) {
    sub R92S_EFUSE_CTRL_DATA_S () {	0;}
}
unless(defined(&R92S_EFUSE_CTRL_ADDR_M)) {
    sub R92S_EFUSE_CTRL_ADDR_M () {	0x3ff00;}
}
unless(defined(&R92S_EFUSE_CTRL_ADDR_S)) {
    sub R92S_EFUSE_CTRL_ADDR_S () {	8;}
}
unless(defined(&R92S_EFUSE_CTRL_VALID)) {
    sub R92S_EFUSE_CTRL_VALID () {	0x80000000;}
}
unless(defined(&R92S_CR_TXDMA_EN)) {
    sub R92S_CR_TXDMA_EN () {	0x10;}
}
unless(defined(&R92S_TCR_IMEM_CODE_DONE)) {
    sub R92S_TCR_IMEM_CODE_DONE () {	0x1;}
}
unless(defined(&R92S_TCR_IMEM_CHK_RPT)) {
    sub R92S_TCR_IMEM_CHK_RPT () {	0x2;}
}
unless(defined(&R92S_TCR_EMEM_CODE_DONE)) {
    sub R92S_TCR_EMEM_CODE_DONE () {	0x4;}
}
unless(defined(&R92S_TCR_EMEM_CHK_RPT)) {
    sub R92S_TCR_EMEM_CHK_RPT () {	0x8;}
}
unless(defined(&R92S_TCR_DMEM_CODE_DONE)) {
    sub R92S_TCR_DMEM_CODE_DONE () {	0x10;}
}
unless(defined(&R92S_TCR_IMEM_RDY)) {
    sub R92S_TCR_IMEM_RDY () {	0x20;}
}
unless(defined(&R92S_TCR_FWRDY)) {
    sub R92S_TCR_FWRDY () {	0x80;}
}
unless(defined(&R92S_GPIO_WPS)) {
    sub R92S_GPIO_WPS () {	0x10;}
}
unless(defined(&R92S_GPIOSEL_GPIO_M)) {
    sub R92S_GPIOSEL_GPIO_M () {	0x3;}
}
unless(defined(&R92S_GPIOSEL_GPIO_S)) {
    sub R92S_GPIOSEL_GPIO_S () {	0;}
}
unless(defined(&R92S_GPIOSEL_GPIO_JTAG)) {
    sub R92S_GPIOSEL_GPIO_JTAG () {	0;}
}
unless(defined(&R92S_GPIOSEL_GPIO_PHYDBG)) {
    sub R92S_GPIOSEL_GPIO_PHYDBG () {	1;}
}
unless(defined(&R92S_GPIOSEL_GPIO_BT)) {
    sub R92S_GPIOSEL_GPIO_BT () {	2;}
}
unless(defined(&R92S_GPIOSEL_GPIO_WLANDBG)) {
    sub R92S_GPIOSEL_GPIO_WLANDBG () {	3;}
}
unless(defined(&R92S_GPIOMUX_EN)) {
    sub R92S_GPIOMUX_EN () {	0x8;}
}
unless(defined(&R92S_IOCMD_CLASS_M)) {
    sub R92S_IOCMD_CLASS_M () {	0xff000000;}
}
unless(defined(&R92S_IOCMD_CLASS_S)) {
    sub R92S_IOCMD_CLASS_S () {	24;}
}
unless(defined(&R92S_IOCMD_CLASS_BB_RF)) {
    sub R92S_IOCMD_CLASS_BB_RF () {	0xf0;}
}
unless(defined(&R92S_IOCMD_VALUE_M)) {
    sub R92S_IOCMD_VALUE_M () {	0xffff00;}
}
unless(defined(&R92S_IOCMD_VALUE_S)) {
    sub R92S_IOCMD_VALUE_S () {	8;}
}
unless(defined(&R92S_IOCMD_INDEX_M)) {
    sub R92S_IOCMD_INDEX_M () {	0xff;}
}
unless(defined(&R92S_IOCMD_INDEX_S)) {
    sub R92S_IOCMD_INDEX_S () {	0;}
}
unless(defined(&R92S_IOCMD_INDEX_BB_READ)) {
    sub R92S_IOCMD_INDEX_BB_READ () {	0;}
}
unless(defined(&R92S_IOCMD_INDEX_BB_WRITE)) {
    sub R92S_IOCMD_INDEX_BB_WRITE () {	1;}
}
unless(defined(&R92S_IOCMD_INDEX_RF_READ)) {
    sub R92S_IOCMD_INDEX_RF_READ () {	2;}
}
unless(defined(&R92S_IOCMD_INDEX_RF_WRITE)) {
    sub R92S_IOCMD_INDEX_RF_WRITE () {	3;}
}
unless(defined(&R92S_USB_HRPWM_PS_ALL_ON)) {
    sub R92S_USB_HRPWM_PS_ALL_ON () {	0x4;}
}
unless(defined(&R92S_USB_HRPWM_PS_ST_ACTIVE)) {
    sub R92S_USB_HRPWM_PS_ST_ACTIVE () {	0x8;}
}
unless(defined(&MS)) {
    sub MS {
	my($val, $field) = @_;
	eval q(((($val) & $field &_M) >> $field &_S));
    }
}
unless(defined(&SM)) {
    sub SM {
	my($field, $val) = @_;
	eval q(((($val) << $field &_S) & $field &_M));
    }
}
unless(defined(&RW)) {
    sub RW {
	my($var, $field, $val) = @_;
	eval q(((($var) & ~$field &_M) |  &SM($field, $val)));
    }
}
unless(defined(&R92S_HCI_SEL_PCIE)) {
    sub R92S_HCI_SEL_PCIE () {	0x1;}
}
unless(defined(&R92S_HCI_SEL_USB)) {
    sub R92S_HCI_SEL_USB () {	0x2;}
}
unless(defined(&R92S_HCI_SEL_SDIO)) {
    sub R92S_HCI_SEL_SDIO () {	0x4;}
}
unless(defined(&R92S_HCI_SEL_8172)) {
    sub R92S_HCI_SEL_8172 () {	0x10;}
}
unless(defined(&R92S_HCI_SEL_AP)) {
    sub R92S_HCI_SEL_AP () {	0x80;}
}
unless(defined(&R92S_VCS_TYPE_DISABLE)) {
    sub R92S_VCS_TYPE_DISABLE () {	0;}
}
unless(defined(&R92S_VCS_TYPE_ENABLE)) {
    sub R92S_VCS_TYPE_ENABLE () {	1;}
}
unless(defined(&R92S_VCS_TYPE_AUTO)) {
    sub R92S_VCS_TYPE_AUTO () {	2;}
}
unless(defined(&R92S_VCS_MODE_NONE)) {
    sub R92S_VCS_MODE_NONE () {	0;}
}
unless(defined(&R92S_VCS_MODE_RTS_CTS)) {
    sub R92S_VCS_MODE_RTS_CTS () {	1;}
}
unless(defined(&R92S_VCS_MODE_CTS2SELF)) {
    sub R92S_VCS_MODE_CTS2SELF () {	2;}
}
unless(defined(&R92S_FW_CMD_MORE)) {
    sub R92S_FW_CMD_MORE () {	0x80;}
}
unless(defined(&R92S_CMD_READ_MACREG)) {
    sub R92S_CMD_READ_MACREG () {	0;}
}
unless(defined(&R92S_CMD_WRITE_MACREG)) {
    sub R92S_CMD_WRITE_MACREG () {	1;}
}
unless(defined(&R92S_CMD_READ_BBREG)) {
    sub R92S_CMD_READ_BBREG () {	2;}
}
unless(defined(&R92S_CMD_WRITE_BBREG)) {
    sub R92S_CMD_WRITE_BBREG () {	3;}
}
unless(defined(&R92S_CMD_READ_RFREG)) {
    sub R92S_CMD_READ_RFREG () {	4;}
}
unless(defined(&R92S_CMD_WRITE_RFREG)) {
    sub R92S_CMD_WRITE_RFREG () {	5;}
}
unless(defined(&R92S_CMD_READ_EEPROM)) {
    sub R92S_CMD_READ_EEPROM () {	6;}
}
unless(defined(&R92S_CMD_WRITE_EEPROM)) {
    sub R92S_CMD_WRITE_EEPROM () {	7;}
}
unless(defined(&R92S_CMD_READ_EFUSE)) {
    sub R92S_CMD_READ_EFUSE () {	8;}
}
unless(defined(&R92S_CMD_WRITE_EFUSE)) {
    sub R92S_CMD_WRITE_EFUSE () {	9;}
}
unless(defined(&R92S_CMD_READ_CAM)) {
    sub R92S_CMD_READ_CAM () {	10;}
}
unless(defined(&R92S_CMD_WRITE_CAM)) {
    sub R92S_CMD_WRITE_CAM () {	11;}
}
unless(defined(&R92S_CMD_SET_BCNITV)) {
    sub R92S_CMD_SET_BCNITV () {	12;}
}
unless(defined(&R92S_CMD_SET_MBIDCFG)) {
    sub R92S_CMD_SET_MBIDCFG () {	13;}
}
unless(defined(&R92S_CMD_JOIN_BSS)) {
    sub R92S_CMD_JOIN_BSS () {	14;}
}
unless(defined(&R92S_CMD_DISCONNECT)) {
    sub R92S_CMD_DISCONNECT () {	15;}
}
unless(defined(&R92S_CMD_CREATE_BSS)) {
    sub R92S_CMD_CREATE_BSS () {	16;}
}
unless(defined(&R92S_CMD_SET_OPMODE)) {
    sub R92S_CMD_SET_OPMODE () {	17;}
}
unless(defined(&R92S_CMD_SITE_SURVEY)) {
    sub R92S_CMD_SITE_SURVEY () {	18;}
}
unless(defined(&R92S_CMD_SET_AUTH)) {
    sub R92S_CMD_SET_AUTH () {	19;}
}
unless(defined(&R92S_CMD_SET_KEY)) {
    sub R92S_CMD_SET_KEY () {	20;}
}
unless(defined(&R92S_CMD_SET_STA_KEY)) {
    sub R92S_CMD_SET_STA_KEY () {	21;}
}
unless(defined(&R92S_CMD_SET_ASSOC_STA)) {
    sub R92S_CMD_SET_ASSOC_STA () {	22;}
}
unless(defined(&R92S_CMD_DEL_ASSOC_STA)) {
    sub R92S_CMD_DEL_ASSOC_STA () {	23;}
}
unless(defined(&R92S_CMD_SET_STAPWRSTATE)) {
    sub R92S_CMD_SET_STAPWRSTATE () {	24;}
}
unless(defined(&R92S_CMD_SET_BASIC_RATE)) {
    sub R92S_CMD_SET_BASIC_RATE () {	25;}
}
unless(defined(&R92S_CMD_GET_BASIC_RATE)) {
    sub R92S_CMD_GET_BASIC_RATE () {	26;}
}
unless(defined(&R92S_CMD_SET_DATA_RATE)) {
    sub R92S_CMD_SET_DATA_RATE () {	27;}
}
unless(defined(&R92S_CMD_GET_DATA_RATE)) {
    sub R92S_CMD_GET_DATA_RATE () {	28;}
}
unless(defined(&R92S_CMD_SET_PHY_INFO)) {
    sub R92S_CMD_SET_PHY_INFO () {	29;}
}
unless(defined(&R92S_CMD_GET_PHY_INFO)) {
    sub R92S_CMD_GET_PHY_INFO () {	30;}
}
unless(defined(&R92S_CMD_SET_PHY)) {
    sub R92S_CMD_SET_PHY () {	31;}
}
unless(defined(&R92S_CMD_GET_PHY)) {
    sub R92S_CMD_GET_PHY () {	32;}
}
unless(defined(&R92S_CMD_READ_RSSI)) {
    sub R92S_CMD_READ_RSSI () {	33;}
}
unless(defined(&R92S_CMD_READ_GAIN)) {
    sub R92S_CMD_READ_GAIN () {	34;}
}
unless(defined(&R92S_CMD_SET_ATIM)) {
    sub R92S_CMD_SET_ATIM () {	35;}
}
unless(defined(&R92S_CMD_SET_PWR_MODE)) {
    sub R92S_CMD_SET_PWR_MODE () {	36;}
}
unless(defined(&R92S_CMD_JOIN_BSS_RPT)) {
    sub R92S_CMD_JOIN_BSS_RPT () {	37;}
}
unless(defined(&R92S_CMD_SET_RA_TABLE)) {
    sub R92S_CMD_SET_RA_TABLE () {	38;}
}
unless(defined(&R92S_CMD_GET_RA_TABLE)) {
    sub R92S_CMD_GET_RA_TABLE () {	39;}
}
unless(defined(&R92S_CMD_GET_CCX_REPORT)) {
    sub R92S_CMD_GET_CCX_REPORT () {	40;}
}
unless(defined(&R92S_CMD_GET_DTM_REPORT)) {
    sub R92S_CMD_GET_DTM_REPORT () {	41;}
}
unless(defined(&R92S_CMD_GET_TXRATE_STATS)) {
    sub R92S_CMD_GET_TXRATE_STATS () {	42;}
}
unless(defined(&R92S_CMD_SET_USB_SUSPEND)) {
    sub R92S_CMD_SET_USB_SUSPEND () {	43;}
}
unless(defined(&R92S_CMD_SET_H2C_LBK)) {
    sub R92S_CMD_SET_H2C_LBK () {	44;}
}
unless(defined(&R92S_CMD_ADDBA_REQ)) {
    sub R92S_CMD_ADDBA_REQ () {	45;}
}
unless(defined(&R92S_CMD_SET_CHANNEL)) {
    sub R92S_CMD_SET_CHANNEL () {	46;}
}
unless(defined(&R92S_CMD_SET_TXPOWER)) {
    sub R92S_CMD_SET_TXPOWER () {	47;}
}
unless(defined(&R92S_CMD_SWITCH_ANTENNA)) {
    sub R92S_CMD_SWITCH_ANTENNA () {	48;}
}
unless(defined(&R92S_CMD_SET_CRYSTAL_CAL)) {
    sub R92S_CMD_SET_CRYSTAL_CAL () {	49;}
}
unless(defined(&R92S_CMD_SET_SINGLE_CARRIER_TX)) {
    sub R92S_CMD_SET_SINGLE_CARRIER_TX () {	50;}
}
unless(defined(&R92S_CMD_SET_SINGLE_TONE_TX)) {
    sub R92S_CMD_SET_SINGLE_TONE_TX () {	51;}
}
unless(defined(&R92S_CMD_SET_CARRIER_SUPPR_TX)) {
    sub R92S_CMD_SET_CARRIER_SUPPR_TX () {	52;}
}
unless(defined(&R92S_CMD_SET_CONTINUOUS_TX)) {
    sub R92S_CMD_SET_CONTINUOUS_TX () {	53;}
}
unless(defined(&R92S_CMD_SWITCH_BANDWIDTH)) {
    sub R92S_CMD_SWITCH_BANDWIDTH () {	54;}
}
unless(defined(&R92S_CMD_TX_BEACON)) {
    sub R92S_CMD_TX_BEACON () {	55;}
}
unless(defined(&R92S_CMD_SET_POWER_TRACKING)) {
    sub R92S_CMD_SET_POWER_TRACKING () {	56;}
}
unless(defined(&R92S_CMD_AMSDU_TO_AMPDU)) {
    sub R92S_CMD_AMSDU_TO_AMPDU () {	57;}
}
unless(defined(&R92S_CMD_SET_MAC_ADDRESS)) {
    sub R92S_CMD_SET_MAC_ADDRESS () {	58;}
}
unless(defined(&R92S_CMD_GET_H2C_LBK)) {
    sub R92S_CMD_GET_H2C_LBK () {	59;}
}
unless(defined(&R92S_CMD_SET_PBREQ_IE)) {
    sub R92S_CMD_SET_PBREQ_IE () {	60;}
}
unless(defined(&R92S_CMD_SET_ASSOCREQ_IE)) {
    sub R92S_CMD_SET_ASSOCREQ_IE () {	61;}
}
unless(defined(&R92S_CMD_SET_PBRESP_IE)) {
    sub R92S_CMD_SET_PBRESP_IE () {	62;}
}
unless(defined(&R92S_CMD_SET_ASSOCRESP_IE)) {
    sub R92S_CMD_SET_ASSOCRESP_IE () {	63;}
}
unless(defined(&R92S_CMD_GET_CURDATARATE)) {
    sub R92S_CMD_GET_CURDATARATE () {	64;}
}
unless(defined(&R92S_CMD_GET_TXRETRY_CNT)) {
    sub R92S_CMD_GET_TXRETRY_CNT () {	65;}
}
unless(defined(&R92S_CMD_GET_RXRETRY_CNT)) {
    sub R92S_CMD_GET_RXRETRY_CNT () {	66;}
}
unless(defined(&R92S_CMD_GET_BCNOK_CNT)) {
    sub R92S_CMD_GET_BCNOK_CNT () {	67;}
}
unless(defined(&R92S_CMD_GET_BCNERR_CNT)) {
    sub R92S_CMD_GET_BCNERR_CNT () {	68;}
}
unless(defined(&R92S_CMD_GET_CURTXPWR_LEVEL)) {
    sub R92S_CMD_GET_CURTXPWR_LEVEL () {	69;}
}
unless(defined(&R92S_CMD_SET_DIG)) {
    sub R92S_CMD_SET_DIG () {	70;}
}
unless(defined(&R92S_CMD_SET_RA)) {
    sub R92S_CMD_SET_RA () {	71;}
}
unless(defined(&R92S_CMD_SET_PT)) {
    sub R92S_CMD_SET_PT () {	72;}
}
unless(defined(&R92S_CMD_READ_TSSI)) {
    sub R92S_CMD_READ_TSSI () {	73;}
}
unless(defined(&R92S_EVT_READ_MACREG)) {
    sub R92S_EVT_READ_MACREG () {	0;}
}
unless(defined(&R92S_EVT_READ_BBREG)) {
    sub R92S_EVT_READ_BBREG () {	1;}
}
unless(defined(&R92S_EVT_READ_RFREG)) {
    sub R92S_EVT_READ_RFREG () {	2;}
}
unless(defined(&R92S_EVT_READ_EEPROM)) {
    sub R92S_EVT_READ_EEPROM () {	3;}
}
unless(defined(&R92S_EVT_READ_EFUSE)) {
    sub R92S_EVT_READ_EFUSE () {	4;}
}
unless(defined(&R92S_EVT_READ_CAM)) {
    sub R92S_EVT_READ_CAM () {	5;}
}
unless(defined(&R92S_EVT_GET_BASICRATE)) {
    sub R92S_EVT_GET_BASICRATE () {	6;}
}
unless(defined(&R92S_EVT_GET_DATARATE)) {
    sub R92S_EVT_GET_DATARATE () {	7;}
}
unless(defined(&R92S_EVT_SURVEY)) {
    sub R92S_EVT_SURVEY () {	8;}
}
unless(defined(&R92S_EVT_SURVEY_DONE)) {
    sub R92S_EVT_SURVEY_DONE () {	9;}
}
unless(defined(&R92S_EVT_JOIN_BSS)) {
    sub R92S_EVT_JOIN_BSS () {	10;}
}
unless(defined(&R92S_EVT_ADD_STA)) {
    sub R92S_EVT_ADD_STA () {	11;}
}
unless(defined(&R92S_EVT_DEL_STA)) {
    sub R92S_EVT_DEL_STA () {	12;}
}
unless(defined(&R92S_EVT_ATIM_DONE)) {
    sub R92S_EVT_ATIM_DONE () {	13;}
}
unless(defined(&R92S_EVT_TX_REPORT)) {
    sub R92S_EVT_TX_REPORT () {	14;}
}
unless(defined(&R92S_EVT_CCX_REPORT)) {
    sub R92S_EVT_CCX_REPORT () {	15;}
}
unless(defined(&R92S_EVT_DTM_REPORT)) {
    sub R92S_EVT_DTM_REPORT () {	16;}
}
unless(defined(&R92S_EVT_TXRATE_STATS)) {
    sub R92S_EVT_TXRATE_STATS () {	17;}
}
unless(defined(&R92S_EVT_C2H_LBK)) {
    sub R92S_EVT_C2H_LBK () {	18;}
}
unless(defined(&R92S_EVT_FWDBG)) {
    sub R92S_EVT_FWDBG () {	19;}
}
unless(defined(&R92S_EVT_C2H_FEEDBACK)) {
    sub R92S_EVT_C2H_FEEDBACK () {	20;}
}
unless(defined(&R92S_EVT_ADDBA)) {
    sub R92S_EVT_ADDBA () {	21;}
}
unless(defined(&R92S_EVT_C2H_BCN)) {
    sub R92S_EVT_C2H_BCN () {	22;}
}
unless(defined(&R92S_EVT_PWR_STATE)) {
    sub R92S_EVT_PWR_STATE () {	23;}
}
unless(defined(&R92S_EVT_WPS_PBC)) {
    sub R92S_EVT_WPS_PBC () {	24;}
}
unless(defined(&R92S_EVT_ADDBA_REQ_REPORT)) {
    sub R92S_EVT_ADDBA_REQ_REPORT () {	25;}
}
unless(defined(&R92S_AUTHMODE_OPEN)) {
    sub R92S_AUTHMODE_OPEN () {	0;}
}
unless(defined(&R92S_AUTHMODE_SHARED)) {
    sub R92S_AUTHMODE_SHARED () {	1;}
}
unless(defined(&R92S_AUTHMODE_WPA)) {
    sub R92S_AUTHMODE_WPA () {	2;}
}
unless(defined(&R92S_KEY_ALGO_NONE)) {
    sub R92S_KEY_ALGO_NONE () {	0;}
}
unless(defined(&R92S_KEY_ALGO_WEP40)) {
    sub R92S_KEY_ALGO_WEP40 () {	1;}
}
unless(defined(&R92S_KEY_ALGO_TKIP)) {
    sub R92S_KEY_ALGO_TKIP () {	2;}
}
unless(defined(&R92S_KEY_ALGO_TKIP_MMIC)) {
    sub R92S_KEY_ALGO_TKIP_MMIC () {	3;}
}
unless(defined(&R92S_KEY_ALGO_AES)) {
    sub R92S_KEY_ALGO_AES () {	4;}
}
unless(defined(&R92S_KEY_ALGO_WEP104)) {
    sub R92S_KEY_ALGO_WEP104 () {	5;}
}
unless(defined(&NDIS802_11FH)) {
    sub NDIS802_11FH () {	0;}
}
unless(defined(&NDIS802_11DS)) {
    sub NDIS802_11DS () {	1;}
}
unless(defined(&NDIS802_11OFDM5)) {
    sub NDIS802_11OFDM5 () {	2;}
}
unless(defined(&NDIS802_11OFDM24)) {
    sub NDIS802_11OFDM24 () {	3;}
}
unless(defined(&NDIS802_11AUTOMODE)) {
    sub NDIS802_11AUTOMODE () {	4;}
}
unless(defined(&NDIS802_11IBSS)) {
    sub NDIS802_11IBSS () {	0;}
}
unless(defined(&NDIS802_11INFRASTRUCTURE)) {
    sub NDIS802_11INFRASTRUCTURE () {	1;}
}
unless(defined(&NDIS802_11AUTOUNKNOWN)) {
    sub NDIS802_11AUTOUNKNOWN () {	2;}
}
unless(defined(&NDIS802_11MONITOR)) {
    sub NDIS802_11MONITOR () {	3;}
}
unless(defined(&NDIS802_11APMODE)) {
    sub NDIS802_11APMODE () {	4;}
}
unless(defined(&R92S_PS_MODE_ACTIVE)) {
    sub R92S_PS_MODE_ACTIVE () {	0;}
}
unless(defined(&R92S_PS_MODE_MIN)) {
    sub R92S_PS_MODE_MIN () {	1;}
}
unless(defined(&R92S_PS_MODE_MAX)) {
    sub R92S_PS_MODE_MAX () {	2;}
}
unless(defined(&R92S_PS_MODE_DTIM)) {
    sub R92S_PS_MODE_DTIM () {	3;}
}
unless(defined(&R92S_PS_MODE_VOIP)) {
    sub R92S_PS_MODE_VOIP () {	4;}
}
unless(defined(&R92S_PS_MODE_UAPSD_WMM)) {
    sub R92S_PS_MODE_UAPSD_WMM () {	5;}
}
unless(defined(&R92S_PS_MODE_UAPSD)) {
    sub R92S_PS_MODE_UAPSD () {	6;}
}
unless(defined(&R92S_PS_MODE_IBSS)) {
    sub R92S_PS_MODE_IBSS () {	7;}
}
unless(defined(&R92S_PS_MODE_WWLAN)) {
    sub R92S_PS_MODE_WWLAN () {	8;}
}
unless(defined(&R92S_PS_MODE_RADIOOFF)) {
    sub R92S_PS_MODE_RADIOOFF () {	9;}
}
unless(defined(&R92S_PS_MODE_DISABLE)) {
    sub R92S_PS_MODE_DISABLE () {	10;}
}
unless(defined(&R92S_MACID_BSS)) {
    sub R92S_MACID_BSS () {	5;}
}
unless(defined(&R92S_RXDW0_PKTLEN_M)) {
    sub R92S_RXDW0_PKTLEN_M () {	0x3fff;}
}
unless(defined(&R92S_RXDW0_PKTLEN_S)) {
    sub R92S_RXDW0_PKTLEN_S () {	0;}
}
unless(defined(&R92S_RXDW0_CRCERR)) {
    sub R92S_RXDW0_CRCERR () {	0x4000;}
}
unless(defined(&R92S_RXDW0_INFOSZ_M)) {
    sub R92S_RXDW0_INFOSZ_M () {	0xf0000;}
}
unless(defined(&R92S_RXDW0_INFOSZ_S)) {
    sub R92S_RXDW0_INFOSZ_S () {	16;}
}
unless(defined(&R92S_RXDW0_QOS)) {
    sub R92S_RXDW0_QOS () {	0x800000;}
}
unless(defined(&R92S_RXDW0_SHIFT_M)) {
    sub R92S_RXDW0_SHIFT_M () {	0x3000000;}
}
unless(defined(&R92S_RXDW0_SHIFT_S)) {
    sub R92S_RXDW0_SHIFT_S () {	24;}
}
unless(defined(&R92S_RXDW0_DECRYPTED)) {
    sub R92S_RXDW0_DECRYPTED () {	0x8000000;}
}
unless(defined(&R92S_RXDW1_MOREFRAG)) {
    sub R92S_RXDW1_MOREFRAG () {	0x8000000;}
}
unless(defined(&R92S_RXDW2_FRAG_M)) {
    sub R92S_RXDW2_FRAG_M () {	0xf000;}
}
unless(defined(&R92S_RXDW2_FRAG_S)) {
    sub R92S_RXDW2_FRAG_S () {	12;}
}
unless(defined(&R92S_RXDW2_PKTCNT_M)) {
    sub R92S_RXDW2_PKTCNT_M () {	0xff0000;}
}
unless(defined(&R92S_RXDW2_PKTCNT_S)) {
    sub R92S_RXDW2_PKTCNT_S () {	16;}
}
unless(defined(&R92S_RXDW3_RATE_M)) {
    sub R92S_RXDW3_RATE_M () {	0x3f;}
}
unless(defined(&R92S_RXDW3_RATE_S)) {
    sub R92S_RXDW3_RATE_S () {	0;}
}
unless(defined(&R92S_RXDW3_TCPCHKRPT)) {
    sub R92S_RXDW3_TCPCHKRPT () {	0x800;}
}
unless(defined(&R92S_RXDW3_IPCHKRPT)) {
    sub R92S_RXDW3_IPCHKRPT () {	0x1000;}
}
unless(defined(&R92S_RXDW3_TCPCHKVALID)) {
    sub R92S_RXDW3_TCPCHKVALID () {	0x2000;}
}
unless(defined(&R92S_RXDW3_HTC)) {
    sub R92S_RXDW3_HTC () {	0x4000;}
}
unless(defined(&R92S_TXDW0_PKTLEN_M)) {
    sub R92S_TXDW0_PKTLEN_M () {	0xffff;}
}
unless(defined(&R92S_TXDW0_PKTLEN_S)) {
    sub R92S_TXDW0_PKTLEN_S () {	0;}
}
unless(defined(&R92S_TXDW0_OFFSET_M)) {
    sub R92S_TXDW0_OFFSET_M () {	0xff0000;}
}
unless(defined(&R92S_TXDW0_OFFSET_S)) {
    sub R92S_TXDW0_OFFSET_S () {	16;}
}
unless(defined(&R92S_TXDW0_TYPE_M)) {
    sub R92S_TXDW0_TYPE_M () {	0x3000000;}
}
unless(defined(&R92S_TXDW0_TYPE_S)) {
    sub R92S_TXDW0_TYPE_S () {	24;}
}
unless(defined(&R92S_TXDW0_LSG)) {
    sub R92S_TXDW0_LSG () {	0x4000000;}
}
unless(defined(&R92S_TXDW0_FSG)) {
    sub R92S_TXDW0_FSG () {	0x8000000;}
}
unless(defined(&R92S_TXDW0_LINIP)) {
    sub R92S_TXDW0_LINIP () {	0x10000000;}
}
unless(defined(&R92S_TXDW0_OWN)) {
    sub R92S_TXDW0_OWN () {	0x80000000;}
}
unless(defined(&R92S_TXDW1_MACID_M)) {
    sub R92S_TXDW1_MACID_M () {	0x1f;}
}
unless(defined(&R92S_TXDW1_MACID_S)) {
    sub R92S_TXDW1_MACID_S () {	0;}
}
unless(defined(&R92S_TXDW1_MOREDATA)) {
    sub R92S_TXDW1_MOREDATA () {	0x20;}
}
unless(defined(&R92S_TXDW1_MOREFRAG)) {
    sub R92S_TXDW1_MOREFRAG () {	0x40;}
}
unless(defined(&R92S_TXDW1_QSEL_M)) {
    sub R92S_TXDW1_QSEL_M () {	0x1f00;}
}
unless(defined(&R92S_TXDW1_QSEL_S)) {
    sub R92S_TXDW1_QSEL_S () {	8;}
}
unless(defined(&R92S_TXDW1_QSEL_BE)) {
    sub R92S_TXDW1_QSEL_BE () {	0x3;}
}
unless(defined(&R92S_TXDW1_QSEL_H2C)) {
    sub R92S_TXDW1_QSEL_H2C () {	0x1f;}
}
unless(defined(&R92S_TXDW1_NONQOS)) {
    sub R92S_TXDW1_NONQOS () {	0x10000;}
}
unless(defined(&R92S_TXDW1_KEYIDX_M)) {
    sub R92S_TXDW1_KEYIDX_M () {	0x60000;}
}
unless(defined(&R92S_TXDW1_KEYIDX_S)) {
    sub R92S_TXDW1_KEYIDX_S () {	17;}
}
unless(defined(&R92S_TXDW1_CIPHER_M)) {
    sub R92S_TXDW1_CIPHER_M () {	0xc00000;}
}
unless(defined(&R92S_TXDW1_CIPHER_S)) {
    sub R92S_TXDW1_CIPHER_S () {	22;}
}
unless(defined(&R92S_TXDW1_CIPHER_WEP)) {
    sub R92S_TXDW1_CIPHER_WEP () {	1;}
}
unless(defined(&R92S_TXDW1_CIPHER_TKIP)) {
    sub R92S_TXDW1_CIPHER_TKIP () {	2;}
}
unless(defined(&R92S_TXDW1_CIPHER_AES)) {
    sub R92S_TXDW1_CIPHER_AES () {	3;}
}
unless(defined(&R92S_TXDW1_HWPC)) {
    sub R92S_TXDW1_HWPC () {	0x80000000;}
}
unless(defined(&R92S_TXDW2_BMCAST)) {
    sub R92S_TXDW2_BMCAST () {	0x80;}
}
unless(defined(&R92S_TXDW2_AGGEN)) {
    sub R92S_TXDW2_AGGEN () {	0x20000000;}
}
unless(defined(&R92S_TXDW2_BK)) {
    sub R92S_TXDW2_BK () {	0x40000000;}
}
unless(defined(&R92S_TXDW3_SEQ_M)) {
    sub R92S_TXDW3_SEQ_M () {	0xfff0000;}
}
unless(defined(&R92S_TXDW3_SEQ_S)) {
    sub R92S_TXDW3_SEQ_S () {	16;}
}
unless(defined(&R92S_TXDW3_FRAG_M)) {
    sub R92S_TXDW3_FRAG_M () {	0xf0000000;}
}
unless(defined(&R92S_TXDW3_FRAG_S)) {
    sub R92S_TXDW3_FRAG_S () {	28;}
}
unless(defined(&R92S_TXDW4_TXBW)) {
    sub R92S_TXDW4_TXBW () {	0x40000;}
}
unless(defined(&R92S_TXDW5_DISFB)) {
    sub R92S_TXDW5_DISFB () {	0x8000;}
}
unless(defined(&RSU_RX_LIST_COUNT)) {
    sub RSU_RX_LIST_COUNT () {	1;}
}
unless(defined(&RSU_TX_LIST_COUNT)) {
    sub RSU_TX_LIST_COUNT () {	(8+ 1);}
}
unless(defined(&RSU_HOST_CMD_RING_COUNT)) {
    sub RSU_HOST_CMD_RING_COUNT () {	32;}
}
unless(defined(&RSU_RXBUFSZ)) {
    sub RSU_RXBUFSZ () {	(8* 1024);}
}
unless(defined(&RSU_TXBUFSZ)) {
    sub RSU_TXBUFSZ () {	(($sizeof{'struct r92s_tx_desc'} +  &IEEE80211_MAX_LEN + 3) & ~3);}
}
unless(defined(&RSU_TX_TIMEOUT)) {
    sub RSU_TX_TIMEOUT () {	5000;}
}
unless(defined(&RSU_CMD_TIMEOUT)) {
    sub RSU_CMD_TIMEOUT () {	2000;}
}
unless(defined(&RSU_QID_BCN)) {
    sub RSU_QID_BCN () {	0;}
}
unless(defined(&RSU_QID_MGT)) {
    sub RSU_QID_MGT () {	1;}
}
unless(defined(&RSU_QID_BMC)) {
    sub RSU_QID_BMC () {	2;}
}
unless(defined(&RSU_QID_VO)) {
    sub RSU_QID_VO () {	3;}
}
unless(defined(&RSU_QID_VI)) {
    sub RSU_QID_VI () {	4;}
}
unless(defined(&RSU_QID_BE)) {
    sub RSU_QID_BE () {	5;}
}
unless(defined(&RSU_QID_BK)) {
    sub RSU_QID_BK () {	6;}
}
unless(defined(&RSU_QID_RXOFF)) {
    sub RSU_QID_RXOFF () {	7;}
}
unless(defined(&RSU_QID_H2C)) {
    sub RSU_QID_H2C () {	8;}
}
unless(defined(&RSU_QID_C2H)) {
    sub RSU_QID_C2H () {	9;}
}
unless(defined(&RSU_RX_RADIOTAP_PRESENT)) {
    sub RSU_RX_RADIOTAP_PRESENT () {	(1<<  &IEEE80211_RADIOTAP_FLAGS | 1<<  &IEEE80211_RADIOTAP_RATE | 1<<  &IEEE80211_RADIOTAP_CHANNEL | 1<<  &IEEE80211_RADIOTAP_DBM_ANTSIGNAL);}
}
unless(defined(&RSU_TX_RADIOTAP_PRESENT)) {
    sub RSU_TX_RADIOTAP_PRESENT () {	(1<<  &IEEE80211_RADIOTAP_FLAGS | 1<<  &IEEE80211_RADIOTAP_CHANNEL);}
}
if((defined(&NBPFILTER) ? &NBPFILTER : undef) > 0) {
    eval 'sub sc_rxtap () { ($sc_rxtapu->{th});}' unless defined(&sc_rxtap);
    eval 'sub sc_txtap () { ($sc_txtapu->{th});}' unless defined(&sc_txtap);
}
1;
