require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&AR_EPT_BULK_TX_NO)) {
    sub AR_EPT_BULK_TX_NO () {	( &UE_DIR_OUT | 1);}
}
unless(defined(&AR_EPT_BULK_RX_NO)) {
    sub AR_EPT_BULK_RX_NO () {	( &UE_DIR_IN | 2);}
}
unless(defined(&AR_EPT_INTR_RX_NO)) {
    sub AR_EPT_INTR_RX_NO () {	( &UE_DIR_IN | 3);}
}
unless(defined(&AR_EPT_INTR_TX_NO)) {
    sub AR_EPT_INTR_TX_NO () {	( &UE_DIR_OUT | 4);}
}
unless(defined(&AR_FW_DOWNLOAD)) {
    sub AR_FW_DOWNLOAD () {	0x30;}
}
unless(defined(&AR_FW_DOWNLOAD_COMPLETE)) {
    sub AR_FW_DOWNLOAD_COMPLETE () {	0x31;}
}
unless(defined(&AR_MAX_WRITE_IDX)) {
    sub AR_MAX_WRITE_IDX () {	6;}
}
unless(defined(&AR_FW_INIT_ADDR)) {
    sub AR_FW_INIT_ADDR () {	0x102800;}
}
unless(defined(&AR_FW_MAIN_ADDR)) {
    sub AR_FW_MAIN_ADDR () {	0x200000;}
}
unless(defined(&AR_USB_MODE_CTRL)) {
    sub AR_USB_MODE_CTRL () {	0x1e1108;}
}
unless(defined(&AR_MAC_REG_BASE)) {
    sub AR_MAC_REG_BASE () {	0x1c3000;}
}
unless(defined(&AR_MAC_REG_MAC_ADDR_L)) {
    sub AR_MAC_REG_MAC_ADDR_L () {	( &AR_MAC_REG_BASE + 0x610);}
}
unless(defined(&AR_MAC_REG_MAC_ADDR_H)) {
    sub AR_MAC_REG_MAC_ADDR_H () {	( &AR_MAC_REG_BASE + 0x614);}
}
unless(defined(&AR_MAC_REG_BSSID_L)) {
    sub AR_MAC_REG_BSSID_L () {	( &AR_MAC_REG_BASE + 0x618);}
}
unless(defined(&AR_MAC_REG_BSSID_H)) {
    sub AR_MAC_REG_BSSID_H () {	( &AR_MAC_REG_BASE + 0x61c);}
}
unless(defined(&AR_MAC_REG_GROUP_HASH_TBL_L)) {
    sub AR_MAC_REG_GROUP_HASH_TBL_L () {	( &AR_MAC_REG_BASE + 0x624);}
}
unless(defined(&AR_MAC_REG_GROUP_HASH_TBL_H)) {
    sub AR_MAC_REG_GROUP_HASH_TBL_H () {	( &AR_MAC_REG_BASE + 0x628);}
}
unless(defined(&AR_MAC_REG_BASIC_RATE)) {
    sub AR_MAC_REG_BASIC_RATE () {	( &AR_MAC_REG_BASE + 0x630);}
}
unless(defined(&AR_MAC_REG_MANDATORY_RATE)) {
    sub AR_MAC_REG_MANDATORY_RATE () {	( &AR_MAC_REG_BASE + 0x634);}
}
unless(defined(&AR_MAC_REG_RTS_CTS_RATE)) {
    sub AR_MAC_REG_RTS_CTS_RATE () {	( &AR_MAC_REG_BASE + 0x638);}
}
unless(defined(&AR_MAC_REG_BACKOFF_PROTECT)) {
    sub AR_MAC_REG_BACKOFF_PROTECT () {	( &AR_MAC_REG_BASE + 0x63c);}
}
unless(defined(&AR_MAC_REG_RX_THRESHOLD)) {
    sub AR_MAC_REG_RX_THRESHOLD () {	( &AR_MAC_REG_BASE + 0x640);}
}
unless(defined(&AR_MAC_REG_RX_PE_DELAY)) {
    sub AR_MAC_REG_RX_PE_DELAY () {	( &AR_MAC_REG_BASE + 0x64c);}
}
unless(defined(&AR_MAC_REG_DYNAMIC_SIFS_ACK)) {
    sub AR_MAC_REG_DYNAMIC_SIFS_ACK () {	( &AR_MAC_REG_BASE + 0x658);}
}
unless(defined(&AR_MAC_REG_SNIFFER)) {
    sub AR_MAC_REG_SNIFFER () {	( &AR_MAC_REG_BASE + 0x674);}
}
unless(defined(&AR_MAC_REG_ACK_EXTENSION)) {
    sub AR_MAC_REG_ACK_EXTENSION () {	( &AR_MAC_REG_BASE + 0x690);}
}
unless(defined(&AR_MAC_REG_EIFS_AND_SIFS)) {
    sub AR_MAC_REG_EIFS_AND_SIFS () {	( &AR_MAC_REG_BASE + 0x698);}
}
unless(defined(&AR_MAC_REG_BUSY)) {
    sub AR_MAC_REG_BUSY () {	( &AR_MAC_REG_BASE + 0x6e8);}
}
unless(defined(&AR_MAC_REG_BUSY_EXT)) {
    sub AR_MAC_REG_BUSY_EXT () {	( &AR_MAC_REG_BASE + 0x6ec);}
}
unless(defined(&AR_MAC_REG_SLOT_TIME)) {
    sub AR_MAC_REG_SLOT_TIME () {	( &AR_MAC_REG_BASE + 0x6f0);}
}
unless(defined(&AR_MAC_REG_AC0_CW)) {
    sub AR_MAC_REG_AC0_CW () {	( &AR_MAC_REG_BASE + 0xb00);}
}
unless(defined(&AR_MAC_REG_AC1_CW)) {
    sub AR_MAC_REG_AC1_CW () {	( &AR_MAC_REG_BASE + 0xb04);}
}
unless(defined(&AR_MAC_REG_AC2_CW)) {
    sub AR_MAC_REG_AC2_CW () {	( &AR_MAC_REG_BASE + 0xb08);}
}
unless(defined(&AR_MAC_REG_AC3_CW)) {
    sub AR_MAC_REG_AC3_CW () {	( &AR_MAC_REG_BASE + 0xb0c);}
}
unless(defined(&AR_MAC_REG_AC4_CW)) {
    sub AR_MAC_REG_AC4_CW () {	( &AR_MAC_REG_BASE + 0xb10);}
}
unless(defined(&AR_MAC_REG_AC1_AC0_AIFS)) {
    sub AR_MAC_REG_AC1_AC0_AIFS () {	( &AR_MAC_REG_BASE + 0xb14);}
}
unless(defined(&AR_MAC_REG_AC3_AC2_AIFS)) {
    sub AR_MAC_REG_AC3_AC2_AIFS () {	( &AR_MAC_REG_BASE + 0xb18);}
}
unless(defined(&AR_MAC_REG_RETRY_MAX)) {
    sub AR_MAC_REG_RETRY_MAX () {	( &AR_MAC_REG_BASE + 0xb28);}
}
unless(defined(&AR_MAC_REG_TXOP_NOT_ENOUGH_INDICATION)) {
    sub AR_MAC_REG_TXOP_NOT_ENOUGH_INDICATION () {	( &AR_MAC_REG_BASE + 0xb30);}
}
unless(defined(&AR_MAC_REG_AC1_AC0_TXOP)) {
    sub AR_MAC_REG_AC1_AC0_TXOP () {	( &AR_MAC_REG_BASE + 0xb44);}
}
unless(defined(&AR_MAC_REG_AC3_AC2_TXOP)) {
    sub AR_MAC_REG_AC3_AC2_TXOP () {	( &AR_MAC_REG_BASE + 0xb48);}
}
unless(defined(&AR_MAC_REG_OFDM_PHY_ERRORS)) {
    sub AR_MAC_REG_OFDM_PHY_ERRORS () {	( &AR_MAC_REG_BASE + 0xcb4);}
}
unless(defined(&AR_MAC_REG_CCK_PHY_ERRORS)) {
    sub AR_MAC_REG_CCK_PHY_ERRORS () {	( &AR_MAC_REG_BASE + 0xcb8);}
}
unless(defined(&AR_MAC_REG_BCN_HT1)) {
    sub AR_MAC_REG_BCN_HT1 () {	( &AR_MAC_REG_BASE + 0xda0);}
}
unless(defined(&AR_USB_DS_ENA)) {
    sub AR_USB_DS_ENA () {	(1<< 0);}
}
unless(defined(&AR_USB_US_ENA)) {
    sub AR_USB_US_ENA () {	(1<< 1);}
}
unless(defined(&AR_USB_US_PACKET_MODE)) {
    sub AR_USB_US_PACKET_MODE () {	(1<< 3);}
}
unless(defined(&AR_USB_RX_STREAM_4K)) {
    sub AR_USB_RX_STREAM_4K () {	(0<< 4);}
}
unless(defined(&AR_USB_RX_STREAM_8K)) {
    sub AR_USB_RX_STREAM_8K () {	(1<< 4);}
}
unless(defined(&AR_USB_RX_STREAM_16K)) {
    sub AR_USB_RX_STREAM_16K () {	(2<< 4);}
}
unless(defined(&AR_USB_RX_STREAM_32K)) {
    sub AR_USB_RX_STREAM_32K () {	(3<< 4);}
}
unless(defined(&AR_USB_TX_STREAM_MODE)) {
    sub AR_USB_TX_STREAM_MODE () {	(1<< 6);}
}
unless(defined(&AR_LED0_ON)) {
    sub AR_LED0_ON () {	(1<< 0);}
}
unless(defined(&AR_LED1_ON)) {
    sub AR_LED1_ON () {	(1<< 1);}
}
unless(defined(&AR_PHY_BASE)) {
    sub AR_PHY_BASE () {	0x1c5800;}
}
unless(defined(&AR_PHY)) {
    sub AR_PHY {
	my($reg) = @_;
	eval q(( &AR_PHY_BASE + ($reg) * 4));
    }
}
unless(defined(&AR_PHY_TURBO)) {
    sub AR_PHY_TURBO () {	( &AR_PHY_BASE + 0x4);}
}
unless(defined(&AR_PHY_RF_CTL3)) {
    sub AR_PHY_RF_CTL3 () {	( &AR_PHY_BASE + 0x28);}
}
unless(defined(&AR_PHY_RF_CTL4)) {
    sub AR_PHY_RF_CTL4 () {	( &AR_PHY_BASE + 0x34);}
}
unless(defined(&AR_PHY_SETTLING)) {
    sub AR_PHY_SETTLING () {	( &AR_PHY_BASE + 0x44);}
}
unless(defined(&AR_PHY_RXGAIN)) {
    sub AR_PHY_RXGAIN () {	( &AR_PHY_BASE + 0x48);}
}
unless(defined(&AR_PHY_DESIRED_SZ)) {
    sub AR_PHY_DESIRED_SZ () {	( &AR_PHY_BASE + 0x50);}
}
unless(defined(&AR_PHY_FIND_SIG)) {
    sub AR_PHY_FIND_SIG () {	( &AR_PHY_BASE + 0x58);}
}
unless(defined(&AR_PHY_AGC_CTL1)) {
    sub AR_PHY_AGC_CTL1 () {	( &AR_PHY_BASE + 0x5c);}
}
unless(defined(&AR_PHY_SFCORR)) {
    sub AR_PHY_SFCORR () {	( &AR_PHY_BASE + 0x68);}
}
unless(defined(&AR_PHY_SFCORR_LOW)) {
    sub AR_PHY_SFCORR_LOW () {	( &AR_PHY_BASE + 0x6c);}
}
unless(defined(&AR_PHY_TIMING_CTRL4)) {
    sub AR_PHY_TIMING_CTRL4 () {	( &AR_PHY_BASE + 0x120);}
}
unless(defined(&AR_PHY_TIMING5)) {
    sub AR_PHY_TIMING5 () {	( &AR_PHY_BASE + 0x124);}
}
unless(defined(&AR_PHY_POWER_TX_RATE1)) {
    sub AR_PHY_POWER_TX_RATE1 () {	( &AR_PHY_BASE + 0x134);}
}
unless(defined(&AR_PHY_POWER_TX_RATE2)) {
    sub AR_PHY_POWER_TX_RATE2 () {	( &AR_PHY_BASE + 0x138);}
}
unless(defined(&AR_PHY_POWER_TX_RATE_MAX)) {
    sub AR_PHY_POWER_TX_RATE_MAX () {	( &AR_PHY_BASE + 0x13c);}
}
unless(defined(&AR_PHY_SWITCH_CHAIN_0)) {
    sub AR_PHY_SWITCH_CHAIN_0 () {	( &AR_PHY_BASE + 0x160);}
}
unless(defined(&AR_PHY_SWITCH_COM)) {
    sub AR_PHY_SWITCH_COM () {	( &AR_PHY_BASE + 0x164);}
}
unless(defined(&AR_PHY_HEAVY_CLIP_ENABLE)) {
    sub AR_PHY_HEAVY_CLIP_ENABLE () {	( &AR_PHY_BASE + 0x1e0);}
}
unless(defined(&AR_PHY_CCK_DETECT)) {
    sub AR_PHY_CCK_DETECT () {	( &AR_PHY_BASE + 0xa08);}
}
unless(defined(&AR_PHY_GAIN_2GHZ)) {
    sub AR_PHY_GAIN_2GHZ () {	( &AR_PHY_BASE + 0xa0c);}
}
unless(defined(&AR_PHY_POWER_TX_RATE3)) {
    sub AR_PHY_POWER_TX_RATE3 () {	( &AR_PHY_BASE + 0xa34);}
}
unless(defined(&AR_PHY_POWER_TX_RATE4)) {
    sub AR_PHY_POWER_TX_RATE4 () {	( &AR_PHY_BASE + 0xa38);}
}
unless(defined(&AR_PHY_TPCRG1)) {
    sub AR_PHY_TPCRG1 () {	( &AR_PHY_BASE + 0xa58);}
}
unless(defined(&AR_PHY_POWER_TX_RATE5)) {
    sub AR_PHY_POWER_TX_RATE5 () {	( &AR_PHY_BASE + 0xb8c);}
}
unless(defined(&AR_PHY_POWER_TX_RATE6)) {
    sub AR_PHY_POWER_TX_RATE6 () {	( &AR_PHY_BASE + 0xb90);}
}
unless(defined(&AR_PHY_POWER_TX_RATE7)) {
    sub AR_PHY_POWER_TX_RATE7 () {	( &AR_PHY_BASE + 0xbcc);}
}
unless(defined(&AR_PHY_POWER_TX_RATE8)) {
    sub AR_PHY_POWER_TX_RATE8 () {	( &AR_PHY_BASE + 0xbd0);}
}
unless(defined(&AR_PHY_POWER_TX_RATE9)) {
    sub AR_PHY_POWER_TX_RATE9 () {	( &AR_PHY_BASE + 0xbd4);}
}
unless(defined(&AR_PHY_CCA)) {
    sub AR_PHY_CCA () {	( &AR_PHY_BASE + 0x3064);}
}
unless(defined(&AR_SEEPROM_HW_TYPE_OFFSET)) {
    sub AR_SEEPROM_HW_TYPE_OFFSET () {	0x1374;}
}
unless(defined(&AR_EEPROM_OFFSET)) {
    sub AR_EEPROM_OFFSET () {	0x1600;}
}
unless(defined(&AR_BANK4_CHUP)) {
    sub AR_BANK4_CHUP () {	(1<< 0);}
}
unless(defined(&AR_BANK4_BMODE_LF_SYNTH_FREQ)) {
    sub AR_BANK4_BMODE_LF_SYNTH_FREQ () {	(1<< 1);}
}
unless(defined(&AR_BANK4_AMODE_REFSEL)) {
    sub AR_BANK4_AMODE_REFSEL {
	my($x) = @_;
	eval q((($x) << 2));
    }
}
unless(defined(&AR_BANK4_ADDR)) {
    sub AR_BANK4_ADDR {
	my($x) = @_;
	eval q((($x) << 5));
    }
}
unless(defined(&AR_TX_MAC_RTS)) {
    sub AR_TX_MAC_RTS () {	(1<< 0);}
}
unless(defined(&AR_TX_MAC_CTS)) {
    sub AR_TX_MAC_CTS () {	(1<< 1);}
}
unless(defined(&AR_TX_MAC_BACKOFF)) {
    sub AR_TX_MAC_BACKOFF () {	(1<< 3);}
}
unless(defined(&AR_TX_MAC_NOACK)) {
    sub AR_TX_MAC_NOACK () {	(1<< 2);}
}
unless(defined(&AR_TX_MAC_HW_DUR)) {
    sub AR_TX_MAC_HW_DUR () {	(1<< 9);}
}
unless(defined(&AR_TX_MAC_QID)) {
    sub AR_TX_MAC_QID {
	my($qid) = @_;
	eval q((($qid) << 10));
    }
}
unless(defined(&AR_TX_MAC_RATE_PROBING)) {
    sub AR_TX_MAC_RATE_PROBING () {	(1<< 15);}
}
unless(defined(&AR_TX_PHY_MT_CCK)) {
    sub AR_TX_PHY_MT_CCK () {	0;}
}
unless(defined(&AR_TX_PHY_MT_OFDM)) {
    sub AR_TX_PHY_MT_OFDM () {	1;}
}
unless(defined(&AR_TX_PHY_MT_HT)) {
    sub AR_TX_PHY_MT_HT () {	2;}
}
unless(defined(&AR_TX_PHY_GF)) {
    sub AR_TX_PHY_GF () {	(1<< 2);}
}
unless(defined(&AR_TX_PHY_BW_SHIFT)) {
    sub AR_TX_PHY_BW_SHIFT () {	3;}
}
unless(defined(&AR_TX_PHY_TPC_SHIFT)) {
    sub AR_TX_PHY_TPC_SHIFT () {	9;}
}
unless(defined(&AR_TX_PHY_ANTMSK)) {
    sub AR_TX_PHY_ANTMSK {
	my($msk) = @_;
	eval q((($msk) << 15));
    }
}
unless(defined(&AR_TX_PHY_MCS)) {
    sub AR_TX_PHY_MCS {
	my($mcs) = @_;
	eval q((($mcs) << 18));
    }
}
unless(defined(&AR_TX_PHY_SHGI)) {
    sub AR_TX_PHY_SHGI () {	(1<< 31);}
}
unless(defined(&AR_RX_HEAD_TAG)) {
    sub AR_RX_HEAD_TAG () {	0x4e00;}
}
unless(defined(&AR_RX_ERROR_TIMEOUT)) {
    sub AR_RX_ERROR_TIMEOUT () {	(1<< 0);}
}
unless(defined(&AR_RX_ERROR_OVERRUN)) {
    sub AR_RX_ERROR_OVERRUN () {	(1<< 1);}
}
unless(defined(&AR_RX_ERROR_DECRYPT)) {
    sub AR_RX_ERROR_DECRYPT () {	(1<< 2);}
}
unless(defined(&AR_RX_ERROR_FCS)) {
    sub AR_RX_ERROR_FCS () {	(1<< 3);}
}
unless(defined(&AR_RX_ERROR_BAD_RA)) {
    sub AR_RX_ERROR_BAD_RA () {	(1<< 4);}
}
unless(defined(&AR_RX_ERROR_PLCP)) {
    sub AR_RX_ERROR_PLCP () {	(1<< 5);}
}
unless(defined(&AR_RX_ERROR_MMIC)) {
    sub AR_RX_ERROR_MMIC () {	(1<< 6);}
}
unless(defined(&AR_RX_STATUS_MT_MASK)) {
    sub AR_RX_STATUS_MT_MASK () {	0x3;}
}
unless(defined(&AR_RX_STATUS_MT_CCK)) {
    sub AR_RX_STATUS_MT_CCK () {	0;}
}
unless(defined(&AR_RX_STATUS_MT_OFDM)) {
    sub AR_RX_STATUS_MT_OFDM () {	1;}
}
unless(defined(&AR_RX_STATUS_MT_HT)) {
    sub AR_RX_STATUS_MT_HT () {	2;}
}
unless(defined(&AR_RX_STATUS_SHPREAMBLE)) {
    sub AR_RX_STATUS_SHPREAMBLE () {	(1<< 3);}
}
unless(defined(&AR_PLCP_HDR_LEN)) {
    sub AR_PLCP_HDR_LEN () {	12;}
}
unless(defined(&AR_CMD_RREG)) {
    sub AR_CMD_RREG () {	0x;}
}
unless(defined(&AR_CMD_WREG)) {
    sub AR_CMD_WREG () {	0x1;}
}
unless(defined(&AR_CMD_RMEM)) {
    sub AR_CMD_RMEM () {	0x2;}
}
unless(defined(&AR_CMD_WMEM)) {
    sub AR_CMD_WMEM () {	0x3;}
}
unless(defined(&AR_CMD_BITAND)) {
    sub AR_CMD_BITAND () {	0x4;}
}
unless(defined(&AR_CMD_BITOR)) {
    sub AR_CMD_BITOR () {	0x5;}
}
unless(defined(&AR_CMD_EKEY)) {
    sub AR_CMD_EKEY () {	0x28;}
}
unless(defined(&AR_CMD_DKEY)) {
    sub AR_CMD_DKEY () {	0x29;}
}
unless(defined(&AR_CMD_FREQUENCY)) {
    sub AR_CMD_FREQUENCY () {	0x30;}
}
unless(defined(&AR_CMD_RF_INIT)) {
    sub AR_CMD_RF_INIT () {	0x31;}
}
unless(defined(&AR_CMD_SYNTH)) {
    sub AR_CMD_SYNTH () {	0x32;}
}
unless(defined(&AR_CMD_FREQ_STRAT)) {
    sub AR_CMD_FREQ_STRAT () {	0x33;}
}
unless(defined(&AR_CMD_ECHO)) {
    sub AR_CMD_ECHO () {	0x80;}
}
unless(defined(&AR_CMD_TALLY)) {
    sub AR_CMD_TALLY () {	0x81;}
}
unless(defined(&AR_CMD_TALLY_APD)) {
    sub AR_CMD_TALLY_APD () {	0x82;}
}
unless(defined(&AR_CMD_CONFIG)) {
    sub AR_CMD_CONFIG () {	0x83;}
}
unless(defined(&AR_CMD_RESET)) {
    sub AR_CMD_RESET () {	0x90;}
}
unless(defined(&AR_CMD_DKRESET)) {
    sub AR_CMD_DKRESET () {	0x91;}
}
unless(defined(&AR_CMD_DKTX_STATUS)) {
    sub AR_CMD_DKTX_STATUS () {	0x92;}
}
unless(defined(&AR_CMD_FDC)) {
    sub AR_CMD_FDC () {	0xa0;}
}
unless(defined(&AR_CMD_WREEPROM)) {
    sub AR_CMD_WREEPROM () {	0xb0;}
}
unless(defined(&AR_CMD_WFLASH)) {
    sub AR_CMD_WFLASH () {	 &AR_CMD_WREEPROM;}
}
unless(defined(&AR_CMD_FLASH_ERASE)) {
    sub AR_CMD_FLASH_ERASE () {	0xb1;}
}
unless(defined(&AR_CMD_FLASH_PROG)) {
    sub AR_CMD_FLASH_PROG () {	0xb2;}
}
unless(defined(&AR_CMD_FLASH_CHKSUM)) {
    sub AR_CMD_FLASH_CHKSUM () {	0xb3;}
}
unless(defined(&AR_CMD_FLASH_READ)) {
    sub AR_CMD_FLASH_READ () {	0xb4;}
}
unless(defined(&AR_CMD_FW_DL_INIT)) {
    sub AR_CMD_FW_DL_INIT () {	0xb5;}
}
unless(defined(&AR_CMD_MEM_WREEPROM)) {
    sub AR_CMD_MEM_WREEPROM () {	0xbb;}
}
unless(defined(&AR_EVT_BEACON)) {
    sub AR_EVT_BEACON () {	0x;}
}
unless(defined(&AR_EVT_TX_COMP)) {
    sub AR_EVT_TX_COMP () {	0x1;}
}
unless(defined(&AR_EVT_TBTT)) {
    sub AR_EVT_TBTT () {	0x2;}
}
unless(defined(&AR_EVT_ATIM)) {
    sub AR_EVT_ATIM () {	0x3;}
}
unless(defined(&AR_CAL_ERR_AGC)) {
    sub AR_CAL_ERR_AGC () {	(1<< 0);}
}
unless(defined(&AR_CAL_ERR_NF)) {
    sub AR_CAL_ERR_NF () {	(1<< 1);}
}
unless(defined(&AR_CAL_ERR_NF_VAL)) {
    sub AR_CAL_ERR_NF_VAL () {	(1<< 2);}
}
unless(defined(&AR_CIPHER_NONE)) {
    sub AR_CIPHER_NONE () {	0;}
}
unless(defined(&AR_CIPHER_WEP64)) {
    sub AR_CIPHER_WEP64 () {	1;}
}
unless(defined(&AR_CIPHER_TKIP)) {
    sub AR_CIPHER_TKIP () {	2;}
}
unless(defined(&AR_CIPHER_AES)) {
    sub AR_CIPHER_AES () {	4;}
}
unless(defined(&AR_CIPHER_WEP128)) {
    sub AR_CIPHER_WEP128 () {	5;}
}
unless(defined(&AR_CIPHER_WEP256)) {
    sub AR_CIPHER_WEP256 () {	6;}
}
unless(defined(&AR_CIPHER_CENC)) {
    sub AR_CIPHER_CENC () {	7;}
}
unless(defined(&AR_TX_STATUS_COMP)) {
    sub AR_TX_STATUS_COMP () {	0;}
}
unless(defined(&AR_TX_STATUS_RETRY_COMP)) {
    sub AR_TX_STATUS_RETRY_COMP () {	1;}
}
unless(defined(&AR_TX_STATUS_FAILED)) {
    sub AR_TX_STATUS_FAILED () {	2;}
}
if(defined(&notyet)) {
}
if(defined(&notyet)) {
}
unless(defined(&AR5416_OPFLAGS_11A)) {
    sub AR5416_OPFLAGS_11A () {	0x1;}
}
unless(defined(&AR5416_OPFLAGS_11G)) {
    sub AR5416_OPFLAGS_11G () {	0x2;}
}
unless(defined(&AR5416_OPFLAGS_5G_HT40)) {
    sub AR5416_OPFLAGS_5G_HT40 () {	0x4;}
}
unless(defined(&AR5416_OPFLAGS_2G_HT40)) {
    sub AR5416_OPFLAGS_2G_HT40 () {	0x8;}
}
unless(defined(&AR5416_OPFLAGS_5G_HT20)) {
    sub AR5416_OPFLAGS_5G_HT20 () {	0x10;}
}
unless(defined(&AR5416_OPFLAGS_2G_HT20)) {
    sub AR5416_OPFLAGS_2G_HT20 () {	0x20;}
}
unless(defined(&AR5416_NUM_5G_CAL_PIERS)) {
    sub AR5416_NUM_5G_CAL_PIERS () {	8;}
}
unless(defined(&AR5416_NUM_2G_CAL_PIERS)) {
    sub AR5416_NUM_2G_CAL_PIERS () {	4;}
}
unless(defined(&AR5416_NUM_5G_20_TARGET_POWERS)) {
    sub AR5416_NUM_5G_20_TARGET_POWERS () {	8;}
}
unless(defined(&AR5416_NUM_5G_40_TARGET_POWERS)) {
    sub AR5416_NUM_5G_40_TARGET_POWERS () {	8;}
}
unless(defined(&AR5416_NUM_2G_CCK_TARGET_POWERS)) {
    sub AR5416_NUM_2G_CCK_TARGET_POWERS () {	3;}
}
unless(defined(&AR5416_NUM_2G_20_TARGET_POWERS)) {
    sub AR5416_NUM_2G_20_TARGET_POWERS () {	4;}
}
unless(defined(&AR5416_NUM_2G_40_TARGET_POWERS)) {
    sub AR5416_NUM_2G_40_TARGET_POWERS () {	4;}
}
unless(defined(&AR5416_NUM_CTLS)) {
    sub AR5416_NUM_CTLS () {	24;}
}
unless(defined(&AR5416_NUM_BAND_EDGES)) {
    sub AR5416_NUM_BAND_EDGES () {	8;}
}
unless(defined(&AR5416_NUM_PD_GAINS)) {
    sub AR5416_NUM_PD_GAINS () {	4;}
}
unless(defined(&AR5416_PD_GAIN_ICEPTS)) {
    sub AR5416_PD_GAIN_ICEPTS () {	5;}
}
unless(defined(&AR5416_EEPROM_MODAL_SPURS)) {
    sub AR5416_EEPROM_MODAL_SPURS () {	5;}
}
unless(defined(&AR5416_MAX_CHAINS)) {
    sub AR5416_MAX_CHAINS () {	2;}
}
unless(defined(&OTUS_TX_DATA_LIST_COUNT)) {
    sub OTUS_TX_DATA_LIST_COUNT () {	8;}
}
unless(defined(&OTUS_RX_DATA_LIST_COUNT)) {
    sub OTUS_RX_DATA_LIST_COUNT () {	1;}
}
unless(defined(&OTUS_CMD_TIMEOUT)) {
    sub OTUS_CMD_TIMEOUT () {	1000;}
}
unless(defined(&OTUS_TX_TIMEOUT)) {
    sub OTUS_TX_TIMEOUT () {	1000;}
}
unless(defined(&OTUS_UID)) {
    sub OTUS_UID {
	my($aid) = @_;
	eval q(( &IEEE80211_AID($aid) + 4));
    }
}
unless(defined(&OTUS_MAX_TXCMDSZ)) {
    sub OTUS_MAX_TXCMDSZ () {	64;}
}
unless(defined(&OTUS_RXBUFSZ)) {
    sub OTUS_RXBUFSZ () {	(8* 1024);}
}
unless(defined(&OTUS_TXBUFSZ)) {
    sub OTUS_TXBUFSZ () {	(4* 1024);}
}
unless(defined(&OTUS_RIDX_CCK1)) {
    sub OTUS_RIDX_CCK1 () {	0;}
}
unless(defined(&OTUS_RIDX_OFDM6)) {
    sub OTUS_RIDX_OFDM6 () {	4;}
}
unless(defined(&OTUS_RIDX_OFDM24)) {
    sub OTUS_RIDX_OFDM24 () {	8;}
}
unless(defined(&OTUS_RIDX_MAX)) {
    sub OTUS_RIDX_MAX () {	11;}
}
unless(defined(&OTUS_RX_RADIOTAP_PRESENT)) {
    sub OTUS_RX_RADIOTAP_PRESENT () {	(1<<  &IEEE80211_RADIOTAP_FLAGS | 1<<  &IEEE80211_RADIOTAP_RATE | 1<<  &IEEE80211_RADIOTAP_CHANNEL | 1<<  &IEEE80211_RADIOTAP_DB_ANTSIGNAL);}
}
unless(defined(&OTUS_TX_RADIOTAP_PRESENT)) {
    sub OTUS_TX_RADIOTAP_PRESENT () {	(1<<  &IEEE80211_RADIOTAP_FLAGS | 1<<  &IEEE80211_RADIOTAP_RATE | 1<<  &IEEE80211_RADIOTAP_CHANNEL);}
}
unless(defined(&OTUS_HOST_CMD_RING_COUNT)) {
    sub OTUS_HOST_CMD_RING_COUNT () {	32;}
}
if((defined(&NBPFILTER) ? &NBPFILTER : undef) > 0) {
    eval 'sub sc_rxtap () { ($sc_rxtapu->{th});}' unless defined(&sc_rxtap);
    eval 'sub sc_txtap () { ($sc_txtapu->{th});}' unless defined(&sc_txtap);
}
1;
