require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&AR_USB_MAX_STA)) {
    sub AR_USB_MAX_STA () {	8;}
}
unless(defined(&AR_USB_DEFAULT_NF)) {
    sub AR_USB_DEFAULT_NF () {	(-95);}
}
unless(defined(&AR_FW_DOWNLOAD)) {
    sub AR_FW_DOWNLOAD () {	0x30;}
}
unless(defined(&AR_FW_DOWNLOAD_COMP)) {
    sub AR_FW_DOWNLOAD_COMP () {	0x31;}
}
unless(defined(&AR_PIPE_TX_DATA)) {
    sub AR_PIPE_TX_DATA () {	( &UE_DIR_OUT | 1);}
}
unless(defined(&AR_PIPE_RX_DATA)) {
    sub AR_PIPE_RX_DATA () {	( &UE_DIR_IN | 2);}
}
unless(defined(&AR_PIPE_RX_INTR)) {
    sub AR_PIPE_RX_INTR () {	( &UE_DIR_IN | 3);}
}
unless(defined(&AR_PIPE_TX_INTR)) {
    sub AR_PIPE_TX_INTR () {	( &UE_DIR_OUT | 4);}
}
unless(defined(&AR_WMI_CMD_ECHO)) {
    sub AR_WMI_CMD_ECHO () {	0x1;}
}
unless(defined(&AR_WMI_CMD_ACCESS_MEMORY)) {
    sub AR_WMI_CMD_ACCESS_MEMORY () {	0x2;}
}
unless(defined(&AR_WMI_CMD_DISABLE_INTR)) {
    sub AR_WMI_CMD_DISABLE_INTR () {	0x3;}
}
unless(defined(&AR_WMI_CMD_ENABLE_INTR)) {
    sub AR_WMI_CMD_ENABLE_INTR () {	0x4;}
}
unless(defined(&AR_WMI_CMD_RX_LINK)) {
    sub AR_WMI_CMD_RX_LINK () {	0x5;}
}
unless(defined(&AR_WMI_CMD_ATH_INIT)) {
    sub AR_WMI_CMD_ATH_INIT () {	0x6;}
}
unless(defined(&AR_WMI_CMD_ABORT_TXQ)) {
    sub AR_WMI_CMD_ABORT_TXQ () {	0x7;}
}
unless(defined(&AR_WMI_CMD_STOP_TX_DMA)) {
    sub AR_WMI_CMD_STOP_TX_DMA () {	0x8;}
}
unless(defined(&AR_WMI_CMD_STOP_DMA_RECV)) {
    sub AR_WMI_CMD_STOP_DMA_RECV () {	0x9;}
}
unless(defined(&AR_WMI_CMD_ABORT_TX_DMA)) {
    sub AR_WMI_CMD_ABORT_TX_DMA () {	0xa;}
}
unless(defined(&AR_WMI_CMD_DRAIN_TXQ)) {
    sub AR_WMI_CMD_DRAIN_TXQ () {	0xb;}
}
unless(defined(&AR_WMI_CMD_DRAIN_TXQ_ALL)) {
    sub AR_WMI_CMD_DRAIN_TXQ_ALL () {	0xc;}
}
unless(defined(&AR_WMI_CMD_START_RECV)) {
    sub AR_WMI_CMD_START_RECV () {	0xd;}
}
unless(defined(&AR_WMI_CMD_STOP_RECV)) {
    sub AR_WMI_CMD_STOP_RECV () {	0xe;}
}
unless(defined(&AR_WMI_CMD_FLUSH_RECV)) {
    sub AR_WMI_CMD_FLUSH_RECV () {	0xf;}
}
unless(defined(&AR_WMI_CMD_SET_MODE)) {
    sub AR_WMI_CMD_SET_MODE () {	0x10;}
}
unless(defined(&AR_WMI_CMD_RESET)) {
    sub AR_WMI_CMD_RESET () {	0x11;}
}
unless(defined(&AR_WMI_CMD_NODE_CREATE)) {
    sub AR_WMI_CMD_NODE_CREATE () {	0x12;}
}
unless(defined(&AR_WMI_CMD_NODE_REMOVE)) {
    sub AR_WMI_CMD_NODE_REMOVE () {	0x13;}
}
unless(defined(&AR_WMI_CMD_VAP_REMOVE)) {
    sub AR_WMI_CMD_VAP_REMOVE () {	0x14;}
}
unless(defined(&AR_WMI_CMD_VAP_CREATE)) {
    sub AR_WMI_CMD_VAP_CREATE () {	0x15;}
}
unless(defined(&AR_WMI_CMD_BEACON_UPDATE)) {
    sub AR_WMI_CMD_BEACON_UPDATE () {	0x16;}
}
unless(defined(&AR_WMI_CMD_REG_READ)) {
    sub AR_WMI_CMD_REG_READ () {	0x17;}
}
unless(defined(&AR_WMI_CMD_REG_WRITE)) {
    sub AR_WMI_CMD_REG_WRITE () {	0x18;}
}
unless(defined(&AR_WMI_CMD_RC_STATE_CHANGE)) {
    sub AR_WMI_CMD_RC_STATE_CHANGE () {	0x19;}
}
unless(defined(&AR_WMI_CMD_RC_RATE_UPDATE)) {
    sub AR_WMI_CMD_RC_RATE_UPDATE () {	0x1a;}
}
unless(defined(&AR_WMI_CMD_DEBUG_INFO)) {
    sub AR_WMI_CMD_DEBUG_INFO () {	0x1b;}
}
unless(defined(&AR_WMI_CMD_HOST_ATTACH)) {
    sub AR_WMI_CMD_HOST_ATTACH () {	0x1c;}
}
unless(defined(&AR_WMI_CMD_TARGET_IC_UPDATE)) {
    sub AR_WMI_CMD_TARGET_IC_UPDATE () {	0x1d;}
}
unless(defined(&AR_WMI_CMD_TGT_STATS)) {
    sub AR_WMI_CMD_TGT_STATS () {	0x1e;}
}
unless(defined(&AR_WMI_CMD_TX_AGGR_ENABLE)) {
    sub AR_WMI_CMD_TX_AGGR_ENABLE () {	0x1f;}
}
unless(defined(&AR_WMI_CMD_TGT_DETACH)) {
    sub AR_WMI_CMD_TGT_DETACH () {	0x20;}
}
unless(defined(&AR_WMI_CMD_TGT_TXQ_ENABLE)) {
    sub AR_WMI_CMD_TGT_TXQ_ENABLE () {	0x21;}
}
unless(defined(&AR_WMI_CMD_AGGR_LIMIT)) {
    sub AR_WMI_CMD_AGGR_LIMIT () {	0x26;}
}
unless(defined(&AR_WMI_EVT_TGT_RDY)) {
    sub AR_WMI_EVT_TGT_RDY () {	0x1;}
}
unless(defined(&AR_WMI_EVT_SWBA)) {
    sub AR_WMI_EVT_SWBA () {	0x2;}
}
unless(defined(&AR_WMI_EVT_FATAL)) {
    sub AR_WMI_EVT_FATAL () {	0x3;}
}
unless(defined(&AR_WMI_EVT_TXTO)) {
    sub AR_WMI_EVT_TXTO () {	0x4;}
}
unless(defined(&AR_WMI_EVT_BMISS)) {
    sub AR_WMI_EVT_BMISS () {	0x5;}
}
unless(defined(&AR_WMI_EVT_WLAN_TXCOMP)) {
    sub AR_WMI_EVT_WLAN_TXCOMP () {	0x6;}
}
unless(defined(&AR_WMI_EVT_DELBA)) {
    sub AR_WMI_EVT_DELBA () {	0x7;}
}
unless(defined(&AR_WMI_EVT_TXRATE)) {
    sub AR_WMI_EVT_TXRATE () {	0x8;}
}
unless(defined(&AR_WMI_EVT_FLAG)) {
    sub AR_WMI_EVT_FLAG () {	0x1000;}
}
unless(defined(&AR_HTC_MODE_AUTO)) {
    sub AR_HTC_MODE_AUTO () {	0;}
}
unless(defined(&AR_HTC_MODE_11A)) {
    sub AR_HTC_MODE_11A () {	1;}
}
unless(defined(&AR_HTC_MODE_11B)) {
    sub AR_HTC_MODE_11B () {	2;}
}
unless(defined(&AR_HTC_MODE_11G)) {
    sub AR_HTC_MODE_11G () {	3;}
}
unless(defined(&AR_HTC_MODE_FH)) {
    sub AR_HTC_MODE_FH () {	4;}
}
unless(defined(&AR_HTC_MODE_TURBO_A)) {
    sub AR_HTC_MODE_TURBO_A () {	5;}
}
unless(defined(&AR_HTC_MODE_TURBO_G)) {
    sub AR_HTC_MODE_TURBO_G () {	6;}
}
unless(defined(&AR_HTC_MODE_11NA)) {
    sub AR_HTC_MODE_11NA () {	7;}
}
unless(defined(&AR_HTC_MODE_11NG)) {
    sub AR_HTC_MODE_11NG () {	8;}
}
unless(defined(&AR_MAX_WRITE_COUNT)) {
    sub AR_MAX_WRITE_COUNT () {	32;}
}
unless(defined(&AR_HTC_STA_AUTH)) {
    sub AR_HTC_STA_AUTH () {	0x1;}
}
unless(defined(&AR_HTC_STA_QOS)) {
    sub AR_HTC_STA_QOS () {	0x2;}
}
unless(defined(&AR_HTC_STA_ERP)) {
    sub AR_HTC_STA_ERP () {	0x4;}
}
unless(defined(&AR_HTC_STA_HT)) {
    sub AR_HTC_STA_HT () {	0x8;}
}
unless(defined(&AR_HTC_RATE_MAX)) {
    sub AR_HTC_RATE_MAX () {	30;}
}
unless(defined(&AR_RC_DS_FLAG)) {
    sub AR_RC_DS_FLAG () {	0x1;}
}
unless(defined(&AR_RC_TS_FLAG)) {
    sub AR_RC_TS_FLAG () {	0x2;}
}
unless(defined(&AR_RC_40_FLAG)) {
    sub AR_RC_40_FLAG () {	0x4;}
}
unless(defined(&AR_RC_SGI_FLAG)) {
    sub AR_RC_SGI_FLAG () {	0x8;}
}
unless(defined(&AR_RC_HT_FLAG)) {
    sub AR_RC_HT_FLAG () {	0x10;}
}
unless(defined(&AR_HTC_M_IBSS)) {
    sub AR_HTC_M_IBSS () {	0;}
}
unless(defined(&AR_HTC_M_STA)) {
    sub AR_HTC_M_STA () {	1;}
}
unless(defined(&AR_HTC_M_WDS)) {
    sub AR_HTC_M_WDS () {	2;}
}
unless(defined(&AR_HTC_M_AHDEMO)) {
    sub AR_HTC_M_AHDEMO () {	3;}
}
unless(defined(&AR_HTC_M_HOSTAP)) {
    sub AR_HTC_M_HOSTAP () {	6;}
}
unless(defined(&AR_HTC_M_MONITOR)) {
    sub AR_HTC_M_MONITOR () {	8;}
}
unless(defined(&AR_HTC_FLAG_TRAILER)) {
    sub AR_HTC_FLAG_TRAILER () {	0x2;}
}
unless(defined(&AR_HTC_MSG_READY)) {
    sub AR_HTC_MSG_READY () {	0x1;}
}
unless(defined(&AR_HTC_MSG_CONN_SVC)) {
    sub AR_HTC_MSG_CONN_SVC () {	0x2;}
}
unless(defined(&AR_HTC_MSG_CONN_SVC_RSP)) {
    sub AR_HTC_MSG_CONN_SVC_RSP () {	0x3;}
}
unless(defined(&AR_HTC_MSG_SETUP_COMPLETE)) {
    sub AR_HTC_MSG_SETUP_COMPLETE () {	0x4;}
}
unless(defined(&AR_HTC_MSG_CONF_PIPE)) {
    sub AR_HTC_MSG_CONF_PIPE () {	0x5;}
}
unless(defined(&AR_HTC_MSG_CONF_PIPE_RSP)) {
    sub AR_HTC_MSG_CONF_PIPE_RSP () {	0x6;}
}
unless(defined(&AR_HTC_AMPDU)) {
    sub AR_HTC_AMPDU () {	1;}
}
unless(defined(&AR_HTC_NORMAL)) {
    sub AR_HTC_NORMAL () {	2;}
}
unless(defined(&AR_HTC_TX_CTSONLY)) {
    sub AR_HTC_TX_CTSONLY () {	0x1;}
}
unless(defined(&AR_HTC_TX_RTSCTS)) {
    sub AR_HTC_TX_RTSCTS () {	0x2;}
}
unless(defined(&AR_HTC_TX_USE_MIN_RATE)) {
    sub AR_HTC_TX_USE_MIN_RATE () {	0x100;}
}
unless(defined(&AR_HTC_SVC_SUCCESS)) {
    sub AR_HTC_SVC_SUCCESS () {	0;}
}
unless(defined(&AR_HTC_SVC_NOT_FOUND)) {
    sub AR_HTC_SVC_NOT_FOUND () {	1;}
}
unless(defined(&AR_HTC_SVC_FAILED)) {
    sub AR_HTC_SVC_FAILED () {	2;}
}
unless(defined(&AR_HTC_SVC_NO_RESOURCES)) {
    sub AR_HTC_SVC_NO_RESOURCES () {	3;}
}
unless(defined(&AR_HTC_SVC_NO_MORE_EP)) {
    sub AR_HTC_SVC_NO_MORE_EP () {	4;}
}
unless(defined(&AR_SVC)) {
    sub AR_SVC {
	my($grp, $idx) = @_;
	eval q((($grp) << 8| ($idx)));
    }
}
unless(defined(&AR_SVC_IDX)) {
    sub AR_SVC_IDX {
	my($svc) = @_;
	eval q((($svc) & 0xff));
    }
}
unless(defined(&AR_SVC_GRP_RSVD)) {
    sub AR_SVC_GRP_RSVD () {	0;}
}
unless(defined(&AR_SVC_GRP_WMI)) {
    sub AR_SVC_GRP_WMI () {	1;}
}
unless(defined(&AR_SVC_WMI_CONTROL)) {
    sub AR_SVC_WMI_CONTROL () {	 &AR_SVC( &AR_SVC_GRP_WMI, 0);}
}
unless(defined(&AR_SVC_WMI_BEACON)) {
    sub AR_SVC_WMI_BEACON () {	 &AR_SVC( &AR_SVC_GRP_WMI, 1);}
}
unless(defined(&AR_SVC_WMI_CAB)) {
    sub AR_SVC_WMI_CAB () {	 &AR_SVC( &AR_SVC_GRP_WMI, 2);}
}
unless(defined(&AR_SVC_WMI_UAPSD)) {
    sub AR_SVC_WMI_UAPSD () {	 &AR_SVC( &AR_SVC_GRP_WMI, 3);}
}
unless(defined(&AR_SVC_WMI_MGMT)) {
    sub AR_SVC_WMI_MGMT () {	 &AR_SVC( &AR_SVC_GRP_WMI, 4);}
}
unless(defined(&AR_SVC_WMI_DATA_VO)) {
    sub AR_SVC_WMI_DATA_VO () {	 &AR_SVC( &AR_SVC_GRP_WMI, 5);}
}
unless(defined(&AR_SVC_WMI_DATA_VI)) {
    sub AR_SVC_WMI_DATA_VI () {	 &AR_SVC( &AR_SVC_GRP_WMI, 6);}
}
unless(defined(&AR_SVC_WMI_DATA_BE)) {
    sub AR_SVC_WMI_DATA_BE () {	 &AR_SVC( &AR_SVC_GRP_WMI, 7);}
}
unless(defined(&AR_SVC_WMI_DATA_BK)) {
    sub AR_SVC_WMI_DATA_BK () {	 &AR_SVC( &AR_SVC_GRP_WMI, 8);}
}
unless(defined(&AR_USB_RX_STREAM_TAG)) {
    sub AR_USB_RX_STREAM_TAG () {	0x4e00;}
}
unless(defined(&AR_USB_TX_STREAM_TAG)) {
    sub AR_USB_TX_STREAM_TAG () {	0x697e;}
}
unless(defined(&AR_MAX_CHAINS)) {
    sub AR_MAX_CHAINS () {	3;}
}
unless(defined(&AR_RXS_FLAG_GI)) {
    sub AR_RXS_FLAG_GI () {	0x4;}
}
unless(defined(&AR_RXS_FLAG_2040)) {
    sub AR_RXS_FLAG_2040 () {	0x8;}
}
unless(defined(&ATHN_USB_RX_LIST_COUNT)) {
    sub ATHN_USB_RX_LIST_COUNT () {	1;}
}
unless(defined(&ATHN_USB_TX_LIST_COUNT)) {
    sub ATHN_USB_TX_LIST_COUNT () {	(8+ 1);}
}
unless(defined(&ATHN_USB_HOST_CMD_RING_COUNT)) {
    sub ATHN_USB_HOST_CMD_RING_COUNT () {	32;}
}
unless(defined(&ATHN_USB_RXBUFSZ)) {
    sub ATHN_USB_RXBUFSZ () {	(8* 1024);}
}
unless(defined(&ATHN_USB_TXBUFSZ)) {
    sub ATHN_USB_TXBUFSZ () {	(($sizeof{'struct ar_stream_hdr'} + $sizeof{'struct ar_htc_frame_hdr'} + $sizeof{'struct ar_tx_frame'} +  &IEEE80211_MAX_LEN + 3) & ~3);}
}
unless(defined(&ATHN_USB_TXCMDSZ)) {
    sub ATHN_USB_TXCMDSZ () {	512;}
}
unless(defined(&ATHN_USB_TX_TIMEOUT)) {
    sub ATHN_USB_TX_TIMEOUT () {	5000;}
}
unless(defined(&ATHN_USB_CMD_TIMEOUT)) {
    sub ATHN_USB_CMD_TIMEOUT () {	1000;}
}
unless(defined(&usb_dev)) {
    sub usb_dev () {	 ($sc_sc->{sc_dev});}
}
unless(defined(&ATHN_USB_FLAG_AR7010)) {
    sub ATHN_USB_FLAG_AR7010 () {	0x1;}
}
1;
