require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&HEADER_BN_H)) {
    eval 'sub HEADER_BN_H () {1;}' unless defined(&HEADER_BN_H);
    require 'openssl/e_os2.ph';
    unless(defined(&OPENSSL_NO_FP_API)) {
	require 'stdio.ph';
    }
    require 'openssl/ossl_typ.ph';
    require 'openssl/crypto.ph';
    if(defined(&__cplusplus)) {
    }
    unless(defined(&OPENSSL_SMALL_FOOTPRINT)) {
	eval 'sub BN_MUL_COMBA () {1;}' unless defined(&BN_MUL_COMBA);
	eval 'sub BN_SQR_COMBA () {1;}' unless defined(&BN_SQR_COMBA);
	eval 'sub BN_RECURSION () {1;}' unless defined(&BN_RECURSION);
    }
    if(defined(&OPENSSL_SYS_MSDOS) || defined(&OPENSSL_SYS_WINDOWS) || defined(&OPENSSL_SYS_WIN32) || defined(&linux)) {
	unless(defined(&BN_DIV2W)) {
	    eval 'sub BN_DIV2W () {1;}' unless defined(&BN_DIV2W);
	}
    }
    if(defined(&SIXTY_FOUR_BIT_LONG)) {
	eval 'sub BN_ULLONG () {\'unsigned long long\';}' unless defined(&BN_ULLONG);
	eval 'sub BN_ULONG () {\'unsigned long\';}' unless defined(&BN_ULONG);
	eval 'sub BN_LONG () {\'long\';}' unless defined(&BN_LONG);
	eval 'sub BN_BITS () {128;}' unless defined(&BN_BITS);
	eval 'sub BN_BYTES () {8;}' unless defined(&BN_BYTES);
	eval 'sub BN_BITS2 () {64;}' unless defined(&BN_BITS2);
	eval 'sub BN_BITS4 () {32;}' unless defined(&BN_BITS4);
	eval 'sub BN_MASK () {(0xffffffffffffffffffffffffffffffff);}' unless defined(&BN_MASK);
	eval 'sub BN_MASK2 () {(0xffffffffffffffff);}' unless defined(&BN_MASK2);
	eval 'sub BN_MASK2l () {(0xffffffff);}' unless defined(&BN_MASK2l);
	eval 'sub BN_MASK2h () {(0xffffffff00000000);}' unless defined(&BN_MASK2h);
	eval 'sub BN_MASK2h1 () {(0xffffffff80000000);}' unless defined(&BN_MASK2h1);
	eval 'sub BN_TBIT () {(0x8000000000000000);}' unless defined(&BN_TBIT);
	eval 'sub BN_DEC_CONV () {(10000000000000000000);}' unless defined(&BN_DEC_CONV);
	eval 'sub BN_DEC_FMT1 () {"%lu";}' unless defined(&BN_DEC_FMT1);
	eval 'sub BN_DEC_FMT2 () {"%019lu";}' unless defined(&BN_DEC_FMT2);
	eval 'sub BN_DEC_NUM () {19;}' unless defined(&BN_DEC_NUM);
	eval 'sub BN_HEX_FMT1 () {"%lX";}' unless defined(&BN_HEX_FMT1);
	eval 'sub BN_HEX_FMT2 () {"%016lX";}' unless defined(&BN_HEX_FMT2);
    }
    if(defined(&SIXTY_FOUR_BIT)) {
	undef(&BN_LLONG) if defined(&BN_LLONG);
	undef(&BN_ULLONG) if defined(&BN_ULLONG);
	eval 'sub BN_ULONG () {\'unsigned long long\';}' unless defined(&BN_ULONG);
	eval 'sub BN_LONG () {\'long long\';}' unless defined(&BN_LONG);
	eval 'sub BN_BITS () {128;}' unless defined(&BN_BITS);
	eval 'sub BN_BYTES () {8;}' unless defined(&BN_BYTES);
	eval 'sub BN_BITS2 () {64;}' unless defined(&BN_BITS2);
	eval 'sub BN_BITS4 () {32;}' unless defined(&BN_BITS4);
	eval 'sub BN_MASK2 () {(0xffffffffffffffff);}' unless defined(&BN_MASK2);
	eval 'sub BN_MASK2l () {(0xffffffff);}' unless defined(&BN_MASK2l);
	eval 'sub BN_MASK2h () {(0xffffffff00000000);}' unless defined(&BN_MASK2h);
	eval 'sub BN_MASK2h1 () {(0xffffffff80000000);}' unless defined(&BN_MASK2h1);
	eval 'sub BN_TBIT () {(0x8000000000000000);}' unless defined(&BN_TBIT);
	eval 'sub BN_DEC_CONV () {(10000000000000000000);}' unless defined(&BN_DEC_CONV);
	eval 'sub BN_DEC_FMT1 () {"%llu";}' unless defined(&BN_DEC_FMT1);
	eval 'sub BN_DEC_FMT2 () {"%019llu";}' unless defined(&BN_DEC_FMT2);
	eval 'sub BN_DEC_NUM () {19;}' unless defined(&BN_DEC_NUM);
	eval 'sub BN_HEX_FMT1 () {"%llX";}' unless defined(&BN_HEX_FMT1);
	eval 'sub BN_HEX_FMT2 () {"%016llX";}' unless defined(&BN_HEX_FMT2);
    }
    if(defined(&THIRTY_TWO_BIT)) {
	if(defined(&BN_LLONG)) {
	    if(defined(&_WIN32)  && !defined(&__GNUC__)) {
		eval 'sub BN_ULLONG () {\'unsigned __int64\';}' unless defined(&BN_ULLONG);
		eval 'sub BN_MASK () {(0xffffffffffffffff &I64);}' unless defined(&BN_MASK);
	    } else {
		eval 'sub BN_ULLONG () {\'unsigned long long\';}' unless defined(&BN_ULLONG);
		eval 'sub BN_MASK () {(0xffffffffffffffff);}' unless defined(&BN_MASK);
	    }
	}
	eval 'sub BN_ULONG () {\'unsigned int\';}' unless defined(&BN_ULONG);
	eval 'sub BN_LONG () {\'int\';}' unless defined(&BN_LONG);
	eval 'sub BN_BITS () {64;}' unless defined(&BN_BITS);
	eval 'sub BN_BYTES () {4;}' unless defined(&BN_BYTES);
	eval 'sub BN_BITS2 () {32;}' unless defined(&BN_BITS2);
	eval 'sub BN_BITS4 () {16;}' unless defined(&BN_BITS4);
	eval 'sub BN_MASK2 () {(0xffffffff);}' unless defined(&BN_MASK2);
	eval 'sub BN_MASK2l () {(0xffff);}' unless defined(&BN_MASK2l);
	eval 'sub BN_MASK2h1 () {(0xffff8000);}' unless defined(&BN_MASK2h1);
	eval 'sub BN_MASK2h () {(0xffff0000);}' unless defined(&BN_MASK2h);
	eval 'sub BN_TBIT () {(0x80000000);}' unless defined(&BN_TBIT);
	eval 'sub BN_DEC_CONV () {(1000000000);}' unless defined(&BN_DEC_CONV);
	eval 'sub BN_DEC_FMT1 () {"%u";}' unless defined(&BN_DEC_FMT1);
	eval 'sub BN_DEC_FMT2 () {"%09u";}' unless defined(&BN_DEC_FMT2);
	eval 'sub BN_DEC_NUM () {9;}' unless defined(&BN_DEC_NUM);
	eval 'sub BN_HEX_FMT1 () {"%X";}' unless defined(&BN_HEX_FMT1);
	eval 'sub BN_HEX_FMT2 () {"%08X";}' unless defined(&BN_HEX_FMT2);
    }
    if(defined(&OPENSSL_SYS_VMS)) {
	if((defined(&__INITIAL_POINTER_SIZE) ? &__INITIAL_POINTER_SIZE : undef) == 64) {
	    eval 'sub PTR_SIZE_INT () {\'long long\';}' unless defined(&PTR_SIZE_INT);
	} else {
	    eval 'sub PTR_SIZE_INT () {\'int\';}' unless defined(&PTR_SIZE_INT);
	}
    } else {
	eval 'sub PTR_SIZE_INT () {\'size_t\';}' unless defined(&PTR_SIZE_INT);
    }
    eval 'sub BN_DEFAULT_BITS () {1280;}' unless defined(&BN_DEFAULT_BITS);
    eval 'sub BN_FLG_MALLOCED () {0x1;}' unless defined(&BN_FLG_MALLOCED);
    eval 'sub BN_FLG_STATIC_DATA () {0x2;}' unless defined(&BN_FLG_STATIC_DATA);
    eval 'sub BN_FLG_CONSTTIME () {0x4;}' unless defined(&BN_FLG_CONSTTIME);
    unless(defined(&OPENSSL_NO_DEPRECATED)) {
	eval 'sub BN_FLG_EXP_CONSTTIME () { &BN_FLG_CONSTTIME;}' unless defined(&BN_FLG_EXP_CONSTTIME);
    }
    unless(defined(&OPENSSL_NO_DEPRECATED)) {
	eval 'sub BN_FLG_FREE () {0x8000;}' unless defined(&BN_FLG_FREE);
    }
    eval 'sub BN_set_flags {
        my($b,$n) = @_;
	    eval q((($b)-> &flags|=($n)));
    }' unless defined(&BN_set_flags);
    eval 'sub BN_get_flags {
        my($b,$n) = @_;
	    eval q((($b)-> &flags($n)));
    }' unless defined(&BN_get_flags);
    eval 'sub BN_with_flags {
        my($dest,$b,$n) = @_;
	    eval q((($dest)-> &d=($b)-> &d, ($dest)-> &top=($b)-> &top, ($dest)-> &dmax=($b)-> &dmax, ($dest)-> &neg=($b)-> &neg, ($dest)-> &flags=((($dest)-> &flags &  &BN_FLG_MALLOCED) | (($b)-> &flags & ~ &BN_FLG_MALLOCED) |  &BN_FLG_STATIC_DATA | ($n))));
    }' unless defined(&BN_with_flags);
    if(0) {
    }
    eval 'sub BN_GENCB_set_old {
        my($gencb, $callback, $cb_arg) = @_;
	    eval q({  &BN_GENCB * &tmp_gencb = ($gencb);  ($tmp_gencb->{ver}) = 1;  ($tmp_gencb->{arg}) = ($cb_arg);  ($tmp_gencb->{cb}->{cb_1}) = ($callback); });
    }' unless defined(&BN_GENCB_set_old);
    eval 'sub BN_GENCB_set {
        my($gencb, $callback, $cb_arg) = @_;
	    eval q({  &BN_GENCB * &tmp_gencb = ($gencb);  ($tmp_gencb->{ver}) = 2;  ($tmp_gencb->{arg}) = ($cb_arg);  ($tmp_gencb->{cb}->{cb_2}) = ($callback); });
    }' unless defined(&BN_GENCB_set);
    eval 'sub BN_prime_checks () {0;}' unless defined(&BN_prime_checks);
    eval 'sub BN_prime_checks_for_size {
        my($b) = @_;
	    eval q((($b) >= 1300? 2: ($b) >= 850? 3: ($b) >= 650? 4: ($b) >= 550? 5: ($b) >= 450? 6: ($b) >= 400? 7: ($b) >= 350? 8: ($b) >= 300? 9: ($b) >= 250? 12: ($b) >= 200? 15: ($b) >= 150? 18: 27));
    }' unless defined(&BN_prime_checks_for_size);
    eval 'sub BN_num_bytes {
        my($a) = @_;
	    eval q((( &BN_num_bits($a)+7)/8));
    }' unless defined(&BN_num_bytes);
    eval 'sub BN_abs_is_word {
        my($a,$w) = @_;
	    eval q((((($a)-> &top == 1)  && (($a)-> $d[0] == ( &BN_ULONG)($w))) || ((($w) == 0)  && (($a)-> &top == 0))));
    }' unless defined(&BN_abs_is_word);
    eval 'sub BN_is_zero {
        my($a) = @_;
	    eval q((($a)-> &top == 0));
    }' unless defined(&BN_is_zero);
    eval 'sub BN_is_one {
        my($a) = @_;
	    eval q(( &BN_abs_is_word(($a),1)  && !($a)-> &neg));
    }' unless defined(&BN_is_one);
    eval 'sub BN_is_word {
        my($a,$w) = @_;
	    eval q(( &BN_abs_is_word(($a),($w))  && (!($w) || !($a)-> &neg)));
    }' unless defined(&BN_is_word);
    eval 'sub BN_is_odd {
        my($a) = @_;
	    eval q(((($a)-> &top > 0)  && (($a)-> $d[0] & 1)));
    }' unless defined(&BN_is_odd);
    eval 'sub BN_one {
        my($a) = @_;
	    eval q(( &BN_set_word(($a),1)));
    }' unless defined(&BN_one);
    eval 'sub BN_zero_ex {
        my($a) = @_;
	    eval q( &do {  &BIGNUM * &_tmp_bn = ($a);  ($_tmp_bn->{top}) = 0;  ($_tmp_bn->{neg}) = 0; }  &while(0));
    }' unless defined(&BN_zero_ex);
    if(defined(&OPENSSL_NO_DEPRECATED)) {
	eval 'sub BN_zero {
	    my($a) = @_;
    	    eval q( &BN_zero_ex($a));
	}' unless defined(&BN_zero);
    } else {
	eval 'sub BN_zero {
	    my($a) = @_;
    	    eval q(( &BN_set_word(($a),0)));
	}' unless defined(&BN_zero);
    }
    unless(defined(&OPENSSL_NO_DEPRECATED)) {
    }
    eval 'sub BN_is_negative {
        my($a) = @_;
	    eval q((($a)-> &neg != 0));
    }' unless defined(&BN_is_negative);
    eval 'sub BN_mod {
        my($rem,$m,$d,$ctx) = @_;
	    eval q( &BN_div( &NULL,($rem),($m),($d),($ctx)));
    }' unless defined(&BN_mod);
    unless(defined(&OPENSSL_NO_FP_API)) {
    }
    if(defined(&HEADER_BIO_H)) {
    } else {
    }
    unless(defined(&OPENSSL_NO_DEPRECATED)) {
    }
    eval 'sub BN_to_montgomery {
        my($r,$a,$mont,$ctx) = @_;
	    eval q( &BN_mod_mul_montgomery( ($r),($a),(($mont)-> &RR),($mont),($ctx)));
    }' unless defined(&BN_to_montgomery);
    eval 'sub BN_BLINDING_NO_UPDATE () {0x1;}' unless defined(&BN_BLINDING_NO_UPDATE);
    eval 'sub BN_BLINDING_NO_RECREATE () {0x2;}' unless defined(&BN_BLINDING_NO_RECREATE);
    unless(defined(&OPENSSL_NO_DEPRECATED)) {
    }
    unless(defined(&OPENSSL_NO_DEPRECATED)) {
    }
    eval 'sub BN_GF2m_sub {
        my($r, $a, $b) = @_;
	    eval q( &BN_GF2m_add($r, $a, $b));
    }' unless defined(&BN_GF2m_sub);
    eval 'sub BN_GF2m_cmp {
        my($a, $b) = @_;
	    eval q( &BN_ucmp(($a), ($b)));
    }' unless defined(&BN_GF2m_cmp);
    eval 'sub bn_expand {
        my($a,$bits) = @_;
	    eval q((((((($bits+ &BN_BITS2-1))/ &BN_BITS2)) <= ($a)-> &dmax)? ($a): &bn_expand2(($a),($bits+ &BN_BITS2-1)/ &BN_BITS2)));
    }' unless defined(&bn_expand);
    eval 'sub bn_wexpand {
        my($a,$words) = @_;
	    eval q(((($words) <= ($a)-> &dmax)?($a): &bn_expand2(($a),($words))));
    }' unless defined(&bn_wexpand);
    unless(defined(&OPENSSL_NO_DEPRECATED)) {
    }
    if(defined(&BN_DEBUG)) {
	require 'assert.ph';
	if(defined(&BN_DEBUG_RAND)) {
	    unless(defined(&RAND_pseudo_bytes)) {
		eval 'sub BN_DEBUG_TRIX () {1;}' unless defined(&BN_DEBUG_TRIX);
	    }
	    eval 'sub bn_pollute {
	        my($a) = @_;
    		eval q( &do {  &const  &BIGNUM * &_bnum1 = ;  &if( ($_bnum1->{top}) <  ($_bnum1->{dmax})) { \'unsigned char _tmp_char\';  &BN_ULONG * &_not_const;  &memcpy(& &_not_const, & ($_bnum1->{d}),  &sizeof);  &RAND_pseudo_bytes(& &_tmp_char, 1);  &memset(( &_not_const +  ($_bnum1->{top})),  &_tmp_char, ( ($_bnum1->{dmax}) -  ($_bnum1->{top})) * $sizeof{ &BN_ULONG}); } }  &while(0));
	    }' unless defined(&bn_pollute);
	    if(defined(&BN_DEBUG_TRIX)) {
		undef(&RAND_pseudo_bytes) if defined(&RAND_pseudo_bytes);
	    }
	} else {
	    eval 'sub bn_pollute {
	        my($a) = @_;
    		eval q();
	    }' unless defined(&bn_pollute);
	}
	eval 'sub bn_check_top {
	    my($a) = @_;
    	    eval q( &do {  &const  &BIGNUM * &_bnum2 = ($a);  &if ( &_bnum2 !=  &NULL) {  &assert(( ($_bnum2->{top}) == 0) || ( ($_bnum2->{d[_bnum2}->{top }- 1]) != 0));  &bn_pollute( &_bnum2); } }  &while(0));
	}' unless defined(&bn_check_top);
	eval 'sub bn_fix_top {
	    my($a) = @_;
    	    eval q( &bn_check_top($a));
	}' unless defined(&bn_fix_top);
    } else {
	eval 'sub bn_pollute {
	    my($a) = @_;
    	    eval q();
	}' unless defined(&bn_pollute);
	eval 'sub bn_check_top {
	    my($a) = @_;
    	    eval q();
	}' unless defined(&bn_check_top);
	eval 'sub bn_fix_top {
	    my($a) = @_;
    	    eval q( &bn_correct_top($a));
	}' unless defined(&bn_fix_top);
    }
    eval 'sub bn_correct_top {
        my($a) = @_;
	    eval q({  &BN_ULONG * &ftl; \'int\'  &tmp_top = ($a)-> &top;  &if ( &tmp_top > 0) {  &for ( &ftl= (($a)-> $d[ &tmp_top-1]);  &tmp_top > 0;  &tmp_top--)  &if (*( &ftl--))  &break; ($a)-> &top =  &tmp_top; }  &bn_pollute($a); });
    }' unless defined(&bn_correct_top);
    eval 'sub BN_F_BNRAND () {127;}' unless defined(&BN_F_BNRAND);
    eval 'sub BN_F_BN_BLINDING_CONVERT_EX () {100;}' unless defined(&BN_F_BN_BLINDING_CONVERT_EX);
    eval 'sub BN_F_BN_BLINDING_CREATE_PARAM () {128;}' unless defined(&BN_F_BN_BLINDING_CREATE_PARAM);
    eval 'sub BN_F_BN_BLINDING_INVERT_EX () {101;}' unless defined(&BN_F_BN_BLINDING_INVERT_EX);
    eval 'sub BN_F_BN_BLINDING_NEW () {102;}' unless defined(&BN_F_BN_BLINDING_NEW);
    eval 'sub BN_F_BN_BLINDING_UPDATE () {103;}' unless defined(&BN_F_BN_BLINDING_UPDATE);
    eval 'sub BN_F_BN_BN2DEC () {104;}' unless defined(&BN_F_BN_BN2DEC);
    eval 'sub BN_F_BN_BN2HEX () {105;}' unless defined(&BN_F_BN_BN2HEX);
    eval 'sub BN_F_BN_CTX_GET () {116;}' unless defined(&BN_F_BN_CTX_GET);
    eval 'sub BN_F_BN_CTX_NEW () {106;}' unless defined(&BN_F_BN_CTX_NEW);
    eval 'sub BN_F_BN_CTX_START () {129;}' unless defined(&BN_F_BN_CTX_START);
    eval 'sub BN_F_BN_DIV () {107;}' unless defined(&BN_F_BN_DIV);
    eval 'sub BN_F_BN_DIV_NO_BRANCH () {138;}' unless defined(&BN_F_BN_DIV_NO_BRANCH);
    eval 'sub BN_F_BN_DIV_RECP () {130;}' unless defined(&BN_F_BN_DIV_RECP);
    eval 'sub BN_F_BN_EXP () {123;}' unless defined(&BN_F_BN_EXP);
    eval 'sub BN_F_BN_EXPAND2 () {108;}' unless defined(&BN_F_BN_EXPAND2);
    eval 'sub BN_F_BN_EXPAND_INTERNAL () {120;}' unless defined(&BN_F_BN_EXPAND_INTERNAL);
    eval 'sub BN_F_BN_GF2M_MOD () {131;}' unless defined(&BN_F_BN_GF2M_MOD);
    eval 'sub BN_F_BN_GF2M_MOD_EXP () {132;}' unless defined(&BN_F_BN_GF2M_MOD_EXP);
    eval 'sub BN_F_BN_GF2M_MOD_MUL () {133;}' unless defined(&BN_F_BN_GF2M_MOD_MUL);
    eval 'sub BN_F_BN_GF2M_MOD_SOLVE_QUAD () {134;}' unless defined(&BN_F_BN_GF2M_MOD_SOLVE_QUAD);
    eval 'sub BN_F_BN_GF2M_MOD_SOLVE_QUAD_ARR () {135;}' unless defined(&BN_F_BN_GF2M_MOD_SOLVE_QUAD_ARR);
    eval 'sub BN_F_BN_GF2M_MOD_SQR () {136;}' unless defined(&BN_F_BN_GF2M_MOD_SQR);
    eval 'sub BN_F_BN_GF2M_MOD_SQRT () {137;}' unless defined(&BN_F_BN_GF2M_MOD_SQRT);
    eval 'sub BN_F_BN_MOD_EXP2_MONT () {118;}' unless defined(&BN_F_BN_MOD_EXP2_MONT);
    eval 'sub BN_F_BN_MOD_EXP_MONT () {109;}' unless defined(&BN_F_BN_MOD_EXP_MONT);
    eval 'sub BN_F_BN_MOD_EXP_MONT_CONSTTIME () {124;}' unless defined(&BN_F_BN_MOD_EXP_MONT_CONSTTIME);
    eval 'sub BN_F_BN_MOD_EXP_MONT_WORD () {117;}' unless defined(&BN_F_BN_MOD_EXP_MONT_WORD);
    eval 'sub BN_F_BN_MOD_EXP_RECP () {125;}' unless defined(&BN_F_BN_MOD_EXP_RECP);
    eval 'sub BN_F_BN_MOD_EXP_SIMPLE () {126;}' unless defined(&BN_F_BN_MOD_EXP_SIMPLE);
    eval 'sub BN_F_BN_MOD_INVERSE () {110;}' unless defined(&BN_F_BN_MOD_INVERSE);
    eval 'sub BN_F_BN_MOD_INVERSE_NO_BRANCH () {139;}' unless defined(&BN_F_BN_MOD_INVERSE_NO_BRANCH);
    eval 'sub BN_F_BN_MOD_LSHIFT_QUICK () {119;}' unless defined(&BN_F_BN_MOD_LSHIFT_QUICK);
    eval 'sub BN_F_BN_MOD_MUL_RECIPROCAL () {111;}' unless defined(&BN_F_BN_MOD_MUL_RECIPROCAL);
    eval 'sub BN_F_BN_MOD_SQRT () {121;}' unless defined(&BN_F_BN_MOD_SQRT);
    eval 'sub BN_F_BN_MPI2BN () {112;}' unless defined(&BN_F_BN_MPI2BN);
    eval 'sub BN_F_BN_NEW () {113;}' unless defined(&BN_F_BN_NEW);
    eval 'sub BN_F_BN_RAND () {114;}' unless defined(&BN_F_BN_RAND);
    eval 'sub BN_F_BN_RAND_RANGE () {122;}' unless defined(&BN_F_BN_RAND_RANGE);
    eval 'sub BN_F_BN_USUB () {115;}' unless defined(&BN_F_BN_USUB);
    eval 'sub BN_R_ARG2_LT_ARG3 () {100;}' unless defined(&BN_R_ARG2_LT_ARG3);
    eval 'sub BN_R_BAD_RECIPROCAL () {101;}' unless defined(&BN_R_BAD_RECIPROCAL);
    eval 'sub BN_R_BIGNUM_TOO_LONG () {114;}' unless defined(&BN_R_BIGNUM_TOO_LONG);
    eval 'sub BN_R_CALLED_WITH_EVEN_MODULUS () {102;}' unless defined(&BN_R_CALLED_WITH_EVEN_MODULUS);
    eval 'sub BN_R_DIV_BY_ZERO () {103;}' unless defined(&BN_R_DIV_BY_ZERO);
    eval 'sub BN_R_ENCODING_ERROR () {104;}' unless defined(&BN_R_ENCODING_ERROR);
    eval 'sub BN_R_EXPAND_ON_STATIC_BIGNUM_DATA () {105;}' unless defined(&BN_R_EXPAND_ON_STATIC_BIGNUM_DATA);
    eval 'sub BN_R_INPUT_NOT_REDUCED () {110;}' unless defined(&BN_R_INPUT_NOT_REDUCED);
    eval 'sub BN_R_INVALID_LENGTH () {106;}' unless defined(&BN_R_INVALID_LENGTH);
    eval 'sub BN_R_INVALID_RANGE () {115;}' unless defined(&BN_R_INVALID_RANGE);
    eval 'sub BN_R_NOT_A_SQUARE () {111;}' unless defined(&BN_R_NOT_A_SQUARE);
    eval 'sub BN_R_NOT_INITIALIZED () {107;}' unless defined(&BN_R_NOT_INITIALIZED);
    eval 'sub BN_R_NO_INVERSE () {108;}' unless defined(&BN_R_NO_INVERSE);
    eval 'sub BN_R_NO_SOLUTION () {116;}' unless defined(&BN_R_NO_SOLUTION);
    eval 'sub BN_R_P_IS_NOT_PRIME () {112;}' unless defined(&BN_R_P_IS_NOT_PRIME);
    eval 'sub BN_R_TOO_MANY_ITERATIONS () {113;}' unless defined(&BN_R_TOO_MANY_ITERATIONS);
    eval 'sub BN_R_TOO_MANY_TEMPORARY_VARIABLES () {109;}' unless defined(&BN_R_TOO_MANY_TEMPORARY_VARIABLES);
    if(defined(&__cplusplus)) {
    }
}
1;
