require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_DEV_PCI_PCIIDE_PIIX_REG_H_)) {
    eval 'sub _DEV_PCI_PCIIDE_PIIX_REG_H_ () {1;}' unless defined(&_DEV_PCI_PCIIDE_PIIX_REG_H_);
    eval 'sub PIIX_BMIBA () {0x20;}' unless defined(&PIIX_BMIBA);
    eval 'sub PIIX_BMIBA_ADDR {
        my($x) = @_;
	    eval q(($x & 0xffff0));
    }' unless defined(&PIIX_BMIBA_ADDR);
    eval 'sub PIIX_BMIBA_RTE {
        my($x) = @_;
	    eval q(($x & 0x1));
    }' unless defined(&PIIX_BMIBA_RTE);
    eval 'sub PIIX_BMIBA_RTE_IO () {0x1;}' unless defined(&PIIX_BMIBA_RTE_IO);
    eval 'sub PIIX_IDETIM () {0x40;}' unless defined(&PIIX_IDETIM);
    eval 'sub PIIX_IDETIM_READ {
        my($x, $channel) = @_;
	    eval q(((($x) >> (16* ($channel))) & 0xffff));
    }' unless defined(&PIIX_IDETIM_READ);
    eval 'sub PIIX_IDETIM_SET {
        my($x, $bytes, $channel) = @_;
	    eval q((($x) | (($bytes) << (16* ($channel)))));
    }' unless defined(&PIIX_IDETIM_SET);
    eval 'sub PIIX_IDETIM_CLEAR {
        my($x, $bytes, $channel) = @_;
	    eval q((($x) & ~(($bytes) << (16* ($channel)))));
    }' unless defined(&PIIX_IDETIM_CLEAR);
    eval 'sub PIIX_IDETIM_IDE () {0x8000;}' unless defined(&PIIX_IDETIM_IDE);
    eval 'sub PIIX_IDETIM_SITRE () {0x4000;}' unless defined(&PIIX_IDETIM_SITRE);
    eval 'sub PIIX_IDETIM_ISP_MASK () {0x3000;}' unless defined(&PIIX_IDETIM_ISP_MASK);
    eval 'sub PIIX_IDETIM_ISP_SHIFT () {12;}' unless defined(&PIIX_IDETIM_ISP_SHIFT);
    eval 'sub PIIX_IDETIM_ISP_SET {
        my($x) = @_;
	    eval q((($x) <<  &PIIX_IDETIM_ISP_SHIFT));
    }' unless defined(&PIIX_IDETIM_ISP_SET);
    eval 'sub PIIX_IDETIM_RTC_MASK () {0x300;}' unless defined(&PIIX_IDETIM_RTC_MASK);
    eval 'sub PIIX_IDETIM_RTC_SHIFT () {8;}' unless defined(&PIIX_IDETIM_RTC_SHIFT);
    eval 'sub PIIX_IDETIM_RTC_SET {
        my($x) = @_;
	    eval q((($x) <<  &PIIX_IDETIM_RTC_SHIFT));
    }' unless defined(&PIIX_IDETIM_RTC_SET);
    eval 'sub PIIX_IDETIM_DTE {
        my($d) = @_;
	    eval q((0x8 << (4* ($d))));
    }' unless defined(&PIIX_IDETIM_DTE);
    eval 'sub PIIX_IDETIM_PPE {
        my($d) = @_;
	    eval q((0x4 << (4* ($d))));
    }' unless defined(&PIIX_IDETIM_PPE);
    eval 'sub PIIX_IDETIM_IE {
        my($d) = @_;
	    eval q((0x2 << (4* ($d))));
    }' unless defined(&PIIX_IDETIM_IE);
    eval 'sub PIIX_IDETIM_TIME {
        my($d) = @_;
	    eval q((0x1 << (4* ($d))));
    }' unless defined(&PIIX_IDETIM_TIME);
    eval 'sub PIIX_SIDETIM () {0x44;}' unless defined(&PIIX_SIDETIM);
    eval 'sub PIIX_SIDETIM_ISP_MASK {
        my($channel) = @_;
	    eval q((0xc << (($channel) * 4)));
    }' unless defined(&PIIX_SIDETIM_ISP_MASK);
    eval 'sub PIIX_SIDETIM_ISP_SHIFT () {2;}' unless defined(&PIIX_SIDETIM_ISP_SHIFT);
    eval 'sub PIIX_SIDETIM_ISP_SET {
        my($x, $channel) = @_;
	    eval q(($x << ( &PIIX_SIDETIM_ISP_SHIFT + (($channel) * 4))));
    }' unless defined(&PIIX_SIDETIM_ISP_SET);
    eval 'sub PIIX_SIDETIM_RTC_MASK {
        my($channel) = @_;
	    eval q((0x3 << (($channel) * 4)));
    }' unless defined(&PIIX_SIDETIM_RTC_MASK);
    eval 'sub PIIX_SIDETIM_RTC_SHIFT () {0;}' unless defined(&PIIX_SIDETIM_RTC_SHIFT);
    eval 'sub PIIX_SIDETIM_RTC_SET {
        my($x, $channel) = @_;
	    eval q(($x << ( &PIIX_SIDETIM_RTC_SHIFT + (($channel) * 4))));
    }' unless defined(&PIIX_SIDETIM_RTC_SET);
    eval 'sub PIIX_UDMAREG () {0x48;}' unless defined(&PIIX_UDMAREG);
    eval 'sub PIIX_UDMACTL_DRV_EN {
        my($channel, $drive) = @_;
	    eval q((0x1 << (($channel) * 2+ ($drive))));
    }' unless defined(&PIIX_UDMACTL_DRV_EN);
    eval 'sub PIIX_UDMATIM_SHIFT () {16;}' unless defined(&PIIX_UDMATIM_SHIFT);
    eval 'sub PIIX_UDMATIM_SET {
        my($x, $channel, $drive) = @_;
	    eval q(((($x) << (($channel * 8) + ($drive * 4))) <<  &PIIX_UDMATIM_SHIFT));
    }' unless defined(&PIIX_UDMATIM_SET);
    eval 'sub PIIX_CONFIG () {0x54;}' unless defined(&PIIX_CONFIG);
    eval 'sub PIIX_CONFIG_PINGPONG () {0x400;}' unless defined(&PIIX_CONFIG_PINGPONG);
    eval 'sub PIIX_CONFIG_CR {
        my($channel, $drive) = @_;
	    eval q((0x10 << (($channel) * 2+ ($drive))));
    }' unless defined(&PIIX_CONFIG_CR);
    eval 'sub PIIX_CONFIG_UDMA66 {
        my($channel, $drive) = @_;
	    eval q((0x1 << (($channel) * 2+ ($drive))));
    }' unless defined(&PIIX_CONFIG_UDMA66);
    eval 'sub PIIX_CONFIG_UDMA100 {
        my($channel, $drive) = @_;
	    eval q((0x1000 << (($channel) * 2+ ($drive))));
    }' unless defined(&PIIX_CONFIG_UDMA100);
    eval 'sub ICH5_SATA_MAP () {0x90;}' unless defined(&ICH5_SATA_MAP);
    eval 'sub ICH5_SATA_MAP_MV_MASK () {0x7;}' unless defined(&ICH5_SATA_MAP_MV_MASK);
    eval 'sub ICH5_SATA_MAP_COMBINED () {0x4;}' unless defined(&ICH5_SATA_MAP_COMBINED);
    eval 'sub ICH5_SATA_PI () {0x9;}' unless defined(&ICH5_SATA_PI);
    eval 'sub ICH5_SATA_PI_PRI_NATIVE () {0x1;}' unless defined(&ICH5_SATA_PI_PRI_NATIVE);
    eval 'sub ICH5_SATA_PI_SEC_NATIVE () {0x4;}' unless defined(&ICH5_SATA_PI_SEC_NATIVE);
    eval 'sub ICH_SATA_PCS () {0x92;}' unless defined(&ICH_SATA_PCS);
    eval 'sub ICH_SATA_PCS_P0E () {0x1;}' unless defined(&ICH_SATA_PCS_P0E);
    eval 'sub ICH_SATA_PCS_P1E () {0x2;}' unless defined(&ICH_SATA_PCS_P1E);
    eval 'sub ICH_SATA_PCS_P0P () {0x10;}' unless defined(&ICH_SATA_PCS_P0P);
    eval 'sub ICH_SATA_PCS_P1P () {0x20;}' unless defined(&ICH_SATA_PCS_P1P);
    eval 'sub ICH6_SATA_MAP_CMB_MASK () {0x3;}' unless defined(&ICH6_SATA_MAP_CMB_MASK);
    eval 'sub ICH6_SATA_MAP_CMB_PRI () {0x1;}' unless defined(&ICH6_SATA_MAP_CMB_PRI);
    eval 'sub ICH6_SATA_MAP_CMB_SEC () {0x2;}' unless defined(&ICH6_SATA_MAP_CMB_SEC);
    eval 'sub ICH7_SATA_MAP_SMS_MASK () {0xc0;}' unless defined(&ICH7_SATA_MAP_SMS_MASK);
    eval 'sub ICH7_SATA_MAP_SMS_IDE () {0x;}' unless defined(&ICH7_SATA_MAP_SMS_IDE);
    eval 'sub ICH7_SATA_MAP_SMS_AHCI () {0x40;}' unless defined(&ICH7_SATA_MAP_SMS_AHCI);
    eval 'sub ICH7_SATA_MAP_SMS_RAID () {0x80;}' unless defined(&ICH7_SATA_MAP_SMS_RAID);
}
1;
