<?php
// (c) Copyright 2002-2009 by authors of the Tiki Wiki/CMS/Groupware Project
// 
// All Rights Reserved. See copyright.txt for details and a complete list of authors.
// Licensed under the GNU LESSER GENERAL PUBLIC LICENSE. See license.txt for details.
// $Id: /cvsroot/tikiwiki/tiki/tiki-admin_menus.php,v 1.20.2.1 2007-10-26 20:36:40 sylvieg Exp $
require_once ('tiki-setup.php');
include_once ('lib/menubuilder/menulib.php');
$auto_query_args = array(
	'offset',
	'sort_mode',
	'menuId'
);
if ($tiki_p_admin != 'y' && $tiki_p_edit_menu != 'y') {
	$smarty->assign('errortype', 401);
	$smarty->assign('msg', tra("You do not have permission to use this feature"));
	$smarty->display("error.tpl");
	die;
}
if (!isset($_REQUEST["menuId"])) {
	$_REQUEST["menuId"] = 0;
}
$smarty->assign('menuId', $_REQUEST["menuId"]);
if ($_REQUEST["menuId"]) {
	$info = $tikilib->get_menu($_REQUEST["menuId"]);
} else {
	$info = array();
	$info["name"] = '';
	$info["description"] = '';
	$info["type"] = 'd';
	$info['icon'] = null;
	$info['use_items_icons'] = 'n';
}
$smarty->assign_by_ref('info', $info);
if (isset($_REQUEST["remove"])) {
	$area = 'delmenu';
	if ($prefs['feature_ticketlib2'] != 'y' or (isset($_POST['daconfirm']) and isset($_SESSION["ticket_$area"]))) {
		key_check($area);
		$menulib->remove_menu($_REQUEST["remove"]);
		$smarty->clear_cache('tiki-user_menu.tpl', $_REQUEST['menuId']);
	} else {
		key_get($area);
	}
}
if (isset($_REQUEST["save"])) {
	check_ticket('admin-menus');
	if (!isset($_REQUEST['icon'])) $_REQUEST['icon'] = null;
	$_REQUEST['use_items_icons'] = (isset($_REQUEST['use_items_icons']) && $_REQUEST['use_items_icons'] == 'on') ? 'y' : 'n';
	$menulib->replace_menu($_REQUEST['menuId'], $_REQUEST['name'], $_REQUEST['description'], $_REQUEST['type'], $_REQUEST['icon'], $_REQUEST['use_items_icons']);
	$smarty->clear_cache('tiki-user_menu.tpl', $_REQUEST['menuId']);
	$_REQUEST["menuId"] = 0;
	$smarty->assign('menuId', 0);
	$smarty->assign('info', array(
		'name' => '',
		'description' => '',
		'type' => 'd',
		'icon' => null,
		'use_items_icons' => 'n'
	));
}
if (!isset($_REQUEST["sort_mode"])) {
	$sort_mode = 'name_desc';
} else {
	$sort_mode = $_REQUEST["sort_mode"];
}
$smarty->assign_by_ref('sort_mode', $sort_mode);
if (!isset($_REQUEST["offset"])) {
	$offset = 0;
} else {
	$offset = $_REQUEST["offset"];
}
$smarty->assign_by_ref('offset', $offset);
if (isset($_REQUEST["find"])) {
	$find = $_REQUEST["find"];
} else {
	$find = '';
}
$smarty->assign('find', $find);
$channels = $menulib->list_menus($offset, $maxRecords, $sort_mode, $find);
foreach($channels['data'] as $i => $channel) {
	if ($userlib->object_has_one_permission($channel['menuId'], 'menus')) {
		$channels['data'][$i]['individual'] = 'y';
	}
}
$smarty->assign_by_ref('cant', $channels['cant']);
$smarty->assign_by_ref('channels', $channels["data"]);
ask_ticket('admin-menus');
// disallow robots to index page:
$smarty->assign('metatag_robots', 'NOINDEX, NOFOLLOW');
// Display the template
$smarty->assign('mid', 'tiki-admin_menus.tpl');
$smarty->display("tiki.tpl");
